#ifndef WORLDOBJECTS_H
#define WORLDOBJECTS_H

#pragma warning (disable : 4786)

#include "WorldGeometry.h"
#include "Perception.h"
#include "ToDoClasses.h"
#include "types.h"

#include "Config.h"
#include "StaticField.h"

#include "Skills.h"
#include "Formationtypes.h"
#include "Formations.h"
#include "FormationData.h"
#include "FormationSkills.h"
#include "TeamSkills.h"

#include <vector>

using namespace std;


typedef vector<double> doublevector;

typedef vector<CDiffuse2DVector> DiffusePointVector;
typedef vector<C2DVector       > PointVector;
typedef vector<CAngular2DVector> AngularVector;
typedef vector<bool            > boolVector;


class CMovingObject
{
protected:
	double m_direction;
	CDiffuse2DVector m_position,m_speed,m_acceleration;
	CDiffuse2DVector m_prev_position,m_prev_speed,m_prev_acceleration;
	double m_probability;
	CAngular2DVector m_see_position,m_see_speed;

	int m_last_seen;

	DWORD m_see_status;

    bool i_am_local;

public:

						CMovingObject()
                        {
                            m_probability=0;
                            m_see_status=0;
                            i_am_local=false;
                        }
	const CDiffuse2DVector &GetPosition() const
                        {
                            return m_position;
                        }
	const CDiffuse2DVector &GetPrevPosition() const
                        {
                            return m_prev_position;
                        }

	const CDiffuse2DVector &GetSpeed   () const 
                        {
                            return m_speed;
                        }
	const CDiffuse2DVector &GetAcceleration   () const
                        {
                            return m_acceleration;
                        }
	double              GetProbability()  const 
                        {
                            return m_probability;
                        }
	double              GetDirection() const 
                        {
                            return m_direction;
                        }
	void				SetPosition(const CDiffuse2DVector &p)
                        {
                            m_prev_position=m_position;
                            if((m_see_status & SEE_DISTANCE ||  m_see_status & EXPECTED_DISTANCE) ||
                               (m_see_status & SEE_ANGLE || m_see_status & EXPECTED_ANGLE))
                            {
                                m_see_status|=PREV_POSITION;
                            }
                            else
                            {
                                m_see_status&=!PREV_POSITION;
                            }
                            // FIX:
                            m_see_status|=SEE_DISTANCE;


                            m_position=p;
                        }
	void				SetSpeed   (const CDiffuse2DVector &s)
                        {
                            if((m_see_status & SEE_DISTANCE_CHANGE ||  m_see_status & EXPECTED_DISTANCE_CHANGE) ||
                               (m_see_status & SEE_ANGLE_CHANGE || m_see_status & EXPECTED_ANGLE_CHANGE))
                            {
                                m_see_status|=PREV_SPEED;
                            }
                            else
                            {
                                m_see_status&=!PREV_SPEED;
                            }
                            m_speed=s;
                        }
	void				SetAcceleration(const CDiffuse2DVector &a)
                        {
                            if(m_see_status & EXPECTED_ACCELERATION)
                            {
                                m_see_status|=PREV_ACCELERATION;
                            }
                            else
                            {
                                m_see_status&=!PREV_ACCELERATION;
                            }

                            m_acceleration=a;
                        }
	void				SetProbability(double p)
                        {
                            m_probability=p;
                        }
	void				SetDirection(double d)
                        {
                            m_direction=d;
                            // FIX:
                            m_see_status|=SEE_ANGLE;
                        }
//	void	virtual		Precompute(int stepcount,CGameCommand *command){}

	const CAngular2DVector &GetSeePosition() const
                        {
                            return m_see_position;
                        }
	const CAngular2DVector &GetSeeSpeed() const
                        {
                            return m_see_speed;
                        }
	int					 GetLastSeen() const
                        {
                            return m_last_seen;
                        }
	DWORD				 GetSeeStatus() const
                        {
                            return m_see_status;
                        }

	void SetSeePosition(const CAngular2DVector &pos)
                        {
                            m_see_position=pos;
                        }
	void SetSeeSpeed(const CAngular2DVector &speed)
                        {
                            m_see_speed=speed;
                        }
	void SetLastSeen(int ls)
                        {
                            m_last_seen=ls;
                        }
	void SetSeeStatus(DWORD stats,DWORD mask)
                        {
                            m_see_status=stats ^ (mask & (stats ^ m_see_status));
                        }


	void virtual Precompute();
};


class CWorldModel;



const int APP_GR_DEFAULT=32;

class CAgent:public CMovingObject
{
protected:
	double	m_neck_direction,m_prev_neck_direction,m_angular_speed;
	double	m_stamina;
	double	m_effort;
	int		m_visual_settings;
	int		m_local_number;

	doublevector m_approach_distances;

	int m_number;
	ESide m_side;
	double m_goalie;

	CWorldModel *m_my_world;

	
public:

    CAgent():CMovingObject()
			{
				m_visual_settings=0;
				SetApproachDistanceGranularity(APP_GR_DEFAULT);
                m_number=UNKNOWN;
                m_side=S_None;
                m_goalie=0;
				m_my_world=0;
			}
	double	GetPrevNeckDirection() const
			{
				return m_prev_neck_direction;
			}
	double	GetAngularSpeed() const
			{
				return m_angular_speed;
			}
	double	GetNeckDirection() const
			{
				return m_neck_direction;
			}
	double	GetStamina() const
			{
				return m_stamina;
			}
	int		GetVisualSettings() const
			{
				return m_visual_settings;
			}
	int		GetLocalNumber() const
			{
				return m_local_number;
			}
    double  GetViewAngle() const
            {
                switch(m_visual_settings)
                {
                    case    VISUAL_RANGE_NARROW : return PI/2;
                    case    VISUAL_RANGE_NORMAL : return PI;
                    case    VISUAL_RANGE_WIDE   : return PI*2;
                }
                return 0;
            }
	int		GetApproachDistanceGranularity() const
			{
				return m_approach_distances.size();
			}
	double	GetApproachDistance(); const

	void	SetApproachDistanceGranularity(int gr)
			{
				m_approach_distances.resize(gr);
				for(int i=0;i<m_approach_distances.size();i++) m_approach_distances[i]=0;
			}
	void	SetAngularSpeed(double sp)
			{
				m_angular_speed=sp;
			}
	void	SetPrevNeckDirection(double nd)
			{
				m_prev_neck_direction=nd;
			}
	void	SetNeckDirection(double nd)
			{
				m_neck_direction=nd;
			}
	void	SetStamina(double st)
			{
				m_stamina=st;
			}
	void	SetVisualSettings(int vs)
			{
				m_visual_settings=vs;
			}
	void	SetLocalNumber(int ln)
			{	
				m_local_number=ln;
			}

	bool command_used;


	int GetPlayerNumber() const
            {
                return m_number;
            }
	ESide GetPlayerSide() const
            {
                return m_side;
            }
	double GetGoalie() const
            {
                return m_goalie;
            }
	
	void SetPlayerNumber(int nr)
            {
                m_number=nr;
            }
	void SetPlayerSide(ESide ps)
            {
                m_side=ps;  
            }
	void SetGoalie(double gl)
            {
                m_goalie=gl;
            }

    CWorldModel *GetWorldModel() { return m_my_world; }

	double	virtual TestOwnership(const CSeenPlayer &player,const CAgent &local);//ughly&nasty
	void	virtual Update(CSeenPlayer &player,const CAgent &local);//ughly
	virtual CGameCommand *GetCommand();//nasty
	void	virtual	Precompute();//nasty

	void	UpdateApproachDistances(const CMovingObject &obj,const CAgent &local);//ughly

    double lastturn, lastturnneck;
};


class CBall:public CMovingObject
{
public:
	void UpdateBallPosition(CSeenObject _oBall,const CAgent &seeing);//ughly
	void virtual Precompute();//nasty

// FIXME: filter na rychlost lopty
int m_oldtime;
CDiffuse2DVector m_oldspeed;
CDiffuse2DVector m_oldposition;
};


#define GOT_SEE 1
#define GOT_SENSE_BODY 2
#define GOT_HEAR 4
#define GOT_ALL 7

class CLocalAgent:public CAgent
{
public:
    // FIXME: asi by mali byt uz v CAgentovi
    CStaticField *field;
    CConfig *cfg;

    CGameCommandSeq *actionseq;
    CBasicSkills *bskl;
    CFormationData *fdata;
    CFormationSkills *fskl;
    CTeamData *tdata;
    CTeamSkills *tskl;

    int m_last_catch;

protected:
    CGameTime m_time;
    EPlayMode m_playmode;

    bool m_bGoalie;

    double m_sb_speed; // FIXME

public:

    CGameTime GetTime() const
    {
        return m_time;
    }

    void SetTime(CGameTime t)
    {
        m_time=t;
    }

    EPlayMode GetPlayMode()
    {
        return m_playmode;
    }

    bool IsGoalie()
    {
        return m_bGoalie;
    }

    double GetEffort() const
    {
        return m_effort;
    }

    CLocalAgent();
    virtual ~CLocalAgent();

    void Deliberate(CGameTime cGameTime, CPerceptionSeq *pPerceptionSeq, CGameCommandSeq *pSentCommandSeq, CGameCommandSeq *pGameCommandSeq);
    bool UpdatePlayerPosition(CSeenFlagsVect &_fFlags, CSeenGoalsVect &_gGoals, CSeenLinesVect &_lLines);//nasty&ughly
    bool UpdatePlayerProperties(CSenseBody *sense_body);
    bool UpdatePlayerSeenObjects(CPerception *Perception);
    void virtual Precompute();//nasty
};


typedef vector<CAgent*> Agents;


class CWorldModel
{
	CBall *m_ball;

	Agents m_identified_agents;
	Agents m_unidentified_agents;
//	Agents m_seen_agents;
public:    


	CWorldModel()
	{
		m_ball=new CBall;
	}
	void Recompute(CPerception *Perception,const CAgent &local);
	void Precompute();//nasty
	~CWorldModel()
	{
		delete m_ball;
		int i;
		for(i=0;i<m_identified_agents.size();i++)
		{
			delete m_identified_agents[i];
		}
		for(i=0;i<m_unidentified_agents.size();i++)
		{
			delete m_unidentified_agents[i];
		}

//		for(i=0;i<m_seen_agents.size();i++)
//		{
//			delete m_seen_agents[i];
//		}
	}

    CBall *GetBall() { return m_ball; };
    Agents *GetIdentifiedAgents() { return &m_identified_agents; }
    Agents *GetUnidentifiedAgents() { return &m_unidentified_agents; }

	int GetUnIdentifiedAgentsCount( void ) { return m_unidentified_agents.size(); };
	int GetIdentifiedAgentsCount( void ) { return m_identified_agents.size(); };

	CAgent* GetUnIdentifiedAgent( int index ) { return m_unidentified_agents[index]; };
	CAgent* GetIdentifiedAgent( int index ) { return m_identified_agents[index]; };
};

#endif