// WorldObjects.cpp: implementation of various world object types....
//
//////////////////////////////////////////////////////////////////////

#include "stdAfx.h"
#include "WorldObjects.h"
#include "Player.h"
#include "Coordinator.h"
#include "Logmanager.h"

#include "ChildView.h"  // FIXME
#include "ToDoEvent.h"
#include "TextMessageBuffer.h"

#define MAXPRECOMPUTE  16

// FIXME:
//int local_gametime;

CConfig *cfg;
CStaticField *field;

extern bool g_bCoordinatorInitGoalie;

//int emergency_cnt=0;

inline double WeightFn(double d)
{
	return 1.0 / (0.01 + d);
}

CLocalAgent::CLocalAgent():CAgent()
{
    m_bGoalie = false;
    m_last_catch = 0;

    cfg = new CConfig;
    cfg->Load("server.conf");
    cfg->Load("agent.conf");
    cfg->AssignValues();

    field = new CStaticField(cfg->field_length, cfg->field_width, cfg->penalty_area_length, cfg->penalty_area_width, cfg->goal_width);

    // FIXME
    ::cfg = cfg;
    ::field = field;

    m_time = CGameTime(-1);     // FIXME: len aby spracuval inity
    m_playmode = PM_NONE;
    m_my_world = new CWorldModel;

    m_sb_speed=0;


    bskl  = new CBasicSkills;
    fdata = new CFormationData(field);
    fskl  = new CFormationSkills;
    tdata = new CTeamData;
    tskl  = new CTeamSkills;
}

CLocalAgent::~CLocalAgent()
{
    if (m_my_world) { delete m_my_world;  m_my_world = NULL; }

    if (bskl) { delete bskl;  bskl = NULL; }

    if (fdata) { delete fdata;  fdata = NULL; }

    if (fskl) { delete fskl;  fskl = NULL; }

    if (tdata) { delete tdata;  tdata = NULL; }

    if (tskl) { delete tskl;  tskl = NULL; }

    if (::field) { delete ::field;  ::field = NULL; }

    if (::cfg) { delete ::cfg;  ::cfg = NULL; }
}

void FixTurnNeckSeq(CGameCommandSeq *pGameCommandSeq)
{
    double turnval = 0;
    CGameCommandSeq tmpseq;

    // zistime, ci sa tam nachadza TURN
    CGameCommand *pGameCommand;
    while (pGameCommandSeq->GetGameCommand(&pGameCommand)) {
        if (pGameCommand->GetCmdType() == CT__TURN) {
            turnval = pGameCommand->GetDArg(1);
        }

        // prehodime do pomocnej sekvencie
        tmpseq.AddGameCommand(pGameCommand);
    }

    // vsetky TURN_NECKy upravime zohliadniac vykonany TURN
    while (tmpseq.GetGameCommand(&pGameCommand)) {
        if (pGameCommand->GetCmdType() == CT__NECK) {
            double newval = pGameCommand->GetDArg(1)-turnval;
            // FIXME: pridat orezanie
            pGameCommand->SetDArg(1, newval);
        }

        // po uprave vratime do povodnej sekvencie
        pGameCommandSeq->AddGameCommand(pGameCommand);
    }
}

void CLocalAgent::Deliberate(CGameTime cGameTime, CPerceptionSeq *pPerceptionSeq, CGameCommandSeq *pSentCommandSeq, CGameCommandSeq *pGameCommandSeq)
// vstupy:
//   cGameTime -> cas ku ktoremu sa ma agent rozhodovat
//   pPerceptionSeq -> postupnost vnemy, ktore od posledneho Deliberate prisli
//   pSentCommandSeq -> postupnost povelov, ktore boli poslane serveru 
// vystup:
//   pGameCommandSeq -> postupnost povelov, ktore sa maju odoslat serveru
{
    // poznacime si GameCommandSeq do kontextu kvoli skillsom
    actionseq = pGameCommandSeq;

//local_gametime = cGameTime.m_nAllCycles;

    CPerception *pPerception;
	CGameCommand *pGameCommand;

    static CPerception world_perception;
    static CPerception rPerception0;  // FIXMEEE: pouzivane len na vizualizaciu 

    int received_info = 0;
    int received_info0 = 0;

    // QUICK FIX NA OTACANIE - ZRUSIT KED BUDE DOBRY WORLDMODEL (SO ZAPOCITANIM POSLEDNEJ HRACOVEJ AKCIE)
    double lastplrdir = m_direction;
    double lastneckdir = m_neck_direction;
    //----------------

    // priklad spracovania pSentCommandSeq -> MALO BY SA ROBIT V RECOMPUTE
    // FIXME:  m_cGameTime by sa malo pouzivat vsade miesto m_time
    //         pretoze dokaze pocitat cas, aj ked realny cas zapasu stoji
//    CGameCommand *pGameCommand;
//    while (pSentCommandSeq->GetGameCommand(&pGameCommand))
//    {
        // pre ukazku si budeme kontrolovat, ci neprisli starsie prikazy
//        if (m_cGameTime <= pGameCommand->GetGameTime()) {
//            m_cGameTime = pGameCommand->GetGameTime();
//            if (pGameCommand->GetCmdType() == CT__TURN)
//            {
//                // nastavime premennu pre QUICK FIX podla prveho argumentu turnu (=moment)
//                lastturn = DegToRad(pGameCommand->GetDArg(1));
//            }
//        }
        // nezabudnut vymazat
//        delete pGameCommand;
//    }

    fprintf(m_ff, "\n%d. [%d] deliberate d:%f, nd:%f\n", cGameTime.m_nAllCycles, m_time.m_nAllCycles, (float)RadToDeg(m_direction), (float)RadToDeg(m_neck_direction));

	bool bIsCmd, bIsPerc;

	bIsPerc = bIsCmd = false;

    // ak by sme sa mali rozhodovat pre cas v minulosti, alebo do prilis 
    //   dalekej buducnosti, tak asi nemame spravny cas a potrebujeme si ho nastavit
    if ((cGameTime <= m_time) || (cGameTime >= m_time.m_nAllCycles + MAXPRECOMPUTE))
        m_time = cGameTime;

	// potrebujeme prepocitat svet az do casu cGameTime
	while (cGameTime >= m_time) 
	{

        fprintf(m_ff, "%d. [%d] before_perc d:%f, nd:%f\n", cGameTime.m_nAllCycles, m_time.m_nAllCycles, (float)RadToDeg(m_direction), (float)RadToDeg(m_neck_direction));

		// nacitaj prvy vnem ---------------------------------------------------------
		if (!bIsPerc)
			bIsPerc = pPerceptionSeq->GetPerception(&pPerception);

		// vyhod vsetky moc stare vnemy
		while (bIsPerc && (pPerception->GetGameTime() < m_time)) 
		{
			delete pPerception;

			bIsPerc = pPerceptionSeq->GetPerception(&pPerception);
		}

		// aplikuj vsetky aktualne vnemy
		received_info =  0;
		while (bIsPerc && (pPerception->GetGameTime() == m_time)) 
		{
			switch(pPerception->GetMsgType())
			{
			case MT_See:
				{
					world_perception = *pPerception;  // brrrrr
					received_info |= GOT_SEE;
					
					UpdatePlayerPosition(pPerception->GetSeenFlags(), pPerception->GetSeenGoals(),pPerception->GetSeenLines());
					
					if (m_pReadyView)
					{
						rPerception0 = *pPerception;  // brrrrr
						m_pReadyView->SetNewPerception(&rPerception0);
						
						CChildView *vv = m_pReadyView;
						
						vv->m_pAgent->SetPosition(GetPosition());
						vv->m_pAgent->SetDirection(GetDirection());
						vv->m_pAgent->SetNeckDirection(GetNeckDirection());
						m_pReadyView = NULL;  // FIXMEEEE
						vv->Invalidate();
					}
				}
				break;
			case MT_Hear:
				{
					received_info |= GOT_HEAR;
					fprintf(m_ff, "<hear>\n");
					
					EPlayMode playmode = pPerception->GetPlayMode();
					if (playmode != PM_NONE)  m_playmode = playmode;  // FIXME
				}
				break;
			case MT_SenseBody:
				{
					received_info |= GOT_SENSE_BODY;
					CSenseBody my_body;
					
					pPerception->GetSenseBody(&my_body);
					UpdatePlayerProperties(&my_body);
					
					if (m_pReadyView)
					{
						rPerception0 = *pPerception;
						m_pReadyView->SetNewPerception(&rPerception0);
						
						CChildView *vv = m_pReadyView;
						vv->m_pAgent->SetDirection(GetDirection());
					}
					
				}
				break;
			case MT_Init:
				{
					CInitMsg cInitMsg;
					
					pPerception->GetInitMsg(&cInitMsg);
					SetPlayerSide(cInitMsg.GetSide());
					SetPlayerNumber(cInitMsg.GetUniformNum());
					
					// FIXME:
					m_bGoalie = g_bCoordinatorInitGoalie;
					
					EPlayMode playmode = pPerception->GetPlayMode();
					if (playmode != PM_NONE) m_playmode = playmode;  // FIXME

					// "resetneme" systemovy cas
					m_time = cGameTime;
				}
				break;
			}

			delete pPerception;

			bIsPerc = pPerceptionSeq->GetPerception(&pPerception);
		}

		if (received_info & GOT_SEE)
		{
			UpdatePlayerSeenObjects(&world_perception);
		}		

		received_info0 |= received_info;

		fprintf(m_ff, "%d. [%d] after_perc d:%f, nd:%f\n", cGameTime.m_nAllCycles, m_time.m_nAllCycles, (float)RadToDeg(m_direction), (float)RadToDeg(m_neck_direction));

		// v aktualnom kroku vyskocime -----------------------------------------------
		if (cGameTime == m_time) 
			break;


		// nacitaj prvy command ------------------------------------------------------
		if (!bIsCmd)
			bIsCmd = pSentCommandSeq->GetGameCommand(&pGameCommand);

		while (bIsCmd && (pGameCommand->GetGameTime() < m_time)) 
		{
			delete pGameCommand;
					
			bIsCmd = pSentCommandSeq->GetGameCommand(&pGameCommand);
		}

		while (bIsCmd && (pGameCommand->GetGameTime() == m_time))
		{
			switch(pGameCommand->GetCmdType())
			{
			case CT__TURN:
				{						
					double zmena=DegToRad((pGameCommand->GetDArg(1))/(1.0+5.0*m_speed.GetDistance()*0.9));
					fprintf(m_ff, "ct__turn %f\n", (float)RadToDeg(zmena));
					m_direction+=zmena;
					m_prev_neck_direction=m_neck_direction;
					m_neck_direction+=zmena;
					m_angular_speed=zmena;
					m_see_status|=PREV_NECK_DIRECTION|EXPECTED_ANGULAR_SPEED;
					fprintf(m_ff, "%d. [%d] turnfix d:%f, nd:%f\n", cGameTime.m_nAllCycles, m_time.m_nAllCycles, (float)RadToDeg(m_direction), (float)RadToDeg(m_neck_direction));
				}
				break;
			case CT__NECK:
				{
					double zmena=DegToRad(pGameCommand->GetDArg(1));
					m_prev_neck_direction=m_neck_direction;
					m_neck_direction+=zmena;
					m_angular_speed=zmena;
					m_see_status|=PREV_NECK_DIRECTION|EXPECTED_ANGULAR_SPEED;
				}
				break;
			case CT__KICK:
				{
				}
				break;
			case CT__DASH:
				{
					double pwr=m_effort*pGameCommand->GetDArg(1);
					m_acceleration=0.06*pwr*CDiffuse2DVector(CAngular2DVector(1,m_direction),0.05);
					m_stamina=__max(0,m_stamina-pwr);
				}
				break;
			case CT__MOVE:
				{
					//m_see_status=0;
					m_position=CDiffuse2DVector(pGameCommand->GetDArg(1),pGameCommand->GetDArg(2),0);
					m_speed=CDiffuse2DVector(0,0,0);
					m_acceleration=CDiffuse2DVector(0,0,0);
				}
				break;

				//				if (pGameCommand->GetCmdType() == CT__TURN)
				//				{
				//					// nastavime premennu pre QUICK FIX podla prveho argumentu turnu (=moment)
				//					lastturn = DegToRad(pGameCommand->GetDArg(1));
				//.				}
				
			}

			delete pGameCommand;
			
			bIsCmd=pSentCommandSeq->GetGameCommand(&pGameCommand);
		}

		fprintf(m_ff, "%d. [%d] after_cmd d:%f, nd:%f\n", cGameTime.m_nAllCycles, m_time.m_nAllCycles, (float)RadToDeg(m_direction), (float)RadToDeg(m_neck_direction));

		// precompute ----------------------------------------------------------------
		Precompute();

		fprintf(m_ff, "%d. [%d] after_precmp d:%f, nd:%f\n", cGameTime.m_nAllCycles, m_time.m_nAllCycles, (float)RadToDeg(m_direction), (float)RadToDeg(m_neck_direction));
	}

	if (bIsPerc) {
		fprintf(m_ff, "nespracovany perception\n");
		delete pPerception;
		bIsPerc = false;
	}

	if (bIsCmd) {
		fprintf(m_ff, "nespracovany gamecommand\n");
		delete pGameCommand;
		bIsCmd = false;
	}

    // nastavime presny cas, ku ktoremu sme prepocitali svet
    m_time = cGameTime;

    // fprintf(m_ff, "%d. [%d] exit d:%f, nd:%f\n", cGameTime.m_nAllCycles, m_time.m_nAllCycles, (float)RadToDeg(m_direction), (float)RadToDeg(m_neck_direction));

    //////////////////////////////////////////////////////////////////
    // no podme uz konecne nieco robit...

    // FIXMEE: aby neposielal moc casto, tak zatial len ak pride
    //   sense body spolu so see
// if((received_info0 & (GOT_SENSE_BODY|GOT_SEE)) == (GOT_SENSE_BODY|GOT_SEE)) 
	{
		/* if((emergency_cnt++)%3)
		{
			bskl->Dash (this,100);
		}
		else
		{
			bskl->Turn (this,DegToRad(11));
		}

		return; */

//      *******************
        tskl->Behave(this);
//      *******************

        FixTurnNeckSeq(actionseq);
	}

}

void  CLocalAgent::Precompute()//nasty
{
    CAgent::Precompute();
    m_acceleration=CDiffuse2DVector(0,0,0.05);
    ++m_time;
}

bool CLocalAgent::UpdatePlayerProperties(CSenseBody *sense_body)
{
    m_see_status|=SEE_BODY_DIRECTION|SEE_STAMINA|SEE_EFFORT|SEE_DISTANCE_CHANGE;//|SEE_ANGLE_CHANGE;

    if( !(m_see_status & EXPECTED_ANGLE_CHANGE || m_see_status & SEE_ANGLE_CHANGE))
    {
        m_speed.SetXYDiffusion(1,0,100);
    }

	if(sense_body->GetSpeedDir()<10000)
	{
		m_speed.SetAngleDistance(DegToRad(sense_body->GetSpeedDir())+m_neck_direction,sense_body->GetSpeed());
		m_speed.SetDiffusion ((0.01+DegToRad(sense_body->GetSpeed()))/2);
		m_see_status|=SEE_ANGLE_CHANGE;
		//m_speed=CDiffuse2DVector(1,1,0);
	}
	else
	{
		m_speed.SetDistance(sense_body->GetSpeed());
		//m_speed=CDiffuse2DVector(-1,-1,0);
	}
	m_sb_speed=sense_body->GetSpeed();
    m_stamina=sense_body->GetStamina();
    m_effort=sense_body->GetEffort();
    m_direction=(AngNormalise (m_neck_direction) - DegToRad(sense_body->GetHeadDir()));
    return true;
}

bool CLocalAgent::UpdatePlayerSeenObjects(CPerception *Perception)
{
	if(m_my_world)
	{
		m_my_world->Recompute(Perception,*this);
		return true;
	}
	else
	{
		return false;
	}
}

double Quantize(double x,double d)
{
	return d*floor(x/d+0.5);
}

double ExpQuantize(double x,double de,double d)
{
	return Quantize(exp(Quantize(log(x),de)),d);
}

double minQ(double x,double d)
{
	double rd=ceil(x/d);
	return d*(rd-0.5);
}

double maxQ(double x,double d)
{
	double rd=floor(x/d+1e-11);
	return d*(rd+0.5);
}


double minEQ(double x,double de,double d)
{
	double mn =minQ(x,d);
	double lmn=log(mn);
	double en=minQ(lmn,de);
	double een=exp(en);
	return een;
}

double maxEQ(double x,double de,double d)
{
	double mn =maxQ(x,d);
	double lmn=log(mn);
	double en=maxQ(lmn,de);
	double een=exp(en);
	return een;
}

//#define PI (3.141592654)

//double AngleDistance(double a1,double a2)
//{
//	double da=AngNormalise(a2)-AngNormalise(a1);
//
//	if(da >PI) da-=2*PI;
//	if(da<-PI) da+=2*PI;
//	return da;
//}


bool CLocalAgent::UpdatePlayerPosition(CSeenFlagsVect &_fFlags, CSeenGoalsVect &_gGoals, CSeenLinesVect &_lLines)//nasty&ughly
{
	//flagy a goaly
//	int fsz = _fFlags.size();
//	DiffusePointVector flag_points;
//	flag_points.resize(fsz);

//	int i;

	// spocitat relativne suradnice bodov

//	for(i = 0; i < fsz; i++)
//	{
//		CAngular2DVector flag_ang(DegToRad(_fFlags[i].GetDirection())  , _fFlags[i].GetDistance());
//		flag_points[i] = CDiffuse2DVector(flag_ang , 0.1 , 0.01 , 0.1);
//	}

/*
	int		iFlag1 = -1;
	int		iFlag2 = -1;
//	int		iFlagM = -1;
	int		iMaxAngle = -1000;
	int		iDeltaAngle;
	int		iFlag1Direction;
	double	r1, r2;				// the distance of the player to the flags 
	double	dist, dist2;		// the distance (square) of the two flags
	double	a;						// distance from one flag to intersection point P3
	double	h;						// distance from P3 to the intersection Points P1 and P2 of the two circles
	double	x, x1, x2, x3;
	double	y, y1, y2, y3;
//	double	ratio;
//	double	dMaxDist;
	int		iFlagDir; //, iAbsDirection;
//	int		beta;

	// search for two visible flags with maximal difference of the view angle
//	dMaxDist = 0;

	// zastavka najviac vpravo 
	for (i = 0; i < fsz; i++)
	{
		if (_fFlags[i].GetDistance() > 4.0) {
            iFlagDir = _fFlags[i].GetDirection();
            if ((iFlag1 == -1) || (iFlagDir < iFlag1Direction)) {
                iFlag1 = i;
                iFlag1Direction = iFlagDir;
            }
		}
	}

	for (i = 0; i < fsz; i++)
	{
		if (_fFlags[i].GetDistance() > 4.0)
		{
			iFlagDir = _fFlags[i].GetDirection();
			if ((iFlag1 == -1) || (iFlag1 == i))
			{
				// found the first visible flag
				iFlag1 = i;
				iFlag1Direction = iFlagDir;
			}
			else
			{
				iDeltaAngle = iFlag1Direction - iFlagDir;
				if (iDeltaAngle < 0)
					iDeltaAngle = -iDeltaAngle;
				if (iDeltaAngle > iMaxAngle)
				{
					// this flag has a bigger angle to the first flag
					iFlag2 = i;
					iMaxAngle = iDeltaAngle;
				}
			}
			if (iFlagDir < 0) iFlagDir = -iFlagDir;
//			if (dMaxDist < _fFlags[i].GetDistance()) {
//				iFlagM = i;
//				dMaxDist = _fFlags[i].GetDistance();
//			}
		}
	}

	if (iFlag2 == -1)
		// there are not 2 visible flags
		return FALSE;

	// do the calculations
	r1 = _fFlags[iFlag1].GetDistance();
	r2 = _fFlags[iFlag2].GetDistance();

	x1 = field->GetFlag(_fFlags[iFlag1].GetFlagID()).GetX();
	x2 = field->GetFlag(_fFlags[iFlag2].GetFlagID()).GetX();

	y1 = field->GetFlag(_fFlags[iFlag1].GetFlagID()).GetY();
	y2 = field->GetFlag(_fFlags[iFlag2].GetFlagID()).GetY();

	// calculate the square distance of the two flags
	dist2 = (x2 - x1)*(x2 - x1) + (y2 - y1)*(y2 - y1);	
	dist = sqrt(dist2);
	if (dist > r1 + r2)
	{
		// the circles would not intersect
		dist = r1 + r2;
		dist2 = dist * dist;
	}
	else if ((r1 > r2) && (dist + r2 < r1))
	{
		// the circles would not intersect
		dist = r1 - r2;
		dist2 = dist * dist;
	}
	else if ((r2 > r1) && (dist + r1 < r2))
	{
		// the circles would not intersect
		dist = r2 - r1;
		dist2 = dist * dist;
	}

	r1 *= r1;
	r2 *= r2;
	
	// a = (r1^2 - r2^2 + d^2 ) / (2 d) 
	a = (r1 - r2 + dist2) / (2.0 * dist);
	// h^2 = r1^2 - a^2
	h = r1 - a*a;
	if (h < 0.0)
		h = 0.0;
	else
		h = sqrt(h);

	// P3 = P1 + a ( P2 - P1 ) / d
	x3 = x1 + a * (x2 - x1) / dist;
	y3 = y1 + a * (y2 - y1) / dist;

	// two circles intersect usually in 2 points. Find out which one to select
	if (_fFlags[iFlag1].GetDirection() > _fFlags[iFlag2].GetDirection())
	{
		// result x = x3 + h ( y2 - y1 ) / d 
		x = x3 + h * (y2 - y1) / dist;
		// result y = y3 - h ( x2 - x1 ) / d 
		y = y3 - h * (x2 - x1) / dist;
	}
	else
	{
		x = x3 - h * (y2 - y1) / dist;
		y = y3 + h * (x2 - x1) / dist;
	}

    m_position.SetXY(x, y);
//    fprintf(m_ff, "pos: %d, %d\n", (int)x, (int)y);
//	m_pThisPlayer->SetPosition(x, y);
//	m_pThisPlayer->SetAbsSpeed(m_pThisPlayer->GetPosition() - m_pThisPlayer->GetOldPos());

	double max_dist = 0;

	if (m_pLine[0]->IsValid() && (max_dist < m_pLine[0]->GetDistance())) 
	{	// left 
		max_dist = m_pLine[0]->GetDistance();
		if (m_pLine[0]->GetDirection()>=0)
			m_pThisPlayer->SetAbsDirection(90 + m_pLine[0]->GetDirection());
		else m_pThisPlayer->SetAbsDirection(270 + m_pLine[0]->GetDirection());
	}
	if (m_pLine[1]->IsValid() && (max_dist < m_pLine[1]->GetDistance())) 
	{	// right line
		max_dist = m_pLine[1]->GetDistance();
		if (m_pLine[1]->GetDirection()>=0)
			m_pThisPlayer->SetAbsDirection(m_pLine[1]->GetDirection()-90);
		else m_pThisPlayer->SetAbsDirection(m_pLine[1]->GetDirection()+90);
	}
	if (m_pLine[2]->IsValid() && (max_dist < m_pLine[2]->GetDistance())) 
	{	// top line
		max_dist = m_pLine[2]->GetDistance();
		if (m_pLine[2]->GetDirection()>=0)
			m_pThisPlayer->SetAbsDirection(	m_pLine[2]->GetDirection());
		else m_pThisPlayer->SetAbsDirection(m_pLine[2]->GetDirection()+180);
		
	}
	if (m_pLine[3]->IsValid() && (max_dist < m_pLine[3]->GetDistance())) 
	{	//bottom
		max_dist = m_pLine[3]->GetDistance();
		if (m_pLine[3]->GetDirection()>=0)
			m_pThisPlayer->SetAbsDirection(	m_pLine[3]->GetDirection()-180);
		else m_pThisPlayer->SetAbsDirection(m_pLine[3]->GetDirection());
	}
	if (max_dist == 0) {
		// calculate the absolute direction
		r1 = m_pFlag[iFlagM]->GetDistance();
		x1 = m_pFlag[iFlagM]->GetAbsX();
		y1 = m_pFlag[iFlagM]->GetAbsY();
		ratio = (y1 - y) / r1;
		beta = (int) (asin(ratio) * RAD2DEG);
		if (x > x1)
			iAbsDirection = 180 - beta + m_pFlag[iFlagM]->GetDirection();
		else
			iAbsDirection = beta + m_pFlag[iFlagM]->GetDirection();
		
		if (iAbsDirection > 180)  iAbsDirection -= 360;
		if (iAbsDirection < -180)  iAbsDirection += 360;
		
		m_pThisPlayer->SetAbsDirection(iAbsDirection);
	}
*/	

	//flagy a goaly



	int i,j;


	double E;
//	double S;
	double angle;
	C2DVector poz;

	double flag_angle;
	double line_angle;

	C2DVector flag_poz;
	C2DVector line_poz;

	bool flag_angle_valid=false;
	bool flag_poz_valid=false;

	bool line_angle_valid=false;
	bool line_poz_valid=false;

	bool cut_poz_valid=false;

	double flag_E;
	double line_E;

	double flag_S;
	double line_S;


	int lsz = _lLines.size();
	
	int fsz = _fFlags.size();
	int gsz = _gGoals.size();
	DiffusePointVector flag_points , goal_points;
	DiffusePointVector flag_speeds , goal_speeds;

	flag_points.resize(fsz);
	goal_points.resize(gsz);

	int ssz=fsz+gsz;

	DiffusePointVector points,speeds;
	PointVector def_points;
	AngularVector ang_points;
	AngularVector ang_speeds;
	boolVector spd_valid;
	
	
	points.resize(ssz);
	def_points.resize(ssz);
	ang_points.resize(ssz);
	ang_speeds.resize(ssz);
	spd_valid.resize (ssz);


//	int i;

	// spocitat relativne suradnice bodov

	for(i = 0 ; i < fsz ; i++)
	{
		CAngular2DVector flag_ang(DegToRad(_fFlags[i].GetDirection())  , _fFlags[i].GetDistance());
		flag_points[i] = CDiffuse2DVector(flag_ang , 0.1 , 0.01 , 0.1);
		points[i] = CDiffuse2DVector(flag_ang , 0.1 , 0.01 , 0.1);
		def_points[i]=field->GetFlag(_fFlags[i].GetFlagID());
		ang_points[i]=flag_ang;
		spd_valid[i]=false;
		if((_fFlags[i].GetSetValuesVar()&SEE_DISTANCE_CHANGE) &&(_fFlags[i].GetSetValuesVar()&SEE_ANGLE_CHANGE))
		{
			ang_speeds[i]=CAngular2DVector(DegToRad(_fFlags[i].GetDirectionChng()),_fFlags[i].GetDistanceChng());

			if(_fFlags[i].GetDistanceChng()<10)
			{
				spd_valid[i]=true;
			}
			


		}
	}

	for(i = 0 ; i < gsz ; i++)
	{
		CAngular2DVector goal_ang(DegToRad(_gGoals[i].GetDirection()) , _gGoals[i].GetDistance());
		goal_points[i] = CDiffuse2DVector(goal_ang , 0.1 , 0.01 , 0.1);
		points[i+fsz] = CDiffuse2DVector(goal_ang , 0.1 , 0.01 , 0.1);
		def_points[i+fsz]=field->GetGoal(_gGoals[i].GetGoalID());
		ang_points[i+fsz]=goal_ang;
		spd_valid[i+fsz]=false;
		if((_gGoals[i].GetSetValuesVar()&SEE_DISTANCE_CHANGE) &&(_gGoals[i].GetSetValuesVar()&SEE_ANGLE_CHANGE))
		{
			ang_speeds[i+fsz]=CAngular2DVector(DegToRad(_gGoals[i].GetDirectionChng()),_gGoals[i].GetDistanceChng());
			
			if(_gGoals[i].GetDistanceChng()<10)
			{
				spd_valid[+fsz]=true;
			}
			
			
			
		}
	}

	double r;

	//vahovany aritmenicky priemer...
	flag_S=0;

	C2DVector T , P , t , p;

	bool is_angle=false;
	
	for(i = 0 ; i < ssz ; i++)
	{
		r = WeightFn(points[i].GetDiffusion());

		T += r * def_points[i];
		P += r * points[i];
		flag_S += r;
	}

	double difE=8000;
//	C2DVector poz;
//	float angle;

	if(flag_S > 0)
	{
		T/=flag_S;
		P/=flag_S;

		double A = 0,B = 0,C = 0;

		for(i = 0 ; i < ssz ; i++)
		{
			r = WeightFn(points[i].GetDiffusion());
			t = T - def_points[i];
			p = points[i];

			A += r * (p & P);
			B += r * (p & t);
			C += r * (p * t);
		}

		float telen=sqrt(B * B + C * C);
		if(telen!=0)
		{
			flag_angle = (acosf(A / sqrt(B * B + C * C)) + atan2( C , B));
			flag_angle_valid=true;
		}
	}



	line_S=0;

	double an=0;
	
	for(i=0;i<lsz;i++)
	{
		
		double at=field->GetLine (_lLines[i].GetLineID()).GetAngle ();
		double ai=DegToRad(_lLines[i].GetDirection());
		
		ELineType tp=_lLines[i].GetLineID();
		
		double da=ai-at;

		bool i_am_here=false;
		
		if(flag_angle_valid)
		{
			if(fabs(AngDistance (da,flag_angle))>PI/2)
			{
				da=AngNormalise (da+PI);	//other side of a line
			}
			i_am_here=true;
		}
		else
		{
			if(m_see_status&EXPECTED_ANGLE)
			{
				if(fabs(AngDistance (da,m_neck_direction))>PI/2)
				{
					da=AngNormalise (da+PI);	//other side of a line
				}
				i_am_here=true;
			}

		}
		
		if(i_am_here)
		{
			an+=da;
			line_S+=1;
		}
	}
	
	if(line_S!=0)
	{
		line_angle=an/line_S;
		line_angle_valid=true;
	}
	
	if(line_angle_valid)
	{
		if(flag_angle_valid)
		{
			angle=line_angle;//line_angle je vzdy lepsi
		}
		else
		{
			angle=line_angle;
		}
	}
	else
	{
		if(flag_angle_valid)
		{
			angle=flag_angle;
		}
		else
		{
		}
	}
	
	if( (flag_angle_valid|| line_angle_valid) && flag_S>0)
	{
		flag_poz = T - Rot(P , -angle);

        // na zaver este zratame svoju vlastnu neurcitost...

		flag_E=0;

		for(i = 0 ; i < ssz ; i++)
		{
			p = points[i] - Rot(def_points[i] - flag_poz , angle);

			flag_E += WeightFn(points[i].GetDiffusion()) * (p * p);
		}
		flag_poz_valid=true;

		flag_E=sqrt(flag_E / flag_S);	
	}




	if( (flag_angle_valid|| line_angle_valid) && lsz>1)
	{
		double A=0,B=0,C=0,G=0,H=0;
		line_S=0;
		for(i=0;i<lsz;i++)
		{
			double an=field->GetLine (_lLines[i].GetLineID()).GetAngle ();
			double dn=field->GetLine (_lLines[i].GetLineID()).GetShift ();
			double di=_lLines[i].GetDistance();
			
			
			double SCL=(-cos(angle)*sin(an)+sin(angle)*cos(an));
			if(SCL!=0)
			{
				SCL=1.0/SCL;
				double EX =-sin(an)*SCL;
				double EY = cos(an)*SCL;
				double ED = dn*SCL;
				
				
				//E=sum( ( (X*EX+Y*EY+dn) - Di )^2 );
				
				//aE/Ax= sum(  X*(EX*EX) + Y*(EX*EY)  +  ((dn-Di)*EX) );
				//aE/Ax= sum(  X*(EY*EX) + Y*(EY*EY)  +  ((dn-Di)*EY) );
				
				A+=EX*EX;
				B+=EX*EY;
				C+=EY*EY;
				
				G=(dn-di)*EX;
				H=(dn-di)*EY;
				
				line_S+=1;
			}
			
		}
		
		//Ax+By=G;
		//Bx+Cy=H;
		
		
		//ABx+BBy=GB;
		//ABx+ACy=HA;
		
		if(line_S>0)
		{
			double det=(B*B-A*C);
			
			if(det!=0)
			{
				double l_x=(H*B-G*C)/det;
				double l_y=(G*B-H*A)/det;
				
				line_poz.SetXY(l_x,l_y);
				
				for(i=0;i<lsz;i++)
				{
					double an=field->GetLine (_lLines[i].GetLineID()).GetAngle ();
					double dn=field->GetLine (_lLines[i].GetLineID()).GetShift ();
					double di=_lLines[i].GetDistance();
					
					
					line_E=0;
					
					double SCL=(-cos(angle)*sin(an)+sin(angle)*cos(an));
					if(SCL!=0)
					{
						SCL=1.0/SCL;
						double EX =-sin(an)*SCL;
						double EY = cos(an)*SCL;
						double ED = dn*SCL;
						
						
						double p=l_x*EX+l_y*EY+dn-di;
						
						line_E+=p*p;
					}
				}
				line_E=sqrt(line_E/line_S);
				line_poz_valid=true;
			}
		}
	}
	

	if(flag_poz_valid)
	{
		if(line_poz_valid)
		{
			if(line_E>3*flag_E) //line_E je 2*sqrt(3) krat nespolahlivejsie
			{
				E=flag_E;
				poz=flag_poz;
			}
			else
			{
				E=line_E;
				poz=line_poz;
			}
		}
		else
		{
			E=flag_E;
			poz=flag_poz;
		}
	}
	else
	{
		E=line_E;
		poz=line_poz;
	}
	
	double xmin=-2000;
	double xmax= 2000;
	double ymin=-2000;
	double ymax= 2000;

	double cx,cy;


	for(i=0;i<ssz;i++)
	{
		for(j=i+1;j<ssz;j+=1)
		{

			double d12=(def_points[j].GetX()-def_points[i].GetX())*(def_points[j].GetX()-def_points[i].GetX())+(def_points[j].GetY()-def_points[i].GetY())*(def_points[j].GetY()-def_points[i].GetY());
			double d12s=sqrt(d12);
			double ddx= (def_points[j].GetX()-def_points[i].GetX());
			double ddy= (def_points[j].GetY()-def_points[i].GetY());
			double sdx= def_points[i].GetX();
			double sdy= def_points[i].GetY();
			
			double d1L=minEQ(ang_points[i].GetDistance(),0.01,0.1);
			double d1H=maxEQ(ang_points[i].GetDistance(),0.01,0.1);
			double d2L=minEQ(ang_points[j].GetDistance(),0.01,0.1);
			double d2H=maxEQ(ang_points[j].GetDistance(),0.01,0.1);

			if(d1L+d2L<d12s)
			{
				continue;
			}

			if(d1H>d12s+d2L)
			{
				continue;
				d1H=d12s+d2L;
			}

			if(d2H>d12s+d1L)
			{
				continue;
				d2H=d12s+d1L;
			}

			double xp[4],yp[4];

			d1L*=d1L;
			d1H*=d1H;
			d2L*=d2L;
			d2H*=d2H;

			double tm,t;
			double xm,ym;

			bool minflag= AngDistance(ang_points[j].GetAngle(),ang_points[i].GetAngle())<0;



			tm=0.5*((d1L-d2L)/d12+1);
			
			xm=sdx+(ddx)*tm;
			ym=sdy+(ddy)*tm;

			t=sqrt(d1L/d12-tm*tm);

			if(minflag) t=-t;

			xp[0]=xm-ddy*t;
			yp[0]=ym+ddx*t;

			tm=0.5*((d1H-d2L)/d12+1);
			
			xm=sdx+(ddx)*tm;
			ym=sdy+(ddy)*tm;

			t=sqrt(d1H/d12-tm*tm);

			if(minflag) t=-t;

			xp[1]=xm-ddy*t;
			yp[1]=ym+ddx*t;


			tm=0.5*((d1L-d2H)/d12+1);
			
			xm=sdx+(ddx)*tm;
			ym=sdy+(ddy)*tm;

			t=sqrt(d1L/d12-tm*tm);

			if(minflag) t=-t;

			xp[2]=xm-ddy*t;
			yp[2]=ym+ddx*t;



			tm=0.5*((d1H-d2H)/d12+1);
			
			xm=sdx+(ddx)*tm;
			ym=sdy+(ddy)*tm;

			t=sqrt(d1H/d12-tm*tm);

			if(minflag) t=-t;

			xp[3]=xm-ddy*t;
			yp[3]=ym+ddx*t;


			double xl=2000;
			double xh=-2000;
			double yl=2000;
			double yh=-2000;

			for(int l=0;l<4;l++)
			{
				if(xl>xp[l]) xl=xp[l];
				if(xh<xp[l]) xh=xp[l];
				if(yl>yp[l]) yl=yp[l];
				if(yh<yp[l]) yh=yp[l];
			}

			double k=1.2;

			double xln=((1+k)*xl+(1-k)*xh)/2;
			double xhn=((1-k)*xl+(1+k)*xh)/2;
			double yln=((1+k)*yl+(1-k)*yh)/2;
			double yhn=((1-k)*yl+(1+k)*yh)/2;

			xmin=__max(xln,xmin);
			xmax=__min(xhn,xmax);
			ymin=__max(yln,ymin);
			ymax=__min(yhn,ymax);
		}
	}

	
	cx=(xmin+xmax)/2;
	cy=(ymin+ymax)/2;

	double cut_E=__max(fabs((xmax-xmin))/2,fabs((ymax-ymin))/2);

	if(cut_E<10) // if algorithm works, it never will be higher than cca 7.6!!!
	{
		cut_poz_valid=true;
	}


	if(flag_angle_valid || line_angle_valid)
	{

		double spd_a,spd_n;//going to correct speed
		if( (m_see_status&SEE_ANGLE_CHANGE) && (m_see_status&SEE_ANGLE_CHANGE))
		{
			spd_a=AngNormalise (m_speed.GetAngle ()-m_neck_direction);
		}
			
		if( m_see_status&SEE_BODY_DIRECTION )
		{
			spd_n=AngNormalise (m_direction-m_neck_direction);
		}

		angle=AngNormalise( angle );

		if(m_see_status&PREV_NECK_DIRECTION)
		{
						m_angular_speed=m_neck_direction-m_prev_neck_direction;
						m_see_status|=EXPECTED_ANGULAR_SPEED;
		}

		m_neck_direction =AngNormalise(-angle);

		if( (m_see_status&SEE_ANGLE_CHANGE) && (m_see_status&SEE_ANGLE_CHANGE))
		{
			m_speed.SetAngle(AngNormalise (spd_a+m_neck_direction));
		}
		
		if( m_see_status&SEE_BODY_DIRECTION )
		{
			m_direction=AngNormalise (spd_n+m_neck_direction);
		}

		m_see_status|=SEE_NECK_DIRECTION;
	}
		
	
	CDiffuse2DVector old=m_position;

	if(flag_poz_valid || line_poz_valid)
	{
		if(cut_poz_valid)
		{
			if(cut_E>10*E)
			{
				m_see_status|=SEE_ANGLE|SEE_DISTANCE;
				m_position.SetVDiffusion(poz , E);
			}
			else
			{
				m_see_status|=SEE_ANGLE|SEE_DISTANCE;
				m_position.SetXYDiffusion(cx,cy,cut_E);
			}
		}
		else
		{
			m_see_status|=SEE_ANGLE|SEE_DISTANCE;
			m_position.SetVDiffusion(poz , E);
		}
		
	}
	else
	{
		if(cut_poz_valid)
		{
			m_see_status|=SEE_ANGLE|SEE_DISTANCE;
			m_position.SetXYDiffusion(cx,cy,cut_E);
		}
		
	}


	double VS=0;
	C2DVector VSpeed;

	double VE=0;

	bool v_speed_valid=false;
	bool c_speed_valid=false;
	

	CDiffuse2DVector SeenSpeed,ComputedSpeed;
	

	for(i = 0 ; i < ssz ; i++)
	{
		if(spd_valid[i])
		{
			CAngular2DVector normal(ang_points[i].GetAngle()+m_neck_direction,ang_speeds[i].GetDistance());
			CAngular2DVector tangent(ang_points[i].GetAngle()+m_neck_direction+PI/2,ang_speeds[i].GetAngle()*ang_points[i].GetDistance());

			double e=(0.1+0.02*ang_points[i].GetDistance()+PI/180*ang_points[i].GetDistance())/2;
			r=WeightFn(e);
			

			VSpeed+=r*( (C2DVector)normal +(C2DVector)tangent);
			VE+=r*e;
			VS+=r;
		}
	}


	if(VS>0)				
	{
		VE/=VS;
		VSpeed/=VS;
		if(VSpeed.GetDistance()<3)
		{
			v_speed_valid=true;
		}
		SeenSpeed=CDiffuse2DVector(VSpeed,VE);
	}
			
	
	CDiffuse2DVector dif=old-m_position;

    if(dif.GetDiffusion()*5<dif.GetDistance())
    {
		m_see_status &= (~PREV_MASK) & (~EXPECTED_DISTANCE_CHANGE) &(~EXPECTED_ANGLE_CHANGE);
	}



		
    if( (m_see_status& PREV_POSITION) && (m_see_status&SEE_DISTANCE) && (m_see_status&SEE_ANGLE))
    {
		ComputedSpeed=m_position-m_prev_position;
		if(ComputedSpeed.GetDistance ()<4)
		{
			c_speed_valid=true;
		}
	}


	CDiffuse2DVector Speed;





	if(v_speed_valid)
	{
		if(c_speed_valid )
		{
//			Speed=SeenSpeed;//seen speed is allways better
			Speed=ComputedSpeed;
		}
		else
		{
			Speed=SeenSpeed;
		}
	}
	else
	{
		if(c_speed_valid )
		{
			Speed=ComputedSpeed;
		}
		else
		{
		}
	}


	if(c_speed_valid||v_speed_valid)
	{
		if( !(m_see_status&SEE_ANGLE_CHANGE))
		{
			if(!(m_see_status&SEE_DISTANCE_CHANGE))
			{
				m_see_status|=SEE_DISTANCE_CHANGE|SEE_ANGLE_CHANGE;
				m_speed=0.95*m_speed+0.05*Speed;
			}
			else
			{
				m_see_status|=SEE_ANGLE_CHANGE;
				double da=m_speed.GetDistance ();
				Speed.SetDistance (da);

				m_speed=0.95*m_speed+0.05*Speed;
				m_speed.SetDistance (da);
			}
		}
	}

//	m_speed=CDiffuse2DVector(1,1,0.5);
	if( (m_see_status&SEE_ANGLE_CHANGE) || (m_see_status&SEE_ANGLE_CHANGE))
	{
        if(m_see_status&PREV_SPEED)
        {
            m_acceleration=CDiffuse2DVector(0,0,0);//m_speed-m_prev_speed;
            m_see_status|=EXPECTED_ACCELERATION;
        }
    }

	return true;
}


void CAgent::UpdateApproachDistances(const CMovingObject &obj,const CAgent &local)//ughly
{
	CAngular2DVector pt(obj.GetPosition());
	m_approach_distances[m_approach_distances.size()*pt.GetAngle()/2/PI] =
        __max(0,pt.GetDistance()-obj.GetPosition().GetDiffusion());
}

void CMovingObject::Precompute()
{
	if(m_see_status&SEE_SIDE)
	{
		m_see_status|=EXPECTED_SIDE;
	}

	if(m_see_status&SEE_NUMBER)
	{
		m_see_status|=EXPECTED_NUMBER;
	}

	if(m_see_status&SEE_ANGLE)
	{
		m_see_status|=EXPECTED_ANGLE;
	}

	if(m_see_status&SEE_DISTANCE)
	{
		m_see_status|=EXPECTED_DISTANCE;
	}

	if(m_see_status&SEE_ANGLE_CHANGE)
	{
		m_see_status|=EXPECTED_ANGLE_CHANGE;
	}

	if(m_see_status&SEE_DISTANCE_CHANGE)
	{
		m_see_status|=EXPECTED_DISTANCE_CHANGE;
	}

	if(m_see_status&SEE_BODY_DIRECTION)
	{
		m_see_status|=EXPECTED_BODY_DIRECTION;
	}

	if(m_see_status&SEE_NECK_DIRECTION)
	{
		m_see_status|=EXPECTED_NECK_DIRECTION;
	}

	if(m_see_status&SEE_STAMINA)
	{
		m_see_status|=EXPECTED_STAMINA;
	}

	if(m_see_status&SEE_EFFORT)
	{
		m_see_status|=EXPECTED_EFFORT;
	}

	m_see_status&=(EXPECTED_MASK);

	if(m_see_status&EXPECTED_ANGLE && m_see_status&EXPECTED_DISTANCE)
	{
		m_prev_position=m_position;
		m_see_status|=PREV_POSITION;
	}
	if(m_see_status&EXPECTED_ANGLE_CHANGE && m_see_status&EXPECTED_DISTANCE_CHANGE)
	{
		m_prev_speed=m_speed;
		m_see_status|=PREV_SPEED;
	}
	if(m_see_status&EXPECTED_ACCELERATION)
	{
		m_prev_acceleration=m_acceleration;
		m_see_status|=PREV_ACCELERATION;
	}

	m_position+=m_speed;
	m_speed=m_speed*0.9+m_acceleration;
	m_speed.SetDistance(__min(1,m_speed.GetDistance()));
//	double pos_un=1.0-m_speed.GetDistance();
	m_speed.SetDiffusion(__min(1,m_speed.GetDiffusion()));
	m_acceleration=CDiffuse2DVector(0,0,1);
}





CDiffuse2DVector DoFilter(CDiffuse2DVector org_val,CDiffuse2DVector new_val)
{
	double diff=__max(0,__min(2,new_val.GetDiffusion ()));
	double weight=0.75*exp(-1.4*diff);
	return org_val*(1-weight)+weight*new_val;
}









void CBall::UpdateBallPosition(CSeenObject _oBall,const CAgent &local)//ughly
{
	int flags=_oBall.GetSetValuesVar();
	
	if(flags &(SEE_ANGLE|SEE_DISTANCE))
	{
        fprintf(m_ff, "{ball %lf}\n", (double)_oBall.GetDirection());

//        if (fabs(_oBall.GetDirection())>15) 
//            fprintf(m_ff, "xx");

		CDiffuse2DVector position(CAngular2DVector(DegToRad(_oBall.GetDirection())+local.GetNeckDirection(),_oBall.GetDistance()),0.1,0.1,0.1);

		m_position=position+CDiffuse2DVector((C2DVector)local.GetPosition(),0);

        m_see_status|=SEE_ANGLE|SEE_DISTANCE;
		double e=1000;

		CDiffuse2DVector CSpeed,VSpeed;
		bool Cspeed_valid=false,Vspeed_valid=false;

		if((flags & SEE_ANGLE_CHANGE) &&(flags & SEE_DISTANCE_CHANGE))
		{
			CAngular2DVector normal (DegToRad(_oBall.GetDirection())+local.GetNeckDirection()     ,_oBall.GetDistanceChng());
			CAngular2DVector tangent(DegToRad(_oBall.GetDirection())+local.GetNeckDirection()+PI/2,DegToRad(_oBall.GetDirectionChng())*_oBall.GetDistance());

			e=(0.1+0.02*_oBall.GetDistance()+PI/180*_oBall.GetDistance())/2;

			VSpeed=CDiffuse2DVector((C2DVector)normal+(C2DVector)tangent,e)+local.GetSpeed ();

			if(VSpeed.GetDistance ()<3)
			{
				Vspeed_valid=true;
				if(VSpeed.GetDistance ()>1)
				{
					VSpeed.SetDistance (1);
				}
			}
		}

		if( m_see_status &PREV_POSITION)
		{
			//CSpeed=m_position-CDiffuse2DVector((C2DVector)local.GetPosition(),0)-m_prev_position+CDiffuse2DVector((C2DVector)local.GetPrevPosition(),0)+local.GetSpeed ();
			CSpeed=m_position-m_prev_position;
			//CSpeed=CDiffuse2DVector(2,2,1);
			Cspeed_valid=true;
		}
		        


		if(Vspeed_valid)
		{
//			if(e<0.1)
//			{
//				m_speed=VSpeed;
//			}
//			else
			{
				if(Cspeed_valid)
				{
					if(CSpeed.GetDiffusion ()<5*VSpeed.GetDiffusion ())
					{
						m_speed=DoFilter(m_speed,VSpeed);
						m_see_status|=SEE_ANGLE_CHANGE|SEE_DISTANCE_CHANGE;
					}
					else
					{
						m_speed=DoFilter(m_speed,VSpeed);
						m_see_status|=SEE_ANGLE_CHANGE|SEE_DISTANCE_CHANGE;
					}
					
				}
				else
				{
					m_speed=DoFilter(m_speed,VSpeed);
					m_see_status|=SEE_ANGLE_CHANGE|SEE_DISTANCE_CHANGE;
				}
			}
		}
		else
		{
			if(Cspeed_valid)
			{
				//m_speed=0.95*m_speed+0.05*CSpeed;
				m_speed=DoFilter(m_speed,CSpeed);
				m_see_status|=SEE_ANGLE_CHANGE|SEE_DISTANCE_CHANGE;
			}
		}
			
		//m_see_status|=SEE_ANGLE_CHANGE|SEE_DISTANCE_CHANGE;
	}
	if( (m_see_status &PREV_SPEED) && (m_see_status & SEE_ANGLE_CHANGE) && (m_see_status & SEE_DISTANCE_CHANGE))
	{
		m_acceleration=m_speed-m_prev_speed;
		m_acceleration=CDiffuse2DVector(0,0,0);
		m_see_status|=EXPECTED_ACCELERATION;
	}
}


void  CAgent::Precompute()//nasty
{
// PRECOMPUTE:
	CMovingObject::Precompute();

	m_acceleration=CDiffuse2DVector(0,0,1);

	m_see_status&=(~EXPECTED_ANGULAR_SPEED);
	
	if(m_see_status&EXPECTED_NECK_DIRECTION)
	{
		m_prev_neck_direction=m_neck_direction;
		m_see_status|=PREV_NECK_DIRECTION|EXPECTED_ANGULAR_SPEED;
	}
	m_angular_speed=0;
	
	if(m_my_world)
	{
		m_my_world->Precompute();
	}
}


CGameCommand * CAgent::GetCommand()
{
	return 0;
}

void CBall::Precompute()
{
// PRECOMPUTE:
 	CMovingObject::Precompute();
	m_acceleration=CDiffuse2DVector(0,0,0.05);
}


void CWorldModel::Recompute(CPerception *Perception,const CAgent &local)
{
	CSeenObject tmp_ball;

	Perception->GetBall(&tmp_ball);

	m_ball->UpdateBallPosition(tmp_ball,local);



// PRECOMPUTE:

	//CSeenPlayersVect my_seen_vect=Perception->GetSeenPlayers();
	int seen_count=Perception->GetPlayersCount();
	int unid_count=m_unidentified_agents.size();
	int id_count=m_identified_agents.size();

	if(seen_count)
	{
		int rer=0;
		rer++;
	}

	int i,j;

	double **id_vals;
	double **unid_vals;

	bool *matched_unid;
	bool *matched_seen;

	CSeenPlayer **act_seen;


	if(unid_count)
	{
		matched_unid=new bool   [unid_count];
		memset(matched_unid,0,unid_count*sizeof(bool));
	}


	
	
	if(seen_count)
	{
		CSeenPlayer *tmp_player=new CSeenPlayer;
		int tmp_poz=Perception->GetFirstPlayer (tmp_player);

		act_seen= new CSeenPlayer *[seen_count];

		if(id_count)
		{
			id_vals     =new double*[id_count  ];
		}
		if(unid_count)
		{
			unid_vals   =new double*[unid_count];
		}

		matched_seen=new bool[seen_count];
		memset(matched_seen,0,seen_count*sizeof(bool));

        act_seen[0]=tmp_player;
		for(i=1;i<seen_count;i++)
		{
			tmp_player=new CSeenPlayer;
			tmp_poz=Perception->GetNextPlayer (tmp_player,tmp_poz);
            act_seen[i]=tmp_player;
		}


		for(i=0;i<id_count;i++)
		{
			id_vals[i]=new double[seen_count];

			for(j=0;j<seen_count;j++)
			{
				id_vals[i][j]=m_identified_agents[i]->TestOwnership(*(act_seen[j]),local);
			}
		}

		for(i=0;i<unid_count;i++)
		{
			unid_vals[i]=new double[seen_count];

			for(j=0;j<seen_count;j++)
			{
				unid_vals[i][j]=m_unidentified_agents[i]->TestOwnership(*(act_seen[j]),local);
			}
		}
	}


	int i_id=-1,j_id=-1;

	double max_id=-1;

	int seen_rem=seen_count;

	bool not_hotovo=true;

	while(not_hotovo)
	{
		int i_unid=-1,j_unid=-1;

		double max_unid=-1;

		int i_id=-1,j_id=-1;

		double max_id=-1;

		for(i=0;i<unid_count;i++)
		{
			for(j=0;j<seen_count;j++)
			{
				if(max_unid<unid_vals[i][j])
				{
					i_unid=i;
					j_unid=j;
					max_unid=unid_vals[i][j];
				}
			}
		}

		for(i=0;i<id_count;i++)
		{
			for(j=0;j<seen_count;j++)
			{
				if(max_id<id_vals[i][j])
				{
					i_id=i;
					j_id=j;
					max_id=id_vals[i][j];
				}
			}
		}


		if(max_id>=max_unid)
		{
			if(max_id>0)
			{
				m_identified_agents[i_id]->Update(*(act_seen[j_id]),local);
				matched_seen[j_id]=true;

				for(j=0;j<seen_count;j++)
				{
					id_vals[i_id][j]=-1;
				}

				for(i=0;i<id_count;i++)
				{
					id_vals[i][j_id]=-1;
				}
			}
			else
			{
				not_hotovo=false;
			}
		}
		else
		{
			if(max_unid>0)
			{
				m_unidentified_agents[i_unid]->Update(*(act_seen[j_unid]),local);
				matched_unid[i_unid]=true;
				matched_seen[j_unid]=true;

				for(j=0;j<seen_count;j++)
				{
					unid_vals[i_unid][j]=-1;
				}

				for(i=0;i<unid_count;i++)
				{
					unid_vals[i][j_unid]=-1;
				}
			}
			else
			{
				not_hotovo=false;
			}
		}
	}


	for(i=0;i<unid_count;i++)
	{
		if(matched_unid[i])
		{
			if((m_unidentified_agents[i]->GetSeeStatus() & SEE_SIDE) &&(m_unidentified_agents[i]->GetSeeStatus() & SEE_NUMBER))
			{
				for(j=0;j<id_count;j++)
				{
					if(	m_identified_agents[j]->GetPlayerSide  ()==m_unidentified_agents[i]->GetPlayerSide  () &&
						m_identified_agents[j]->GetPlayerNumber()==m_unidentified_agents[i]->GetPlayerNumber()
					)
					{
						break;
					}
				}
				if(j!=id_count)
				{
					delete m_identified_agents[j];
					m_identified_agents[j]=m_unidentified_agents[i];
				}
				else
				{
					m_identified_agents.insert(m_identified_agents.end(),m_unidentified_agents[i]);
				}
				m_unidentified_agents[i]=0;
			}
		}
		else
		{
			delete m_unidentified_agents[i];
			m_unidentified_agents[i]=0;
		}
	}

	bool one_zero=true;

	while(one_zero)
	{
		one_zero=false;

		for(i=0;i<m_unidentified_agents.size();i++)
		{
			if(!m_unidentified_agents[i])
			{
				m_unidentified_agents.erase(&(m_unidentified_agents[i]));
				one_zero=true;
				break;
			}
		}
	}

	for(i=0;i<seen_count;i++)
	{
		if(!matched_seen[i])
		{
			CAgent *new_agent=new CAgent;
			new_agent->Update(*(act_seen[i]),local);

			if((new_agent->GetSeeStatus() &SEE_SIDE) &&(new_agent->GetSeeStatus() &SEE_NUMBER))
			{
				m_identified_agents.insert(m_identified_agents.end(),new_agent);
			}
			else
			{
				m_unidentified_agents.insert(m_unidentified_agents.end(),new_agent);
			}

		}
	}

	if(seen_count)
	{
		for(i=0;i<id_count;i++)
		{
			delete []id_vals[i];
		}
		if(id_count) delete []id_vals;

		for(i=0;i<unid_count;i++)
		{
			delete []unid_vals[i];
		}
		if(unid_count) delete []unid_vals;

		for(i=0;i<seen_count;i++)
		{
			delete act_seen[i];
		}
		delete []act_seen;
		delete []matched_seen;
	}

	if(unid_count) delete []matched_unid;
}


void CWorldModel::Precompute()
{
	m_ball->Precompute();

// PRECOMPUTE:
	int i;
	for(i=0;i<m_identified_agents.size();i++)
	{
		m_identified_agents[i]->Precompute();
	}
	for(i=0;i<m_unidentified_agents.size();i++)
	{
		m_unidentified_agents[i]->Precompute();
	}
}





double CAgent::TestOwnership(const CSeenPlayer &player,const CAgent &local)//ughly
{
	int flags=player.GetSetValuesVar();

	if((flags&SEE_SIDE) && ((m_see_status&SEE_SIDE) || (m_see_status&EXPECTED_SIDE) ) && ( (m_side==local.m_side)!=(player.GetSide())) )
	{
		return 0;
	}

	if((flags&SEE_NUMBER) && ((m_see_status&SEE_NUMBER) || (m_see_status&EXPECTED_NUMBER) ) && (m_number!=player.GetUniformNum()))
	{
		return 0;
	}

	if((flags&SEE_SIDE) && ((m_see_status&SEE_SIDE) || (m_see_status&EXPECTED_SIDE)) && (flags&SEE_NUMBER) && ((m_see_status&SEE_NUMBER) || (m_see_status&EXPECTED_NUMBER) ))
	{
		return 1;
	}
////////////!!!!!!!!!

	if(flags &(SEE_ANGLE|SEE_DISTANCE))
	{
		CDiffuse2DVector position(CAngular2DVector(DegToRad(player.GetDirection())+local.GetNeckDirection(),player.GetDistance()),0.1,0.1,0.1);

		CDiffuse2DVector delta=m_position-position-local.GetPosition();

		if(delta.GetDiffusion ()>4)
		{
			delta.SetDiffusion (4);
		}
		
		if(delta.GetDistance ()>20)
		{
			return 0;
		}
		
		return 0.9*exp(-delta.GetDistance()/delta.GetDiffusion());
	}
	return 0;// CAUTION AGENT IS BLIND !!!
}



void CAgent::Update(CSeenPlayer &player,const CAgent &local)//ughly
{
	int flags=player.GetSetValuesVar();

	ESide sd=m_side;
	if(flags&SEE_SIDE)
	{
        // FIXME
		m_see_status|=SEE_SIDE;
        if (player.GetSide())
		{
            m_side=local.GetPlayerSide();
		}
        else 
		{
            m_side=(local.GetPlayerSide()==S_Left)?S_Right:S_Left;
		}
	}
	if(sd!=m_side)
	{
		int nn=sd;
	}
	int num=m_number;

	if(flags&SEE_NUMBER)
	{
		m_number=player.GetUniformNum();
		m_see_status|=SEE_NUMBER;
	}
	if(m_number!=num)
	{
		num++;
		num--;
	}


	if(flags&SEE_BODY_DIRECTION)
	{
		m_direction=AngNormalise((double)DegToRad(player.GetBodyDir())+local.GetNeckDirection());
		m_see_status|=SEE_BODY_DIRECTION;
	}

	if(flags&SEE_NECK_DIRECTION)
	{
		m_neck_direction=AngNormalise((double)DegToRad(player.GetHeadDir())+local.GetNeckDirection());
		m_see_status|=SEE_NECK_DIRECTION;
	}

	
	if(flags &(SEE_ANGLE|SEE_DISTANCE))
	{
//        fprintf(m_ff, "{ball %lf}\n", (double)_oBall.GetDirection());
		
		//        if (fabs(_oBall.GetDirection())>15) 
		//            fprintf(m_ff, "xx");
		
		CDiffuse2DVector position(CAngular2DVector(DegToRad(player.GetDirection())+local.GetNeckDirection(),player.GetDistance()),0.1,0.1,0.1);
		
		m_position=position+CDiffuse2DVector((C2DVector)local.GetPosition(),0);
		
        m_see_status|=SEE_ANGLE|SEE_DISTANCE;
		double e=1000;
		
		CDiffuse2DVector CSpeed,VSpeed;
		bool Cspeed_valid=false,Vspeed_valid=false;
		
		if((flags & SEE_ANGLE_CHANGE) &&(flags & SEE_DISTANCE_CHANGE))
		{
			CAngular2DVector normal (DegToRad(player.GetDirection())+local.GetNeckDirection()     ,player.GetDistanceChng());
			CAngular2DVector tangent(DegToRad(player.GetDirection())+local.GetNeckDirection()+PI/2,DegToRad(player.GetDirectionChng())*player.GetDistance());
			
			e=(0.1+0.02* player.GetDistance()+PI/180*player.GetDistance())/2;
			
			VSpeed=CDiffuse2DVector((C2DVector)normal+(C2DVector)tangent,e)+local.GetSpeed ();
			
			if(VSpeed.GetDistance ()<3)
			{
				Vspeed_valid=true;
				if(VSpeed.GetDistance ()>1)
				{
					VSpeed.SetDistance (1);
				}
			}
		}
		
		if( m_see_status &PREV_POSITION)
		{
			//CSpeed=m_position-CDiffuse2DVector((C2DVector)local.GetPosition(),0)-m_prev_position+CDiffuse2DVector((C2DVector)local.GetPrevPosition(),0)+local.GetSpeed ();
			CSpeed=m_position-m_prev_position;
			Cspeed_valid=true;
		}
		
		
		
		if(Vspeed_valid)
		{
			//			if(e<0.1)
			//			{
			//				m_speed=VSpeed;
			//			}
			//			else
			{
				if(Cspeed_valid)
				{
					if(CSpeed.GetDiffusion ()<5*VSpeed.GetDiffusion ())
					{
						m_speed=DoFilter(m_speed,VSpeed);
						m_see_status|=SEE_ANGLE_CHANGE|SEE_DISTANCE_CHANGE;
					}
					else
					{
						m_speed=DoFilter(m_speed,VSpeed);
						m_see_status|=SEE_ANGLE_CHANGE|SEE_DISTANCE_CHANGE;
					}
					
				}
				else
				{
					m_speed=DoFilter(m_speed,VSpeed);
					m_see_status|=SEE_ANGLE_CHANGE|SEE_DISTANCE_CHANGE;
				}
			}
		}
		else
		{
			if(Cspeed_valid)
			{
				//m_speed=0.95*m_speed+0.05*CSpeed;
				m_speed=DoFilter(m_speed,CSpeed);
				m_see_status|=SEE_ANGLE_CHANGE|SEE_DISTANCE_CHANGE;
			}
		}
		
		//m_see_status|=SEE_ANGLE_CHANGE|SEE_DISTANCE_CHANGE;
	}
	if( (m_see_status &PREV_SPEED) && (m_see_status & SEE_ANGLE_CHANGE) && (m_see_status & SEE_DISTANCE_CHANGE))
	{
		m_acceleration=m_speed-m_prev_speed;
		m_acceleration=CDiffuse2DVector(0,0,0);
		m_see_status|=EXPECTED_ACCELERATION;
	}
}
