// VisPerception.cpp: implementation of the CVisPerception class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Player.h"
#include "VisPerception.h"
#include "WorldObjects.h"
#include "SoccerAgent.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern CSoccerAgent SoccerAgent;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CVisPerception::CVisPerception()
{
//	m_pAgent = new CLocalAgent();					// aj toto, pekne sa tu nastavi smernik an skutocny objekt hraca
	m_pAgent = SoccerAgent.GetLocalAgent();
	m_pPerception0 = new CPerception();				// FIXME: tak toto vo final nebude to je jasne
	m_pPerception = m_pPerception0;
}

CVisPerception::~CVisPerception()
{
	delete m_pPerception0;
//	delete m_pAgent;
}

//////////////////////////////////////////////////////////////////////////////
// int CVisPerception::GetSeenFlag( int index, CVisObject* visObject )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		int index
//		CVisObject* visObject
//
//////////////////////////////////////////////////////////////////////////////
int CVisPerception::GetSeenFlag( int index, CVisObject* visObject )
{
	CSeenFlag	flag;
	int			retVal = m_pPerception->GetNextFlag( &flag, index );

	if ( retVal == -1 )
		return retVal;

	visObject->CreateFlag( &flag, m_pAgent );
	return retVal;
}

//////////////////////////////////////////////////////////////////////////////
// int CVisPerception::GetSeenPlayer( int index, CVisObject* visObject )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		int index
//		CVisObject* visObject
//
//////////////////////////////////////////////////////////////////////////////
int CVisPerception::GetSeenPlayer( int index, CVisObject* visObject )
{
	CSeenPlayer	player;
	int			retVal = m_pPerception->GetNextPlayer( &player, index );

	if ( retVal == -1 )
		return retVal;

	// the same for teammate and opponent ???????

	visObject->CreatePlayer( &player, m_pAgent );
	return retVal;
}

//////////////////////////////////////////////////////////////////////////////
// int CVisPerception::GetSeenBall( CVisObject* visObject )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		CVisObject* visObject
//
//////////////////////////////////////////////////////////////////////////////
int CVisPerception::GetSeenBall( CVisObject* visObject )
{
	CSeenObject	object;
	bool		pRetVal = m_pPerception->GetBall( &object );

	if ( !pRetVal )
		return -1;

	visObject->CreateBall( &object, m_pAgent );
	return 1;
}