// VisObject.h: interface for the CVisObject class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_VISOBJECT_H__63238AC9_3FAD_4F3A_A8D1_29AAF7449AB8__INCLUDED_)
#define AFX_VISOBJECT_H__63238AC9_3FAD_4F3A_A8D1_29AAF7449AB8__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ToDoClasses.h"
#include "WorldGeometry.h"
#include "FormationTypes.h"

class CSeenFlag;
class CSeenObject;
class CSeenPlayer;
class CLocalAgent;

class CAgent;
class CBall;

enum EVisObjectType {

	VOT_None,
	VOT_Flag,
	VOT_Line,
	VOT_Ball,
	VOT_OwnPlayer,
	VOT_UnknownPlayer,
	VOT_TeamPlayer,
	VOT_EnemyPlayer,

	VOT_PerFlag,
	VOT_PerBall,
	VOT_PerLine,
	VOT_PerUnknownPlayer,
	VOT_PerTeamPlayer,
	VOT_PerEnemyPlayer,

	VOT_Count
};

static char* FORMATION_NAMES[FT_FORMATION_COUNT] = 
{
  "None",
  "433",
  "442",
  "352",
  "72",
  "334",
  "244",
  "532",
  "Right",
  "Left"
};

static char* PLAYER_ROLE_NAMES[PT_COUNT] =
{
  "None",
  "Goaltender",
  "Sweeper",
  "Defender",
  "Midfielder",
  "Forward",
};

static char* PLAYER_UNIT_NAMES[UT_COUNT] = 
{
  "Defense",
  "Midfield",
  "Forward",
  "Left",
  "Center",
  "Right",
  "None"
};

class CAgent;

class CVisObject  
{
	EVisObjectType		m_eObjectType;			// typ objektu
	
	float				m_fRotation;			// rotacia objektu
	float				m_fHeadRotation;		// rotacia hlavy hracov, u ostatnych objektoch nepouzite

	float				m_fViewAngle;			// sirka pohladu hraca
	float				m_fViewDistance;		// dohlad hraca

	CDiffuse2DVector	m_cSpeed;				// rychlost hraca
	CDiffuse2DVector	m_cPosition;			// pozicia hraca
	CDiffuse2DVector	m_cAcceleration;		// zrychlenie hraca

	int					m_nNumber;				// cislo hraca
	Ptype				m_eRole;				// uloha hraca
	Ftype				m_eFormation;			// identifikator formacie
	Utype				m_eUnit;				// jednotka v ramci formacie
	float				m_fStamina;				// vydrz hraca
	float				m_fEffort;				// vykonnost hraca	

	DWORD				m_DFlags;				// platnost jednotlivych udajovych poli
	RRectangle			m_cHomeArea;			// domovska oblast posobnosti hraca
	RRectangle			m_cMaxArea;				// max. oblast posobnosti hraca

public:

	CVisObject();
	virtual ~CVisObject();

	void Initialize( void ) { m_eObjectType = VOT_None; };

	void CreateFlag( C2DVector staticFieldFlag );
	void CreateOwnPlayer( CLocalAgent* agent );

	/// Vytvaranie objektov na zobrazenie ///

	// reprezentacia vnutorneho sveta
	void CreatePlayer( CAgent* agent );
	void CreateBall( CBall* ball );

	// na zaklade vnemov zo servera
	void CreateFlag( CSeenFlag* seenFlag, CAgent* agent );
	void CreatePlayer( CSeenPlayer* seenFlag, CAgent* agent );
	void CreateBall( CSeenObject* seenFlag, CAgent* agent );

	float GetPosX( void ) { return m_cPosition.GetX(); };
	float GetPosY( void ) { return m_cPosition.GetY(); };
	float GetPosDiff( void ) { return m_cPosition.GetDiffusion(); };

	float GetSpeedX( void ) { return m_cSpeed.GetX(); };
	float GetSpeedY( void ) { return m_cSpeed.GetY(); };
	float GetSpeedDiff( void ) { return m_cSpeed.GetDiffusion(); };

	float GetAccelX( void ) { return m_cAcceleration.GetX(); };
	float GetAccelY( void ) { return m_cAcceleration.GetY(); };
	float GetAccelDiff( void ) { return m_cAcceleration.GetDiffusion(); };

	float GetRotation( void ) { return m_fRotation; };
	float GetHeadRotation( void ) { return m_fHeadRotation; };

	float GetViewAngle( void ) { return m_fViewAngle; };
	float GetViewDistance( void ) { return m_fViewDistance; };

	DWORD GetFlags( void ) { return m_DFlags; };

	int GetPlayerNumber( void ) { return m_nNumber; };
	float GetStamina( void ) { return m_fStamina; };
	float GetEffort( void ) { return m_fEffort; };

	char* GetCurrentFormationText( void ) { return FORMATION_NAMES[m_eFormation]; };
	char* GetCurrentRoleText( void ) { return PLAYER_ROLE_NAMES[m_eRole]; };
	char* GetCurrentUnitText( void ) { return PLAYER_UNIT_NAMES[m_eUnit]; };

	void GetHomeArea( int& minx, int& miny, int& maxx, int& maxy )
	{
		minx = int( m_cHomeArea.LeftX() );
		maxx = int( m_cHomeArea.RightX() );
		miny = int( m_cHomeArea.TopY() );
		maxy = int( m_cHomeArea.BottomY() );
	};
	void GetMaxArea( int& minx, int& miny, int& maxx, int& maxy )
	{
		minx = int( m_cMaxArea.LeftX() );
		maxx = int( m_cMaxArea.RightX() );
		miny = int( m_cMaxArea.TopY() );
		maxy = int( m_cMaxArea.BottomY() );
	};

	EVisObjectType GetObjectType( void ) { return m_eObjectType; };
	
	void Localize( float distance, float angle, float& worldX, float& worldY );
	void Localize( float distance, float angle, CDiffuse2DVector* world_pos );

	bool KnownPosition( void );
	bool KnownAcceleration( void );
	bool KnownSpeed( void );
	bool KnownRotation( void );
	bool KnownHeadRotation( void );
	bool KnownNumber( void );
	bool ExpectedNumber( void );
};

#endif // !defined(AFX_VISOBJECT_H__63238AC9_3FAD_4F3A_A8D1_29AAF7449AB8__INCLUDED_)
