// VisObject.cpp: implementation of the CVisObject class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Player.h"

#include "VisObject.h"
#include "staticfield.h"
#include "Perception.h"
#include "WorldObjects.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CVisObject::CVisObject()
{
	Initialize();
}

CVisObject::~CVisObject()
{

}

//////////////////////////////////////////////////////////////////////////////
// void CVisObject::CreateFlag( C2DVector staticFieldFlag )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		C2DVector staticFieldFlag
//
//////////////////////////////////////////////////////////////////////////////
void CVisObject::CreateFlag( C2DVector staticFieldFlag )
{
	Initialize();

	// nastav typ objektu, meno a poziciu, pri vlajke viac netreba
	m_eObjectType = VOT_Flag;
	m_cPosition = CDiffuse2DVector( staticFieldFlag, 0 );
}


// nasledjuce funkcie su pre objekty z vnutorneho sveta

void CVisObject::CreateOwnPlayer( CLocalAgent* agent )
{
	m_eObjectType = VOT_OwnPlayer;
	m_DFlags = agent->GetSeeStatus();

	m_cPosition = agent->GetPosition();
	m_cSpeed = agent->GetSpeed();
	m_cAcceleration = agent->GetAcceleration();

	m_fRotation = agent->GetDirection();
	m_fHeadRotation = agent->GetNeckDirection();

	m_fViewDistance = 100;//FIXME !!! FIX ME !!! FIX_ME !!!
	m_fViewAngle = agent->GetViewAngle();

	m_nNumber = agent->GetPlayerNumber();
	m_fStamina = float( agent->GetStamina() );
	m_fEffort = float( agent->GetEffort() );

	m_eFormation = agent->fskl->GetActualFormation( agent );
	m_eRole = agent->fskl->GetActualPlayerType( agent );
	m_eUnit = agent->fskl->GetMyUnitType( agent, m_nNumber );
}

void CVisObject::CreatePlayer( CAgent* agent )
{
	m_DFlags = agent->GetSeeStatus();

	switch( agent->GetPlayerSide() )
	{
		case S_None :
	    //case UNKNOWN :
			m_eObjectType = VOT_UnknownPlayer;
			break;

		case S_Left :
		//case TEAM_PLAYER :
			m_eObjectType = VOT_TeamPlayer;
			break;

		case S_Right :
		//case ENEMY_PLAYER :
			m_eObjectType = VOT_EnemyPlayer;
			break;
	}

	if ( !( m_DFlags & ( SEE_SIDE | EXPECTED_SIDE ) ) )
	{
		m_eObjectType = VOT_UnknownPlayer;
	}

	m_cPosition = agent->GetPosition();
	m_cSpeed = agent->GetSpeed();
	m_cAcceleration = agent->GetAcceleration();
	
	m_fRotation = agent->GetDirection();
	m_fHeadRotation = agent->GetNeckDirection();

	m_nNumber = agent->GetPlayerNumber();
}

void CVisObject::CreateBall( CBall* ball )
{
	m_eObjectType = VOT_Ball;
	m_DFlags = ball->GetSeeStatus();
	
	m_cPosition = ball->GetPosition();
	m_cSpeed = ball->GetSpeed();
	m_cAcceleration = ball->GetAcceleration();
	
	m_fRotation = 0.0f;
	m_fHeadRotation = 0.0f;

	m_nNumber = -1;
}

//////////////////////////////////////////////////////////////////////////////
// void CVisObject::CreateFlag( CSeenFlag* seenFlag, CAgent* agent )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		CSeenFlag* seenFlag
//		CAgent* agent
//
//////////////////////////////////////////////////////////////////////////////
void CVisObject::CreateFlag( CSeenFlag* seenFlag, CAgent* agent )
{
	m_eObjectType = VOT_PerFlag;
	m_cPosition = agent->GetPosition();

	float angle = float( DegToRad( seenFlag->GetDirection() ) ) + agent->GetNeckDirection();
		
	Localize( seenFlag->GetDistance(), angle, &m_cPosition );
}

//////////////////////////////////////////////////////////////////////////////
// void CVisObject::CreatePlayer( CSeenPlayer* seenFlag, CAgent* agent )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		CSeenPlayer* seenFlag
//		CAgent* agent
//
//////////////////////////////////////////////////////////////////////////////
void CVisObject::CreatePlayer( CSeenPlayer* seenPlayer, CAgent* agent )
{
	// za tento bordel je zopovedny franz
	switch( seenPlayer->GetSide() )
	{
		case 1:
			m_eObjectType = VOT_PerUnknownPlayer;
			break;
		case 0:
			m_eObjectType = VOT_PerTeamPlayer;
			break;
		/*
		case 1:
			m_eObjectType = VOT_PerEnemyPlayer;
			break;
		*/
	}

	m_cPosition = agent->GetPosition();
	
	float angle = float( DegToRad( seenPlayer->GetDirection() ) ) + agent->GetNeckDirection();
		
	Localize( seenPlayer->GetDistance(), angle, &m_cPosition );
}

//////////////////////////////////////////////////////////////////////////////
// void CVisObject::CreateBall( CSeenObject* seenFlag, CAgent* agent )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		CSeenObject* seenFlag
//		CAgent* agent
//
//////////////////////////////////////////////////////////////////////////////
void CVisObject::CreateBall( CSeenObject* seenObject, CAgent* agent )
{
	m_eObjectType = VOT_PerBall;
	m_cPosition = agent->GetPosition();

	float angle = float( DegToRad( seenObject->GetDirection() ) ) + agent->GetNeckDirection();
		
	Localize( seenObject->GetDistance(), angle, &m_cPosition );
}

//////////////////////////////////////////////////////////////////////////////
// void CVisObject::Localize( float distance, float angle, float& worldX, float& worldY )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		float distance
//		float angle
//		float& worldX
//		float& worldY
//
//////////////////////////////////////////////////////////////////////////////
void CVisObject::Localize( float distance, float angle, float& worldX, float& worldY )
{
	worldX += distance * cos( angle );
	worldY += distance * sin( angle );
}

void CVisObject::Localize( float distance, float angle, CDiffuse2DVector* world_pos )
{
	(*world_pos) +=CDiffuse2DVector(CAngular2DVector( angle , distance ),0);
}

//////////////////////////////////////////////////////////////////////////////
// bool CVisObject::KnownPosition( void )
// ---------------------------------------------------------------------------
// Description:
//		test ci u daneho objektu pozname poziciu
//
// ---------------------------------------------------------------------------
// Parameters:
//
//////////////////////////////////////////////////////////////////////////////
bool CVisObject::KnownPosition( void )
{
	return ( m_DFlags & ( SEE_DISTANCE | EXPECTED_DISTANCE ) ) && ( m_DFlags & ( SEE_ANGLE | EXPECTED_ANGLE ) );
}

//////////////////////////////////////////////////////////////////////////////
// bool CVisObject::KnownAcceleration( void )
// ---------------------------------------------------------------------------
// Description:
//		test ci u objektu pozname zrychlenie	
//
// ---------------------------------------------------------------------------
// Parameters:
//
//////////////////////////////////////////////////////////////////////////////
bool CVisObject::KnownAcceleration( void )
{
	return ( m_DFlags & EXPECTED_ACCELERATION ) != 0;
}

//////////////////////////////////////////////////////////////////////////////
// bool CVisObject::KnownSpeed( void )
// ---------------------------------------------------------------------------
// Description:
//		test ci u daneho objetku pozname rychlost
//
// ---------------------------------------------------------------------------
// Parameters:

//
//////////////////////////////////////////////////////////////////////////////
bool CVisObject::KnownSpeed( void )
{
	return ( m_DFlags & ( EXPECTED_DISTANCE_CHANGE | SEE_DISTANCE_CHANGE ) ) && ( m_DFlags & ( EXPECTED_ANGLE_CHANGE | SEE_ANGLE_CHANGE ) );
}

//////////////////////////////////////////////////////////////////////////////
// bool CVisObject::KnownRotation( void )
// ---------------------------------------------------------------------------
// Description:
//		test ci u daneho objetku pozname rotaciu
//
// ---------------------------------------------------------------------------
// Parameters:
//
//////////////////////////////////////////////////////////////////////////////
bool CVisObject::KnownRotation( void )
{
	return ( m_DFlags & ( EXPECTED_BODY_DIRECTION | SEE_BODY_DIRECTION ) ) != 0;
}

//////////////////////////////////////////////////////////////////////////////
// bool CVisObject::KnownHeadRotation( void )
// ---------------------------------------------------------------------------
// Description:
//		test ci u daneho objetku pozname rotaciu hlavy
//
// ---------------------------------------------------------------------------
// Parameters:
//
//////////////////////////////////////////////////////////////////////////////
bool CVisObject::KnownHeadRotation( void )
{
	return ( m_DFlags & ( EXPECTED_NECK_DIRECTION | SEE_NECK_DIRECTION ) ) != 0;
}

//////////////////////////////////////////////////////////////////////////////
// bool CVisObject::KnownNumber( void )
// ---------------------------------------------------------------------------
// Description:
//		test ci u daneho objetku pozname cislo dresu
//
// ---------------------------------------------------------------------------
// Parameters:
//
//////////////////////////////////////////////////////////////////////////////
bool CVisObject::KnownNumber( void )
{
	return ( m_DFlags & SEE_NUMBER ) != 0;
}

//////////////////////////////////////////////////////////////////////////////
// bool CVisObject::ExpectedNumber( void )
// ---------------------------------------------------------------------------
// Description:
//		test ci u daneho objetku odhadujeme cislo dresu
//
// ---------------------------------------------------------------------------
// Parameters:
//
//////////////////////////////////////////////////////////////////////////////
bool CVisObject::ExpectedNumber( void )
{
	return ( m_DFlags & EXPECTED_NUMBER ) != 0;
}