#include "stdafx.h"
#include "Skills.h"
#include "FormationSkills.h"
#include "LogManager.h"
#include "WorldObjects.h"

extern CConfig *cfg;           // FIXME
extern FILE *m_ff;             // FIXME

// FIXME: pre aku neurcitost sa pozerat za loptou
#define INVALID(diff, dist) ((((dist)>5) && ((diff)>(0.5*(dist)))) || (((dist)<5) && ((diff)>3)))

// FIXME
extern double kkx;
extern double kky;

// GOALIE:
void CTeamSkills::GoalieBehave(CLocalAgent *pa)
{
    CBall *pBall = pa->GetWorldModel()->GetBall();    
    C2DVector toball = pBall->GetPosition() - pa->GetPosition();
    double diff = pBall->GetPosition().GetDiffusion();
    double dist = toball.GetDistance();        

    double disttoball = pa->bskl->RelVectorTo(pa, pa->GetWorldModel()->GetBall()->GetPosition()).GetDistance();
    
    fprintf(m_ff, "JEF GAMETIME %d, to_ball=%f,%f ball_dist=%f, ball_dir=%f\r\n", pa->GetTime(), toball.GetX(), toball.GetY(), dist, toball.GetAngle());    
    fprintf(m_ff, "dist=%f disttoball=%f dist=%f diff=%f, diff=%d\r\n", dist, disttoball, dist, diff, diff);
    
    ESide myside = pa->GetPlayerSide();

    if ((myside==S_Left && pa->GetPlayMode() == PM_FreeKick_Left) || (myside==S_Right && pa->GetPlayMode() == PM_FreeKick_Right)) 
    {
        C2DVector homepos = C2DVector(-40, 20);
        if (myside==S_Right) homepos = C2DVector(40, -20);
        if ((pa->GetPosition() - homepos).GetDistance() > 5) 
        {
            homepos = C2DVector(-40, 20);
            pa->bskl->Move(pa, homepos);
            return;
        }
        
        CAgent *a = pa->bskl->FreestFriend(pa);
        if (a == NULL) 
        {
            if (myside==S_Left) pa->bskl->KickTo(pa, pa->field->GetGoal(GT_R), 100.0);			   
            else pa->bskl->KickTo(pa, pa->field->GetGoal(GT_L), 100.0);
        } 
        else 
        {
            pa->bskl->KickTo(pa, a->GetPosition());
        }        
    }

    bool invalid = INVALID(diff,dist);
    if (diff < 5.00) invalid=false;


    if ((((pBall->GetSeeStatus() & SEE_ANGLE) && (pBall->GetSeeStatus() & SEE_DISTANCE)) ||
        ((pBall->GetSeeStatus() & EXPECTED_ANGLE) && (pBall->GetSeeStatus() & EXPECTED_DISTANCE))) &&
        !invalid)
    {
        
        LOGMSG(1, "[%d] AGENT x:%lf, y:%lf", pa->GetTime().m_nAllCycles, pa->GetPosition().GetX(), pa->GetPosition().GetY());
        //bskl->GetBallInterceptPosition(this, pBall->GetSpeed());
        
        if (pa->bskl->BallCatchable(pa)) 
        {   
            if ((pa->bskl->RelVectorTo(pa, pBall->GetPosition())).GetAngle() > 0)
            {
               pa->bskl->Catch(pa, DegToRad(45.0));            
            }
            else
            {
               pa->bskl->Catch(pa, DegToRad(-45.0));
            }
            fprintf(m_ff, "JEF CATCH %d\r\n", pa->GetTime());
        } 
		else if (pa->bskl->BallKickable(pa)) 
        {
            // bskl->TurnNeckTo(this, field->GetGoal(GT_L));            
            CAgent *a = pa->bskl->FreestFriend(pa);
            if (a == NULL) 
            {
                if (myside==S_Left) pa->bskl->KickTo(pa, pa->field->GetGoal(GT_R), 50.0);
                else pa->bskl->KickTo(pa, pa->field->GetGoal(GT_L), 50.0);
            }
            else 
            {
                pa->bskl->KickTo(pa, a->GetPosition(), 50.0);
            }            
            fprintf(m_ff, "JEF KICKTO %d\r\n", pa->GetTime());
        } 
        else 
        {
            //  bskl->TurnNeckStraight(this);
            
            // C2DVector ballpos = pBall->GetPosition();
            
            C2DVector ballpos = pa->bskl->GetBallInterceptPosition(pa, pBall->GetSpeed());
            
            if (ballpos.GetX() == NOT_EXISTING) ballpos = pBall->GetPosition();
                        
            //bskl->GoTo(this, ballpos, 100.0);
            //bskl->TurnTo(this, ballpos);
            
            //jeeff (brankar):                                    
            fprintf(m_ff, "JEF TOBALL x=%f, y=%f\r\n", pBall->GetPosition().GetX(), pBall->GetPosition().GetY());            

            bool isInMyArea;
            if (myside==S_Left) isInMyArea = (pBall->GetPosition().GetX() < -35) && (fabs(pBall->GetPosition().GetY()) < 18);
            else isInMyArea = (pBall->GetPosition().GetX() > 35) && (fabs(pBall->GetPosition().GetY()) < 18);

            if (isInMyArea) // || ballpos.GetX() > 0)
            {
                pa->bskl->GoTo(pa, ballpos, 100.0);                
                fprintf(m_ff, "JEF GOTO %d\r\n", pa->GetTime());
            }
            else
            {                
                //ak je lopta prilis daleko chod domov
                C2DVector homePos = pa->fskl->GetMyHomePosition(pa);					
                
                double r=pa->field->GetGoalSize()*0.6;
                double alfa = atan2(ballpos.GetY(), ballpos.GetX()+52.5);
                
                homePos.SetY(sin(alfa) * r);
                homePos.SetX(cos(alfa)*r - 52.5);

                if (myside==S_Right) homePos.SetX(-homePos.GetX());

                //homePos.SetX(7.2);
                //homePos.SetY(-52.3);
                
                
                double homeDist = homePos.GetDistance();
                C2DVector toHomePos = pa->GetPosition();
                toHomePos.SetXY(toHomePos.GetX() - homePos.GetX(), toHomePos.GetY() - homePos.GetY());
                if (toHomePos.GetDistance() < 1.0)
                {
                    pa->bskl->TurnTo(pa, ballpos);
                }
                else
                {
                    pa->bskl->GoTo(pa, homePos, 100.0);
                }
                fprintf(m_ff, "JEF GOHOME %d\r\n", pa->GetTime());
            }
        }
        
        
        
                    
        ////            LOGMSG(1, "MyPosition  X %lf, Y %lf", GetPosition().GetX(), GetPosition().GetY());
        ////            LOGMSG(1, "BallPosition  X %lf, Y %lf", pBall->GetPosition().GetX(), pBall->GetPosition().GetY());
        ////            C2DVector ccc2 = bskl->GetBallInterceptPosition(this, cccc);
        ////            LOGMSG(1, "BallInterceptPosition X %lf, Y %lf", ccc2.GetX(), ccc2.GetY());
        
        
        
    } 
    else 
    {
        //bskl->TurnNeckStraight(this);
        //bskl->Turn2(this, 4.50);   // spravit skill, ktory najde loptu (mal by pockat na perception, moze sa tocit o 45? stupnov)
        pa->bskl->Turn(pa, DegToRad(45));
        fprintf(m_ff, "JEF TURN %d\r\n", pa->GetTime());
    }
}

// naplanovanie chodenia do pozicie cPlanPos na dalsich nPlanTime sim. krokov
void CTeamSkills::PlanGoTo(CLocalAgent *pa, C2DVector cPlanPos, int nPlanTime)
{
    pa->tdata->SetPlanPos(nPlanTime, cPlanPos);
}

bool CTeamSkills::DoPlan(CLocalAgent *pa)
// vrati false, ak nie je co vykonavat v ramci planu (plan splneny/nezadany)
{
    int nPlanTime;
    C2DVector cPlanPos;

    // zistime si, co mame naplanovane -> ak nic, tak koncime
    pa->tdata->GetPlanPos(nPlanTime, cPlanPos);

    if (nPlanTime <= 0) return false;

    nPlanTime--;
    // ak uz sme na mieste, tak koniec (+ vrat false)
    if ((pa->GetPosition() - cPlanPos).GetDistance() <= 5) {
        nPlanTime = 0;
        pa->tdata->SetPlanPos(nPlanTime, cPlanPos);
        return false;
    }

    pa->bskl->GoTo(pa, cPlanPos, 100.0);

    // FIXME: musime nejak decnut cas
    pa->tdata->SetPlanPos(nPlanTime, cPlanPos);
    return true;
}

void CTeamSkills::OffenderBehave(CLocalAgent *pa, C2DVector homepos)
{
    CBall *pBall = pa->GetWorldModel()->GetBall();
    C2DVector toball = pBall->GetPosition() - pa->GetPosition();
    double diff = pBall->GetPosition().GetDiffusion();
    double dist = toball.GetDistance();
//    fprintf(m_ff, "diff/dist: %f / %f\n",(float)diff, (float)dist);
    
    if ((((pBall->GetSeeStatus() & SEE_ANGLE) && (pBall->GetSeeStatus() & SEE_DISTANCE)) ||
        ((pBall->GetSeeStatus() & EXPECTED_ANGLE) && (pBall->GetSeeStatus() & EXPECTED_DISTANCE))) &&
        (!INVALID(diff,dist)))    
    {
     
        LOGMSG(1, "[%d] AGENT x:%lf, y:%lf", pa->GetTime().m_nAllCycles, pa->GetPosition().GetX(), pa->GetPosition().GetY());
        // bskl->GetBallInterceptPosition(this, pBall->GetSpeed());

        // mame pokracovat v "plane"? -> ak ano, tak nic ine uz nemozeme robit
        if (DoPlan(pa)) return;
        
        if (pa->bskl->BallKickable(pa)) {
            // bskl->TurnNeckTo(this, field->GetGoal(GT_L));
            
            // nahrame najblizsiemu spoluhracovi, ak je smerom na superovu
            // branu, inak kopneme rovno do brany
            CAgent *a = pa->bskl->NearestFriendToBall(pa);
            if ((a == NULL) || ((a != NULL) && ((a->GetPosition() - pa->GetPosition()).GetX()<0))) {
                pa->bskl->KickTo(pa, pa->field->GetGoal(GT_R), 50.0);
            } else {
                pa->bskl->KickTo(pa, a->GetPosition(), 50.0);
            }
          
        } else {
            //bskl->TurnNeckStraight(this);
            
            //C2DVector ballpos = pBall->GetPosition();
            
            C2DVector ballpos = pa->bskl->GetBallInterceptPosition(pa, pBall->GetSpeed());
            
            if (ballpos.GetX() == NOT_EXISTING) ballpos = pBall->GetPosition();
            // FIXME: vizualizacia incerceptposition
            kkx = ballpos.GetX();
            kky = ballpos.GetY();
            
            // zodpovednost za loptu??
            CAgent *a = pa->bskl->NearestFriendToBall(pa);
            if (a == NULL) {
                pa->bskl->GoTo(pa, ballpos, 100.0);
                //bskl->FaceGoTo(this, pBall->GetPosition(), ballpos, 100.0);
            } else {
                //FIXME: jeho intercept
                if ((ballpos - pa->GetPosition()).GetDistance() <= (ballpos - (C2DVector)a->GetPosition()).GetDistance()) {
                    pa->bskl->GoTo(pa, ballpos, 100.0);
                    //bskl->FaceGoTo(this, pBall->GetPosition(), ballpos, 100.0);
                } else {
                    //bskl->TurnNeckStraight(this);
                    if ((pa->GetPosition() - homepos).GetDistance() > 5) {
                        // naplanuj presun do homepos a vykonavaj 
                        // to dalsich 8 krokov
                        PlanGoTo(pa, homepos, 8);
                    } else pa->bskl->TurnTo(pa, ballpos);
                    
                }
            }
        }       
    } 
    else 
    {
        //bskl->TurnNeckStraight(this);
        //bskl->Turn2(this, 4.50);   // spravit skill, ktory najde loptu (mal by pockat na perception, moze sa tocit o 45? stupnov)
        pa->bskl->Turn(pa, DegToRad(45));
    }

}

// rutina NeckTest testuje turnnecky a demonstruje pouzitie skillsy FaceGoTo
void NeckTest(CLocalAgent *pa)
{
    C2DVector destpos(0,0);
    C2DVector lookpos = pa->GetWorldModel()->GetBall()->GetPosition();

    kkx=lookpos.GetX();
    kky=lookpos.GetY();

    fprintf(m_ff, "-> neck_direction: %f\n",(float)RadToDeg(pa->GetNeckDirection()));
    fprintf(m_ff, "-> neck_direction(r): %f\n",(float)pa->GetNeckDirection());
    if ((pa->GetPosition() - destpos).GetDistance()<5) {
        pa->bskl->TurnNeckTo(pa, lookpos);
        return;

        static int tt=0;
        static int tt2=180/5;
        if (tt) pa->bskl->TurnNeck(pa, DegToRad(+5));
        else pa->bskl->TurnNeck(pa, DegToRad(-5));
        double dir = pa->GetNeckDirection() - pa->GetDirection();
        if (RadToDeg(dir) > 60) tt=0;
        if (RadToDeg(dir) < -60) tt=1;

//        if (tt2-- <= 0) {
//            tt = !tt;
//            tt2=180/5;
//        }
        pa->bskl->Turn(pa, 0);
    } else 
        pa->bskl->FaceGoTo(pa, pa->GetWorldModel()->GetBall(), destpos, 100.0);
        // pa->bskl->FaceGoTo(pa, lookpos, destpos, 100.0);
}

void CTeamSkills::Behave(CLocalAgent *pa)
{   
    // Priklad: homepos vypocitame podla formacie a do dalsich rutin 
    //          ho posleme ako parameter
    C2DVector homepos = pa->fskl->GetMyHomePosition(pa);
//  C2DVector homepos = C2DVector(-40, 20);
    
    // FIXMEE: ak je beforekickoff a nie sme na mieste, tak sa premiestnime
    if (pa->GetPlayMode() == PM_BeforeKickOff) {
        //          bskl->Turn(this, 10);
        if ((pa->GetPosition() - homepos).GetDistance() > 5) {
            pa->bskl->Move(pa, homepos);
            return;
        }
    }
    
//  else { bskl->GoTo(this, C2DVector(-10, -20), 20.0); }
//  else { bskl->GoTo(this, C2DVector(-20, 10), 20.0); }

//  NeckTest(pa); return;

    // ak bol hrac zinitializovany ako goalie, tak zavolame goalie-ho obsluhu
    if (pa->IsGoalie()) {
        GoalieBehave(pa);
    } else {
        // inak sme univerzalny utocnik
// added by frz
        Ptype pType = pa->fskl->GetActualPlayerType(pa);
		switch(pType) {
		case   PT_Defender:
			DefenseBehave(pa, homepos);
			break;
		case PT_Sweeper:
			DefenseBehave(pa, homepos);
			break;
		default:
			OffenderBehave(pa, homepos);
			break;
		}
    }
}

/*// testovanie turnnecku -> vykrutime hlavu nabok a chodime do kruhu opacne
static int ww=0;
if (ww++<2) {
    bskl->TurnNeck(this, DegToRad(-80));
    return;
}
static int ww2=0;
bskl->GoTo(this, field->GetGoal(GT_R), 100);
//if (ww2)
//    bskl->Dash(this, 100);
//else
//    bskl->Turn(this, DegToRad(10));
ww2 = !ww2;
return; */

void CTeamSkills::DefenseBehave(CLocalAgent *pa, C2DVector homepos)
{
    CBall *pBall = pa->GetWorldModel()->GetBall();
	C2DVector toball = pBall->GetPosition() - pa->GetPosition();
    double diff = pBall->GetPosition().GetDiffusion();
    double dist = toball.GetDistance();

	// ak je nieco naplanovane, vykona sa to
	// if (DoPlan(pa)) return;

	TRACE("\nDefenseBehave\n");
	TRACE("\tMoje pozicia: %f, %f\n", pa->GetPosition().GetX(), pa->GetPosition().GetY());
	TRACE("\tNatocenie: telo %f, hlava %f\n",RadToDeg(pa->GetDirection()), RadToDeg(pa->GetNeckDirection()));
	TRACE("\tPozicia lopty: %f, %f\n", pBall->GetPosition().GetX(), pBall->GetPosition().GetY());

    // ak vidim loptu, alebo viem kde je
	if ((((pBall->GetSeeStatus() & SEE_ANGLE) && (pBall->GetSeeStatus() & SEE_DISTANCE)) ||
        ((pBall->GetSeeStatus() & EXPECTED_ANGLE) && (pBall->GetSeeStatus() & EXPECTED_DISTANCE))) &&
        (!INVALID(diff,dist)))    
    {
		TRACE("\tViem kde je lopta\n");
		// ak sa da kopat
        if (pa->bskl->BallKickable(pa)) {
			TRACE("\tKopem\n");
			// najdem najblizsieho hraca a ak je blizsie k superovej branke nahram mu
			// inak kopnem smerom na branu supera
            CAgent *a = pa->bskl->NearestFriendToBall(pa);
            if ((a == NULL) || ((a != NULL) && ((a->GetPosition() - pa->GetPosition()).GetX()<1))) {
                // FIXME opravit aby mohol strielat aj na druhu stranu
				pa->bskl->KickTo(pa, pa->field->GetGoal(GT_R));
			} else {
                pa->bskl->KickTo(pa, a->GetPosition());
            }
		}
		// ak sa neda kopnut do lopty
		else {

			TRACE("\tNemozem kopat do lopty\n");
			// zistim kto je najblizsie k lopte
			CAgent *a = pa->bskl->NearestPlayerToBall(pa);
			if(a != NULL) {
				// ak je to super
				if(a->GetPlayerSide() != pa->GetPlayerSide()) {				

					// zistim kto je z mojho unitu je najblizsie k superovi s loptov
					CAgent *fa = pa->bskl->NearestUnitMemberToPlayer(pa, a);

					// ak som najblizsie k protihracovi s loptou
					if(fa->GetPlayerNumber() == pa->GetPlayerNumber()) {				

						TRACE("\t\tBranim hraca s loptou\n");
						TRACE("\t\t\tPozicia supera: %f, %f\n", a->GetPosition().GetX(), a->GetPosition().GetY());

						// zistim kde je lopta
						C2DVector ballpos = pa->bskl->BallPosition(pa, 0);
				
						// kde mam moju branku
						C2DVector goalpos;
						if(pa->GetPlayerSide() == S_Left) 
							goalpos = pa->field->GetGoal(GT_L);
						else
							goalpos = pa->field->GetGoal(GT_R);
						
				        if (ballpos.GetX() == NOT_EXISTING) ballpos = pBall->GetPosition();
		
						// FIXME: vizualizacia incerceptposition
			            kkx = ballpos.GetX();
				        kky = ballpos.GetY();
						
						// zistim ako je daleko super a ako je daleko od lopty
						C2DVector toplr, plrtoball;
						toplr = a->GetPosition() - pa->GetPosition();
						plrtoball = toball - toplr;

					
						// podla zistenych vzdialenosti rozhodnem kto bude skor u lopty	
						if((toball.GetDistance() > plrtoball.GetDistance()) && (a->GetPosition().GetX() > -19.0)) {
							// ak to je super postavim sa mu do cesty medzi loptu a branku
							C2DVector goaltoball = ballpos - goalpos;
							goaltoball *= 0.66;
						
							TRACE("\t\t\tIdem na poziciu: %f, %f\n", (goalpos + goaltoball).GetX(), (goalpos + goaltoball).GetY());
			
							pa->bskl->FaceGoTo(pa, pBall, (goalpos + goaltoball)); 
							/*
							// zistim ci je rozumne bezat dozadu
							double goaltomedir = ((C2DVector)(pa->GetPosition() - goalpos)).GetAngle();
							double goaltoballdir = goaltoball.GetAngle();
							double ang;
							bool back = false;

							// ak hrac stoji na osi medzi brankov a loptov
							if((fabs(goaltomedir - goaltoballdir) < DegToRad(5.0)) && ((goalpos + goaltoball).GetX() < pa->GetPosition().GetX())) {
								// vypocitam uhol o ktory sa mam otocit
								double metoballdir = (goalpos + goaltoball - pa->GetPosition()).GetAngle();
								ang = metoballdir - pa->GetDirection();
								ang = AngNormalise(ang + DegToRad(180));
								back = true;
							}
							// ak som mimo osi
							else {
								// ang = ((C2DVector)(goalpos + goaltoball - pa->GetPosition())).GetAngle() - pa->GetDirection();
							}

							// vypocet accel, aby tam agent presne zastavil
							double accel = (pa->bskl->RelVectorTo(pa, goalpos + goaltoball) - pa->GetSpeed()).GetDistance();
							
							// ak budem cuvat
							if(back) {
								accel *= -1;
								if(accel < -100.0)
									accel = -100.0;
								double mindir = DegToRad(5.0); 
							
								// aby sme sa stale netocili
								if ((ang > -mindir) && (ang < mindir)) 
								{
									pa->bskl->Dash2(pa, accel);
									//pa->bskl->TurnNeckTo(pa, pa->GetWorldModel()->GetBall()->GetPosition());
								}
								else 
								{
									pa->bskl->Turn2(pa, ang);
									//pa->bskl->TurnNeckTo(pa, pa->GetWorldModel()->GetBall()->GetPosition());
								}
							}
							// inak pojdem dopredu aby som sa dostal medzi loptu a branku
							else {
								PlanGoTo(pa, goalpos + goaltoball, 3);
							}
							//pa->bskl->TurnNeckToBall(pa);
							*/

						}
						// ak som blizsie k lopte
						else {
							// bezi k lopte
							TRACE("\t\tSom blizsie k lopte ako super\n");
							
							pa->bskl->FaceGoTo(pa, pBall, pa->bskl->BallPosition(pa, 0));			
							// PlanGoTo(pa, pa->bskl->BallPosition(pa, 0), 5);					
							//pa->bskl->TurnNeckStraight(pa);
						}
					}
					// ak nie som najblizsie k superovi s loptou
					else {

						// najdem najblizsieho protihraca, ktory nema loptu
						CAgent *sa = pa->bskl->NearestOppPlayer(pa);
								
						// zistim si za aku cast ihriska som zodpovedny (y suradnice)
						RRectangle *rect = pa->fskl->GetMyHomeRange(pa);
						double top_y = rect->TopY();
						double bottom_y = rect->BottomY();
						// FIXME: ak niekto presne vie ako to je s top a bottom y tak nech to opravi
						if(top_y < bottom_y) {
							double tmp = top_y;
							top_y = bottom_y;
							bottom_y = tmp;
						}
						top_y += 5;
						bottom_y -= 5;


						// ak taky je a je v mojej casti ihriska
						if((sa != NULL) && 
						   (sa->GetPosition().GetY() < top_y) && 
						   (sa->GetPosition().GetY() > bottom_y)) {

							TRACE("\t\tBranim hraca bez lopty\n");
							TRACE("\t\t\tBlizsi spoluhrac k lopte %d\n", fa->GetPlayerNumber());
							TRACE("\t\t\tPozicia supera: %f, %f\n", sa->GetPosition().GetX(), sa->GetPosition().GetY());

							// kde mam moju branku
							C2DVector goalpos;
							if(pa->GetPlayerSide() == S_Left) 
								goalpos = pa->field->GetGoal(GT_L);
							else
								goalpos = pa->field->GetGoal(GT_R);	
	
							C2DVector goaltoplr = sa->GetPosition() - goalpos;
							goaltoplr *= 0.66;
							

							// ak je na mojom uzemi budem sa posuvat iba do bokov
							if(pa->fskl->LocationToPosition(pa, sa->GetPosition()) != pa->GetPlayerNumber()) {
								goaltoplr.SetX(homepos.GetX());
							}

							TRACE("\t\t\tIdem na poziciu: %f, %f a pozeram sa na protihraca\n", (goalpos + goaltoplr).GetX(), (goalpos + goaltoplr).GetY());

							pa->bskl->FaceGoTo(pa, sa, (goaltoplr + goalpos)); 

							/*
							// zistim ci je rozumne bezat dozadu
							double goaltomedir = (pa->GetPosition() - goalpos).GetAngle();
							double goaltoplrdir = (sa->GetPosition() - goalpos).GetAngle();
							double ang;
							bool back = false;

							// ak hrac stoji na osi medzi brankov a loptov
							if((fabs(goaltomedir - goaltoplrdir) < DegToRad(5.0)) && ((goalpos + goaltoplr).GetX() < pa->GetPosition().GetX())) {
								// vypocitam uhol o ktory sa mam otocit
								double metoballdir = (goalpos + goaltoplr - pa->GetPosition()).GetAngle();
								ang = metoballdir - pa->GetDirection();
								ang = AngNormalise(ang + DegToRad(180));
								back = true;
							}

							// vypocet accel, aby tam agent presne zastavil
							double accel = (pa->bskl->RelVectorTo(pa, goalpos + goaltoplr) - pa->GetSpeed()).GetDistance();
								
							// ak budem cuvat
							if(back) {
								accel *= -1;
								if(accel < -100.0)
									accel = -100.0;
								double mindir = DegToRad(5.0); 
							
								// aby sme sa stale netocili
								if ((ang > -mindir) && (ang < mindir)) 
								{
									pa->bskl->Dash2(pa, accel);
									//pa->bskl->TurnNeckTo(pa, pa->GetWorldModel()->GetBall()->GetPosition());
								}
								else 
								{
									pa->bskl->Turn2(pa, ang);
									//pa->bskl->TurnNeckTo(pa, pa->GetWorldModel()->GetBall()->GetPosition());
								}
							}
							// inak pojdem dopredu aby som sa dostal medzi loptu a branku
							else {
								PlanGoTo(pa, goalpos + goaltoplr, 5);
							}
							*/
						}
						// ak sa nenasiel vhodny protihrac idem na svoju poziciu
						else {

							TRACE("\t\tIdem na poziciu\n");

							C2DVector mypos = pa->GetPosition();
							if((fabs(mypos.GetX() - homepos.GetX()) > 4) || (fabs(mypos.GetY() - homepos.GetY()) > 4)) {
	
								TRACE("\t\t\tIdem svoju poziciu: %f, %f\n", homepos.GetX(), homepos.GetY());
								
								pa->bskl->FaceGoTo(pa, pBall, homepos);					
							}
							else {
								
								TRACE("\t\t\tSom na pozicii a otacam sa za loptou\n");

								if(fabs(pa->GetNeckDirection() - pa->GetDirection()) < DegToRad(5)) {

									TRACE("\t\t\t\tturn: %f\n", RadToDeg((pa->GetWorldModel()->GetBall()->GetPosition() - pa->GetPosition()).GetAngle()));
									
									pa->bskl->TurnTo(pa, pa->GetWorldModel()->GetBall()->GetPosition());
								}
								else {

									TRACE("\t\t\t\tturnneck: %f\n", RadToDeg(pa->GetDirection() - pa->GetNeckDirection()));

									pa->bskl->TurnNeckStraight(pa);
								
								}
							// pa->bskl->GoTo(pa, homepos, 100.0);
							}
						}
					}
				}
				// ak je spoluhrac najblizsie k lopte
				else {

					TRACE("\t\tJa alebo spoluhrac je najblizsie k lopte\n");

					C2DVector metoball = pa->bskl->RelVectorTo(pa, pa->bskl->GetBallInterceptPosition(pa, pa->GetWorldModel()->GetBall()->GetSpeed()));
					C2DVector plrtoball = pa->bskl->GetBallInterceptPosition(pa, pa->GetWorldModel()->GetBall()->GetSpeed()) - a->GetPosition();
					
					// zistim kto z nas je blizsie
					if(metoball.GetDistance() < plrtoball.GetDistance()) {
						
						TRACE("\t\t\tJa som najblizsie k lopte a idem k nej\n");
	
						// bezi k lopte
						if(fabs(pa->GetNeckDirection() - pa->GetDirection()) < DegToRad(5))
							pa->bskl->FaceGoTo(pa, pa->GetWorldModel()->GetBall(), pa->bskl->BallPosition(pa, 0));			
						else {

							TRACE("\t\t\t\tturnneck: %f\n", RadToDeg(pa->GetDirection() - pa->GetNeckDirection()));
							
							pa->bskl->TurnNeckStraight(pa);
						}
						// PlanGoTo(pa, pa->bskl->BallPosition(pa, 0), 5);										
					}
					else {
						// ide na svoju poziciu
						
						TRACE("\t\t\tNie som najblizsie k lopte a idem na svoju poziciu\n");

						C2DVector mypos = pa->GetPosition();
						if((fabs(mypos.GetX() - homepos.GetX()) > 4) || (fabs(mypos.GetY() - homepos.GetY()) > 4))
							pa->bskl->FaceGoTo(pa, pBall, homepos);					
						else {
							if(fabs(pa->GetNeckDirection() - pa->GetDirection()) < DegToRad(5)) {
								TRACE("\t\t\t\tturn: %f\n", RadToDeg((pa->GetWorldModel()->GetBall()->GetPosition() - pa->GetPosition()).GetAngle()));

								pa->bskl->TurnTo(pa, pa->GetWorldModel()->GetBall()->GetPosition());
							}	
							else {
								TRACE("\t\t\t\tturnneck: %f\n", RadToDeg(pa->GetDirection() - pa->GetNeckDirection()));
							
								pa->bskl->TurnNeckStraight(pa);
							}
						}
						// pa->bskl->GoTo(pa, homepos, 100.0);			
					}
					//pa->bskl->TurnNeckStraight(pa);
				}
			}

			// ak nevidi nikoho u lopty
			else {

				TRACE("\t\tNikto nie je u lopty a idem za nou\n");

				// ide za loptou
	            C2DVector ballpos = pa->bskl->BallPosition(pa, 0);
				// PlanGoTo(pa, ballpos, 5);					
				if(fabs(pa->GetNeckDirection() - pa->GetDirection()) < DegToRad(5))
	               pa->bskl->FaceGoTo(pa, pBall, ballpos);
				else {
					TRACE("\t\t\t\tturnneck: %f\n", RadToDeg(pa->GetDirection() - pa->GetNeckDirection()));

					pa->bskl->TurnNeckStraight(pa);
				}
				//pa->bskl->TurnNeckStraight(pa);
			}
		}
	}
	// ak neviem kde je lopte 
	else {
		TRACE("\t\tHladam loptu\n");

		// tocim sa kym ju nenajdem
		if(fabs(pa->GetNeckDirection() - pa->GetDirection()) < DegToRad(5)) {
			TRACE("\t\t\t\tturn 45\n");

			pa->bskl->Turn(pa, DegToRad(45));	
		}
		else {
			TRACE("\t\t\t\tturnneck: %f\n", RadToDeg(pa->GetDirection() - pa->GetNeckDirection()));

			pa->bskl->TurnNeckStraight(pa);
		}
	}
}
