#ifndef SYSTEMCLOCK_H
#define SYSTEMCLOCK_H

#include "Windows.h"
#include "LargeInt.h"

typedef int TSystemTime;

class CSystemClock
{
private:
    __int64 m_nInitCount;
    __int64 m_nCountsPerSec;

public:
    void Initialize() {
        LARGE_INTEGER nInitCount;
        LARGE_INTEGER nCountsPerSec;

        QueryPerformanceFrequency(&nCountsPerSec);  m_nCountsPerSec = nCountsPerSec.QuadPart;
        QueryPerformanceCounter(&nInitCount);  m_nInitCount = nInitCount.QuadPart;
        //if (QueryPerformanceCounter(&m_nInitCount) == FALSE);
            // exception;
    };
    TSystemTime GetTime() {
        LARGE_INTEGER nCurCount;

        QueryPerformanceCounter(&nCurCount);
        //if (QueryPerformanceCounter(&nCurCount) == FALSE);
            // exception;

        return int(((__int64(nCurCount.QuadPart) - m_nInitCount) * 1000) / m_nCountsPerSec);
//        nResCount = LargeIntegerDivide(ExtendedIntegerMultiply(LargeIntegerSubtract(nCurCount, m_nInitCount),1000), m_nCountsPerSec, &nRemainder);
//        nResCount = LargeIntegerDivide(ExtendedIntegerMultiply(LargeIntegerSubtract(nCurCount, m_nInitCount),1000), m_nCountsPerSec, &nRemainder);
//        return nResCount.LowPart;  // vrati cas v milisekundach od zinicializovania
    }
};

#endif  // SYSTEMCLOCK_H