// StaticField.h: interface for the CStaticField class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_STATICFIELD_H__D4C59C84_CA4D_11D4_8E53_AB76FF68270D__INCLUDED_)
#define AFX_STATICFIELD_H__D4C59C84_CA4D_11D4_8E53_AB76FF68270D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#pragma warning (disable : 4786)

#include <vector>
#include "PerceptionTypes.h"
#include "WorldObjects.h"

using namespace std;


//--------------------------------------

class CStaticField  
{
public:
	CStaticField();
	CStaticField(double dFLen, double dFWid, double dPALen, double dPAWid, double dGWid);
	virtual ~CStaticField();
	C2DVector GetFlag(EFlagType f) { return m_cFlags[f]; }
	C2DVector GetGoal(EGoalType g) { return m_cGoals[g]; }
	C2DLine GetLine(ELineType l) { return m_cLines[l]; }

	double GetFieldLength( void )		{ return m_dFieldLen; };
	double GetFieldWidth( void )		{ return m_dFieldWid; };
	double GetPenaltyAreaLength( void ) { return m_dFieldPALen; };
	double GetPenaltyAreaWidth( void )	{ return m_dFieldPAWid; };
	double GetGoalSize( void )			{ return m_dGoalSize; };

private:
	vector<C2DVector> m_cFlags;
	vector<C2DVector> m_cGoals;
	vector<C2DLine> m_cLines;

	double m_dFieldLen;
	double m_dFieldWid;
	double m_dFieldPALen;
	double m_dFieldPAWid;
	double m_dGoalSize;

	void SetDefaultFlags(double dFLen, double dFWid, double dPALen, double dPAWid, double dGWid);
    void SetDefaultGoals(double dFLen, double dFWid, double dPALen, double dPAWid, double dGWid);
    void SetDefaultLines(double dFLen, double dFWid, double dPALen, double dPAWid, double dGWid);
};

#endif // !defined(AFX_STATICFIELD_H__D4C59C84_CA4D_11D4_8E53_AB76FF68270D__INCLUDED_)
