#ifndef SKILLS_H
#define SKILLS_H

#include "GameCommand.h"
#include "WorldGeometry.h"

class CLocalAgent;           // aby sme sa vyhli rekurzivnemu includovaniu
class CAgent;
class CBall;
class CMovingObject;

class CBasicSkills
{
// FIXME: protected?
public:
    C2DVector RelVectorTo(CLocalAgent *pa, C2DVector pos);

protected:
    double MinimalDirection(CLocalAgent *pa, double dist);
    double MinimalDirection(CLocalAgent *pa, double dist, double playerdiffusion);
    double KickDistance(CLocalAgent *pa);

    double DistToClosestOpponent(CLocalAgent *pa, C2DVector cFriendPos);

public:
    //! priam az elementary skills
    void Dash      (CLocalAgent *pa, double power);
    void Turn      (CLocalAgent *pa, double moment);
    void Kick      (CLocalAgent *pa, double power, double dir);
    void TurnNeck  (CLocalAgent *pa, double moment);
    void Move      (CLocalAgent *pa, double x, double y);
    void Move      (CLocalAgent *pa, C2DVector pos);
    void Catch     (CLocalAgent *pa, double dir);
    void Say       (CLocalAgent *pa, string message);
    void ChangeView(CLocalAgent *pa, EViewWidth width, EViewQuality quality);

public:
    //! zapocitanie rychlosti hraca...(prip. lopty)
    void Dash2(CLocalAgent *pa, double accel);
    void Turn2(CLocalAgent *pa, double angle);
    void Kick2(CLocalAgent *pa, double accel, double dir);

    double DashRealToWanted(CLocalAgent *pa, double accel);
    double TurnWantedToReal(CLocalAgent *pa, double angle);
    double TurnRealToWanted(CLocalAgent *pa, double moment);
	C2DVector KickRealToWanted(CLocalAgent *pa, double accel, double dir);
	C2DVector KickWantedToReal(CLocalAgent *pa, double accel, double dir);

public:
    //! low level skills
    void TurnTo(CLocalAgent *pa, C2DVector pos);

    void TurnNeckTo(CLocalAgent *pa, C2DVector pos);
    void TurnNeckToBall(CLocalAgent *pa);
    void TurnNeckStraight(CLocalAgent *pa);

    void GoTo(CLocalAgent *pa, C2DVector pos, double accel=0);
    void FaceGoTo(CLocalAgent *pa, CMovingObject *faceobj, C2DVector pos, double accel=0);
    void KickTo(CLocalAgent *pa, C2DVector pos, double accel=0);
    void DribbleTo(CLocalAgent *pa, C2DVector pos, double spd, double safe);

public:
    //! jednoduche ohodnocovacie skills
    bool BallKickable(CLocalAgent *pa);
    bool NearGoal(CLocalAgent *pa, EGoalType g);
    CAgent *PlayerInWay(CLocalAgent *pa, double dir);
//    double NearestOpponentToBall(CLocalAgent *pa);
    CAgent *NearestFriendToBall(CLocalAgent *pa);
	CAgent *FreestFriend(CLocalAgent *pa);

    bool BallCatchable(CLocalAgent *pa);


    //! odhad do buducnosti
    C2DVector BallPosition(CLocalAgent *pa, int nTime, C2DVector cNewBallSpeed);
    C2DVector BallPosition(CLocalAgent *pa, int nTime);
    C2DVector GetBallInterceptPosition(CLocalAgent *pa, C2DVector cNewBallSpeed);


	// added by frz
	CAgent *NearestPlayerToBall(CLocalAgent *pa);  // vrati najblizsieho hraca zo vsekych identifikovanych 
	CAgent *NearestOppPlayer(CLocalAgent* pa);	// vrati najblizsieho protihraca
	CAgent *NearestUnitMemberToPlayer(CLocalAgent* pa, CAgent *a); // vrati najblizsieho clena unitu k danemu protihracovi
};

#endif  // SKILLS_H
