#include "stdafx.h"
#include "Skills.h"
#include "LogManager.h"
#include "WorldObjects.h"

#define POWERRANGE(x)  (((x)>pa->cfg->maxpower)?pa->cfg->maxpower:             \
                        (((x)<pa->cfg->minpower)?pa->cfg->minpower:(x)))
#define MOMENTRANGE(x) (((x)>pa->cfg->maxmoment)?pa->cfg->maxmoment:           \
                        (((x)<pa->cfg->minmoment)?pa->cfg->minmoment:(x)))
#define NECKRANGE(x)   (((x)>pa->cfg->maxneckmoment)?pa->cfg->maxneckmoment:   \
                        (((x)<pa->cfg->minneckmoment)?pa->cfg->minneckmoment:(x)))


// FIXME: pre aku neurcitost sa pozerat za loptou
#define INVALID(diff, dist) ((((dist)>5) && ((diff)>(0.5*(dist)))) || (((dist)<5) && ((diff)>3)))

//--------------------------------------------------------------------------
// Elementary skills
//--------------------------------------------------------------------------


void CBasicSkills::Dash(CLocalAgent *pa, double power)
{
    CGameCommand *pGameCommand = new CGameCommand();

    pGameCommand->Dash(POWERRANGE(power));
    pa->actionseq->AddGameCommand(pGameCommand);
}

void CBasicSkills::Turn(CLocalAgent *pa, double moment)
{
    CGameCommand *pGameCommand = new CGameCommand();
    
    double moment2 = RadToDeg(moment);  moment2 = MOMENTRANGE(moment2);
    pGameCommand->Turn(moment2);
    pa->actionseq->AddGameCommand(pGameCommand);

//    // QUICK FIX NA OTACANIE - ZRUSIT KED BUDE DOBRY WORLDMODEL (SO ZAPOCITANIM POSLEDNEJ HRACOVEJ AKCIE)
//    pa->lastturn = DegToRad(moment2);
}

void CBasicSkills::Kick(CLocalAgent *pa, double power, double dir)
{
    CGameCommand *pGameCommand = new CGameCommand();
    
    pGameCommand->Kick(POWERRANGE(power), RadToDeg(dir));
//FIXME: to je taka hra...
//+30);
    pa->actionseq->AddGameCommand(pGameCommand);
}

void CBasicSkills::TurnNeck(CLocalAgent *pa, double moment)
{
    CGameCommand *pGameCommand = new CGameCommand();
    
    double moment2 = RadToDeg(moment);  moment2 = NECKRANGE(moment2);
    pGameCommand->TurnNeck(moment2);
    pa->actionseq->AddGameCommand(pGameCommand);
}

void CBasicSkills::Move(CLocalAgent *pa, double x, double y)
{
    CGameCommand *pGameCommand = new CGameCommand();
    
    pGameCommand->Move(x, y);
    pa->actionseq->AddGameCommand(pGameCommand);
}

void CBasicSkills::Move(CLocalAgent *pa, C2DVector pos)
{
    Move(pa, pos.GetX(), pos.GetY());
}

void CBasicSkills::Catch(CLocalAgent *pa, double dir)
{
    CGameCommand *pGameCommand = new CGameCommand();
    
    pGameCommand->Catch(RadToDeg(dir));
    pa->actionseq->AddGameCommand(pGameCommand);
}

void CBasicSkills::Say(CLocalAgent *pa, string message)
{
    CGameCommand *pGameCommand = new CGameCommand();
    
    pGameCommand->Say(message);
    pa->actionseq->AddGameCommand(pGameCommand);
}

void CBasicSkills::ChangeView(CLocalAgent *pa, EViewWidth width, EViewQuality quality)
{
    CGameCommand *pGameCommand = new CGameCommand();
    
    pGameCommand->ChangeView(width, quality);
    pa->actionseq->AddGameCommand(pGameCommand);
}


//--------------------------------------------------------------------------
// Pomocne funkcie
//--------------------------------------------------------------------------

C2DVector CBasicSkills::RelVectorTo(CLocalAgent *pa, C2DVector pos)
{
    return Rot(pos - (C2DVector)pa->GetPosition(), -pa->GetDirection());
}


//! Vrati minimalny uhol, v ktorom moze byt relativne ku mne iny hrac aby som donho nenarazil, ked pojdem rovno
double CBasicSkills::MinimalDirection(CLocalAgent *pa, double dist)
{
    double dFix = 1;
    double s = (pa->cfg->player_size + dFix * pa->cfg->player_size) / dist;
    if (s <= 1) return asin(s);
    else        return DegToRad(90);
//    return asin(2 * dFix * cfg->player_size / dist);
}

double CBasicSkills::MinimalDirection(CLocalAgent *pa, double dist, double playerdiffusion)
{
    double playersize;

//  if (playerdiffusion < 20) 
        playersize = playerdiffusion;
//  else
//      playersize = 0;

    return asin(2 * playersize / dist);
}



//! vzdialenost, kam je schopna dojst lopta po odkopnuti
double KickDistance(CLocalAgent *pa)
{

	// zavisi od maxpower*kickwantedtoreal*...

    return 20;
}


//--------------------------------------------------------------------------
// Dash
//--------------------------------------------------------------------------

void CBasicSkills::Dash2(CLocalAgent *pa, double accel)
{
    Dash(pa, DashRealToWanted(pa, accel));
}

double CBasicSkills::DashRealToWanted(CLocalAgent *pa, double accel)
{
    // todo: zapocitat staminu

    return accel / (pa->cfg->dash_power_rate);
}


//--------------------------------------------------------------------------
// Turn
//--------------------------------------------------------------------------

void CBasicSkills::Turn2(CLocalAgent *pa, double angle)
{
    Turn(pa, TurnRealToWanted(pa, angle));
}

double CBasicSkills::TurnWantedToReal(CLocalAgent *pa, double angle)
{
    return angle / (1.0 + pa->cfg->inertia_moment * pa->GetSpeed().GetDistance());
}

double CBasicSkills::TurnRealToWanted(CLocalAgent *pa, double moment)
{
    return moment * (1.0 + pa->cfg->inertia_moment * pa->GetSpeed().GetDistance());
}


//--------------------------------------------------------------------------
// Turn Neck
//--------------------------------------------------------------------------

// turnneck nie je otestovany - velka pravdepodobnost ze to nefunguje
void CBasicSkills::TurnNeckTo(CLocalAgent *pa, C2DVector pos)
// FIXME: ak urobim turn, tak turnneckto sa musi od toho odpocitat!!!
// FIXME: bude treba urobit kontrolu ci sa mozem az tam otocit
//        a pripadne orezat, nech pri recompute nepocitam s blbostami
{
    C2DVector necktopos = Rot(pos - (C2DVector)pa->GetPosition(), -pa->GetNeckDirection());
    TurnNeck(pa, necktopos.GetAngle());

//    double n = - ( pa->GetNeckDirection() - pa->GetDirection() );
//    double n = pa->GetDirection();

//    double n = RelVectorTo(pa, pos).GetAngle() - pa->GetDirection();
//    n += Rot(pos - (C2DVector)pa->GetPosition(), -pa->GetNeckDirection()).GetAngle();

//    n+=DegToRad(10);

//    TurnNeck(pa, n);
}

void CBasicSkills::TurnNeckToBall(CLocalAgent *pa)
{
    CBall *pBall = pa->GetWorldModel()->GetBall();
    CDiffuse2DVector vball = pBall->GetPosition() - pa->GetPosition();
    double necktoball = vball.GetAngle() - pa->GetNeckDirection();
    TurnNeck(pa, necktoball);
}

void CBasicSkills::TurnNeckStraight(CLocalAgent *pa)
{
    double neckang =  pa->GetDirection() - pa->GetNeckDirection();
    if ((neckang < DegToRad(-1.0)) || (neckang > DegToRad(1.0))) TurnNeck(pa, neckang);
}


//--------------------------------------------------------------------------
// Kick
//--------------------------------------------------------------------------

// vstup tejto funkcie nie je sila akou sa bude kopat,
// ale rychlost (cize o kolko metrov sa ma lopta pohnut v dalsom kroku)
// (takisto uhol je zelany uhol)
void CBasicSkills::Kick2(CLocalAgent *pa, double accel, double dir)
{
    // treba dat pozor aby sme nekopli do seba (prip. do ineho hraca???)

    // treba zapocitat rychlost lopty + natocenie
    C2DVector vkick = KickRealToWanted(pa, accel, dir);
    Kick(pa, vkick.GetDistance(), vkick.GetAngle());

}

C2DVector CBasicSkills::KickRealToWanted(CLocalAgent *pa, double accel, double dir)
{
    // treba zapocitat rychlost lopty + natocenie
    CBall *pBall = pa->GetWorldModel()->GetBall();
    C2DVector vball = RelVectorTo(pa, pBall->GetPosition());
    double dist_ball = vball.GetDistance();
    double dir_diff = fabs(RadToDeg(vball.GetAngle()));
    double factor = pa->cfg->kick_power_rate * (1.0 - 0.25 * dir_diff / 180.0 - 0.25 * (dist_ball - pa->cfg->player_size - pa->cfg->ball_size) / pa->cfg->kickable_margin);

    C2DVector vkick;
    vkick.SetAngleDistance(dir, accel);
//    vkick -= pBall->GetSpeed();
	vkick.SetDistance(vkick.GetDistance() / factor);
	return vkick;
}

C2DVector CBasicSkills::KickWantedToReal(CLocalAgent *pa, double accel, double dir)
{
    // treba zapocitat rychlost lopty + natocenie
    CBall *pBall = pa->GetWorldModel()->GetBall();
    C2DVector vball = RelVectorTo(pa, pBall->GetPosition());
    double dist_ball = vball.GetDistance();
    double dir_diff = fabs(RadToDeg(vball.GetAngle()));
    double factor = pa->cfg->kick_power_rate * (1.0 - 0.25 * dir_diff / 180.0 - 0.25 * (dist_ball - pa->cfg->player_size - pa->cfg->ball_size) / pa->cfg->kickable_margin);

    C2DVector vkick;
    vkick.SetAngleDistance(dir, accel);
	vkick.SetDistance(vkick.GetDistance() * factor);
//    vkick += pBall->GetSpeed();
	return vkick;
}





//--------------------------------------------------------------------------
// Basic Skills
//--------------------------------------------------------------------------


void CBasicSkills::TurnTo(CLocalAgent *pa, C2DVector pos)
{
    Turn2(pa, RelVectorTo(pa, pos).GetAngle());
}


void CBasicSkills::GoTo(CLocalAgent *pa, C2DVector pos, double accel)
{
    C2DVector topos = RelVectorTo(pa, pos);
    double ang = topos.GetAngle();

    if (topos.GetDistance() < pa->cfg->kickable_area)  return;

    // zistujeme, ci je v ceste nejaky hrac
    CAgent *paiw = PlayerInWay(pa, ang);
    if (paiw) {
        // tu sa riesi vyhybanie sa hracovi
        C2DVector toplr = RelVectorTo(pa, paiw->GetPosition());
        double pldist = toplr.GetDistance();
        double pldir = toplr.GetAngle();
        LOGMSG(1, "player in way - dist %lf, dir %lf",pldist,pldir);

        LOGMSG(1, "ang before %lf", ang);
        // vyhybame sa iba ked je hrac blizsie ako miesto kam chceme ist
        if (pldist < topos.GetDistance())
            (pldir < ang) ? ang -= MinimalDirection(pa, pldist) + fabs(pldir - ang)
                          : ang += MinimalDirection(pa, pldist) + fabs(pldir - ang);


        LOGMSG(1, "ang after  %lf", ang);
    
    }

    double mindir = DegToRad(5.0); // aby sme sa stale netocili
    if ((ang > -mindir) && (ang < mindir)) 
    {
        if (accel==0) {
            // vypocet accel, aby tam agent presne zastavil
            accel = (topos - (C2DVector)pa->GetSpeed()).GetDistance();
        }
        Dash2(pa, accel);
    }
    else 
    {
        Turn2(pa, ang);
    }
}

/*
void CBasicSkills::FaceGoTo(CLocalAgent *pa, C2DVector facepos, C2DVector pos, double accel)
{
    TurnNeckTo(pa, facepos);
    GoTo(pa, pos, accel);

//    static int rr=0;
//    if (rr) TurnNeckTo(pa, facepos);
//    else    GoTo(pa, pos, accel);
//    rr = !rr;
} */

/*! 
Metoda zabezpeci, ze hrac bezi na dane miesto a pozera sa na dany objekt.
\param pa Pointer na LocalAgenta, ktory sa ma hybat.
\param faceobj Pointer na MovingObject, ktoty sa ma pocas pohybu sledovat.
\param pos Vektor na ktory sa ma hrac presunut.
\param accel Sila akou sa ma aget rozbehnut. Ak nie je uvedena vypocita sa automaticky.
*/
void CBasicSkills::FaceGoTo(CLocalAgent *pa, CMovingObject *faceobj, C2DVector pos, double accel)
{
//    TurnNeckTo(pa, facepos);
//    GoTo(pa, pos, accel);

//    static int rr=0;
//    if (rr) TurnNeckTo(pa, facepos);
//    else    GoTo(pa, pos, accel);
//    rr = !rr;

	// added by frz

	// maximalne mozne natocenie krku
	double maxneckang = pa->cfg->Getd("maxneckang");

	// natocenie hlavy a krku
	C2DVector mypos = pa->GetPosition();
	double mydir = pa->GetDirection();
	double myheaddir = pa->GetNeckDirection();

	TRACE("\t\t\t\tMoje natocenie: telo %f, hlava %f\n", RadToDeg(mydir), RadToDeg(myheaddir));

	// vektor a uhol k cielu
	C2DVector reldestpos = pos - mypos;
	double reldestdir = reldestpos.GetAngle();

	// musim sa tocit ak chcel ist k cielu
	double turnangle = AngNormalise(reldestdir - mydir);

	double relfodir;
	double neckturnangle = 0.0;
	C2DVector fopos = faceobj->GetPosition();
	C2DVector relfopos = fopos - mypos;

	double diff = faceobj->GetPosition().GetDiffusion();
	double dist = relfopos.GetDistance();
	// ak viem kde je objekt na ktory sa chcem pozerat
	if ((((faceobj->GetSeeStatus() & SEE_ANGLE) && (faceobj->GetSeeStatus() & SEE_DISTANCE)) ||
        ((faceobj->GetSeeStatus() & EXPECTED_ANGLE) && (faceobj->GetSeeStatus() & EXPECTED_DISTANCE))) &&
        (!INVALID(diff,dist)))    
    {	
		relfodir = relfopos.GetAngle();
	}
	// ak neviem kde je objekt tocim sa dokola aby som ho nasiel
	else {
		relfodir = 45 + mydir;
	}
	bool goback = false;

	TRACE("\t\t\t\t");
	
		// zistim ci musim cuvat aby som mohol pozorovat objekt
	if(fabs(AngNormalise(reldestdir - relfodir)) > DegToRad(maxneckang)) {
		turnangle = AngNormalise(turnangle + DegToRad(180));
		goback = true;

		TRACE("Budem cuvat:");
	}

	TRACE("turnangle %f\n", RadToDeg(turnangle));

	// zistim natocenie krku
	neckturnangle = AngNormalise(relfodir - myheaddir);

	TRACE("\t\t\t\tneckturnangle %f\n", RadToDeg(neckturnangle));

	// vypocitam silu behu
	if(accel == 0) {
		double powerrate = pa->cfg->Getd("dash_power_rate");
		accel = ((reldestpos - pa->GetSpeed())/powerrate).GetDistance();
	}

	if(goback)
		accel *= -1;
		
	if(fabs(turnangle) > DegToRad(7.0))
		Turn(pa, turnangle);
	else if(fabs(neckturnangle - turnangle) > DegToRad(4.0))
		TurnNeck(pa, neckturnangle);
	else
		Dash(pa, accel); 
	
	// if(fabs(neckturnangle - turnangle) > DegToRad(4.0))
	// 	TurnNeck(pa, neckturnangle);
}

void CBasicSkills::KickTo(CLocalAgent *pa, C2DVector pos, double accel)
{
    // vektor od lopty k pozicii kam treba strelit
    C2DVector v = pos - (C2DVector)pa->GetWorldModel()->GetBall()->GetPosition();
    // uhol relativne k hracovemu natoceniu
    double ang = v.GetAngle() - pa->GetDirection();

    if (accel==0) {
        // vypocet accel zo vzdialenosti pos aby tam lopta akurat prisla
        // accel = |vektor_k_pos - vektor_k_lopte|
        accel = v.GetDistance() * (1 - pa->cfg->ball_decay ) + 0.1;

	}
    else {
        // inac dame silu taku ako bola zadana rychlost
        accel = KickWantedToReal(pa, accel, ang).GetDistance();
    }
    
    Kick2(pa, accel, ang);
}


void CBasicSkills::DribbleTo(CLocalAgent *pa, C2DVector pos, double spd, double safe)
{
    // Dorobit vyhybanie sa ostatnym hracom!

    if (BallKickable(pa)) {
//        TurnNeckTo(pa, pos);
        KickTo(pa, pos, spd);

    } else {
//        TurnNeckStraight(pa);
        C2DVector ballpos = pa->GetWorldModel()->GetBall()->GetPosition();
        double pow = spd;   //taka sila, aby zastal tesne pred loptou
        GoTo(pa, ballpos, pow);
    }

}




//--------------------------------------------------------------------------
// Ohodnocovacie skills
//--------------------------------------------------------------------------

bool CBasicSkills::BallKickable(CLocalAgent *pa)
{
    double disttoball = RelVectorTo(pa, pa->GetWorldModel()->GetBall()->GetPosition()).GetDistance();
    double dist = pa->cfg->kickable_area - disttoball;
    if (dist < 0) return false;
    return true;
}


bool CBasicSkills::NearGoal(CLocalAgent *pa, EGoalType g)
{
    /*
    C2DVector p = pa->GetPosition();
    C2DVector k;
    k.SetAngleDistance(pa->GetDirection(), 0.90*KickDistance(pa));



    switch(g) {
    case GT_L:
        break;
    case GT_R:
        break;
    default:
    }



    CDiffuse2DVector goal(goalpos, 0);
    CDiffuse2DVector vgoal = goal - pa->GetPosition();
    double disttogoal = vgoal.GetDistance();
    double diffugoal = vgoal.GetDiffusion();
    double dist = 20 - disttogoal; // FIXME - nie 20, ale nejako vyratat odkial uz mozem strielat do brany
    // TODO nepocitat s brankou ako s bodom ale s celou brankou!
    if (dist < 0) return false;
    return true;
    */
    return false;
}



CAgent *CBasicSkills::PlayerInWay(CLocalAgent *pa, double dir)
{
    CWorldModel *pwm = pa->GetWorldModel();
    Agents *pia = pwm->GetIdentifiedAgents();
    Agents *pua = pwm->GetUnidentifiedAgents();

    int i;
    C2DVector toplr, toplr2;
    double pldir;
    double pldist, pldist2;
    double mindir;
    CAgent *pnow = NULL;
    CAgent *pret = NULL;

    LOGMSG(1, "search 4 player in way (see total %d players)", pia->size()+pua->size());


    // hladame medzi identifikovanymi hracmi
	for(i=0; i < pia->size(); i++)
	{
        pnow = pia->at(i);
        // vektor na hraca
        toplr = RelVectorTo(pa, pnow->GetPosition());
        pldir = toplr.GetAngle();
        pldist = toplr.GetDistance();
        mindir = MinimalDirection(pa, pldist/*, pnow->GetPosition().GetDiffusion()*/);
//        if ((pldir > -mindir) && (pldir < mindir)) {
        if (fabs(pldir - dir) < mindir) {
            if (pret) {
                toplr2 = RelVectorTo(pa, pret->GetPosition());
                pldist2 = toplr2.GetDistance();
                // vratime toho co je blizsie
                if( pldist < pldist2) pret = pnow;
            }
            else {
                pret = pnow;
            }
        }

        LOGMSG(1, "IDPLAYER %d: dir %lf, dist %lf  (mindir %lf)", i, pldir, pldist, mindir);

    }

    // hladame medzi neidentifikovanymi hracmi
    for(i=0;i<pua->size();i++)
	{
        pnow = pua->at(i);
        // vektor na hraca
        toplr = RelVectorTo(pa, pnow->GetPosition());
        pldir = toplr.GetAngle();
        pldist = toplr.GetDistance();
        mindir = MinimalDirection(pa, pldist/*, pnow->GetPosition().GetDiffusion()*/);
//        if ((pldir > -mindir) && (pldir < mindir)) {
        if (fabs(pldir - dir) < mindir) {
            if (pret) {
                toplr2 = RelVectorTo(pa, pret->GetPosition());
                pldist2 = toplr2.GetDistance();
                // vratime toho co je blizsie
                if( pldist < pldist2) pret = pnow;
            }
            else {
                pret = pnow;
            }
        }

        LOGMSG(1, "NIDPLAYER %d: dir %lf, dist %lf  (mindir %lf)", i, pldir, pldist, mindir);

    }

    return pret;
}

/*
double CBasicSkills::NearestOpponentToBall(CLocalAgent *pa)
{


    return 0;
}
*/




// odhadnuta pozicia lopty po case dTime krokov a s pociatiocnou rychlostou cNewBallSpeed
C2DVector CBasicSkills::BallPosition(CLocalAgent *pa, int nTime, C2DVector cNewBallSpeed)
{
    C2DVector cBallPos = pa->GetWorldModel()->GetBall()->GetPosition();

    // geometricky rad - postupne spomalovanie lopty
    double x;
    if (pa->cfg->ball_decay != 1)
        x = (pow(pa->cfg->ball_decay, (double)nTime) - 1) / (pa->cfg->ball_decay - 1);
    else
        x = nTime * pa->cfg->ball_decay;

    return cBallPos + cNewBallSpeed * x;
}

C2DVector CBasicSkills::BallPosition(CLocalAgent *pa, int nTime)
{
    C2DVector cBallPos = pa->GetWorldModel()->GetBall()->GetPosition();
    C2DVector cNewBallSpeed = pa->GetWorldModel()->GetBall()->GetSpeed();

/*
    double x;
    if (cfg->ball_decay != 1)
        x = (pow(cfg->ball_decay, (double)nTime) - 1) / (cfg->ball_decay - 1);
    else
        x = nTime * cfg->ball_decay;

    return cBallPos + cNewBallSpeed * x;
*/

	for(int i = 0; i < nTime; i++)
	{
		cBallPos += cNewBallSpeed;
        cNewBallSpeed *= pa->cfg->ball_decay;
	}

    return cBallPos;
}




// pozor na cNewBallSpeed! (treba asi pouzit KickWantedToReal)
C2DVector CBasicSkills::GetBallInterceptPosition(CLocalAgent *pa, C2DVector cNewBallSpeed)
{
    C2DVector v(NOT_EXISTING, NOT_EXISTING);

    // ratame s tym, ze sa musi najprv otocit do spravneho uhlu.
    // keby sa dalo nejako zistit ci sa musi otocit alebo nie, bolo by to presnejsie
    int nTurn = 1;

    // - ratanie polohy playera
    C2DVector cNewPos, cSpd, cAccel, cu;
//    cNewPos = pa->GetPosition();
    cNewPos.SetXY(0, 0);
    // FIX: accel
    // cAccel.SetAngle(pa->GetDirection());
    cSpd.SetXY(0,0);
//    cSpd = pa->GetSpeed();    // ked bude fungovat rychlost...
    // -


    // FIX: co to urobi pre 120??
    for (int i=0; i < 120; i++)    // pokial to ma ist ???
    {
        // - ratanie polohy playera
        // FIX: accel
        cAccel.SetAngleDistance(0, pa->cfg->maxpower * pa->cfg->dash_power_rate); // todo: zapocitat staminu!
        // cAccel.SetDistance(cfg->maxpower * cfg->dash_power_rate); // todo: zapocitat staminu!
        if (cAccel.GetDistance() > pa->cfg->player_accel_max) cAccel.SetDistance(pa->cfg->player_accel_max);
        cu = cSpd + cAccel;
        cNewPos += cu;
        cSpd = cu * pa->cfg->player_decay;
        if (cSpd.GetDistance() > pa->cfg->player_speed_max) cSpd.SetDistance(pa->cfg->player_speed_max);
        // -

        // poloha lopty
        v = BallPosition(pa, i + nTurn, cNewBallSpeed);

        if (RelVectorTo(pa, v).GetDistance() < cNewPos.GetDistance())
        {
            break;
        }

        // FIX: posledna poloha
//        v.SetXY(NOT_EXISTING, NOT_EXISTING);
    }



//    if (i<19) LOGMSG(1, "+time %d : disttoball %lf, howfaricanget %lf", i, RelVectorTo(pa, v).GetDistance(), cNewPos.GetDistance());

//    LOGMSG(1, "BallPos x:%lf, y:%lf", BallPosition(pa, 0).GetX(), BallPosition(pa, 0).GetY());
//    LOGMSG(1, "BallSpeed x:%lf, y:%lf", pa->GetWorldModel()->GetBall()->GetSpeed());
//    LOGMSG(1, "InterceptPos x:%lf, y:%lf", v.GetX(), v.GetY());

    return v;
}




#define  MAX_DISTANCE   999999.99

CAgent *CBasicSkills::NearestFriendToBall(CLocalAgent *pa)
{
    CWorldModel *pwm = pa->GetWorldModel();
    Agents *pia = pwm->GetIdentifiedAgents();

    int i;
    C2DVector toplr, toplr2;
    double mindist;
    CAgent *pnow = NULL;
    CAgent *pret = NULL;

    ESide myside = pa->GetPlayerSide();

    C2DVector ballpos = pa->GetWorldModel()->GetBall()->GetPosition();
    C2DVector toball = RelVectorTo(pa, ballpos);

    mindist = MAX_DISTANCE;
    pret = NULL;

    double distplr2ball;

    // hladame medzi identifikovanymi hracmi
	for(i=0; i < pia->size(); i++)
	{
        pnow = pia->at(i);
        if (pnow->GetPlayerSide() == myside) {
            // vektor na hraca
            toplr = RelVectorTo(pa, pnow->GetPosition());

            distplr2ball = (toball - toplr).GetDistance();

			if (distplr2ball < mindist) {
				pret = pnow;
				mindist = distplr2ball;
			}
        }
    }

    return pret;
}




CAgent *CBasicSkills::FreestFriend(CLocalAgent *pa)
{
    CWorldModel *pwm = pa->GetWorldModel();
    Agents *pia = pwm->GetIdentifiedAgents();
    int i;
    CAgent *pnow = NULL;
    CAgent *pret = NULL;

	ESide myside = pa->GetPlayerSide();

	double dClosestOpp, dMinimum = MAX_DISTANCE;

    // hladame medzi identifikovanymi hracmi
	for(i=0; i < pia->size(); i++)
	{
        pnow = pia->at(i);
        if (pnow->GetPlayerSide() == myside) {
			dClosestOpp = DistToClosestOpponent(pa, pnow->GetPosition());
			if (dClosestOpp <= dMinimum) {
				dMinimum = dClosestOpp;
				pret = pnow;
			}
        }
    }

    return pret;

}



double CBasicSkills::DistToClosestOpponent(CLocalAgent *pa, C2DVector cFriendPos)
{
	// todo: mozno by bolo dobre neidentifikovaneho playera chapat ako oponenta

	C2DVector tofriend = RelVectorTo(pa, cFriendPos);

    CWorldModel *pwm = pa->GetWorldModel();
    Agents *pia = pwm->GetIdentifiedAgents();
    int i;
    CAgent *pnow = NULL;
	double dOppDist, dRet = MAX_DISTANCE;

    ESide myside = pa->GetPlayerSide();

	for(i=0; i < pia->size(); i++)
	{
        pnow = pia->at(i);
        if (pnow->GetPlayerSide() != myside) {
			dOppDist = (RelVectorTo(pa, pnow->GetPosition()) - tofriend).GetDistance();
			if (dOppDist < dRet) dRet = dOppDist;
        }
    }
    return dRet;
}





bool CBasicSkills::BallCatchable(CLocalAgent *pa)
{    
    //TODO: hodnotu 5 treba vycitat niekde z konfigu, ale ako?
    if (pa->m_last_catch + 5 > pa->GetTime())
    {
        return false;
    }
    pa->m_last_catch = pa->GetTime().m_nAllCycles;

    

    // UROBIT PRE JEEFFA!!!

    // a zistit ci sa moze chytat - da sa iba raz za nejaky cas

    // toto je ballkickable 
    double disttoball = RelVectorTo(pa, pa->GetWorldModel()->GetBall()->GetPosition()).GetDistance();
    double dist = (pa->cfg->kickable_area*2) - disttoball;
    if (dist < 0) return false;
    return true;
}

CAgent *CBasicSkills::NearestOppPlayer(CLocalAgent *pa)
{
    CWorldModel *pwm = pa->GetWorldModel();
    Agents *pia = pwm->GetIdentifiedAgents();

    int i;
	CDiffuse2DVector plrpos, plrspd;
    C2DVector toplr, toplr2;
    double mindist;
    CAgent *pnow = NULL;
    CAgent *pret = NULL;

    ESide myside = pa->GetPlayerSide();

    mindist = MAX_DISTANCE;
    pret = NULL;

    double distplr2me;

	for(i=0; i < pia->size(); i++)
	{
        pnow = pia->at(i);
        if (pnow->GetPlayerSide() != myside) {
            // predpokladany vektor na hraca v dalsom kroku
			// todo: pridat rychlost a smer kam bezi
			plrpos = pnow->GetPosition();

			toplr = RelVectorTo(pa, plrpos);
			
            distplr2me = toplr.GetDistance();

			if (distplr2me < mindist) {
				pret = pnow;
				mindist = distplr2me;
			}
        }
    }

    return pret;
}

CAgent *CBasicSkills::NearestPlayerToBall(CLocalAgent *pa)
{
    CWorldModel *pwm = pa->GetWorldModel();
    Agents *pia = pwm->GetIdentifiedAgents();

    int i;
    C2DVector toplr, toplr2;
    double mindist;
    CAgent *pnow = NULL;
    CAgent *pret = NULL;

    ESide myside = pa->GetPlayerSide();


    C2DVector ballpos = pa->bskl->GetBallInterceptPosition(pa, pa->GetWorldModel()->GetBall()->GetSpeed());
    C2DVector toball = RelVectorTo(pa, ballpos);

    mindist = MAX_DISTANCE;
    pret = NULL;

    double distplr2ball;

    // medzi identifikovanymi hracmi
	for(i=0; i < pia->size(); i++)
	{
        pnow = pia->at(i);
        // vektor na hraca
        toplr = RelVectorTo(pa, pnow->GetPosition());

        distplr2ball = (toball - toplr).GetDistance();

		if (distplr2ball < mindist) {
			pret = pnow;
			mindist = distplr2ball;
		}
    }

    return pret;
}

CAgent *CBasicSkills::NearestUnitMemberToPlayer(CLocalAgent* pa, CAgent *a) 
{
    CWorldModel *pwm = pa->GetWorldModel();
    Agents *pia = pwm->GetIdentifiedAgents();

    int i, j;
    C2DVector toplr, tofriend;
    double mindist;
    CAgent *pnow = NULL;
    CAgent *pret = NULL;

	// zistim unit a velkost unitu pre pa
	int unitsize = pa->fskl->GetMyUnitSize(pa, pa->fskl->GetMyUnitType(pa, pa->GetPlayerNumber()));
	Pnum *unitmembers = pa->fskl->GetUnitMembers(pa, pa->fskl->GetMyUnitType(pa, pa->GetPlayerNumber()));

	// na ktorej strane hra pa
    ESide myside = pa->GetPlayerSide();

	// vektor od pa k protihtacovi
    toplr = RelVectorTo(pa, a->GetPosition());
    // ako je protihrac vzdialeny od pa
	mindist = toplr.GetDistance();
    pret = pa;

    double distplr2plr;

    // medzi identifikovanymi hracmi
	for(i=0; i < pia->size(); i++)
	{
		// je to spoluhrac
        if(myside == pia->at(i)->GetPlayerSide()) {
			pnow = pia->at(i);

			// je spoluhrac v mojom unite
			for(j = 0; j < unitsize; j++) {
				if(pnow->GetPlayerNumber() == unitmembers[j])
						break;
			}

			// ak je pozri ci nie je blizsie k hracovi
			if(j != unitsize) {

				// vektor na hraca
				tofriend = RelVectorTo(pa, pnow->GetPosition());

				distplr2plr = (toplr - tofriend).GetDistance();
			
				if (distplr2plr < mindist) {
					pret = pnow;
					mindist = distplr2plr;
				}
			}
		}
    }

    return pret;
	
}

