// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "Player.h"

#include "MainFrm.h"
#include "VisualSetupDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CPlayerApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_SERVER_CONNECT, OnServerConnect)
	ON_COMMAND(ID_SERVER_DISCONNECT, OnServerDisconnect)
	ON_UPDATE_COMMAND_UI(ID_SERVER_CONNECT, OnUpdateServerConnect)
	ON_UPDATE_COMMAND_UI(ID_SERVER_DISCONNECT, OnUpdateServerDisconnect)
	ON_COMMAND(ID_WINDOW_GRAPHICVIEW, OnWindowGraphicview)
	ON_COMMAND(ID_WINDOW_STATICTEXTVIEW, OnWindowStatictextview)
	ON_COMMAND(ID_SHOW_VISUAL_SETUP, OnShowVisualSetup)
	ON_COMMAND(ID_SERVER_CONNECT_GOALIE, OnServerConnectGoalie)
	ON_UPDATE_COMMAND_UI(ID_SERVER_CONNECT_GOALIE, OnUpdateServerConnectGoalie)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame() : m_pCoordinatorThread(NULL)
{
}

CMainFrame::~CMainFrame()
{
	// Ak bezi Coordinator thread, tak ho zrusi
	OnServerDisconnect();
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CMDIFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

extern bool g_bCoordinatorInitGoalie;           // FIXME: horko zaplakal

/* Vytvori a spusti Coordinator thread */
/* 'kopia' OnServerConnectGoalie()!!! */
void CMainFrame::OnServerConnect() 
{
	if (m_pCoordinatorThread)
		return;

    g_bCoordinatorInitGoalie = false;

	m_pCoordinatorThread = AfxBeginThread(RUNTIME_CLASS(CCoordinator),
		THREAD_PRIORITY_HIGHEST, 0, CREATE_SUSPENDED);

	// *TODO*: tu sa da zinicializovat objekt CCoordinator
	// skor ako sa v novom threade spusti message pump

	m_pCoordinatorThread->ResumeThread();
}

/* Vytvori a spusti Coordinator thread */
/* 'kopia' OnServerConnect()!!! */
void CMainFrame::OnServerConnectGoalie() 
{
	if (m_pCoordinatorThread)
		return;

    g_bCoordinatorInitGoalie = true;

	m_pCoordinatorThread = AfxBeginThread(RUNTIME_CLASS(CCoordinator),
		THREAD_PRIORITY_HIGHEST, 0, CREATE_SUSPENDED);

	// *TODO*: tu sa da zinicializovat objekt CCoordinator
	// skor ako sa v novom threade spusti message pump

	m_pCoordinatorThread->ResumeThread();	
}

/* Ukonci Coordinator thread */
void CMainFrame::OnServerDisconnect() 
{
	if (!m_pCoordinatorThread)
		return;

	m_pCoordinatorThread->PostThreadMessage(WM_QUIT, 0, 0);
	m_pCoordinatorThread = NULL;
}

/* Riadi zobrazovanie polozky Connect v menu */
void CMainFrame::OnUpdateServerConnect(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!m_pCoordinatorThread);
}

/* Riadi zobrazovanie polozky Connect Goalie v menu */
void CMainFrame::OnUpdateServerConnectGoalie(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!m_pCoordinatorThread);
}

/* Riadi zobrazovanie polozky Disconnect v menu */
void CMainFrame::OnUpdateServerDisconnect(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!!m_pCoordinatorThread);
}

void CMainFrame::OnWindowGraphicview() 
{
	// TODO: Add your command handler code here
	theApp.OnFileNew();
}

void CMainFrame::OnWindowStatictextview() 
{
	// TODO: Add your command handler code here
	theApp.OnFileTextNew();
	
}

void CMainFrame::OnShowVisualSetup() 
{
	CVisualSetupDlg visual_setup;
	
	visual_setup.DoModal();
}
