#ifndef GAMETIME_H
#define GAMETIME_H

class CGameTime
{
public:
    int m_nPlayTime;
    int m_nStopCycles;
    int m_nAllCycles;

public:
    CGameTime(int nCycles = 0) { m_nPlayTime = m_nStopCycles = 0;  m_nAllCycles = nCycles; };

    void operator ++(void) { m_nAllCycles++; }
    void operator +=(const int a) { m_nAllCycles += a; }

    bool operator <(const CGameTime &a) { return (m_nAllCycles < a.m_nAllCycles); }
    bool operator <=(const CGameTime &a) { return (m_nAllCycles <= a.m_nAllCycles); }
    bool operator >(const CGameTime &a) { return (m_nAllCycles > a.m_nAllCycles); }
    bool operator >=(const CGameTime &a) { return (m_nAllCycles >= a.m_nAllCycles); }
    bool operator ==(const CGameTime &a) { return (m_nAllCycles == a.m_nAllCycles); }

    bool operator <(const int &a) { return (m_nAllCycles < a); }
    bool operator <=(const int &a) { return (m_nAllCycles <= a); }
    bool operator >(const int &a) { return (m_nAllCycles > a); }
    bool operator >=(const int &a) { return (m_nAllCycles >= a); }
    bool operator ==(const int &a) { return (m_nAllCycles == a); }

//    CGameTime operator = { return *this; }
};

inline bool operator <(const int &a, const CGameTime &b) { return (a < b.m_nAllCycles); }
inline bool operator <=(const int &a, const CGameTime &b) { return (a <= b.m_nAllCycles); }
inline bool operator >(const int &a, const CGameTime &b) { return (a > b.m_nAllCycles); }
inline bool operator >=(const int &a, const CGameTime &b) { return (a >= b.m_nAllCycles); }
inline bool operator ==(const int &a, const CGameTime &b) { return (a == b.m_nAllCycles); }

#endif  // GAMETIME_H