#ifndef GAMESTATE
#define GAMESTATE

#include "GameTime.h"

enum EPlayMode {
	PM_NONE,
    PM_UNKNOWN_STOP,
    PM_UNKNOWN_NOSTOP,
	PM_BeforeKickOff,
	PM_TimeOver,
	PM_PlayOn,
	PM_KickOff_Left,
	PM_KickOff_Right,
	PM_KickIn_Left,
	PM_KickIn_Right,
	PM_FreeKick_Left,
	PM_FreeKick_Right,
	PM_CornerKick_Left,
	PM_CornerKick_Right,
	PM_GoalKick_Left,
	PM_GoalKick_Right,
	PM_AfterGoal_Left,
	PM_AfterGoal_Right,
	PM_DropBall,
	PM_OffSide_Left,
	PM_OffSide_Right,
};

#define isValidPlayMode(x)  ((x != PM_NONE) && (x != PM_UNKNOWN_NOSTOP))
#define isStopMode(x) ((x == PM_BeforeKickOff) || (x == PM_OffSide_Left) || (x == PM_OffSide_Right) || (x == PM_NONE))

class CGameState
{
    EPlayMode m_nPlayMode;
    CGameTime m_tGameTime;
//  Score
//  Side??

public:
	CGameState();

    CGameTime GetGameTime() { return m_tGameTime; };
    EPlayMode GetPlayMode() { return m_nPlayMode; };

    void SetGameTime(CGameTime &tGameTime) { m_tGameTime = tGameTime; };
    EPlayMode SetPlayMode(EPlayMode nPlayMode) { return m_nPlayMode = nPlayMode; };
};

#endif  // GAMESTATE