#ifndef FORMATIONTYPES_H
#define FORMATIONTYPES_H

typedef int Pnum;
typedef int Unum;  /* Uniform number           */

#define MAX_PLAYERS 25
#define SP_team_size 11
#define Pnum_Unknown  0
#define Formation_Unknown NULL

// Player Type
enum Ptype{
  PT_None,
  PT_Goaltender,
  PT_Sweeper,
  PT_Defender,
  PT_Midfielder,
  PT_Forward,

  PT_COUNT
};

// Player Side
enum Pside{
  PS_None,
  PS_Left,
  PS_Center,
  PS_Right
};

// Unit Type
enum Utype{
  UT_Defense,
  UT_Midfield,
  UT_Forward,
  UT_Left,
  UT_Center,
  UT_Right,
  UT_None,

  UT_COUNT
};

// Formation Type
enum Ftype{
  FT_None,
  FT_433,
  FT_442,
  FT_352,
  FT_72,
  FT_334,
  FT_244,
  FT_532,
  FT_right,
  FT_left,

  FT_FORMATION_COUNT
};

// Field Side
enum Fside{ 
  FS_Right,
  FS_Left
};


//					4-3-3 Formation 
#define f433_GOALIE           1
#define f433_SWEEPER         (f433_GOALIE         +1)
#define f433_RIGHT_DEFENSE   (f433_SWEEPER        +1)
#define f433_CENTER_DEFENSE  (f433_RIGHT_DEFENSE  +1)
#define f433_LEFT_DEFENSE    (f433_CENTER_DEFENSE +1)
#define f433_RIGHT_MIDFIELD  (f433_LEFT_DEFENSE   +1)
#define f433_CENTER_MIDFIELD (f433_RIGHT_MIDFIELD +1) 
#define f433_LEFT_MIDFIELD   (f433_CENTER_MIDFIELD+1) 
#define f433_RIGHT_WING      (f433_LEFT_MIDFIELD  +1) 
#define f433_CENTER_FORWARD  (f433_RIGHT_WING     +1) 
#define f433_LEFT_WING       (f433_CENTER_FORWARD +1) 

//					4-4-2 Formation 

#define f442_GOALIE                     1
#define f442_SWEEPER                   (f442_GOALIE         +1)
#define f442_RIGHT_DEFENSE             (f442_SWEEPER        +1)
#define f442_CENTER_DEFENSE            (f442_RIGHT_DEFENSE  +1)
#define f442_LEFT_DEFENSE              (f442_CENTER_DEFENSE +1)
#define f442_RIGHT_MIDFIELD            (f442_LEFT_DEFENSE   +1)
#define f442_DEFENSIVE_CENTER_MIDFIELD (f442_RIGHT_MIDFIELD +1) 
#define f442_OFFENSIVE_CENTER_MIDFIELD (f442_DEFENSIVE_CENTER_MIDFIELD +1) 
#define f442_LEFT_MIDFIELD             (f442_OFFENSIVE_CENTER_MIDFIELD+1) 
#define f442_RIGHT_WING                (f442_LEFT_MIDFIELD  +1) 
#define f442_LEFT_WING                 (f442_RIGHT_WING +1) 



//					FORMATION DEFINITIONS 



//					4-3-3 Formation 


#define f433_GOALIE_BUF      2
#define f433_POSITION_BUF    3

#define f433_GOALTENDERX  (-52)
#define f433_SWEEPERX     (-43)
#define f433_DEFENDERX    (-35)
#define f433_MIDFIELDERX     0
#define f433_FORWARDX       30
#define f433_RIGHTY         25
#define f433_CENTERY         0
#define f433_LEFTY       (-25)

#define f433_HOMEXRANGE f433_FORWARDX
#define f433_HOMEYRANGE f433_RIGHTY
#define f433_MAXXRANGE  (f433_FORWARDX*2)
#define f433_MAXYRANGE  ((((m_pfield->GetFieldWidth()/2.0)+5) - f433_RIGHTY)*2)

#define	 FP_initial_player_1_pos 1;
#define  FP_initial_player_2_pos 2;
#define  FP_initial_player_3_pos 3;
#define	 FP_initial_player_4_pos 4;
#define  FP_initial_player_5_pos 5;
#define  FP_initial_player_6_pos 6;
#define  FP_initial_player_7_pos 7;
#define  FP_initial_player_8_pos 8;
#define  FP_initial_player_9_pos 9;
#define  FP_initial_player_10_pos 10;
#define  FP_initial_player_11_pos 11;
#define	 Unum_Unknown  0

#endif  // FORMATIONTYPES_H
