// FormationSkills.h: interface for the CFormationSkills class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_FORMATIONSKILLS_H__B3C11617_6F95_48CB_96CC_269128AA3844__INCLUDED_)
#define AFX_FORMATIONSKILLS_H__B3C11617_6F95_48CB_96CC_269128AA3844__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "WorldGeometry.h"
#include "Formationtypes.h"

class CLocalAgent;

class CFormationSkills
{
	//CFormationData	*m_FormationData;
public:

//  skills
//	void Name(CLocalAgent *pa, params);

    Ftype		GetActualFormation(CLocalAgent *pa); // vrat aktualnu formaciu

    C2DVector   GetMyHomePosition(CLocalAgent *pa); // vrat moju poziciu
	void	    SetMyHomePosition(CLocalAgent *pa, C2DVector p, float buf, Ptype t, Pside s); // nastav moju poziciu
    double      GetMyHomeXPosition(CLocalAgent *pa); // vrat moju  x-ovu suradnicu
	double      GetMyHomeYPosition(CLocalAgent *pa); // vrat moju  x-ovu suradnicu
	double	    GetMyHomeBuffer(CLocalAgent *pa);
	RRectangle *GetMyHomeRange(CLocalAgent *pa);
	void		SetMyHomeRange(CLocalAgent *pa, C2DVector c, C2DVector s);
	RRectangle *GetMyMaxRange(CLocalAgent *pa);
	void		SetMyMaxRange(CLocalAgent *pa, C2DVector c, C2DVector s);

	Ptype       GetActualPlayerType(CLocalAgent *pa);  // rola/uloha (typ) hraca
	Pside	    GetActualPlayerSide(CLocalAgent *pa);  // strana hraca na ktorej hra (prava/lava) 
													   // nie polovica ihriska, na ktorej sa hra

	void		SetFormation(CLocalAgent *pa, Ftype f); // nastav aktualnu formaciu

	Pnum		LocationToPosition(CLocalAgent *pa, C2DVector p); // vrat hraca najblizie na danej pozicii
	double		DistanceToPositionHome(CLocalAgent *pa, Pnum position, C2DVector p);
	
	// jednotky - units
	bool		AmIUnitCaptain(CLocalAgent *pa, int unit, Pnum position); // som kapitanom jednotky
	bool		AmIUnitMember(CLocalAgent *pa, int unit, Pnum position);  // som clenom jednotky
	int			GetNumOfUnits(CLocalAgent *pa);	 // pocet jednotiek v ramci formacie
	Utype		GetUnitType(CLocalAgent *pa, int unit); // typ jednotky 
	Utype		GetMyUnitType(CLocalAgent *pa, Pnum p); // typ jednotky v ktorej hram
	int			GetMyUnitSize(CLocalAgent *pa, int unit); // velkost (pocet hracov) mojej jednotky
	Pnum		GetUnitCaptain(CLocalAgent *pa, int unit); // vrat kapitana jednotky
	Pnum		*GetUnitMembers(CLocalAgent *pa, int unit); // vrat clenov jednotky
	Pnum		MoreImportantPositionWithinUnit(CLocalAgent *pa, int unit, Pnum p1, Pnum p2); // vrat hraca, ktory je dolezitejsi 
};

#endif // !defined(AFX_FORMATIONSKILLS_H__B3C11617_6F95_48CB_96CC_269128AA3844__INCLUDED_)
