// FormationSkills.cpp: implementation of the CFormationSkills class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Player.h"

#include "Formations.h"
#include "Formationtypes.h"
#include "FormationData.h"
#include "FormationSkills.h"
#include "WorldObjects.h"


void CFormationSkills::SetFormation(CLocalAgent *pa, Ftype f)
{
  pa->fdata->SetFormation(f);
}

Ftype CFormationSkills::GetActualFormation(CLocalAgent *pa)
{
   return pa->fdata->GetCurrentFormation()->GetType();
}

C2DVector CFormationSkills::GetMyHomePosition(CLocalAgent *pa)
{
    return pa->fdata->GetCurrentFormation()->GetPosition(pa->GetPlayerNumber())->GetHome();
}

void CFormationSkills::SetMyHomePosition(CLocalAgent *pa, C2DVector p, float buf, Ptype t, Pside s)
{
   pa->fdata->GetCurrentFormation()->GetPosition(pa->GetPlayerNumber())->SetHome(p, buf, t, s);
}

double CFormationSkills::GetMyHomeXPosition(CLocalAgent *pa)
{
    return pa->fdata->GetCurrentFormation()->GetPosition(pa->GetPlayerNumber())->GetHomeX();
}

double CFormationSkills::GetMyHomeYPosition(CLocalAgent *pa)
{
    return pa->fdata->GetCurrentFormation()->GetPosition(pa->GetPlayerNumber())->GetHomeY();
}

double CFormationSkills::GetMyHomeBuffer(CLocalAgent *pa)
{
    return pa->fdata->GetCurrentFormation()->GetPosition(pa->GetPlayerNumber())->GetHomeBuffer();
}

RRectangle *CFormationSkills::GetMyHomeRange(CLocalAgent *pa)
{
    return pa->fdata->GetCurrentFormation()->GetPosition(pa->GetPlayerNumber())->GetHomeRange();
}

void CFormationSkills::SetMyHomeRange(CLocalAgent *pa, C2DVector c, C2DVector s)
{
	pa->fdata->GetCurrentFormation()->GetPosition(pa->GetPlayerNumber())->SetHomeRange(c,s);
}

RRectangle *CFormationSkills::GetMyMaxRange(CLocalAgent *pa)
{
    return pa->fdata->GetCurrentFormation()->GetPosition(pa->GetPlayerNumber())->GetMaxRange();
}

void CFormationSkills::SetMyMaxRange(CLocalAgent *pa, C2DVector c, C2DVector s)
{
	pa->fdata->GetCurrentFormation()->GetPosition(pa->GetPlayerNumber())->SetMaxRange(c,s);
}

Ptype CFormationSkills::GetActualPlayerType(CLocalAgent *pa)
{
	return pa->fdata->GetCurrentFormation()->GetPosition(pa->GetPlayerNumber())->GetType();
}

Pside CFormationSkills::GetActualPlayerSide(CLocalAgent *pa)
{
	return pa->fdata->GetCurrentFormation()->GetPosition(pa->GetPlayerNumber())->GetSide();
}

// skillsy pre pracu s jednotkami
bool CFormationSkills::AmIUnitCaptain(CLocalAgent *pa, int unit, Pnum position)
{
   return pa->fdata->GetCurrentFormation()->IsUnitCaptain(unit, position);
}

bool CFormationSkills::AmIUnitMember(CLocalAgent *pa, int unit, Pnum position)
{
   return pa->fdata->GetCurrentFormation()->IsUnitMember(unit, position);
}

int CFormationSkills::GetNumOfUnits(CLocalAgent *pa)
{
   return pa->fdata->GetCurrentFormation()->GetNumUnits();
}

Utype CFormationSkills::GetUnitType(CLocalAgent *pa, int unit)
{ 
   return (pa->fdata->GetCurrentFormation()->GetUnit(unit))->GetType();
}

int CFormationSkills::GetMyUnitSize(CLocalAgent *pa, int unit)
{ 
   return (pa->fdata->GetCurrentFormation()->GetUnit(unit))->GetSize();
}

Pnum CFormationSkills::GetUnitCaptain(CLocalAgent *pa, int unit)
{
   return (pa->fdata->GetCurrentFormation()->GetUnit(unit))->GetCaptain();
}

Pnum *CFormationSkills::GetUnitMembers(CLocalAgent *pa, int unit)
{
   return (pa->fdata->GetCurrentFormation()->GetUnit(unit))->GetMembers();
}

Pnum CFormationSkills::MoreImportantPositionWithinUnit(CLocalAgent *pa, int unit, Pnum p1, Pnum p2)
{
   return (pa->fdata->GetCurrentFormation()->GetUnit(unit))->ImportantPosition(p1, p2);
}

Pnum CFormationSkills::LocationToPosition(CLocalAgent *pa, C2DVector p)
{
  return pa->fdata->GetCurrentFormation()->LocationToPosition(p);
}

Utype CFormationSkills::GetMyUnitType(CLocalAgent *pa, Pnum p)
{

   for (int i=0; i < pa->fdata->GetCurrentFormation()->GetNumUnits(); i++)
   {
	   if (pa->fdata->GetCurrentFormation()->IsUnitMember(i, p))
		 return (pa->fdata->GetCurrentFormation()->GetUnit(i))->GetType();
   }
 return UT_None;
}

