#ifndef FORMATIONS_H
#define FORMATIONS_H

#include "worldgeometry.h"
#include "formationtypes.h"

//////////////////////////////////////////////////////////////////////////////////
//                        TeamPosition Class                                    
//////////////////////////////////////////////////////////////////////////////////

class CTeamPosition {

public:

  CTeamPosition();

  void SetHome(C2DVector p, float buf, Ptype t, Pside s);
  void SetHomeRange(C2DVector c, C2DVector s);
  void SetMaxRange (C2DVector c, C2DVector s);

  inline double GetHomeX()      { return m_Home.m_x;     }   
  inline double GetHomeY()      { return m_Home.m_y;     }	 
  inline C2DVector GetHome()       { return m_Home;       }   
  inline double GetHomeBuffer() { return m_dHomeBuffer; }	 

  inline RRectangle *GetHomeRange() { return &m_HomeRange; }  // vrat rozsah
  inline RRectangle *GetMaxRange()  { return &m_MaxRange;  }  // vrat max rozsah

  inline Ptype GetType() { return m_type; } // vrat typ hraca
  inline Pside GetSide() { return m_side; } // vrat stranu hraca

private:

  C2DVector m_Home;	// suradnice kde by sa mal hrac nachadzat
  double m_dHomeBuffer; // vzdialenost od Home

  RRectangle m_HomeRange; // rozsah v ktorom sa hrac moze nachadzat v ramci formacie
  RRectangle m_MaxRange; // maximalny rozsah - || -

  Ptype m_type;		// typ hraca, brankar, obranca, utocnik
  Pside m_side;		// strana hraca, lava, prava, stred 
};

//////////////////////////////////////////////////////////////////////////////////
//                             Unit Class                                    
//////////////////////////////////////////////////////////////////////////////////
class CUnit {
public:
  CUnit();
  ~CUnit();

  void InitializeUnit(Utype tp, int sz, int *mems, int capt);

  inline Utype GetType()		{ return m_type;    }
  inline int      GetSize()     { return m_size;    }
  inline Pnum     GetCaptain()  { return captain; }
  inline Pnum     *GetMembers() { return members; }
  
  bool IsMember(Pnum position);
  bool IsCaptain(Pnum position);

  Pnum ImportantPosition(Pnum p1, Pnum p2);

private:
  Utype		m_type;		// typ jednotky utocna, obranna
  int		m_size;		// pocet clenov
  Pnum		*members;	// smernik na hracov v ramci jednotky
  Pnum		captain;	// kapitan jednotky
};


//////////////////////////////////////////////////////////////////////////////////
//                             Formation Class                                    
//////////////////////////////////////////////////////////////////////////////////
class CFormation {
public:

  CFormation(Ftype type, int size);
  ~CFormation();

  void AllocateUnits(int num);

  inline Ftype GetType() { return type; }
  inline int   GetSize() { return size; }

  void SetPosition(Pnum num, C2DVector home, float buffer,
		   C2DVector home_center, C2DVector home_size,
		   C2DVector max_center,  C2DVector max_size,
		   Ptype t, Pside s);

  CTeamPosition *GetPosition(Pnum num);

  int Build_433_ReceiverList(int *PreferenceList, int position, Fside LocationSide);
/*
  int Build_442_ReceiverList(int *PreferenceList, int position, Fside LocationSide);
  int Build_352_ReceiverList(int *PreferenceList, int position, Fside LocationSide);
  int Build_72_ReceiverList(int *PreferenceList, int position, Fside LocationSide);
  int Build_334_ReceiverList(int *PreferenceList, int position, Fside LocationSide);
  int Build_244_ReceiverList(int *PreferenceList, int position, Fside LocationSide);
  int Build_532_ReceiverList(int *PreferenceList, int position, Fside LocationSide);
  int Build_right_ReceiverList(int *PreferenceList, int position, Fside LocationSide);
  int Build_left_ReceiverList(int *PreferenceList, int position, Fside LocationSide);
*/
  void   SetCandidateReceivers(Pnum position, int num, Pnum *PrefList);
  int   *GetCandidateReceivers(Pnum position, Fside LocationSide);

  CUnit *GetUnit(int unit);
  inline int GetNumUnits() {return NumUnits;}
  bool IsUnitMember(int unit, Pnum position);
  bool IsUnitCaptain(int unit, Pnum position);

  bool IsMoreImportantPosition(Pnum pos1, Pnum pos2);

  Pnum   LocationToPosition(C2DVector p);
  double DistanceToPositionHome(Pnum position, C2DVector p);
  Pnum   ClosestPosition(C2DVector p);

private:
  Ftype type;
  int  size;

  CTeamPosition PositionList[MAX_PLAYERS]; 
                                          
  Pnum *ReceiverList[MAX_PLAYERS]; 
                                   
  Pnum *TempReceiverList;          

  int  NumUnits;
  CUnit *FormationUnits;
};

#endif