
#include "stdAfx.h"
#include "Formationtypes.h"
#include "Formations.h"

//						4-3-3 Formation 

#define f433_GOALIE           1
#define f433_SWEEPER         (f433_GOALIE         +1)
#define f433_RIGHT_DEFENSE   (f433_SWEEPER        +1)
#define f433_CENTER_DEFENSE  (f433_RIGHT_DEFENSE  +1)
#define f433_LEFT_DEFENSE    (f433_CENTER_DEFENSE +1)
#define f433_RIGHT_MIDFIELD  (f433_LEFT_DEFENSE   +1)
#define f433_CENTER_MIDFIELD (f433_RIGHT_MIDFIELD +1) 
#define f433_LEFT_MIDFIELD   (f433_CENTER_MIDFIELD+1) 
#define f433_RIGHT_WING      (f433_LEFT_MIDFIELD  +1) 
#define f433_CENTER_FORWARD  (f433_RIGHT_WING     +1) 
#define f433_LEFT_WING       (f433_CENTER_FORWARD +1) 

/*
#define f433_GOALIE_BUF      2
#define f433_POSITION_BUF    3

#define f433_GOALTENDERX  (-52)
#define f433_SWEEPERX     (-43)
#define f433_DEFENDERX    (-35)
#define f433_MIDFIELDERX     0
#define f433_FORWARDX       30
#define f433_RIGHTY         25
#define f433_CENTERY         0
#define f433_LEFTY       (-25)

#define f433_HOMEXRANGE f433_FORWARDX
#define f433_HOMEYRANGE f433_RIGHTY
#define f433_MAXXRANGE  (f433_FORWARDX*2)
#define f433_MAXYRANGE  ((((SP_pitch_width/2.0)+5) - f433_RIGHTY)*2)
*/

//////////////////////////////////////////////////////////////////////////////////
//						Team Position
//////////////////////////////////////////////////////////////////////////////////

CTeamPosition::CTeamPosition()
{
  m_dHomeBuffer = 0;
  m_type = PT_None;
  m_side = PS_None;
}


void CTeamPosition::SetHome(C2DVector p, float buf, Ptype t, Pside s)
{
  m_Home = p;
  m_dHomeBuffer = buf;

  m_type = t; 
  m_side = s;
}


void CTeamPosition::SetHomeRange(C2DVector center, C2DVector size)
{
  m_HomeRange = RRectangle(center,size);
}


void CTeamPosition::SetMaxRange (C2DVector center, C2DVector size)
{
  m_MaxRange = RRectangle(center,size);
}

//////////////////////////////////////////////////////////////////////////////////
//                        Unit Class                                            
//////////////////////////////////////////////////////////////////////////////////

CUnit::CUnit()
{
  m_type = UT_None;
  m_size = captain = 0;
  members = NULL;
}


CUnit::~CUnit()
{
  if ( members != NULL )
    delete [] members;
}


void CUnit::InitializeUnit(Utype tp, int sz, Pnum *mems, Pnum capt)
{
  m_type = tp;
  m_size = sz;
  captain = mems[capt];
  members = new Pnum[m_size];

  for (int i=0; i<m_size; i++)
    members[i] = mems[i];
}


bool CUnit::IsMember(Pnum position)
{
  for (int i=0; i<m_size; i++){
    if ( members[i] == position )
      return TRUE;
  }
  return FALSE;
}


bool CUnit::IsCaptain(Pnum position)
{
  if ( members[0] == position )
      return TRUE;
  return FALSE;
}


Pnum CUnit::ImportantPosition(Pnum p1, Pnum p2)
{
  int index1, index2;

  for (int i=0; i<m_size; i++){
    if ( members[i] == p1 )
      index1 = i;
    if ( members[i] == p2 )
      index2 = i;
  }

  if ( index1 < index2 )
    return p1;
  else if ( index2 < index1 )
    return p2;
  else
    return 0;
}

//////////////////////////////////////////////////////////////////////////////////
//							Formation Class
//////////////////////////////////////////////////////////////////////////////////

CFormation::CFormation(Ftype formation_number, int sz)
{
  type = formation_number;
  size = sz;
  FormationUnits = NULL;

  for (int i=1; i<=size; i++)            /* Positions start at 1            */
    ReceiverList[i] = new Pnum[size];
                                         /* receiver positions              */
  TempReceiverList = new Pnum[size];     /* Used to pass back possible receivers */
}


CFormation::~CFormation()
{
  if ( FormationUnits != NULL )
    delete [] FormationUnits;

  for (int i=1; i<=size; i++)
    delete [] ReceiverList[i];
  delete [] TempReceiverList;
}


void CFormation::AllocateUnits(int num)
{
  NumUnits = num;
  FormationUnits = new CUnit[NumUnits];
}


void CFormation::SetPosition(Pnum num, C2DVector home, float buffer,
			    C2DVector home_center, C2DVector home_size,
			    C2DVector max_center,  C2DVector max_size,
			    Ptype t, Pside s)
{
  /* Use this to put in the parameters for the positions in a given formation */
  PositionList[num].SetHome(home,buffer,t,s);
  PositionList[num].SetHomeRange(home_center,home_size);
  PositionList[num].SetMaxRange(max_center,max_size);
}


CTeamPosition *CFormation::GetPosition(Pnum num)
{
//  if (num > size || num < 1) 
    //my_error("position list index only goes from 1 to size %d (trying to get %d)",size,num);
  return &(PositionList[num]); 
}


void CFormation::SetCandidateReceivers(Pnum position, int num, Pnum *PrefList)
{
  int i;

  for (i=0; i<num; i++)
    ReceiverList[position][i] = PrefList[i];

  for (; i<size; i++)
    ReceiverList[position][i] = Pnum_Unknown;  /* End the list with sequence       */
}					       /* of unknowns----means no reciever */


Pnum *CFormation::GetCandidateReceivers(Pnum position, Fside LocationSide)
{
  /* Either call a function to build the list on the fly, 
     or return the precanned ReceiverList */

  switch(type){
  case FT_433: 
    Build_433_ReceiverList(TempReceiverList,position,LocationSide); 
    return TempReceiverList;
  case FT_442: 
  //  Build_442_ReceiverList(TempReceiverList,position,LocationSide); 
    return TempReceiverList;
  case FT_352: 
  //  Build_352_ReceiverList(TempReceiverList,position,LocationSide); 
    return TempReceiverList;
  case FT_72: 
  //  Build_72_ReceiverList(TempReceiverList,position,LocationSide); 
    return TempReceiverList;
  case FT_334: 
  //  Build_334_ReceiverList(TempReceiverList,position,LocationSide); 
    return TempReceiverList;
  case FT_244: 
  //  Build_244_ReceiverList(TempReceiverList,position,LocationSide); 
    return TempReceiverList;
  case FT_532: 
  //  Build_532_ReceiverList(TempReceiverList,position,LocationSide); 
    return TempReceiverList;
  default: 

    return  ReceiverList[position]; 
  }
}


CUnit *CFormation::GetUnit(int num)
{
  return &FormationUnits[num];
}


bool CFormation::IsUnitMember(int unit, Pnum position)
{
  return GetUnit(unit)->IsMember(position);
}


bool CFormation::IsUnitCaptain(int unit, Pnum position)
{
  return GetUnit(unit)->IsCaptain(position);
}


bool CFormation::IsMoreImportantPosition(Pnum pos1, Pnum pos2)
{
//  if ( pos1 == pos2 )
    //my_error("same positions more important???");

  for (int unit=0; unit<NumUnits; unit++){
    if ( IsUnitMember(unit,pos1) && IsUnitMember(unit,pos2) ){
      if ( GetUnit(unit)->ImportantPosition(pos1,pos2) == pos1 )
	return TRUE;
    }
  }
  return FALSE;
}


Pnum CFormation::LocationToPosition(C2DVector p)
{
  /* Finds the position whose home range (x,y) falls.  If more than one,
     takes the one closest to the home position.  If none, takes the one
     whose home range rectangle is closest */

  double tiebreakDist = -1000;  /* > 2 * (pitch_length + pitch_width) */
  Pnum position;
  RRectangle *HomeRange;
  
  for (int i=1; i<=GetSize(); i++){
    HomeRange = GetPosition(i)->GetHomeRange();
    if ( HomeRange->IsWithin(p) ){  /* Check if (x,y) is within the home range */
      double HomeDist = DistanceToPositionHome(i,p);
      if ( tiebreakDist < 0 || HomeDist < tiebreakDist ){
	position = i;
	tiebreakDist = HomeDist;
      }
    }    /* We're not in the range of this position. Now check if closest so far */
    else if ( tiebreakDist < 0 && HomeRange->DistanceToEdge(p) > tiebreakDist ){
      position = i;
      tiebreakDist = HomeRange->DistanceToEdge(p);    /* a negative number     */
    }
  }

  return position;
}


double CFormation::DistanceToPositionHome(Pnum position, C2DVector p)
{
  C2DVector Home = GetPosition(position)->GetHome();
  return (Home-p).GetDistance();
}


Pnum CFormation::ClosestPosition(C2DVector p)
{
  double dist, minDist = HUGE;
  Pnum closestPosition;
  for (int position=1; position<=size; position++){
    dist = DistanceToPositionHome(position,p);
    if (dist < minDist){
      minDist = dist;
      closestPosition = position;
    }
  }
  return closestPosition;
}


int CFormation::Build_433_ReceiverList(Pnum *PreferenceList, Pnum position, Fside LocationSide){

  int NumOptions=0;

  switch ( position ){
  case f433_CENTER_FORWARD: 
    NumOptions = 2;
    PreferenceList[0] = (LocationSide == FS_Right) ? f433_RIGHT_WING : f433_LEFT_WING;
    PreferenceList[1] = (LocationSide == FS_Right) ? f433_LEFT_WING : f433_RIGHT_WING;
  case f433_LEFT_WING:
    NumOptions = 2;
    PreferenceList[0] = f433_CENTER_FORWARD;
    PreferenceList[1] = f433_RIGHT_WING;
  case f433_RIGHT_WING:
    NumOptions = 2;
    PreferenceList[0] = f433_CENTER_FORWARD;
    PreferenceList[1] = f433_LEFT_WING;
    break;
  case f433_CENTER_MIDFIELD:
    NumOptions = 5;
    PreferenceList[0] = (LocationSide == FS_Right) ? f433_RIGHT_WING : f433_LEFT_WING;
    PreferenceList[1] = (LocationSide == FS_Right) ? f433_LEFT_WING : f433_RIGHT_WING;
    PreferenceList[2] = f433_CENTER_FORWARD;
    PreferenceList[3] = (LocationSide == FS_Right) ? f433_RIGHT_MIDFIELD :f433_LEFT_MIDFIELD;
    PreferenceList[4] = (LocationSide == FS_Right) ? f433_LEFT_MIDFIELD :f433_RIGHT_MIDFIELD;
    break;
  case f433_RIGHT_MIDFIELD:
  case f433_LEFT_MIDFIELD:
    NumOptions = 4;
    PreferenceList[0] = f433_CENTER_FORWARD;
    PreferenceList[1] = f433_CENTER_MIDFIELD;
    PreferenceList[2] = (LocationSide == FS_Right) ? f433_RIGHT_WING : f433_LEFT_WING;
    PreferenceList[3] = (LocationSide == FS_Right) ? f433_LEFT_WING : f433_RIGHT_WING;
    break;
  case f433_CENTER_DEFENSE:    
    NumOptions = 3;
    PreferenceList[0] = (LocationSide == FS_Right) ? f433_RIGHT_MIDFIELD : f433_LEFT_MIDFIELD;
    PreferenceList[1] = (LocationSide == FS_Right) ? f433_LEFT_MIDFIELD : f433_RIGHT_MIDFIELD;
    PreferenceList[2] = f433_CENTER_MIDFIELD;
    break;
  case f433_RIGHT_DEFENSE:
  case f433_LEFT_DEFENSE:
    NumOptions = 3;
    PreferenceList[0] = (LocationSide == FS_Right) ? f433_RIGHT_MIDFIELD : f433_LEFT_MIDFIELD;
    PreferenceList[1] = (LocationSide == FS_Right) ? f433_RIGHT_WING : f433_LEFT_WING;
    PreferenceList[2] = f433_CENTER_MIDFIELD;
    break;
  case f433_SWEEPER:
  case f433_GOALIE:
    NumOptions = 7;
    PreferenceList[0] = (LocationSide == FS_Right) ? f433_RIGHT_DEFENSE : f433_LEFT_DEFENSE;
    PreferenceList[1] = (LocationSide == FS_Right) ? f433_LEFT_DEFENSE : f433_RIGHT_DEFENSE;
    PreferenceList[2] = (LocationSide == FS_Right) ? f433_RIGHT_MIDFIELD : f433_LEFT_MIDFIELD;
    PreferenceList[3] = (LocationSide == FS_Right) ? f433_LEFT_MIDFIELD : f433_RIGHT_MIDFIELD;
    PreferenceList[4] = f433_CENTER_MIDFIELD;
    PreferenceList[5] = (LocationSide == FS_Right) ? f433_RIGHT_WING : f433_LEFT_WING;
    PreferenceList[6] = (LocationSide == FS_Right) ? f433_LEFT_WING : f433_RIGHT_WING;
    break;
  }	

  for (int i = NumOptions; i<size; i++)
    PreferenceList[i] = Pnum_Unknown;  /* Pad list with own number, meaning no receiver */

  return NumOptions;
}

