// FormationData.h: interface for the CFormationData class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_FORMATIONDATA_H__769AF4A9_1524_440A_B2E1_C415BA1DD1DE__INCLUDED_)
#define AFX_FORMATIONDATA_H__769AF4A9_1524_440A_B2E1_C415BA1DD1DE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "FormationTypes.h"

class CStaticField;

class CFormationData  
{
public:
	
	CFormationData(CStaticField *field);
	virtual ~CFormationData();

	void Initialize_433_Formation();
	void SetFormation(Ftype formation_number);
	CFormation *GetCurrentFormation();

private:
  
  //C2DVector CurrentHome;  /* This could be different from Home in my position */
	CStaticField	*m_pfield;

	CFormation *m_pCurrentFormation;	// aktualna formacia
	CFormation *m_pFormation_433;
	CFormation *m_pFormation_442;
	CFormation *m_pFormation_352;
	CFormation *m_pFormation_72;
	CFormation *m_pFormation_334;
	CFormation *m_pFormation_244;
	CFormation *m_pFormation_532;
	CFormation *m_pFormation_right;
	CFormation *m_pFormation_left;

    Ftype m_InitialFormation;
	Ftype m_FormationWhenWinning;
	Ftype m_FormationWhenLosing;
	Ftype m_FormationWhenLosingByLots;
	Ftype m_FormationWhenTied;

	Unum *PositionPlayers;  /* Maps positions to their players  */
	Pnum *PlayerPositions;  /* Maps players to their positions  */

	Unum *PositionMarks;    /* Maps positions to the opponents they mark */

};

#endif // !defined(AFX_FORMATIONDATA_H__769AF4A9_1524_440A_B2E1_C415BA1DD1DE__INCLUDED_)
