// FormationData.cpp: implementation of the CFormationData class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Player.h"
#include "types.h"

#include "Formations.h"
#include "FormationData.h"

#include "staticfield.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CFormationData::CFormationData(CStaticField *field)
{
	m_pCurrentFormation = Formation_Unknown;
	m_pfield = field;

	m_pFormation_433 = new CFormation(FT_433,11);
	Initialize_433_Formation();

	/*
	m_pFormation_442 = new CFormation(FT_442,11);
	Initialize_442_Formation();

	.
	.
	.
	vsetky ostatne formacie
	*/


	PositionPlayers = new Unum[SP_team_size+1];     /* Start map at 1 */
	PlayerPositions = new Pnum[SP_team_size+1];     /* Start map at 1 */

	PositionMarks = new Unum[SP_team_size+1];


	for(int i=1; i<=SP_team_size; i++)
	{
    PositionPlayers[i] = Unum_Unknown;
    PlayerPositions[i] = Pnum_Unknown;
    
    PositionMarks[i] = Unum_Unknown;
	}


	for(i=1; i<=SP_team_size; i++)
	{
		PlayerPositions[i] = i; 
		PositionPlayers[i] = i;
	}	
			

	m_InitialFormation = FT_433;
	/*
	.
	.
	.
	m_FormationWhenLosing = m_InitialFormation;
	.
	.
	.
	*/
	SetFormation(m_InitialFormation);

}


CFormationData::~CFormationData()
{
    if (m_pFormation_433 != NULL)
        delete m_pFormation_433;

    delete[] PositionPlayers;
	delete[] PlayerPositions;
    delete[] PositionMarks;
}

void CFormationData::Initialize_433_Formation()
{

  /* set position within goal stay, in penalty box      */
  m_pFormation_433->SetPosition(f433_GOALIE, C2DVector(f433_GOALTENDERX,f433_CENTERY), f433_GOALIE_BUF, 
			     C2DVector(f433_GOALTENDERX,f433_CENTERY),
			     C2DVector(((m_pfield->GetFieldLength()/2.0)- (-f433_GOALTENDERX))*2,m_pfield->GetGoalSize()),   //SP_pitch_length
			     C2DVector(f433_GOALTENDERX,f433_CENTERY),
			     C2DVector(((m_pfield->GetFieldLength()/2.0)- (-f433_GOALTENDERX))*2,m_pfield->GetGoalSize()),   ///SP_goal_width
			     PT_Goaltender,PS_Center);

  /* set position inside penalty box, don't go more than half-way to mid  */
  m_pFormation_433->SetPosition(f433_SWEEPER, C2DVector(f433_SWEEPERX,f433_CENTERY), f433_POSITION_BUF, 
			     C2DVector(f433_SWEEPERX,f433_CENTERY),
			     C2DVector(((m_pfield->GetFieldLength()/2.0)- (-f433_SWEEPERX))*2,(m_pfield->GetPenaltyAreaWidth()/2.0)*2),
			     C2DVector(f433_SWEEPERX,f433_CENTERY),
			     C2DVector(-f433_SWEEPERX - (m_pfield->GetFieldLength()/2.0)/2,((m_pfield->GetFieldWidth()/2.0)+5)*2),
			     PT_Sweeper,PS_Center);

  m_pFormation_433->SetPosition(f433_RIGHT_DEFENSE, C2DVector(f433_DEFENDERX,f433_RIGHTY), f433_POSITION_BUF, 
			     C2DVector(f433_DEFENDERX,f433_RIGHTY),
			     C2DVector(f433_HOMEXRANGE,f433_HOMEYRANGE),
			     C2DVector(f433_DEFENDERX,f433_RIGHTY),
			     C2DVector(f433_MAXXRANGE ,f433_MAXYRANGE),
			     PT_Defender, PS_Right);

  m_pFormation_433->SetPosition(f433_CENTER_DEFENSE, C2DVector(f433_DEFENDERX+5,f433_CENTERY), f433_POSITION_BUF, 
			     C2DVector(f433_DEFENDERX+5,f433_CENTERY),
			     C2DVector(f433_HOMEXRANGE,f433_HOMEYRANGE),
			     C2DVector(f433_DEFENDERX+5,f433_CENTERY),
			     C2DVector(f433_MAXXRANGE ,f433_MAXYRANGE),
			     PT_Defender, PS_Center);

  m_pFormation_433->SetPosition(f433_LEFT_DEFENSE, C2DVector(f433_DEFENDERX,f433_LEFTY), f433_POSITION_BUF, 
			     C2DVector(f433_DEFENDERX,f433_LEFTY),
			     C2DVector(f433_HOMEXRANGE,f433_HOMEYRANGE),
			     C2DVector(f433_DEFENDERX,f433_LEFTY),
			     C2DVector(f433_MAXXRANGE ,f433_MAXYRANGE),
			     PT_Defender, PS_Left);

  m_pFormation_433->SetPosition(f433_RIGHT_MIDFIELD, C2DVector(f433_MIDFIELDERX,f433_RIGHTY), f433_POSITION_BUF, 
			     C2DVector(f433_MIDFIELDERX,f433_RIGHTY),
			     C2DVector(f433_HOMEXRANGE,f433_HOMEYRANGE),
			     C2DVector(f433_MIDFIELDERX,f433_RIGHTY),
			     C2DVector(f433_MAXXRANGE ,f433_MAXYRANGE),
			     PT_Midfielder, PS_Right);

  m_pFormation_433->SetPosition(f433_CENTER_MIDFIELD, C2DVector(f433_MIDFIELDERX,f433_CENTERY), f433_POSITION_BUF, 
			     C2DVector(f433_MIDFIELDERX,f433_CENTERY),
			     C2DVector(f433_HOMEXRANGE,f433_HOMEYRANGE),
			     C2DVector(f433_MIDFIELDERX,f433_CENTERY),
			     C2DVector(f433_MAXXRANGE ,f433_MAXYRANGE),
			     PT_Midfielder, PS_Center);

  m_pFormation_433->SetPosition(f433_LEFT_MIDFIELD, C2DVector(f433_MIDFIELDERX,f433_LEFTY), f433_POSITION_BUF, 
			     C2DVector(f433_MIDFIELDERX,f433_LEFTY),
			     C2DVector(f433_HOMEXRANGE,f433_HOMEYRANGE),
			     C2DVector(f433_MIDFIELDERX,f433_LEFTY),
			     C2DVector(f433_MAXXRANGE ,f433_MAXYRANGE),
			     PT_Midfielder, PS_Left);
  
  m_pFormation_433->SetPosition(f433_RIGHT_WING, C2DVector(f433_FORWARDX,f433_RIGHTY), f433_POSITION_BUF, 
			     C2DVector(f433_FORWARDX,f433_RIGHTY),
			     C2DVector(f433_HOMEXRANGE,f433_HOMEYRANGE),
			     C2DVector(f433_FORWARDX,f433_RIGHTY),
			     C2DVector(f433_MAXXRANGE ,f433_MAXYRANGE),
			     PT_Forward, PS_Right);

  m_pFormation_433->SetPosition(f433_CENTER_FORWARD, C2DVector(f433_FORWARDX+5,f433_CENTERY), f433_POSITION_BUF, 
			     C2DVector(f433_FORWARDX+5,f433_CENTERY),
			     C2DVector(f433_HOMEXRANGE,f433_HOMEYRANGE),
			     C2DVector(f433_FORWARDX+5,f433_CENTERY),
			     C2DVector(f433_MAXXRANGE ,f433_MAXYRANGE),
			     PT_Forward, PS_Center);

  m_pFormation_433->SetPosition(f433_LEFT_WING, C2DVector(f433_FORWARDX,f433_LEFTY), f433_POSITION_BUF, 
			     C2DVector(f433_FORWARDX,f433_LEFTY),
			     C2DVector(f433_HOMEXRANGE,f433_HOMEYRANGE),
			     C2DVector(f433_FORWARDX,f433_LEFTY),
			     C2DVector(f433_MAXXRANGE ,f433_MAXYRANGE),
			     PT_Forward, PS_Left);

  /* Candidate receivers will be chosen on the fly here */
  Pnum dummylist[1];
  for (int i=1; i<=m_pFormation_433->GetSize(); i++)
    m_pFormation_433->SetCandidateReceivers(i,0,dummylist);

  m_pFormation_433->AllocateUnits(6);

  /* Positions listed in order of importance, captain indicated as index into list */

  Pnum defenders[5] = {f433_GOALIE, f433_SWEEPER,
		      f433_CENTER_DEFENSE, f433_RIGHT_DEFENSE, f433_LEFT_DEFENSE};
  m_pFormation_433->GetUnit(UT_Defense)->InitializeUnit(UT_Defense, 5, defenders, 0);

  Pnum midfielders[3] = {f433_CENTER_MIDFIELD, f433_RIGHT_MIDFIELD, f433_LEFT_MIDFIELD};
  m_pFormation_433->GetUnit(UT_Midfield)->InitializeUnit(UT_Midfield, 3, midfielders, 0);

  Pnum forwards[3] = {f433_CENTER_FORWARD, f433_RIGHT_WING, f433_LEFT_WING};
  m_pFormation_433->GetUnit(UT_Forward)->InitializeUnit(UT_Forward, 3, forwards, 0);

  Pnum rights[3] = {f433_RIGHT_DEFENSE, f433_RIGHT_MIDFIELD, f433_RIGHT_WING};
  m_pFormation_433->GetUnit(UT_Right)->InitializeUnit(UT_Right, 3, rights, 1);

  Pnum centers[5] = {f433_GOALIE, f433_SWEEPER, f433_CENTER_DEFENSE, 
		    f433_CENTER_MIDFIELD, f433_CENTER_FORWARD};
  m_pFormation_433->GetUnit(UT_Center)->InitializeUnit(UT_Center, 5, centers, 3);

  Pnum lefts[3] = {f433_LEFT_DEFENSE, f433_LEFT_MIDFIELD, f433_LEFT_WING};
  m_pFormation_433->GetUnit(UT_Left)->InitializeUnit(UT_Left, 3, lefts, 1);

}

void CFormationData::SetFormation(Ftype formation_number)
{
  Ftype old_form = FT_None;
  
  if ( GetCurrentFormation() != Formation_Unknown )
    old_form = GetCurrentFormation()->GetType();

  switch(formation_number)
  {
  case FT_433: m_pCurrentFormation = m_pFormation_433; break;
  case FT_442: m_pCurrentFormation = m_pFormation_442; break;
  case FT_352: m_pCurrentFormation = m_pFormation_352; break;
  case FT_72:  m_pCurrentFormation = m_pFormation_72;  break;
  case FT_334: m_pCurrentFormation = m_pFormation_334; break;
  case FT_244: m_pCurrentFormation = m_pFormation_244; break;
  case FT_532: m_pCurrentFormation = m_pFormation_532; break;
  case FT_right: m_pCurrentFormation = m_pFormation_right; break;
  case FT_left: m_pCurrentFormation = m_pFormation_left; break;
  }

  //ResetCurrentHome();
/*
  if ( old_form != FT_None && formation_number != old_form )
    Say(PMsg_none); // Announce the new formation 
*/
}

CFormation *CFormationData::GetCurrentFormation()
{
	return m_pCurrentFormation;
}