// Config.h: interface for the CConfig class.
//
//////////////////////////////////////////////////////////////////////

#pragma warning (disable : 4786 4503)

#include <string.h>
#include <string>
#include <map>
#include <vector>
#include <algorithm>
#include <iterator>

using namespace std;

#if !defined(AFX_CONFIG_H__E8428DEC_1F9D_11D5_8E53_EC5F97A30E24__INCLUDED_)
#define AFX_CONFIG_H__E8428DEC_1F9D_11D5_8E53_EC5F97A30E24__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

typedef map<string, string> STRINGMAP;

class CConfig
{
private:
    STRINGMAP m_mapConfig;
public:
    CConfig();
    CConfig(char *szFilename, char cSeparator = ':');
    virtual ~CConfig();
    void Load(char *szFilename, char cSeparator = ':');
    void Clear();
    string Gets(string sID);
    char   Getc(string sID);
    double Getd(string sID);
    int    Geti(string sID);
    bool   Getb(string sID);
    string Gets(string sID, int i);
    double Getd(string sID, int i);
    int    Geti(string sID, int i);
    bool   Getb(string sID, int i);

public:
    void   AssignValues();

    #define CFGD(a) double a
    #define CFGI(a) int a
    #define CFGB(a) bool a
    #define CFGS(a) string a
    #include "Config_var.h"
    #undef CFGD
    #undef CFGI
    #undef CFGB
    #undef CFGS

public:
    double kickable_area;

};

#endif // !defined(AFX_CONFIG_H__E8428DEC_1F9D_11D5_8E53_EC5F97A30E24__INCLUDED_)
