// Config.cpp: implementation of the CConfig class.
//
//////////////////////////////////////////////////////////////////////

#pragma warning (disable : 4786 4503)

#include "stdafx.h"
#include "Player.h"
#include "Config.h"

using namespace std;

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CConfig::CConfig()
{
}

CConfig::CConfig(char *szFilename, char cSeparator)
{
    Load(szFilename, cSeparator);
}

void CConfig::Load(char *szFilename, char cSeparator)
{
    string sKey,sValue;
    char *szBufferB, *szKeyBuffer, *szValueBuffer, *szEnd;
    FILE *fileConf;

    if ((fileConf=fopen(szFilename, "rt"))==NULL) return;
    if ((szBufferB=(char *)malloc(256*sizeof(char)))==NULL) return;
    if ((szKeyBuffer=(char *)malloc(256*sizeof(char)))==NULL) return;

    while(fgets(szBufferB,256,fileConf) != NULL)
    {
        if (szBufferB[0]=='#' || szBufferB[0]=='\n') continue;

        szValueBuffer = strchr(szBufferB, cSeparator);
        if (szValueBuffer) 
        {
            sscanf(szBufferB, "%s", szKeyBuffer);
            *szValueBuffer='\0';
            szValueBuffer++;
            while ((*szValueBuffer==' ')||(*szValueBuffer=='\t')) szValueBuffer++;
            szEnd = strchr(szValueBuffer, '\0');
            while ((*(szEnd-1)==' ')||(*(szEnd-1)=='\t')||(*(szEnd-1)=='\n')) szEnd--;
            *szEnd='\0';
            sKey = szKeyBuffer;
            sValue = szValueBuffer;
            m_mapConfig[sKey] = sValue;
        }
    }

    fclose(fileConf);
    free(szBufferB);
    free(szKeyBuffer);
}

void CConfig::Clear()
{
    m_mapConfig.clear();
}

CConfig::~CConfig()
{
    m_mapConfig.clear();
}

string CConfig::Gets(string sID)
{
    return m_mapConfig[sID];
}

char   CConfig::Getc(string sID)
{
    return Gets(sID)[0];
}

double CConfig::Getd(string sID)
{
    return atof(Gets(sID).c_str());
}

int    CConfig::Geti(string sID)
{
    return atoi(Gets(sID).c_str());
}

bool   CConfig::Getb(string sID)
{
    string sTemp = Gets(sID);
    if (sTemp.find("on") != sID.npos) return true;
    if (sTemp.find("off") != sID.npos) return true;
    if (sTemp.find("0") != sID.npos) return false;
    if (sTemp.find("y") != sID.npos) return true;
    if (sTemp.find("n") != sID.npos) return false;
    return false;
}


string CConfig::Gets(string sID, int i)
{
    char szSpace[] = " \t\n";
    int np1,np2=0,ni;
    string sTemp = Gets(sID);

    for(ni=0; ni < (i+1); ni++)
    {
        np1 = sTemp.find_first_not_of(szSpace, np2);
        if (np1 == sTemp.npos) return "";
        np2 = sTemp.find_first_of(szSpace, np1);
    }
    return sTemp.substr(np1, np2 - np1);
}

double CConfig::Getd(string sID, int i)
{
    return atof(Gets(sID, i).c_str());
}

int    CConfig::Geti(string sID, int i)
{
    return atoi(Gets(sID, i).c_str());
}

bool   CConfig::Getb(string sID, int i)
{
    string sTemp = Gets(sID, i);
    if (sTemp.find("on") != sID.npos) return true;
    if (sTemp.find("off") != sID.npos) return true;
    if (sTemp.find("0") != sID.npos) return false;
    if (sTemp.find("y") != sID.npos) return true;
    if (sTemp.find("n") != sID.npos) return false;
    return false;
}



void   CConfig::AssignValues()
{
    #define CFGD(a) a = Getd(#a)
    #define CFGI(a) a = Geti(#a)
    #define CFGB(a) a = Getb(#a)
    #define CFGS(a) a = Gets(#a)
    #include "Config_var.h"
    #undef CFGD
    #undef CFGI
    #undef CFGB
    #undef CFGS

    kickable_area = kickable_margin + ball_size + player_size;

}

