// ChildView.h : interface of the CChildView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_CHILDVIEW_H__EAFD186F_C0C6_11D4_BEC2_00C0CA122103__INCLUDED_)
#define AFX_CHILDVIEW_H__EAFD186F_C0C6_11D4_BEC2_00C0CA122103__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "VisStaticField.h"
#include "VisPerception.h"
#include "ToDoClasses.h"

/////////////////////////////////////////////////////////////////////////////
// CChildView window

class CAgent;
class CLocalAgent;

class CChildView : public CWnd
{
// Construction
public:
	CChildView();

// Attributes
private:

	// nastroje a objekty na vykreslovanie
	CDC*					m_pMyDevice;				// smernik na pamatove zariadenie
	CBitmap*				m_pMyBitmap;				// smernik na bitmapu v pamati, do ktorej sa zobrazuje

	CPen*					m_pFlagPen;					// pero ktorym sa vykresluje vlajka
	CBrush*					m_pFlagBrush;				// vypln vlajky

	CPen*					m_pBallPen;					// pero ktorym sa vykresluje lopta
	CBrush*					m_pBallBrush;				// vypln lopty

	CPen*					m_pUnknownPlayerPen;		// pero ktorym sa vykresluje hrac, neznamej strany
	CBrush*					m_pUnknownPlayerBrush;		// vypln neznameho hraca
	CPen*					m_pUnknownPlayerSpeedPen;	// pero, ktorym sa znazornuje rychlost neznameho agenta
	CPen*					m_pUnknownPlayerAccelPen;	// pero, ktorym sa znayornuje zrychlenie neznameho agenta

	CPen*					m_pTeamPlayerPen;			// pero ktorym sa vykresluje spluhrac
	CBrush*					m_pTeamPlayerBrush;			// vypln spoluhraca
	CPen*					m_pTeamPlayerSpeedPen;		// pero, ktorym sa znazornuje rychlost spoluhraca
	CPen*					m_pTeamPlayerAccelPen;		// pero, ktorym sa znayornuje zrychlenie spoluhraca

	CPen*					m_pEnemyPlayerPen;			// pero ktorym sa vykresluje protihrac
	CBrush*					m_pEnemyPlayerBrush;		// vypln protihraca
	CPen*					m_pEnemyPlayerSpeedPen;		// pero, ktorym sa znazornuje rychlost superovho agenta
	CPen*					m_pEnemyPlayerAccelPen;		// pero, ktorym sa znayornuje zrychlenie superovho agenta

	CPen*					m_pOwnAgentPen;				// pero ktorym sa vykresluje vlastny agent
	CBrush*					m_pOwnAgentBrush;			// vypln agenta
	CPen*					m_pOwnHeadAgentPen;			// pero ktorym sa vykresluje hlava vlastneho agent
	CBrush*					m_pOwnHeadAgentBrush;		// vypln hlavy agenta
	CPen*					m_pOwnAgentRotationPen;		// pero na vykreslenie rotacie agenta
	CPen*					m_pOwnAgentSpeedPen;		// pero, ktorym sa znazornuje rychlost vlastneho agenta
	CPen*					m_pOwnAgentAccelPen;		// pero, ktorym sa znazornuje zrychlenie vlastneho agenta

	// objekty rozhrania s ostatnym datovym svetom, resp. ostatne objekty
	CVisStaticField*		m_pStaticField;				// reprezentuje udaje o ihrisku 
	CVisPerception*			m_pPerception;				// vnemy zo servera
public:  // FIXME
	CLocalAgent*			m_pAgent;					// vlastny agent
private:

	// staticke parametre ihriska
	int						m_nMeterPixelRatio;			// prevod medzi jednotkami sveta ( metrami ) a pixelmi

	int						m_nFieldLineWidth;			// sirka ciar ihriska
	int						m_nFieldGoalLineWidth;		// sirka cira branok
	int						m_nOrientedLineSizePixel;	// velkost zakoncenia orientovanej ciary

	int						m_nFieldLengthPixel;		// dlzka ihriska v pixeloch
	int						m_nFieldWidthPixel;			// sirka ihriska v pixeloch
	int						m_nFieldBorderPixel;		// velkost okraja ihriska v pixeloch

	int						m_nFieldCenterXPixel;		// x-ova suradnica stredu ihriska v pixeloch
	int						m_nFieldCenterYPixel;		// y-ova suradnica stredu ihriska v pixeloch

	int						m_nAllFieldPosXPixel;		// x-ova suradnica laveho okraja ihriska v pixeloch
	int						m_nAllFieldPosYPixel;		// y-ova suradnica horneho okraja ihriska v pixeloch

	// visual setup parameters
	bool					m_bVisualSetupFlagIcon;

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CChildView)
	public:
	virtual BOOL Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext = NULL);
	protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CChildView();

	void OnDraw( CDC* pDC );
	void SetNewPerception( CPerception* newPerception ) { m_pPerception->SetPerception( newPerception ); };

private:

	void CreatePensAndBrushes( void );

	bool LoadBMPImage( LPCTSTR sBMPFile, CBitmap& bitmap, CPalette *pPal );
	void DrawBitmap(CDC* pDC, CBitmap& bitmap, CPalette *pPal, int pos_x, int pos_y );

	void DrawField( CDC* pDC, int pos_x, int pos_y, bool drawStaticFlags = true );

	void DrawFlag( CDC* pDC, CVisObject* pVisFlag );
	void DrawBall( CDC* pDC, CVisObject* pVisBall );
	void DrawOwnAgent( CDC* pDC, CVisObject* pVisAgent );
	void DrawPlayer( CDC* pDC, CVisObject* pVisPlayer );

	void DrawPerceptionFlag( CDC* pDC, CVisObject* pVisFlag );
	void DrawPerceptionBall( CDC* pDC, CVisObject* pVisBall );
	void DrawPerceptionPlayer( CDC* pDC, CVisObject* pVisPlayer );

	// funkcie na vykreslenie zakladnych elementov sceny
	void DrawOrientedLine( CDC* pDC, int startX, int startY, int targetX, int targetY, CPen* drawPen );
	void DrawCircle( CDC* pDC, int centerX, int centerY, int radius, CPen* drawPen, CBrush* drawBrush );
	void DrawCircleLine( CDC* pDC, int centerX, int centerY, int radius, CPen* drawPen );
	void DrawLine( CDC* pDC, int posX0, int posY0, int posX1, int posY1, CPen* drawPen );
	void DrawCross( CDC* pDC, int centerX, int centerY, int size, CPen* drawPen ); 
	void DrawArc( CDC* pDC, int posX0, int posY0, int posX1, int posY1, int arcX0, int arcY0, int arcX1, int arcY1, CPen* drawPen );

	void ConvertWorldToPixel( float coord_x, float coord_y, int& pixel_x, int& pixel_y );

	void PerceptionColorUpdate( CPen* new_pen, CBrush* new_brush, CPen* origin_pen, CBrush* origin_brush );

	CPen*	GetFlagPen( void ) { return m_pFlagPen; };
	CBrush* GetFlagBrush( void ) { return m_pFlagBrush; };

	CPen*	GetBallPen( void ) { return m_pBallPen; };
	CBrush* GetBallBrush( void ) { return m_pBallBrush; };

	CPen*	GetUnknownPlayerPen( void ) { return m_pUnknownPlayerPen; };
	CBrush* GetUnknownPlayerBrush( void ) { return m_pUnknownPlayerBrush; };
	CPen*	GetUnknownPlayerSpeedPen( void ) { return m_pUnknownPlayerPen; };
	CPen*	GetUnknownPlayerAccelPen( void ) { return m_pUnknownPlayerAccelPen; };

	CPen*	GetEnemyPlayerPen( void ) { return m_pEnemyPlayerPen; };
	CBrush* GetEnemyPlayerBrush( void ) { return m_pEnemyPlayerBrush; };
	CPen*	GetEnemyPlayerSpeedPen( void ) { return m_pEnemyPlayerSpeedPen; };
	CPen*	GetEnemyPlayerAccelPen( void ) { return m_pEnemyPlayerAccelPen; };

	CPen*	GetTeamPlayerPen( void ) { return m_pTeamPlayerPen; };
	CBrush* GetTeamPlayerBrush( void ) { return m_pTeamPlayerBrush; };
	CPen*	GetTeamPlayerSpeedPen( void ) { return m_pTeamPlayerSpeedPen; };
	CPen*	GetTeamPlayerAccelPen( void ) { return m_pTeamPlayerAccelPen; };

	CPen*	GetOwnAgentPen( void ) { return m_pOwnAgentPen; };
	CBrush* GetOwnAgentBrush( void ) { return m_pOwnAgentBrush; };
	CPen*	GetOwnHeadAgentPen( void ) { return m_pOwnHeadAgentPen; };
	CBrush* GetOwnHeadAgentBrush( void ) { return m_pOwnHeadAgentBrush; };
	CPen*	GetOwnAgentRotationLine( void ) { return m_pOwnAgentRotationPen; };
	CPen*	GetOwnAgentSpeedPen( void ) { return m_pOwnAgentSpeedPen; };
	CPen*	GetOwnAgentAccelPen( void ) { return m_pOwnAgentAccelPen; };

	// Generated message map functions
protected:
	//{{AFX_MSG(CChildView)
	afx_msg void OnPaint();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CHILDVIEW_H__EAFD186F_C0C6_11D4_BEC2_00C0CA122103__INCLUDED_)
