// ChildTextView.cpp : implementation file
//

#include "stdafx.h"
#include "Player.h"
#include "ChildTextView.h"
#include "LogManager.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


extern CChildTextView* m_pTextReadyView;

const DWORD ACTIVE_MESSAGE_MASK = -1;
const int DEFAULT_FONT_SIZE = 16;

/////////////////////////////////////////////////////////////////////////////
// CChildTextView

CChildTextView::CChildTextView()
{
	m_pMyDevice = new CDC();
	m_pMyBitmap = new CBitmap();
	m_nFontSize = DEFAULT_FONT_SIZE;
}

CChildTextView::~CChildTextView()
{
	m_pTextReadyView = 0;

	delete m_pMyDevice;
	delete m_pMyBitmap;
}


BEGIN_MESSAGE_MAP(CChildTextView, CWnd)
	//{{AFX_MSG_MAP(CChildTextView)
	ON_WM_ERASEBKGND()
	ON_WM_PAINT()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CChildTextView message handlers

//////////////////////////////////////////////////////////////////////////////
// BOOL CChildTextView::OnEraseBkgnd(CDC* pDC) 
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		CDC* pDC
//
//////////////////////////////////////////////////////////////////////////////
BOOL CChildTextView::OnEraseBkgnd(CDC* pDC) 
{
	//return CWnd::OnEraseBkgnd(pDC);
	return FALSE;
}

void CChildTextView::WriteTextMessage( CDC* pDC, SMessageStruct* message, int position_y )
{
	// FIXME to iste ako pri pridavani do TextMessageBuffer
	//
	// if ( !( mask | message->m_dMask ) )
	//		return;

	pDC->TextOut( 0, position_y, CString( message->m_czText ) );
}

//////////////////////////////////////////////////////////////////////////////
// void CChildTextView::OnDraw( CDC* pDC )
// ---------------------------------------------------------------------------
// Description:
//		hlavna funkcia zobrazovania
//
// ---------------------------------------------------------------------------
// Parameters:
//		CDC* pDC
//
//////////////////////////////////////////////////////////////////////////////
void CChildTextView::OnDraw( CDC* pDC )
{
	DWORD active_mask = 1;

	CMessageList* m_list = ::cLogManager.GetMessageList();
	CMessageList::iterator i = m_list->begin();

	int font_size = GetFontSize();
	int max_lines = ( m_cWindow.y / font_size );
	int off = m_list->size() - max_lines;
	if ( off > 0 )
	{
		for( int j = 0; j < off; j++ )
		{
			++i;
		}
	}

	++font_size;
	int pos_y = 0;

	while( i != m_list->end() )
	{
		WriteTextMessage( pDC, *i, pos_y );
		++i;

		pos_y += font_size;
	}
}

//////////////////////////////////////////////////////////////////////////////
// void CChildTextView::OnPaint() 
// ---------------------------------------------------------------------------
// Description:
//		
//
//////////////////////////////////////////////////////////////////////////////
void CChildTextView::OnPaint() 
{
	CPaintDC dc(this);
	CRect		rectUpdate;

	dc.GetClipBox( &rectUpdate );

	CBitmap* oldBitmap = m_pMyDevice->SelectObject( m_pMyBitmap );
	
	m_pMyDevice->SelectClipRgn( 0 );
	m_pMyDevice->IntersectClipRect( &rectUpdate );

	CBrush bkgndBrush( ( COLORREF ) ::GetSysColor( COLOR_WINDOW ) );
	CBrush* oldBrush = m_pMyDevice->SelectObject( &bkgndBrush );

	m_pMyDevice->PatBlt( rectUpdate.left, rectUpdate.top, rectUpdate.Width(), rectUpdate.Height(), PATCOPY );

	OnDraw( m_pMyDevice );

	dc.BitBlt( rectUpdate.left, rectUpdate.top, rectUpdate.Width(), rectUpdate.Height(), 
			m_pMyDevice, rectUpdate.left, rectUpdate.top, SRCCOPY );

	m_pMyDevice->SelectObject( oldBitmap );
	m_pMyDevice->SelectObject( oldBrush );
}

//////////////////////////////////////////////////////////////////////////////
// BOOL CChildTextView::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext) 
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		LPCTSTR lpszClassName
//		LPCTSTR lpszWindowName
//		DWORD dwStyle
//		const RECT& rect
//		CWnd* pParentWnd
//		UINT nID
//		CCreateContext* pContext
//
//////////////////////////////////////////////////////////////////////////////
BOOL CChildTextView::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext) 
{	
	//return CWnd::Create(lpszClassName, lpszWindowName, dwStyle, rect, pParentWnd, nID, pContext);

	BOOL retVal = CWnd::Create(lpszClassName, lpszWindowName, dwStyle, rect, pParentWnd, nID, pContext);

	CClientDC dc( this );
	m_pMyDevice->CreateCompatibleDC( &dc );
	m_pMyBitmap->CreateCompatibleBitmap( &dc, ::GetSystemMetrics( SM_CXSCREEN ), ::GetSystemMetrics( SM_CYSCREEN ) ); 
	m_pMyDevice->SetMapMode( MM_TEXT );

	return retVal;
}

//////////////////////////////////////////////////////////////////////////////
// BOOL CChildTextView::PreCreateWindow(CREATESTRUCT& cs) 
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		CREATESTRUCT& cs
//
//////////////////////////////////////////////////////////////////////////////
BOOL CChildTextView::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	cs.dwExStyle |= WS_EX_CLIENTEDGE;
	cs.style &= ~WS_BORDER;
	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		::LoadCursor(NULL, IDC_ARROW), HBRUSH(COLOR_WINDOW+1), NULL);

	m_pTextReadyView = this;

	return TRUE;
}

void CChildTextView::OnSize(UINT nType, int cx, int cy) 
{
	//CWnd::OnSize(nType, cx, cy);
	m_cWindow.x = cx;
	m_cWindow.y = cy;
}
