// WorldObjects.cpp: implementation of various world object types....
//
//////////////////////////////////////////////////////////////////////

#include "stdAfx.h"
#include "WorldObjects.h"
#include "staticfield.h"
#include "Player.h"
#include "Coordinator.h"
#include "Config.h"
#include "Logmanager.h"

#include "ChildView.h"  // FIXME
#include "ToDoEvent.h"
#include "TextMessageBuffer.h"

// FIXME: pre aku neurcitost sa pozerat za loptou
#define INVALID(diff, dist) ((((dist)>5) && ((diff)>(1.0*(dist)))) || (((dist)<5) && ((diff)>3)))

CStaticField *field;
CConfig *cfg;

// FIXME:
int local_gametime;

inline double WeightFn(double d)
{
	return 1.0 / (0.01 + d);
}

CLocalAgent::CLocalAgent():CAgent()
{
    cfg = new CConfig;
    cfg->Load("server.conf");
    cfg->Load("agent.conf");
    cfg->AssignValues();

    field = new CStaticField(cfg->field_length, cfg->field_width, cfg->penalty_area_length, cfg->penalty_area_width, cfg->goal_width);

    m_time = 0;
    m_playmode = PM_NONE;
    m_my_world = new CWorldModel;

    bskl  = new CBasicSkills;
    fdata = new CFormationData(field);
    fskl  = new CFormationSkills;
}

CLocalAgent::~CLocalAgent()
{
    if (m_my_world) { delete m_my_world;  m_my_world = NULL; }

    if (bskl) { delete bskl;  bskl = NULL; }

    if (fdata) { delete fdata;  fdata = NULL; }

    if (fskl) { delete fskl;  fskl = NULL; }

    if (field) { delete field;  field = NULL; }

    if (cfg) { delete cfg;  cfg = NULL; }
}

void  CLocalAgent::Precompute()//nasty
{
	CAgent::Precompute();
	m_time++;
}

void CLocalAgent::Deliberate(CGameTime cGameTime, CPerceptionSeq *pPerceptionSeq, CGameCommandSeq *pSentCommandSeq, CGameCommandSeq *pGameCommandSeq)
// vstupy:
//   cGameTime -> cas ku ktoremu sa ma agent rozhodovat
//   pPerceptionSeq -> postupnost vnemy, ktore od posledneho Deliberate prisli
//   pSentCommandSeq -> postupnost povelov, ktore boli poslane serveru 
// vystup:
//   pGameCommandSeq -> postupnost povelov, ktore sa maju odoslat serveru
{
    // poznacime si GameCommandSeq do kontextu kvoli skillsom
    actionseq = pGameCommandSeq;

local_gametime = cGameTime.m_nAllCycles;

    CPerception *pPerception;

    static CPerception world_perception;
    static CPerception rPerception0;  // FIXMEEE: pouzivane len na vizualizaciu 

    int received_info = 0;
    int received_info0 = 0;

    // QUICK FIX NA OTACANIE - ZRUSIT KED BUDE DOBRY WORLDMODEL (SO ZAPOCITANIM POSLEDNEJ HRACOVEJ AKCIE)
    double lastplrdir = m_direction;
    double lastneckdir = m_neck_direction;
    //----------------

    // priklad spracovania pSentCommandSeq -> MALO BY SA ROBIT V RECOMPUTE
    // FIXME:  m_cGameTime by sa malo pouzivat vsade miesto m_time
    //         pretoze dokaze pocitat cas, aj ked realny cas zapasu stoji
    CGameCommand *pGameCommand;
    while (pSentCommandSeq->GetGameCommand(&pGameCommand))
    {
        // pre ukazku si budeme kontrolovat, ci neprisli starsie prikazy
        if (m_cGameTime <= pGameCommand->GetGameTime()) {
            m_cGameTime = pGameCommand->GetGameTime();
            if (pGameCommand->GetCmdType() == CT__TURN)
            {
                // nastavime premennu pre QUICK FIX podla prveho argumentu turnu (=moment)
                lastturn = DegToRad(pGameCommand->GetDArg(1));
            }
        }
        // nezabudnut vymazat
        delete pGameCommand;
    }

    while (pPerceptionSeq->GetPerception(&pPerception))
	{
		while(pPerception->GetPlayTime()>m_time)
		{
			if(received_info & GOT_SEE)
			{
				UpdatePlayerSeenObjects(&world_perception);
			}
			received_info=0;
			Precompute();
        }

		switch(pPerception->GetMsgType())
		{
			case MT_See:
			{
				world_perception = *pPerception;  // brrrrr
				received_info |= GOT_SEE;

				UpdatePlayerPosition(pPerception->GetSeenFlags(), pPerception->GetSeenGoals(),pPerception->GetSeenLines());

				if (m_pReadyView)
				{
					rPerception0 = *pPerception;  // brrrrr
					m_pReadyView->SetNewPerception(&rPerception0);

					CChildView *vv = m_pReadyView;

					vv->m_pAgent->SetPosition(GetPosition());
					vv->m_pAgent->SetDirection(GetDirection());
					vv->m_pAgent->SetNeckDirection(GetNeckDirection());
					m_pReadyView = NULL;  // FIXMEEEE
					vv->Invalidate();
                }
			}
			break;
			case MT_Hear:
			{
				received_info |= GOT_HEAR;
				fprintf(m_ff, "<hear>\n");

				EPlayMode playmode = pPerception->GetPlayMode();
				if (playmode != PM_NONE)  m_playmode = playmode;  // FIXME
			}
			break;
			case MT_SenseBody:
			{
				received_info |= GOT_SENSE_BODY;
                CSenseBody my_body;

                pPerception->GetSenseBody(&my_body);
				UpdatePlayerProperties(&my_body);

				if (m_pReadyView)
				{
					rPerception0 = *pPerception;
					m_pReadyView->SetNewPerception(&rPerception0);

					CChildView *vv = m_pReadyView;
					vv->m_pAgent->SetDirection(GetDirection());
				}

			}
			break;
			case MT_Init:
			{
                CInitMsg cInitMsg;

                pPerception->GetInitMsg(&cInitMsg);
                SetPlayerSide(cInitMsg.GetSide());
                SetPlayerNumber(cInitMsg.GetUniformNum());

                EPlayMode playmode = pPerception->GetPlayMode();
                if (playmode != PM_NONE)  m_playmode = playmode;  // FIXME
            }
            break;
		}

        received_info0 |= received_info;

		delete pPerception;
    }

	if(received_info & GOT_SEE)
	{
		UpdatePlayerSeenObjects(&world_perception);
	}

    //////////////////////////////////////////////////////////////////
    // no podme uz konecne nieco robit...

    // FIXMEE: aby neposielal moc casto, tak zatial len ak pride
    //   sense body spolu so see
    if((received_info0 & (GOT_SENSE_BODY|GOT_SEE)) == (GOT_SENSE_BODY|GOT_SEE)) 
	{
//bskl->Turn(this, DegToRad(5));
//return;

        double turnfix = m_direction;
        double turnneckfix = m_neck_direction;
		// QUICK FIX NA OTACANIE - ZRUSIT KED BUDE DOBRY WORLDMODEL (SO ZAPOCITANIM POSLEDNEJ HRACOVEJ AKCIE)
        //   zmenime a potom vratime naspat, aby sme to bobrikovi nepokazili
		if (lastturn!=0) {
            if (fabs(m_direction - lastplrdir) < DegToRad(1)) {
                fprintf(m_ff, "quickfix: %d\n", (int)RadToDeg(lastturn));
                m_direction += lastturn;
            } else fprintf(m_ff, "no quickfix\n");
			if (fabs(m_neck_direction - lastplrdir) < DegToRad(1))  m_neck_direction += lastturn;
		}
		lastturn=0;
		// ----------        

        // FIXMEE: ak je beforekickoff a nie sme na mieste, tak sa premiestnime
        if (m_playmode == PM_BeforeKickOff) {
//            C2DVector homepos = fskl->GetMyHomePosition(this);
            C2DVector homepos = C2DVector(-40, 20);
//            bskl->Turn(this, 10);
            if ((m_position - homepos).GetDistance() > 5) {
                bskl->Move(this, homepos);
            }
        }

        // inak sa zacneme zaujimat o loptu
		CBall *pBall=m_my_world->GetBall();
        C2DVector toball = pBall->GetPosition() - GetPosition();
        double diff = pBall->GetPosition().GetDiffusion();
        double dist = toball.GetDistance();
        fprintf(m_ff, "diff/dist: %f / %f\n",(float)diff, (float)dist);

        if ((((pBall->GetSeeStatus() & SEE_ANGLE) && (pBall->GetSeeStatus() & SEE_DISTANCE)) ||
			((pBall->GetSeeStatus() & EXPECTED_ANGLE) && (pBall->GetSeeStatus() & EXPECTED_DISTANCE))) &&
            (!INVALID(diff,dist)))

        {

////            C2DVector cccc;
            
            
            
            if (bskl->BallKickable(this)) {
//                bskl->TurnNeckTo(this, field->GetGoal(GT_L));

                CAgent *a = bskl->NearestFriendToBall(this);
                if (a == NULL) 
                    bskl->KickTo(this, field->GetGoal(GT_R), 50.0);
                else {
                    bskl->KickTo(this, a->GetPosition(), 50.0);
                    

                }

////                cccc = (C2DVector)field->GetGoal(GT_R) - (C2DVector)pBall->GetPosition();
////                cccc.SetDistance(50.0*cfg->kick_power_rate);



            } else {
//                bskl->TurnNeckStraight(this);
                C2DVector ballpos = pBall->GetPosition();
                bskl->GoTo(this, ballpos, 100.0);
//                bskl->TurnTo(this, ballpos);

////                cccc.SetAngleDistance(0, 0);
            }



////            LOGMSG(1, "GAMETIME %d", m_cGameTime);
////            LOGMSG(1, "MyPosition  X %lf, Y %lf", GetPosition().GetX(), GetPosition().GetY());
////            LOGMSG(1, "BallPosition  X %lf, Y %lf", pBall->GetPosition().GetX(), pBall->GetPosition().GetY());
////            C2DVector ccc2 = bskl->GetBallInterceptPosition(this, cccc);
////            LOGMSG(1, "BallInterceptPosition X %lf, Y %lf", ccc2.GetX(), ccc2.GetY());



        } 
		else 
		{
    //        bskl->TurnNeckStraight(this);
				//bskl->Turn2(this, 4.50);   // spravit skill, ktory najde loptu (mal by pockat na perception, moze sa tocit o 45? stupnov)
				bskl->Turn(this, DegToRad(20));
        }

        m_direction = turnfix;
        m_neck_direction = turnneckfix;

    }
}


bool CLocalAgent::UpdatePlayerProperties(CSenseBody *sense_body)
{
    m_see_status|=SEE_BODY_DIRECTION|SEE_STAMINA|SEE_EFFORT|SEE_DISTANCE_CHANGE;

    if( !(m_see_status & EXPECTED_ANGLE_CHANGE || m_see_status & SEE_ANGLE_CHANGE))
    {
        m_speed.SetXYDiffusion(1,0,1e9);
    }

    m_speed.SetDistance(sense_body->GetSpeed());
    m_stamina=sense_body->GetStamina();
    m_effort=sense_body->GetEffort();
    m_direction=(AngNormalise (m_neck_direction) - DegToRad(sense_body->GetHeadDir()));
    return true;
}

bool CLocalAgent::UpdatePlayerSeenObjects(CPerception *Perception)
{
	if(m_my_world)
	{
		m_my_world->Recompute(Perception,*this);
		return true;
	}
	else
	{
		return false;
	}
}



bool CLocalAgent::UpdatePlayerPosition(CSeenFlagsVect &_fFlags, CSeenGoalsVect &_gGoals, CSeenLinesVect &_lLines)//nasty&ughly
{
	//flagy a goaly
	int fsz = _fFlags.size();
//	DiffusePointVector flag_points;
//	flag_points.resize(fsz);

	int i;

	// spocitat relativne suradnice bodov

//	for(i = 0; i < fsz; i++)
//	{
//		CAngular2DVector flag_ang(DegToRad(_fFlags[i].GetDirection())  , _fFlags[i].GetDistance());
//		flag_points[i] = CDiffuse2DVector(flag_ang , 0.1 , 0.01 , 0.1);
//	}


	int		iFlag1 = -1;
	int		iFlag2 = -1;
//	int		iFlagM = -1;
	int		iMaxAngle = -1000;
	int		iDeltaAngle;
	int		iFlag1Direction;
	double	r1, r2;				// the distance of the player to the flags 
	double	dist, dist2;		// the distance (square) of the two flags
	double	a;						// distance from one flag to intersection point P3
	double	h;						// distance from P3 to the intersection Points P1 and P2 of the two circles
	double	x, x1, x2, x3;
	double	y, y1, y2, y3;
//	double	ratio;
//	double	dMaxDist;
	int		iFlagDir; //, iAbsDirection;
//	int		beta;

	// search for two visible flags with maximal difference of the view angle
//	dMaxDist = 0;

	// zastavka najviac vpravo 
	for (i = 0; i < fsz; i++)
	{
		if (_fFlags[i].GetDistance() > 4.0) {
            iFlagDir = _fFlags[i].GetDirection();
            if ((iFlag1 == -1) || (iFlagDir < iFlag1Direction)) {
                iFlag1 = i;
                iFlag1Direction = iFlagDir;
            }
		}
	}

	for (i = 0; i < fsz; i++)
	{
		if (_fFlags[i].GetDistance() > 4.0)
		{
			iFlagDir = _fFlags[i].GetDirection();
			if ((iFlag1 == -1) || (iFlag1 == i))
			{
				// found the first visible flag
				iFlag1 = i;
				iFlag1Direction = iFlagDir;
			}
			else
			{
				iDeltaAngle = iFlag1Direction - iFlagDir;
				if (iDeltaAngle < 0)
					iDeltaAngle = -iDeltaAngle;
				if (iDeltaAngle > iMaxAngle)
				{
					// this flag has a bigger angle to the first flag
					iFlag2 = i;
					iMaxAngle = iDeltaAngle;
				}
			}
			if (iFlagDir < 0) iFlagDir = -iFlagDir;
//			if (dMaxDist < _fFlags[i].GetDistance()) {
//				iFlagM = i;
//				dMaxDist = _fFlags[i].GetDistance();
//			}
		}
	}

	if (iFlag2 == -1)
		// there are not 2 visible flags
		return FALSE;

	// do the calculations
	r1 = _fFlags[iFlag1].GetDistance();
	r2 = _fFlags[iFlag2].GetDistance();

	x1 = field->GetFlag(_fFlags[iFlag1].GetFlagID()).GetX();
	x2 = field->GetFlag(_fFlags[iFlag2].GetFlagID()).GetX();

	y1 = field->GetFlag(_fFlags[iFlag1].GetFlagID()).GetY();
	y2 = field->GetFlag(_fFlags[iFlag2].GetFlagID()).GetY();

	// calculate the square distance of the two flags
	dist2 = (x2 - x1)*(x2 - x1) + (y2 - y1)*(y2 - y1);	
	dist = sqrt(dist2);
	if (dist > r1 + r2)
	{
		// the circles would not intersect
		dist = r1 + r2;
		dist2 = dist * dist;
	}
	else if ((r1 > r2) && (dist + r2 < r1))
	{
		// the circles would not intersect
		dist = r1 - r2;
		dist2 = dist * dist;
	}
	else if ((r2 > r1) && (dist + r1 < r2))
	{
		// the circles would not intersect
		dist = r2 - r1;
		dist2 = dist * dist;
	}

	r1 *= r1;
	r2 *= r2;
	
	// a = (r1^2 - r2^2 + d^2 ) / (2 d) 
	a = (r1 - r2 + dist2) / (2.0 * dist);
	// h^2 = r1^2 - a^2
	h = r1 - a*a;
	if (h < 0.0)
		h = 0.0;
	else
		h = sqrt(h);

	// P3 = P1 + a ( P2 - P1 ) / d
	x3 = x1 + a * (x2 - x1) / dist;
	y3 = y1 + a * (y2 - y1) / dist;

	// two circles intersect usually in 2 points. Find out which one to select
	if (_fFlags[iFlag1].GetDirection() > _fFlags[iFlag2].GetDirection())
	{
		// result x = x3 + h ( y2 - y1 ) / d 
		x = x3 + h * (y2 - y1) / dist;
		// result y = y3 - h ( x2 - x1 ) / d 
		y = y3 - h * (x2 - x1) / dist;
	}
	else
	{
		x = x3 - h * (y2 - y1) / dist;
		y = y3 + h * (x2 - x1) / dist;
	}

    m_position.SetXY(x, y);
//    fprintf(m_ff, "pos: %d, %d\n", (int)x, (int)y);
//	m_pThisPlayer->SetPosition(x, y);
//	m_pThisPlayer->SetAbsSpeed(m_pThisPlayer->GetPosition() - m_pThisPlayer->GetOldPos());
/*
	double max_dist = 0;

	if (m_pLine[0]->IsValid() && (max_dist < m_pLine[0]->GetDistance())) 
	{	// left 
		max_dist = m_pLine[0]->GetDistance();
		if (m_pLine[0]->GetDirection()>=0)
			m_pThisPlayer->SetAbsDirection(90 + m_pLine[0]->GetDirection());
		else m_pThisPlayer->SetAbsDirection(270 + m_pLine[0]->GetDirection());
	}
	if (m_pLine[1]->IsValid() && (max_dist < m_pLine[1]->GetDistance())) 
	{	// right line
		max_dist = m_pLine[1]->GetDistance();
		if (m_pLine[1]->GetDirection()>=0)
			m_pThisPlayer->SetAbsDirection(m_pLine[1]->GetDirection()-90);
		else m_pThisPlayer->SetAbsDirection(m_pLine[1]->GetDirection()+90);
	}
	if (m_pLine[2]->IsValid() && (max_dist < m_pLine[2]->GetDistance())) 
	{	// top line
		max_dist = m_pLine[2]->GetDistance();
		if (m_pLine[2]->GetDirection()>=0)
			m_pThisPlayer->SetAbsDirection(	m_pLine[2]->GetDirection());
		else m_pThisPlayer->SetAbsDirection(m_pLine[2]->GetDirection()+180);
		
	}
	if (m_pLine[3]->IsValid() && (max_dist < m_pLine[3]->GetDistance())) 
	{	//bottom
		max_dist = m_pLine[3]->GetDistance();
		if (m_pLine[3]->GetDirection()>=0)
			m_pThisPlayer->SetAbsDirection(	m_pLine[3]->GetDirection()-180);
		else m_pThisPlayer->SetAbsDirection(m_pLine[3]->GetDirection());
	}
	if (max_dist == 0) {
		// calculate the absolute direction
		r1 = m_pFlag[iFlagM]->GetDistance();
		x1 = m_pFlag[iFlagM]->GetAbsX();
		y1 = m_pFlag[iFlagM]->GetAbsY();
		ratio = (y1 - y) / r1;
		beta = (int) (asin(ratio) * RAD2DEG);
		if (x > x1)
			iAbsDirection = 180 - beta + m_pFlag[iFlagM]->GetDirection();
		else
			iAbsDirection = beta + m_pFlag[iFlagM]->GetDirection();
		
		if (iAbsDirection > 180)  iAbsDirection -= 360;
		if (iAbsDirection < -180)  iAbsDirection += 360;
		
		m_pThisPlayer->SetAbsDirection(iAbsDirection);
	}
*/	

	//flagy a goaly

//	int fsz = _fFlags.size();
	int gsz = _gGoals.size();
	DiffusePointVector flag_points , goal_points;
	DiffusePointVector flag_speeds , goal_speeds;
	flag_points.resize(fsz);
	goal_points.resize(gsz);

//	int i;

	// spocitat relativne suradnice bodov

	for(i = 0 ; i < fsz ; i++)
	{
		CAngular2DVector flag_ang(DegToRad(_fFlags[i].GetDirection())  , _fFlags[i].GetDistance());
		flag_points[i] = CDiffuse2DVector(flag_ang , 0.1 , 0.01 , 0.1);
	}

	for(i = 0 ; i < gsz ; i++)
	{
		CAngular2DVector goal_ang(DegToRad(_gGoals[i].GetDirection()) , _gGoals[i].GetDistance());
		goal_points[i] = CDiffuse2DVector(goal_ang , 0.1 , 0.01 , 0.1);
	}

	double S = 0 , r;

	//vahovany aritmenicky priemer...

	C2DVector T , P , t , p;

	
	for(i = 0 ; i < fsz ; i++)
	{
		r = WeightFn(flag_points[i].GetDiffusion());

		T += r * field->GetFlag(_fFlags[i].GetFlagID());
		P += r * flag_points[i];
		S += r;
	}

	for(i = 0 ; i < gsz ; i++)
	{
		r = WeightFn(goal_points[i].GetDiffusion());

		T += r * field->GetGoal(_gGoals[i].GetGoalID());
		P += r * goal_points[i];
		S += r;
	}

	if(S > 0)
	{
		T/=S;
		P/=S;

		double A = 0,B = 0,C = 0;

		for(i = 0 ; i < fsz ; i++)
		{
			r = WeightFn(flag_points[i].GetDiffusion());
			t = T - field->GetFlag(_fFlags[i].GetFlagID());
			p = flag_points[i];

			A += r * (p & P);
			B += r * (p & t);
			C += r * (p * t);
		}

		for(i = 0 ; i < gsz ; i++)
		{
			r = WeightFn(goal_points[i].GetDiffusion());
			t = T - field->GetGoal(_gGoals[i].GetGoalID());
			p = goal_points[i];

			A += r * (p & P);
			B += r * (p & t);
			C += r * (p * t);
		}
		float telen=sqrt(B * B + C * C);
		if(telen==0) return false;
		float angle = (acosf(A / sqrt(B * B + C * C)) + atan2( C , B));

		C2DVector Poz = T - Rot(P , -angle);

        // na zaver este zratame svoju vlastnu neurcitost...

		double E=0;

		for(i = 0 ; i < fsz ; i++)
		{
			p = flag_points[i] - Rot(field->GetFlag(_fFlags[i].GetFlagID()) - Poz , angle);

			E += WeightFn(flag_points[i].GetDiffusion()) * (p * p);
		}

		for(i = 0 ; i < gsz ; i++)
		{
			p = goal_points[i] - Rot(field->GetGoal(_gGoals[i].GetGoalID()) - Poz , angle);

			E += WeightFn(goal_points[i].GetDiffusion()) * (p * p);
		}


        CDiffuse2DVector old=m_position;

		angle=AngNormalise( angle );

        m_position.SetVDiffusion(Poz , sqrt(E / S));
fprintf(m_ff, "tim4.m_position: %f, %f\n", (float)m_position.GetX(), (float)m_position.GetY());
fprintf(m_ff, "motko.m_position: %f, %f\n", (float)x, (float)y);
//m_position.SetXY(x, y);  // FIX

        // FIX: zmena znamienka neck_direction
		m_neck_direction =AngNormalise(-angle);
		if(m_see_status&PREV_NECK_DIRECTION)
		{
			m_angular_speed=m_neck_direction-m_prev_neck_direction;
			m_see_status|=EXPECTED_ANGULAR_SPEED;
		}

		S=0;
		C2DVector VSpeed;

		for(i = 0 ; i < fsz ; i++)
		{
			if((_fFlags[i].GetSetValuesVar()&SEE_DISTANCE_CHANGE) &&(_fFlags[i].GetSetValuesVar()&SEE_ANGLE_CHANGE))
			{
			r = WeightFn(flag_points[i].GetDiffusion());
			}
			else
			{
				r=0;
			}
			VSpeed-=r*Rot(C2DVector(_fFlags[i].GetDistanceChng(),_fFlags[i].GetDistance()*_fFlags[i].GetDirectionChng()),angle);
			S+=r;
		}

		for(i = 0 ; i < gsz ; i++)
		{
			if((_gGoals[i].GetSetValuesVar()&SEE_DISTANCE_CHANGE) &&(_gGoals[i].GetSetValuesVar()&SEE_ANGLE_CHANGE))
			{
				// FIX: flag_points -> goal_points
				r = WeightFn(goal_points[i].GetDiffusion());
			}
			else
			{
				r=0;
			}
			VSpeed-=r*Rot(C2DVector(_gGoals[i].GetDistanceChng(),_gGoals[i].GetDistance()*_gGoals[i].GetDirectionChng()),angle);
			S+=r;
		}
        CDiffuse2DVector dif=old-m_position;

        if(dif.GetDiffusion()>dif.GetDistance())
        {
			m_see_status &= (!PREV_MASK) & (!EXPECTED_DISTANCE_CHANGE) &(!EXPECTED_ANGLE_CHANGE);
		}


		bool seeing_speed=false;

		CDiffuse2DVector SeenSpeed;
		if(S>0)
		{
			VSpeed/=S;

			E=0;

			for(i = 0 ; i < fsz ; i++)
			{
				if((_fFlags[i].GetSetValuesVar()&SEE_DISTANCE_CHANGE) &&(_fFlags[i].GetSetValuesVar()&SEE_ANGLE_CHANGE))
				{
					r = WeightFn(flag_points[i].GetDiffusion());
				}
				else
				{
					r=0;
				}
				p=VSpeed+Rot(C2DVector(_fFlags[i].GetDistanceChng(),_fFlags[i].GetDistance()*_fFlags[i].GetDirectionChng()),angle);
				E+=r*(p*p);
			}

			for(i = 0 ; i < gsz ; i++)
			{
				if((_gGoals[i].GetSetValuesVar()&SEE_DISTANCE_CHANGE) &&(_gGoals[i].GetSetValuesVar()&SEE_ANGLE_CHANGE))
				{
					// FIX: flag_points -> goal_points
					r = WeightFn(goal_points[i].GetDiffusion());
				}
				else
				{
					r=0;
				}
				p=VSpeed+Rot(C2DVector(_gGoals[i].GetDistanceChng(),_gGoals[i].GetDistance()*_gGoals[i].GetDirectionChng()),angle);
				E+=r*(p*p);
			}

			E=sqrt(E/S);

		   SeenSpeed.SetVDiffusion(VSpeed,E);
		   seeing_speed=true;
		}

		bool computing_speed=false;
		
		CDiffuse2DVector ComputedSpeed;

        if(m_see_status& PREV_POSITION)
        {
			ComputedSpeed=m_position-m_prev_position;
			computing_speed=true;

		}


		CDiffuse2DVector Speed;

		if(seeing_speed)
		{
			if(computing_speed )
			{
				double a=0*WeightFn(SeenSpeed.GetDiffusion());
				double b=WeightFn(ComputedSpeed.GetDiffusion());
				Speed=(a*SeenSpeed+b*ComputedSpeed)/(a+b);
			}
			else
			{
				Speed=SeenSpeed;
			}
		}
		else
		{
			Speed=ComputedSpeed;
		}

		if(seeing_speed || computing_speed)
		{
            m_see_status|=SEE_ANGLE_CHANGE;

			if(m_see_status&SEE_DISTANCE_CHANGE)
			{
				m_speed.SetAngle(Speed.GetAngle());
				m_speed.SetDiffusion(Speed.GetDiffusion());
			}
			else
			{
				m_speed=Speed;
			}


            if(m_see_status&PREV_SPEED)
            {
                m_acceleration=m_speed-m_prev_speed;
                m_see_status|=EXPECTED_ACCELERATION;
            }
        }

        m_see_status|=SEE_ANGLE|SEE_DISTANCE|SEE_NECK_DIRECTION;

		return true;


	}
	return false;
}


void CAgent::UpdateApproachDistances(const CMovingObject &obj,const CAgent &local)//ughly
{
	CAngular2DVector pt(obj.GetPosition());
	m_approach_distances[m_approach_distances.size()*pt.GetAngle()/2/PI] =
        __max(0,pt.GetDistance()-obj.GetPosition().GetDiffusion());
}

void CMovingObject::Precompute()
{
	if(m_see_status&SEE_SIDE)
	{
		m_see_status|=EXPECTED_SIDE;
	}

	if(m_see_status&SEE_NUMBER)
	{
		m_see_status|=EXPECTED_NUMBER;
	}

	if(m_see_status&SEE_ANGLE)
	{
		m_see_status|=EXPECTED_ANGLE;
	}

	if(m_see_status&SEE_DISTANCE)
	{
		m_see_status|=EXPECTED_DISTANCE;
	}

	if(m_see_status&SEE_ANGLE_CHANGE)
	{
		m_see_status|=EXPECTED_ANGLE_CHANGE;
	}

	if(m_see_status&SEE_DISTANCE_CHANGE)
	{
		m_see_status|=EXPECTED_DISTANCE_CHANGE;
	}

	if(m_see_status&SEE_BODY_DIRECTION)
	{
		m_see_status|=EXPECTED_BODY_DIRECTION;
	}

	if(m_see_status&SEE_NECK_DIRECTION)
	{
		m_see_status|=EXPECTED_NECK_DIRECTION;
	}

	if(m_see_status&SEE_STAMINA)
	{
		m_see_status|=EXPECTED_STAMINA;
	}

	if(m_see_status&SEE_EFFORT)
	{
		m_see_status|=EXPECTED_EFFORT;
	}

	m_see_status&=(EXPECTED_MASK);

	if(m_see_status&EXPECTED_ANGLE && m_see_status&EXPECTED_DISTANCE)
	{
		m_prev_position=m_position;
		m_see_status|=PREV_POSITION;
	}
	if(m_see_status&EXPECTED_ANGLE_CHANGE && m_see_status&EXPECTED_DISTANCE_CHANGE)
	{
		m_prev_speed=m_speed;
		m_see_status|=PREV_SPEED;
	}
	if(m_see_status&EXPECTED_ACCELERATION)
	{
		m_prev_acceleration=m_acceleration;
		m_see_status|=PREV_ACCELERATION;
	}

	m_position+=m_speed;
	m_speed=m_speed*0.9+m_acceleration;
	m_speed.SetDistance(__min(1,m_speed.GetDistance()));
//	double pos_un=1.0-m_speed.GetDistance();
	m_speed.SetDiffusion(__min(1,m_speed.GetDiffusion()));
	m_acceleration=CDiffuse2DVector(0,0,1);
}

void CBall::UpdateBallPosition(CSeenObject _oBall,const CAgent &local)//ughly
{
	int flags=_oBall.GetSetValuesVar();
	
	if(flags &(SEE_ANGLE|SEE_DISTANCE))
	{
        fprintf(m_ff, "{ball %lf}\n", (double)_oBall.GetDirection());

//        if (fabs(_oBall.GetDirection())>15) 
//            fprintf(m_ff, "xx");

		CDiffuse2DVector position(CAngular2DVector(DegToRad(_oBall.GetDirection())+local.GetNeckDirection(),_oBall.GetDistance()),0.1,0.1,0.1);

		m_position=position+CDiffuse2DVector((C2DVector)local.GetPosition(),0);

        m_see_status|=SEE_ANGLE|SEE_DISTANCE;

		CDiffuse2DVector speed;

//		if(flags &(SEE_ANGLE_CHANGE|SEE_DISTANCE_CHANGE))
//		{
//			CDiffuse2DVector speed(_oBall.GetDistance()*(DegToRad(_oBall.GetDirectionChng())-local.GetAngularSpeed()),_oBall.GetDistanceChng(),0.1);
//			speed=Rot(speed,local.GetNeckDirection());
//			m_speed=speed+local.GetSpeed();
//	        m_see_status|=SEE_ANGLE_CHANGE|SEE_DISTANCE_CHANGE;
//		}
//		else
		{
			if( m_see_status &PREV_POSITION)
			{
// FIX: pocitame podla motkov
                CDiffuse2DVector speed(0,0,0);
                int dtime = local_gametime-m_oldtime;

                if ((dtime > 0) && (dtime < 10)) {
                    speed=m_position-m_oldposition; //m_prev_position;
                    speed=speed/dtime;
                    fprintf(m_ff, "_speed: %f, %f\n", (float)speed.GetX(), (float)speed.GetY());
                    speed = 0.3 * m_speed * cfg->ball_decay + 0.7 * speed;
                } 

                fprintf(m_ff, "m_position: %f, %f\n", (float)m_position.GetX(), (float)m_position.GetY());
                fprintf(m_ff, "m_oldposition: %f, %f\n", (float)m_oldposition.GetX(), (float)m_oldposition.GetY());
                fprintf(m_ff, "m_dtime: %d\n", dtime);
                fprintf(m_ff, "m_speed: %f, %f\n", (float)m_speed.GetX(), (float)m_speed.GetY());
                fprintf(m_ff, "m_oldspeed: %f, %f\n", (float)m_oldspeed.GetX(), (float)m_oldspeed.GetY());
                fprintf(m_ff, "speed: %f, %f\n", (float)speed.GetX(), (float)speed.GetY());
                fprintf(m_ff, "dif: %f / %f\n",(float)(speed - (m_oldspeed * cfg->ball_decay)).GetDistance(), (float)speed.GetDistance() * 0.2);
				// updejtneme rychlost, len ak dve po sebe iduce hodnoty su podobne
				//   (alebo ak bezpecne stojime)
                if (//((local.GetPosition() - local.GetPrevPosition()).GetDistance() < 0.01) || 
					((speed - (m_oldspeed * cfg->ball_decay)).GetDistance() < (speed.GetDistance() * 0.2))) {
                    fprintf(m_ff, "**cup'n");
                    if (speed.GetDistance() <= cfg->ball_speed_max) {
					    m_speed = speed;
                    }
				}
                m_oldspeed = speed;

	            //m_speed=m_position-m_prev_position;
		        
		        m_see_status|=SEE_ANGLE_CHANGE|SEE_DISTANCE_CHANGE;
			}
			else
			{
				return;
			}
            m_oldposition = m_position;
            m_oldtime = local_gametime;

		}
		if( m_see_status &PREV_SPEED)
		{
			m_acceleration=m_speed-m_prev_speed;
// FIX: zrusime zrychlenie
m_acceleration=m_speed-m_speed;
		    m_see_status|=EXPECTED_ACCELERATION;
		}
	}
}


void  CAgent::Precompute()//nasty
{
// PRECOMPUTE:
	CMovingObject::Precompute();

	m_see_status&=(~EXPECTED_ANGULAR_SPEED);
	
	if(m_see_status&EXPECTED_NECK_DIRECTION)
	{
		m_prev_neck_direction=m_neck_direction;
		m_see_status|=PREV_NECK_DIRECTION|EXPECTED_ANGULAR_SPEED;
	}
	m_angular_speed=0;
	
	if(m_my_world)
	{
		m_my_world->Precompute();
	}
}


CGameCommand * CAgent::GetCommand()
{
	return 0;
}

void CBall::Precompute()
{
// PRECOMPUTE:
 	CMovingObject::Precompute();
}


void CWorldModel::Recompute(CPerception *Perception,const CAgent &local)
{
	CSeenObject tmp_ball;

	Perception->GetBall(&tmp_ball);

	m_ball->UpdateBallPosition(tmp_ball,local);



// PRECOMPUTE:

	//CSeenPlayersVect my_seen_vect=Perception->GetSeenPlayers();
	int seen_count=Perception->GetPlayersCount();
	int unid_count=m_unidentified_agents.size();
	int id_count=m_identified_agents.size();
	if(seen_count)
	{
		int rer=0;
		rer++;
	}

	int i,j;

	double **id_vals;
	double **unid_vals;

	bool *matched_unid;
	bool *matched_seen;

	CSeenPlayer **act_seen;

	if(unid_count)
	{
		matched_unid=new bool   [unid_count];
		memset(matched_unid,0,unid_count*sizeof(bool));
	}

	if(seen_count)
	{
		CSeenPlayer *tmp_player=new CSeenPlayer;
		int tmp_poz=Perception->GetFirstPlayer (tmp_player);

		act_seen= new CSeenPlayer *[seen_count];

		if(id_count)
		{
			id_vals     =new double*[id_count  ];
		}
		if(unid_count)
		{
			unid_vals   =new double*[unid_count];
		}

		matched_seen=new bool[seen_count];
		memset(matched_seen,0,seen_count*sizeof(bool));

        act_seen[0]=tmp_player;
		for(i=1;i<seen_count;i++)
		{
			tmp_player=new CSeenPlayer;
			tmp_poz=Perception->GetNextPlayer (tmp_player,tmp_poz);
            act_seen[i]=tmp_player;
		}

		for(i=0;i<id_count;i++)
		{
			id_vals[i]=new double[seen_count];

			for(j=0;j<seen_count;j++)
			{
				id_vals[i][j]=m_identified_agents[i]->TestOwnership(*(act_seen[j]),local);
			}
		}

		for(i=0;i<unid_count;i++)
		{
			unid_vals[i]=new double[seen_count];

			for(j=0;j<seen_count;j++)
			{
				unid_vals[i][j]=m_unidentified_agents[i]->TestOwnership(*(act_seen[j]),local);
			}
		}
	}


	int i_id=-1,j_id=-1;

	double max_id=-1;

	int seen_rem=seen_count;

	bool not_hotovo=true;

	while(not_hotovo)
	{
		int i_unid=-1,j_unid=-1;

		double max_unid=-1;

		int i_id=-1,j_id=-1;

		double max_id=-1;

		for(i=0;i<unid_count;i++)
		{
			for(j=0;j<seen_count;j++)
			{
				if(max_unid<unid_vals[i][j])
				{
					i_unid=i;
					j_unid=j;
					max_unid=unid_vals[i][j];
				}
			}
		}

		for(i=0;i<id_count;i++)
		{
			for(j=0;j<seen_count;j++)
			{
				if(max_id<id_vals[i][j])
				{
					i_id=i;
					j_id=j;
					max_id=id_vals[i][j];
				}
			}
		}

		if(max_id>=max_unid)
		{
			if(max_id>0)
			{
				m_identified_agents[i_id]->Update(*(act_seen[j_id]),local);
				matched_seen[j_id]=true;

				for(j=0;j<seen_count;j++)
				{
					id_vals[i_id][j]=-1;
				}

				for(i=0;i<id_count;i++)
				{
					id_vals[i][j_id]=-1;
				}
			}
			else
			{
				not_hotovo=false;
			}
		}
		else
		{
			if(max_unid>0)
			{
				m_unidentified_agents[i_unid]->Update(*(act_seen[j_unid]),local);
				matched_unid[i_unid]=true;
				matched_seen[j_unid]=true;

				for(j=0;j<seen_count;j++)
				{
					unid_vals[i_unid][j]=-1;
				}

				for(i=0;i<unid_count;i++)
				{
					unid_vals[i][j_unid]=-1;
				}
			}
			else
			{
				not_hotovo=false;
			}
		}
	}


	for(i=0;i<unid_count;i++)
	{
		if(matched_unid[i])
		{
			if(m_unidentified_agents[i]->GetSeeStatus() &(SEE_SIDE|SEE_NUMBER))
			{
				m_identified_agents.insert(m_identified_agents.end(),m_unidentified_agents[i]);
				m_unidentified_agents[i]=0;
			}
		}
		else
		{
			delete m_unidentified_agents[i];
			m_unidentified_agents[i]=0;
		}
	}

	for(i=0;i<m_unidentified_agents.size();)
	{
		if(!m_unidentified_agents[i])
		{
			m_unidentified_agents.erase(&(m_unidentified_agents[i]));
		}
		else
		{
			i++;
		}
	}

	for(i=0;i<seen_count;i++)
	{
		if(!matched_seen[i])
		{
			CAgent *new_agent=new CAgent;
			new_agent->Update(*(act_seen[i]),local);

			if(new_agent->GetSeeStatus() &(SEE_SIDE|SEE_NUMBER))
			{
				m_identified_agents.insert(m_identified_agents.end(),new_agent);
			}
			else
			{
				m_unidentified_agents.insert(m_unidentified_agents.end(),new_agent);
			}

		}
	}

	if(seen_count)
	{
		for(i=0;i<id_count;i++)
		{
			delete []id_vals[i];
		}
		if(id_count) delete []id_vals;

		for(i=0;i<unid_count;i++)
		{
			delete []unid_vals[i];
		}
		if(unid_count) delete []unid_vals;

		for(i=0;i<seen_count;i++)
		{
			delete act_seen[i];
		}
		delete []act_seen;
		delete []matched_seen;
	}

	if(unid_count) delete []matched_unid;
}


void CWorldModel::Precompute()
{
	m_ball->Precompute();

// PRECOMPUTE:
	int i;
	for(i=0;i<m_identified_agents.size();i++)
	{
		m_identified_agents[i]->Precompute();
	}
	for(i=0;i<m_unidentified_agents.size();i++)
	{
		m_unidentified_agents[i]->Precompute();
	}
}





double CAgent::TestOwnership(const CSeenPlayer &player,const CAgent &local)//ughly
{
	int flags=player.GetSetValuesVar();

	if((flags&SEE_SIDE) && ((m_see_status&SEE_SIDE) || (m_see_status&EXPECTED_SIDE) ) && (m_side!=player.GetSide()))
	{
		return 0;
	}

	if((flags&SEE_NUMBER) && ((m_see_status&SEE_NUMBER) || (m_see_status&EXPECTED_NUMBER) ) && (m_number!=player.GetUniformNum()))
	{
		return 0;
	}

	if((flags&SEE_SIDE) && ((m_see_status&SEE_SIDE) || (m_see_status&EXPECTED_SIDE)) && (flags&SEE_NUMBER) && ((m_see_status&SEE_NUMBER) || (m_see_status&EXPECTED_NUMBER) ))
	{
		return 1;
	}
////////////!!!!!!!!!

	if(flags &(SEE_ANGLE|SEE_DISTANCE))
	{
		CDiffuse2DVector position(CAngular2DVector(DegToRad(player.GetDirection())+local.GetNeckDirection(),player.GetDistance()),0.1,0.1,0.1);

		CDiffuse2DVector delta=m_position-position-local.GetPosition();

		return exp(-delta.GetDistance()/delta.GetDiffusion());
	}
	return 0;// CAUTION AGENT IS BLIND !!!
}



void CAgent::Update(CSeenPlayer &player,const CAgent &local)//ughly
{
	int flags=player.GetSetValuesVar();

	if(flags&SEE_SIDE)
	{
        // FIXME
        if (player.GetSide() == 0)
            m_side=local.GetPlayerSide();
        else 
            m_side=(local.GetPlayerSide()==S_Left)?S_Right:S_Left;
	}

	if(flags&SEE_NUMBER)
	{
		m_number=player.GetUniformNum();
		m_see_status|=SEE_NUMBER;
	}

	if(flags&SEE_BODY_DIRECTION)
	{
		m_direction=AngNormalise((double)DegToRad(player.GetBodyDir())+local.GetNeckDirection());
		m_see_status|=SEE_BODY_DIRECTION;
	}

	if(flags&SEE_NECK_DIRECTION)
	{
		m_neck_direction=AngNormalise((double)DegToRad(player.GetHeadDir())+local.GetNeckDirection());
		m_see_status|=SEE_NECK_DIRECTION;
	}

	if(flags &(SEE_ANGLE|SEE_DISTANCE))
	{
		CDiffuse2DVector position(CAngular2DVector(DegToRad(player.GetDirection())+local.GetNeckDirection(),player.GetDistance()),0.1,0.1,0.1);

		m_position=position+CDiffuse2DVector((C2DVector)local.GetPosition(),0);

        m_see_status|=SEE_ANGLE|SEE_DISTANCE;

		CDiffuse2DVector speed;

		//if(flags &(SEE_ANGLE_CHANGE|SEE_DISTANCE_CHANGE))
		//{
		//	CDiffuse2DVector speed(player.GetDistance()*(DegToRad(player.GetDirectionChng())-local.GetAngularSpeed()),player.GetDistanceChng(),0.1);
		//	speed=Rot(speed,local.GetNeckDirection());
		//	m_speed=speed+local.GetSpeed();
	    //    m_see_status|=SEE_ANGLE_CHANGE|SEE_DISTANCE_CHANGE;
		//}
		//else
		{
			if( m_see_status &PREV_POSITION)
			{
				m_speed=m_position-m_prev_position;
		        m_see_status|=SEE_ANGLE_CHANGE|SEE_DISTANCE_CHANGE;
			}
			else
			{
				return;
			}
		}
		if( m_see_status &PREV_SPEED)
		{
			m_acceleration=m_speed-m_prev_speed;
		    m_see_status|=EXPECTED_ACCELERATION;
		}
	}
}
