// StaticField.cpp: implementation of the CStaticField class.
//
//////////////////////////////////////////////////////////////////////

#include "stdAfx.h"

#include "StaticField.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


CStaticField::CStaticField()
{
	SetDefaultFlags(105.0, 68.0, 16.5, 40.32, 7.32);
	SetDefaultGoals(105.0, 68.0, 16.5, 40.32, 7.32);
	SetDefaultLines(105.0, 68.0, 16.5, 40.32, 7.32);

	m_dFieldLen = 105.0;
	m_dFieldWid = 68.0;
	m_dFieldPALen = 16.5;
	m_dFieldPAWid = 40.32;
	m_dGoalSize = 7.32;
}

CStaticField::CStaticField(double dFLen, double dFWid, double dPALen, double dPAWid, double dGWid)
{
	SetDefaultFlags(dFLen, dFWid, dPALen, dPAWid, dGWid);
    SetDefaultGoals(dFLen, dFWid, dPALen, dPAWid, dGWid);
    SetDefaultLines(dFLen, dFWid, dPALen, dPAWid, dGWid);

	m_dFieldLen = dFLen;
	m_dFieldWid = dFWid;
	m_dFieldPALen = dPALen;
	m_dFieldPAWid = dPAWid;
	m_dGoalSize = dGWid;
}

CStaticField::~CStaticField()
{
	m_cFlags.clear();
	m_cGoals.clear();
	m_cLines.clear();
}


void CStaticField::SetDefaultFlags(double dFLen, double dFWid, double dPALen, double dPAWid, double dGWid)
{
	m_cFlags.reserve(FT_COUNT);

	m_cFlags[FT_C   ].SetXY(                  0,               0);
	m_cFlags[FT_LT  ].SetXY(-dFLen / 2        , dFWid / 2       );
	m_cFlags[FT_LB  ].SetXY(-dFLen / 2        , -dFWid / 2      );
	m_cFlags[FT_CT  ].SetXY(                  0, dFWid / 2      );
	m_cFlags[FT_CB  ].SetXY(                  0, -dFWid  / 2    );
	m_cFlags[FT_RT  ].SetXY( dFLen / 2         ,  dFWid  / 2    );
	m_cFlags[FT_RB  ].SetXY( dFLen / 2         , -dFWid  / 2    );
	m_cFlags[FT_PLT ].SetXY(-dFLen / 2 + dPALen,  dPAWid / 2    );
	m_cFlags[FT_PLC ].SetXY(-dFLen / 2 + dPALen,               0);
	m_cFlags[FT_PLB ].SetXY(-dFLen / 2 + dPALen, -dPAWid / 2    );
	m_cFlags[FT_PRT ].SetXY( dFLen / 2 - dPALen,  dPAWid / 2    );
	m_cFlags[FT_PRC ].SetXY( dFLen / 2 - dPALen,               0);
	m_cFlags[FT_PRB ].SetXY( dFLen / 2 - dPALen, -dPAWid / 2    );
	m_cFlags[FT_GLT ].SetXY(-dFLen / 2         ,  dGWid  / 2    );
	m_cFlags[FT_GLB ].SetXY(-dFLen / 2         , -dGWid  / 2    );
	m_cFlags[FT_GRT ].SetXY( dFLen / 2         ,  dGWid  / 2    );
	m_cFlags[FT_GRB ].SetXY( dFLen / 2         , -dGWid  / 2    );
	m_cFlags[FT_TL10].SetXY(                -10,  dFWid  / 2 + 5);
	m_cFlags[FT_TL20].SetXY(                -20,  dFWid  / 2 + 5);
	m_cFlags[FT_TL30].SetXY(                -30,  dFWid  / 2 + 5);
	m_cFlags[FT_TL40].SetXY(                -40,  dFWid  / 2 + 5);
	m_cFlags[FT_TL50].SetXY(                -50,  dFWid  / 2 + 5);
	m_cFlags[FT_TR10].SetXY(                 10,  dFWid  / 2 + 5);
	m_cFlags[FT_TR20].SetXY(                 20,  dFWid  / 2 + 5);
	m_cFlags[FT_TR30].SetXY(                 30,  dFWid  / 2 + 5);
	m_cFlags[FT_TR40].SetXY(                 40,  dFWid  / 2 + 5);
	m_cFlags[FT_TR50].SetXY(                 50,  dFWid  / 2 + 5);
	m_cFlags[FT_BL10].SetXY(                -10, -dFWid  / 2 - 5);
	m_cFlags[FT_BL20].SetXY(                -20, -dFWid  / 2 - 5);
	m_cFlags[FT_BL30].SetXY(                -30, -dFWid  / 2 - 5);
	m_cFlags[FT_BL40].SetXY(                -40, -dFWid  / 2 - 5);
	m_cFlags[FT_BL50].SetXY(                -50, -dFWid  / 2 - 5);
	m_cFlags[FT_BR10].SetXY(                 10, -dFWid  / 2 - 5);
	m_cFlags[FT_BR20].SetXY(                 20, -dFWid  / 2 - 5);
	m_cFlags[FT_BR30].SetXY(                 30, -dFWid  / 2 - 5);
	m_cFlags[FT_BR40].SetXY(                 40, -dFWid  / 2 - 5);
	m_cFlags[FT_BR50].SetXY(                 50, -dFWid  / 2 - 5);
	m_cFlags[FT_LT10].SetXY(-dFLen / 2 -      5,              10);
	m_cFlags[FT_LT20].SetXY(-dFLen / 2 -      5,              20);
	m_cFlags[FT_LT30].SetXY(-dFLen / 2 -      5,              30);
	m_cFlags[FT_LB10].SetXY(-dFLen / 2 -      5,             -10);
	m_cFlags[FT_LB20].SetXY(-dFLen / 2 -      5,             -20);
	m_cFlags[FT_LB30].SetXY(-dFLen / 2 -      5,             -30);
	m_cFlags[FT_RT10].SetXY( dFLen / 2 +      5,              10);
	m_cFlags[FT_RT20].SetXY( dFLen / 2 +      5,              20);
	m_cFlags[FT_RT30].SetXY( dFLen / 2 +      5,              30);
	m_cFlags[FT_RB10].SetXY( dFLen / 2 +      5,             -10);
	m_cFlags[FT_RB20].SetXY( dFLen / 2 +      5,             -20);
	m_cFlags[FT_RB30].SetXY( dFLen / 2 +      5,             -30);
	m_cFlags[FT_T0  ].SetXY(0                  ,  dFWid / 2 +  5);
	m_cFlags[FT_B0  ].SetXY(0                  , -dFWid / 2 -  5);
	m_cFlags[FT_L0  ].SetXY(-dFLen / 2 -      5, 0              );
	m_cFlags[FT_R0  ].SetXY( dFLen / 2 +      5, 0              );

    for(int i=0; i<FT_COUNT; i++)
        m_cFlags[i].SetY(-m_cFlags[i].GetY());
}




void CStaticField::SetDefaultGoals(double dFLen, double dFWid, double dPALen, double dPAWid, double dGWid)
{
//	m_cGoals.reserve(GT_R);
	m_cGoals.reserve(GT_COUNT);

	m_cGoals[GT_L   ].SetXY(-dFLen / 2, 0.0);
	m_cGoals[GT_R   ].SetXY( dFLen / 2, 0.0);
}


void CStaticField::SetDefaultLines(double dFLen, double dFWid, double dPALen, double dPAWid, double dGWid)
{
//	m_cLines.reserve(LT_Y);
	m_cLines.reserve(LT_COUNT);
/*
	m_cLines[LT_L] = C2DLine(	C2DVector( - dFLen / 2 ,   dFWid / 2 ),
					C2DVector( - dFLen / 2 , - dFWid / 2 ));
	m_cLines[LT_R] = C2DLine(	C2DVector(   dFLen / 2 ,   dFWid / 2 ),
					C2DVector(   dFLen / 2 , - dFWid / 2 ));
	m_cLines[LT_Y] = C2DLine(	C2DVector( - dFLen / 2 ,   dFWid / 2 ),
					C2DVector(   dFLen / 2 ,   dFWid / 2 ));
	m_cLines[LT_B] = C2DLine(	C2DVector( - dFLen / 2 , - dFWid / 2 ),
					C2DVector(   dFLen / 2 , - dFWid / 2 ));
*/
	m_cLines[LT_L] = C2DLine(	C2DVector( - dFLen / 2 ,  - dFWid / 2 ),
					C2DVector( - dFLen / 2 ,  dFWid / 2 ));
	m_cLines[LT_R] = C2DLine(	C2DVector(   dFLen / 2 ,  - dFWid / 2 ),
					C2DVector(   dFLen / 2 ,  dFWid / 2 ));
	m_cLines[LT_Y] = C2DLine(	C2DVector( - dFLen / 2 ,  - dFWid / 2 ),
					C2DVector(   dFLen / 2 , -  dFWid / 2 ));
	m_cLines[LT_B] = C2DLine(	C2DVector( - dFLen / 2 ,   dFWid / 2 ),
					C2DVector(   dFLen / 2 ,  dFWid / 2 ));

}


