#include "stdafx.h"
#include "Skills.h"
#include "LogManager.h"
#include "Config.h"
#include "WorldObjects.h"

#define POWERRANGE(x)  (((x)>cfg->maxpower)?cfg->maxpower:             \
                        (((x)<cfg->minpower)?cfg->minpower:(x)))
#define MOMENTRANGE(x) (((x)>cfg->maxmoment)?cfg->maxmoment:           \
                        (((x)<cfg->minmoment)?cfg->minmoment:(x)))
#define NECKRANGE(x)   (((x)>cfg->maxneckmoment)?cfg->maxneckmoment:   \
                        (((x)<cfg->minneckmoment)?cfg->minneckmoment:(x)))

extern CConfig *cfg;
extern FILE *m_ff;

//--------------------------------------------------------------------------
// Elementary skills
//--------------------------------------------------------------------------


void CBasicSkills::Dash(CLocalAgent *pa, double power)
{
    CGameCommand *pGameCommand = new CGameCommand();

    pGameCommand->Dash(POWERRANGE(power));
    pa->actionseq->AddGameCommand(pGameCommand);
}

void CBasicSkills::Turn(CLocalAgent *pa, double moment)
{
    CGameCommand *pGameCommand = new CGameCommand();
    
    double moment2 = RadToDeg(moment);  moment2 = MOMENTRANGE(moment2);
    pGameCommand->Turn(moment2);
    pa->actionseq->AddGameCommand(pGameCommand);

//    // QUICK FIX NA OTACANIE - ZRUSIT KED BUDE DOBRY WORLDMODEL (SO ZAPOCITANIM POSLEDNEJ HRACOVEJ AKCIE)
//    pa->lastturn = DegToRad(moment2);
}

void CBasicSkills::Kick(CLocalAgent *pa, double power, double dir)
{
    CGameCommand *pGameCommand = new CGameCommand();
    
    pGameCommand->Kick(POWERRANGE(power), RadToDeg(dir));
    pa->actionseq->AddGameCommand(pGameCommand);
}

void CBasicSkills::TurnNeck(CLocalAgent *pa, double moment)
{
    CGameCommand *pGameCommand = new CGameCommand();
    
    double moment2 = RadToDeg(moment);  moment2 = NECKRANGE(moment2);
    pGameCommand->TurnNeck(RadToDeg(moment2));
    pa->actionseq->AddGameCommand(pGameCommand);
}

void CBasicSkills::Move(CLocalAgent *pa, double x, double y)
{
    CGameCommand *pGameCommand = new CGameCommand();
    
    pGameCommand->Move(x, y);
    pa->actionseq->AddGameCommand(pGameCommand);
}

void CBasicSkills::Move(CLocalAgent *pa, C2DVector pos)
{
    Move(pa, pos.GetX(), pos.GetY());
}

void CBasicSkills::Catch(CLocalAgent *pa, double dir)
{
    CGameCommand *pGameCommand = new CGameCommand();
    
    pGameCommand->Catch(RadToDeg(dir));
    pa->actionseq->AddGameCommand(pGameCommand);
}

void CBasicSkills::Say(CLocalAgent *pa, string message)
{
    CGameCommand *pGameCommand = new CGameCommand();
    
    pGameCommand->Say(message);
    pa->actionseq->AddGameCommand(pGameCommand);
}

void CBasicSkills::ChangeView(CLocalAgent *pa, EViewWidth width, EViewQuality quality)
{
    CGameCommand *pGameCommand = new CGameCommand();
    
    pGameCommand->ChangeView(width, quality);
    pa->actionseq->AddGameCommand(pGameCommand);
}


//--------------------------------------------------------------------------
// Pomocne funkcie
//--------------------------------------------------------------------------

C2DVector CBasicSkills::RelVectorTo(CLocalAgent *pa, C2DVector pos)
{
    return Rot(pos - (C2DVector)pa->GetPosition(), -pa->GetDirection());
}


//! Vrati minimalny uhol, v ktorom moze byt relativne ku mne iny hrac aby som donho nenarazil, ked pojdem rovno
double CBasicSkills::MinimalDirection(double dist)
{
    double dFix = 1.5;
    return asin(2 * dFix * cfg->player_size / dist);
}

double CBasicSkills::MinimalDirection(double dist, double playerdiffusion)
{
	double playersize;

	if (playerdiffusion < 20) 
		playersize = playerdiffusion;
	else
		playersize = 0;

    return asin(2 * playersize / dist);
}



//! vzdialenost, kam je schopna dojst lopta po odkopnuti
double KickDistance(CLocalAgent *pa)
{

	// zavisi od maxpower*kickwantedtoreal*...

    return 20;
}


//--------------------------------------------------------------------------
// Dash
//--------------------------------------------------------------------------

void CBasicSkills::Dash2(CLocalAgent *pa, double accel)
{
    Dash(pa, DashRealToWanted(pa, accel));
}

double CBasicSkills::DashRealToWanted(CLocalAgent *pa, double accel)
{
    // todo: zapocitat staminu

    return accel / (cfg->dash_power_rate);
}


//--------------------------------------------------------------------------
// Turn
//--------------------------------------------------------------------------

void CBasicSkills::Turn2(CLocalAgent *pa, double angle)
{
    Turn(pa, TurnRealToWanted(pa, angle));
}

double CBasicSkills::TurnWantedToReal(CLocalAgent *pa, double angle)
{
    return angle / (1.0 + cfg->inertia_moment * pa->GetSpeed().GetDistance());
}

double CBasicSkills::TurnRealToWanted(CLocalAgent *pa, double moment)
{
    return moment * (1.0 + cfg->inertia_moment * pa->GetSpeed().GetDistance());
}


//--------------------------------------------------------------------------
// Turn Neck
//--------------------------------------------------------------------------

void CBasicSkills::TurnNeckTo(CLocalAgent *pa, C2DVector pos)
{
    C2DVector necktopos = Rot(pos - (C2DVector)pa->GetPosition(), -pa->GetNeckDirection());
    TurnNeck(pa, necktopos.GetAngle());
}

void CBasicSkills::TurnNeckToBall(CLocalAgent *pa)
{
    CBall *pBall = pa->GetWorldModel()->GetBall();
    CDiffuse2DVector vball = pBall->GetPosition() - pa->GetPosition();
    double necktoball = vball.GetAngle() - pa->GetNeckDirection();
    TurnNeck(pa, necktoball);
}

void CBasicSkills::TurnNeckStraight(CLocalAgent *pa)
{
    double neckang =  pa->GetDirection() - pa->GetNeckDirection();
    if ((neckang < DegToRad(-1.0)) || (neckang > DegToRad(1.0))) TurnNeck(pa, neckang);
}


//--------------------------------------------------------------------------
// Kick
//--------------------------------------------------------------------------

void CBasicSkills::Kick2(CLocalAgent *pa, double accel, double dir)
{
    // treba dat pozor aby sme nekopli do seba (prip. do ineho hraca???)

    // treba zapocitat rychlost lopty + natocenie
    C2DVector vkick = KickRealToWanted(pa, accel, dir);
    Kick(pa, vkick.GetDistance(), vkick.GetAngle());

}

C2DVector CBasicSkills::KickRealToWanted(CLocalAgent *pa, double accel, double dir)
{
    // treba zapocitat rychlost lopty + natocenie
    CBall *pBall = pa->GetWorldModel()->GetBall();
    C2DVector vball = RelVectorTo(pa, pBall->GetPosition());
    double dist_ball = vball.GetDistance();
    double dir_diff = fabs(RadToDeg(vball.GetAngle()));
    double factor = cfg->kick_power_rate * (1.0 - 0.25 * dir_diff / 180.0 - 0.25 * (dist_ball - cfg->player_size - cfg->ball_size) / cfg->kickable_margin);

    C2DVector vkick;
    vkick.SetAngleDistance(dir, accel);
//    vkick -= pBall->GetSpeed();
	vkick.SetDistance(vkick.GetDistance() / factor);
	return vkick;
}

C2DVector CBasicSkills::KickWantedToReal(CLocalAgent *pa, double accel, double dir)
{
    // treba zapocitat rychlost lopty + natocenie
    CBall *pBall = pa->GetWorldModel()->GetBall();
    C2DVector vball = RelVectorTo(pa, pBall->GetPosition());
    double dist_ball = vball.GetDistance();
    double dir_diff = fabs(RadToDeg(vball.GetAngle()));
    double factor = cfg->kick_power_rate * (1.0 - 0.25 * dir_diff / 180.0 - 0.25 * (dist_ball - cfg->player_size - cfg->ball_size) / cfg->kickable_margin);

    C2DVector vkick;
    vkick.SetAngleDistance(dir, accel);
	vkick.SetDistance(vkick.GetDistance() * factor);
//    vkick += pBall->GetSpeed();
	return vkick;
}





//--------------------------------------------------------------------------
// Basic Skills
//--------------------------------------------------------------------------


void CBasicSkills::TurnTo(CLocalAgent *pa, C2DVector pos)
{
    Turn2(pa, RelVectorTo(pa, pos).GetAngle());
}


void CBasicSkills::GoTo(CLocalAgent *pa, C2DVector pos, double accel)
{
    C2DVector topos = RelVectorTo(pa, pos);
    double ang = topos.GetAngle();

    if (topos.GetDistance() < cfg->kickable_area)  return;

    // zistujeme, ci je v ceste nejaky hrac
    CAgent *paiw = PlayerInWay(pa, ang);
    if (paiw) {
        // tu sa riesi vyhybanie sa hracovi
        C2DVector toplr = RelVectorTo(pa, paiw->GetPosition());
        double pldist = toplr.GetDistance();
        double pldir = toplr.GetAngle();
//        LOGMSG(1, "player in way - dist %lf, dir %lf",pldist,pldir);

        // vyhybame sa iba ked je hrac blizsie ako miesto kam chceme ist
        if (pldist < topos.GetDistance())
            (pldir > 0) ? ang -= (MinimalDirection(pldist, paiw->GetPosition().GetDiffusion()) - pldir)
                        : ang += (MinimalDirection(pldist, paiw->GetPosition().GetDiffusion()) + pldir);
    }

    double mindir = DegToRad(5.0); // aby sme sa stale netocili
    if ((ang > -mindir) && (ang < mindir)) 
    {
        if (accel==0) {
            // vypocet accel, aby tam agent presne zastavil
            accel = (topos - (C2DVector)pa->GetSpeed()).GetDistance();
        }
        Dash2(pa, accel);
    }
    else 
    {
        Turn2(pa, ang);
    }
}

void CBasicSkills::KickTo(CLocalAgent *pa, C2DVector pos, double accel)
{
    // vektor od lopty k pozicii kam treba strelit
    C2DVector v = pos - (C2DVector)pa->GetWorldModel()->GetBall()->GetPosition();
//    C2DVector toball = RelVectorTo(pa, pos);
    // smer vektoru relativne k natoceniu hraca
    double ang = Rot(v, -pa->GetDirection()).GetAngle();
//    double ang = toball.GetAngle();

    if (accel==0) {
        // vypocet accel zo vzdialenosti pos aby tam lopta akurat prisla
        // accel = |vektor_k_pos - vektor_k_lopte|
        accel = v.GetDistance() * (1 - cfg->ball_decay ) + 0.1;

	}
    Kick2(pa, accel, ang);
//    Kick(pa, accel, ang);
}


void CBasicSkills::DribbleTo(CLocalAgent *pa, C2DVector pos, double spd, double safe)
{
    // Dorobit vyhybanie sa ostatnym hracom!

    if (BallKickable(pa)) {
//        TurnNeckTo(pa, pos);
        KickTo(pa, pos, spd);

    } else {
//        TurnNeckStraight(pa);
        C2DVector ballpos = pa->GetWorldModel()->GetBall()->GetPosition();
        double pow = spd;   //taka sila, aby zastal tesne pred loptou
        GoTo(pa, ballpos, pow);
    }

}




//--------------------------------------------------------------------------
// Ohodnocovacie skills
//--------------------------------------------------------------------------

bool CBasicSkills::BallKickable(CLocalAgent *pa)
{
    double disttoball = RelVectorTo(pa, pa->GetWorldModel()->GetBall()->GetPosition()).GetDistance();
    double dist = cfg->kickable_area - disttoball;
    if (dist < 0) return false;
    return true;
}


bool CBasicSkills::NearGoal(CLocalAgent *pa, EGoalType g)
{
    /*
    C2DVector p = pa->GetPosition();
    C2DVector k;
    k.SetAngleDistance(pa->GetDirection(), 0.90*KickDistance(pa));



    switch(g) {
    case GT_L:
        break;
    case GT_R:
        break;
    default:
    }



    CDiffuse2DVector goal(goalpos, 0);
    CDiffuse2DVector vgoal = goal - pa->GetPosition();
    double disttogoal = vgoal.GetDistance();
    double diffugoal = vgoal.GetDiffusion();
    double dist = 20 - disttogoal; // FIXME - nie 20, ale nejako vyratat odkial uz mozem strielat do brany
    // TODO nepocitat s brankou ako s bodom ale s celou brankou!
    if (dist < 0) return false;
    return true;
    */
    return false;
}



CAgent *CBasicSkills::PlayerInWay(CLocalAgent *pa, double dir)
{
    CWorldModel *pwm = pa->GetWorldModel();
    Agents *pia = pwm->GetIdentifiedAgents();
    Agents *pua = pwm->GetUnidentifiedAgents();

    int i;
    C2DVector toplr, toplr2;
    double pldir;
    double pldist, pldist2;
    double mindir;
    CAgent *pnow = NULL;
    CAgent *pret = NULL;

    LOGMSG(1, "search 4 player in way (see total %d players)", pia->size()+pua->size());


    // hladame medzi identifikovanymi hracmi
	for(i=0; i < pia->size(); i++)
	{
        pnow = pia->at(i);
        // vektor na hraca
        toplr = RelVectorTo(pa, pnow->GetPosition());
        pldir = toplr.GetAngle();
        pldist = toplr.GetDistance();
        mindir = MinimalDirection(pldist, pnow->GetPosition().GetDiffusion());
        if ((pldir > -mindir) && (pldir < mindir)) {
            if (pret) {
                toplr2 = RelVectorTo(pa, pret->GetPosition());
                pldist2 = toplr2.GetDistance();
                // vratime toho co je blizsie
                if( pldist < pldist2) pret = pnow;
            }
            else {
                pret = pnow;
            }
        }

        LOGMSG(1, "PLAYER %d: dir %lf, dist %lf  (mindir %lf)", i, pldir, pldist, mindir);

    }

    // hladame medzi neidentifikovanymi hracmi
    for(i=0;i<pua->size();i++)
	{
        pnow = pua->at(i);
        // vektor na hraca
        toplr = RelVectorTo(pa, pnow->GetPosition());
        pldir = toplr.GetAngle();
        pldist = toplr.GetDistance();
        mindir = MinimalDirection(pldist, pnow->GetPosition().GetDiffusion());
        if ((pldir > -mindir) && (pldir < mindir)) {
            if (pret) {
                toplr2 = RelVectorTo(pa, pret->GetPosition());
                pldist2 = toplr2.GetDistance();
                // vratime toho co je blizsie
                if( pldist < pldist2) pret = pnow;
            }
            else {
                pret = pnow;
            }
        }

        LOGMSG(1, "PLAYER %d: dir %lf, dist %lf  (mindir %lf)", i, pldir, pldist, mindir);

    }

    return pret;
}

/*
double CBasicSkills::NearestOpponentToBall(CLocalAgent *pa)
{


    return 0;
}
*/




// odhadnuta pozicia lopty po case dTime krokov a s pociatiocnou rychlostou cNewBallSpeed
C2DVector CBasicSkills::BallPosition(CLocalAgent *pa, int nTime, C2DVector cNewBallSpeed)
{
    C2DVector cBallPos = pa->GetWorldModel()->GetBall()->GetPosition();

    // geometricky rad - postupne spomalovanie lopty
    double x;
    if (cfg->ball_decay != 1)
        x = (pow(cfg->ball_decay, (double)nTime) - 1) / (cfg->ball_decay - 1);
    else
        x = nTime * cfg->ball_decay;

    return cBallPos + cNewBallSpeed * x;
}


// pozor na cNewBallSpeed! (treba asi pouzit KickWantedToReal)
C2DVector CBasicSkills::GetBallInterceptPosition(CLocalAgent *pa, C2DVector cNewBallSpeed)
{
    C2DVector v(NOT_EXISTING, NOT_EXISTING);

    // ratame s tym, ze sa musi najprv otocit do spravneho uhlu.
    // keby sa dalo nejako zistit ci sa musi otocit alebo nie, bolo by to presnejsie
    int nTurn = 1;

    // - ratanie polohy playera
    C2DVector cNewPos, cSpd, cAccel, cu;
//    cNewPos = pa->GetPosition();
    cNewPos.SetXY(0, 0);
    cAccel.SetAngle(pa->GetDirection());
    cSpd.SetXY(0,0);
//    cSpd = pa->GetSpeed();    // ked bude fungovat rychlost...
    // -


    for (int i=0; i < 20; i++)    // pokial to ma ist ???
    {
        // - ratanie polohy playera
        cAccel.SetDistance(cfg->maxpower * cfg->dash_power_rate); // todo: zapocitat staminu!
        if (cAccel.GetDistance() > cfg->player_accel_max) cAccel.SetDistance(cfg->player_accel_max);
        cu = cSpd + cAccel;
        cNewPos += cu;
        cSpd = cu * cfg->player_decay;
        if (cSpd.GetDistance() > cfg->player_speed_max) cSpd.SetDistance(cfg->player_speed_max);
        // -

        // poloha lopty
        v = BallPosition(pa, i + nTurn, cNewBallSpeed);

        if (RelVectorTo(pa, v).GetDistance() < cNewPos.GetDistance())
        {
            break;
        }

        v.SetXY(NOT_EXISTING, NOT_EXISTING);
    }



    if (i<19) LOGMSG(1, "+time %d : disttoball %lf, howfaricanget %lf", i, RelVectorTo(pa, v).GetDistance(), cNewPos.GetDistance());

    return v;
}





CAgent *CBasicSkills::NearestFriendToBall(CLocalAgent *pa)
{
    CWorldModel *pwm = pa->GetWorldModel();
    Agents *pia = pwm->GetIdentifiedAgents();

    int i;
    C2DVector toplr, toplr2;
    double mindist;
    CAgent *pnow = NULL;
    CAgent *pret = NULL;

    ESide myside = pa->GetPlayerSide();

    C2DVector ballpos = pa->GetWorldModel()->GetBall()->GetPosition();
    C2DVector toball = RelVectorTo(pa, ballpos);

    mindist = NOT_EXISTING;
    pret = NULL;

    double distplr2ball;

    // hladame medzi identifikovanymi hracmi
	for(i=0; i < pia->size(); i++)
	{
        pnow = pia->at(i);
        if (pnow->GetPlayerSide() == myside) {
            // vektor na hraca
            toplr = RelVectorTo(pa, pnow->GetPosition());

            distplr2ball = (toball - toplr).GetDistance();

			if (distplr2ball < mindist) {
				pret = pnow;
				mindist = distplr2ball;
			}
        }
    }

    return pret;
}




CAgent *CBasicSkills::FreestFriend(CLocalAgent *pa)
{
    CWorldModel *pwm = pa->GetWorldModel();
    Agents *pia = pwm->GetIdentifiedAgents();
    int i;
    CAgent *pnow = NULL;
    CAgent *pret = NULL;

	ESide myside = pa->GetPlayerSide();

	double dClosestOpp, dMinimum = NOT_EXISTING;

    // hladame medzi identifikovanymi hracmi
	for(i=0; i < pia->size(); i++)
	{
        pnow = pia->at(i);
        if (pnow->GetPlayerSide() == myside) {
			dClosestOpp = DistToClosestOpponent(pa, pnow->GetPosition());
			if (dClosestOpp <= dMinimum) {
				dMinimum = dClosestOpp;
				pret = pnow;
			}
        }
    }

    return pret;

}



double CBasicSkills::DistToClosestOpponent(CLocalAgent *pa, C2DVector cFriendPos)
{
	// todo: mozno by bolo dobre neidentifikovaneho playera chapat ako oponenta

	C2DVector tofriend = RelVectorTo(pa, cFriendPos);

    CWorldModel *pwm = pa->GetWorldModel();
    Agents *pia = pwm->GetIdentifiedAgents();
    int i;
    CAgent *pnow = NULL;
	double dOppDist, dRet = NOT_EXISTING;

    ESide myside = pa->GetPlayerSide();

	for(i=0; i < pia->size(); i++)
	{
        pnow = pia->at(i);
        if (pnow->GetPlayerSide() != myside) {
			dOppDist = (RelVectorTo(pa, pnow->GetPosition()) - tofriend).GetDistance();
			if (dOppDist < dRet) dRet = dOppDist;
        }
    }
    return dRet;
}





