// ServerConnection.cpp : implementation file
//

#include "stdafx.h"
#include "Player.h"
#include "ServerConnection.h"
#include "ToDoEvent.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CServerConnection

CServerConnection::CServerConnection()
{
    m_bInitialized = FALSE;

    // FIXME
    // m_mSrvMsgBuff.m_sMessage[0] = 0;
}

CServerConnection::~CServerConnection()
{
	if (m_hSocket != INVALID_SOCKET)
		Close();
}

void CServerConnection::Initialize(CSystemClock *pSysClock, CServerCommunicator *pSrvComm)
{ 
    m_pSystemClock = pSysClock; 
	m_pSrvComm = pSrvComm;
    m_bInitialized = TRUE;   // FIXME - testovat v inych rutinach
};

// Do not edit the following lines, which are needed by ClassWizard.
#if 0
BEGIN_MESSAGE_MAP(CServerConnection, CAsyncSocket)
	//{{AFX_MSG_MAP(CServerConnection)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
#endif	// 0

/////////////////////////////////////////////////////////////////////////////
// CServerConnection member functions

BOOL CServerConnection::Connect(LPCTSTR lpszHostAddress, UINT nHostPort)
{
	if (!Create(0, SOCK_DGRAM, FD_READ))
		return FALSE;

	memset(&m_sSockAddr, 0, sizeof(m_sSockAddr));
	LPSTR lpszAscii = (LPTSTR) lpszHostAddress;
	m_sSockAddr.sin_family	= AF_INET ;
	m_sSockAddr.sin_addr.s_addr = inet_addr(lpszAscii) ;
	if (m_sSockAddr.sin_addr.s_addr == INADDR_NONE)
	{
		LPHOSTENT lphost;
		lphost = gethostbyname(lpszAscii);
		if (lphost != NULL)
			m_sSockAddr.sin_addr.s_addr = ((LPIN_ADDR) lphost->h_addr)->s_addr;
		else
		{
			WSASetLastError(WSAEINVAL);
			return FALSE;
		}
	}
	m_sSockAddr.sin_port = htons((u_short) nHostPort) ;

	return TRUE;
}

void CServerConnection::OnReceive2(int nErrorCode)
{
	char szBuff[65467];
   	int nSockAddrLen = sizeof(m_sSockAddr);
	int nResult = CAsyncSocket::ReceiveFrom(szBuff, sizeof (szBuff), (SOCKADDR*)&m_sSockAddr,
											&nSockAddrLen, 0);
	if(nResult == SOCKET_ERROR) return;

    int nSystemTime = m_pSystemClock->GetTime();
    szBuff[nResult] = 0;

    // FIXME - implementovat buffer
    // nastavime cas prijatia (dame aktualny => presnost podla threadov)
    m_mSrvMsgBuff.m_tReceivedTime = nSystemTime;
	m_mSrvMsgBuff.m_sMessage = szBuff;

    if (szBuff[3]=='n') fprintf(m_ff, "SenseBody[ %d ]\t", nSystemTime);
    if (szBuff[3]=='e') fprintf(m_ff, "See[ %d ]\t\t", nSystemTime);
    // vypisuj len 32 znakov
    if (strlen(szBuff) > 32) {
        szBuff[32] = 0;
        fprintf(m_ff, "->  %s...\n", szBuff);
    } else fprintf(m_ff, "->  %s", szBuff);
	//TRACE("Received [%d]: %s...\n", nSystemTime, szBuff);

//    m_pSrvComm->OnReceiveServerMsg();
//    if (szBuff[3]=='n') m_pSrvComm->OnSynchTimer(); // FIXME - len 

    static CEvent event;
    event.m_eType = ET__RECEIVED_MSG;
    EventDispatcher.SendEvent(&event);
}

void CServerConnection::OnReceive(int nErrorCode) 
{
    OnReceive2(nErrorCode);
//  fprintf(m_ff, "Receive_msg[ %d ].\n", m_pSystemClock->GetTime());

//    m_pSrvComm->m_pSendCommandSeq->Clear();
    EventDispatcher.Handle();
}

int CServerConnection::SendMsg(CServerMsg& cMsg)
{
	TRACE("Sending: %s\n", cMsg.m_sMessage.c_str());

    cMsg.m_tReceivedTime = m_pSystemClock->GetTime();
	int res = CAsyncSocket::SendTo(cMsg.m_sMessage.c_str(), cMsg.m_sMessage.size(),
                                   (SOCKADDR*) &m_sSockAddr, sizeof (m_sSockAddr), 0);

    fprintf(m_ff, "Sent[ %d ]\t\t<-  %s\n", cMsg.m_tReceivedTime, cMsg.m_sMessage.c_str());

    return res;
}

CServerMsg *CServerConnection::ReceiveMsg(void) 
{
    // FIXME
    if (m_mSrvMsgBuff.m_sMessage[0] == 0) return NULL;
    
    // FIXME - vratime kopiu, aby sme mohli nacitavat dalej
    m_mSrvMsgBuff2 = m_mSrvMsgBuff;  m_mSrvMsgBuff.m_sMessage[0] = 0;
    return &m_mSrvMsgBuff2;
}
