#ifndef SERVERCOMMUNICATOR_H
#define SERVERCOMMUNICATOR_H

#include "GameState.h"
#include "ServerConnection.h"
#include "ServerMsgTranslator.h"
#include "Perception.h"
#include "ToDoClasses.h"

class CServerCommunicator
{
private:
    int nLastDeliberateTime;
    int nLastSendTime;

private:
public:
	CGameState *m_pGameState;
    CPerceptionSeq *m_pPerceptionSeq;     // perception sequence
    CGameCommandSeq *m_pSendCommandSeq;   // FIXME - mozu byt aj vo vlastnej rezii
    CGameCommandSeq *m_pSentCommandSeq;

private:
    CSystemClock *m_pSystemClock;
    CServerConnection *m_pServerConnection;
    CServerMsgTranslator *m_pServerMsgTranslator;

private:
    Bool m_bSynchronized;
    int m_nSynchPlayTime;
    int m_nSynchSystemTime;
    int m_nLastSystemTime;

public:
	CServerCommunicator();
    virtual ~CServerCommunicator();

    void Initialize(CGameState *pGameState,
                    CPerceptionSeq *pPerceptionSeq,
                    CSystemClock *pSysClock,
                    CServerConnection *pSrvConnection,
                    CServerMsgTranslator *pSrvTranslator);

	void OnReceiveServerMsg();
	void OnSynchTimer(int nTimeToNextCall = 0);

    int UpdateGameTime(int nSystemTime);
    void UpdateSynchTime(int nPlayTime, int nSystemTime);
    void UpdateGameState(CPerception *pPerception);

    void ProcessReceivedSrvMsgs();
    void SendCommands(CGameCommandSeq *pSendCommands);
};

#endif  // SERVERCOMMUNICATOR_H

