// VisualSetupDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Player.h"
#include "VisualSetupDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CPlayerApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CVisualSetupDlg dialog


CVisualSetupDlg::CVisualSetupDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CVisualSetupDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CVisualSetupDlg)
	m_bDrawPerceptions = FALSE;
	m_bDrawTeammateInfo = FALSE;
	m_bDrawOpponentInfo = FALSE;
	m_bDrawBallInfo = TRUE;
	m_bDrawLocalAgentInfo = FALSE;
	//}}AFX_DATA_INIT

	m_bDrawPerceptions = theApp.GetPerceptionsSetup();
	m_bDrawTeammateInfo = theApp.GetTeammateSetup();
	m_bDrawOpponentInfo = theApp.GetOpponentSetup();
	m_bDrawBallInfo = theApp.GetBallSetup();
	m_bDrawLocalAgentInfo = theApp.GetAgentSetup();
}


void CVisualSetupDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVisualSetupDlg)
	DDX_Check(pDX, IDC_CB_PERCEPTION_VIEW, m_bDrawPerceptions);
	DDX_Check(pDX, IDC_CB_DRAW_TEAMMATE_INFO, m_bDrawTeammateInfo);
	DDX_Check(pDX, IDC_CB_DRAW_OPPONENT_INFO, m_bDrawOpponentInfo);
	DDX_Check(pDX, IDC_CB_DRAW_BALL_INFO, m_bDrawBallInfo);
	DDX_Check(pDX, IDC_CB_DRAW_AGENT_INFO, m_bDrawLocalAgentInfo);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CVisualSetupDlg, CDialog)
	//{{AFX_MSG_MAP(CVisualSetupDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVisualSetupDlg message handlers

void CVisualSetupDlg::OnOK() 
{
	// TODO: Add extra validation here	
	UpdateData( TRUE );
	
	theApp.SetAgentSetup( m_bDrawLocalAgentInfo );
	theApp.SetBallSetup( m_bDrawBallInfo );
	theApp.SetOpponentSetup( m_bDrawOpponentInfo );
	theApp.SetPerceptionSetup( m_bDrawPerceptions );
	theApp.SetTeammateSetup( m_bDrawTeammateInfo );

	CDialog::OnOK();
}
