// LogManager.h: interface for the CLogManager class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_LOGMANAGER_H__33CB9640_18C2_11D5_A8C6_0080C6F7E305__INCLUDED_)
#define AFX_LOGMANAGER_H__33CB9640_18C2_11D5_A8C6_0080C6F7E305__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#pragma warning (disable : 4786)

#include "TextMessageBuffer.h"

#include <map>
#include <string>
using namespace std;

#ifdef _NO_LOG_FILES_
	#define LOGMSG			1 ? 0 : ::log_msg
#else
	#define LOGMSG			::log_msg
#endif

extern void log_msg( DWORD priority, const char* str, ...);

struct _iobuf;
typedef struct _iobuf FILE;

struct SFilePriorityMask
{
	FILE* file_hande;												// ukazotel na subor
	DWORD upper_mask;												// maska suboru, horne 4 bity
	DWORD active_priority;											// momentalne nastavena priorita
};

class CLogManager {

	CTextMessageBuffer text_buffer;
	map< string,SFilePriorityMask>		m_vFiles;				// zoznam nazvov suborov, handle a maska priorit

public :

	CLogManager();
	virtual ~CLogManager();

	FILE* GetFileHandle( char* sFileName );

	void AddNewFile( char* sName, DWORD mask );						// vytvorenie noveho log. suboru

	void AddActivePriority( char* sName, DWORD dNewPriority );
	void RemoveActivePriority( char* sName, DWORD dRemPriority );

	void AddMessageText( FILE* pFile, DWORD dPriority, const char* fmt, va_list args );

	CMessageList* GetMessageList( void )
	{
		return text_buffer.GetMessageList();
	}
};

extern CLogManager cLogManager;

#endif // !defined(AFX_LOGMANAGER_H__33CB9640_18C2_11D5_A8C6_0080C6F7E305__INCLUDED_)
