// GameCommand.cpp: implementation of the CGameCommand class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Player.h"
#include "GameCommand.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CGameCommand::~CGameCommand()
{

}


//! todo doplnit generovanie ostatnych sprav pre server
bool CGameCommand::GenerateMessage(char* buff)
{
    switch (m_tCmdType) {
    case CT__DASH: 
        sprintf(buff, "(dash %.2lf)", m_dArg1);
        return true;
    case CT__TURN: 
        sprintf(buff, "(turn %.2lf)", m_dArg1);
        return true;
    case CT__NECK: 
        sprintf(buff, "(turn_neck %.2lf)", m_dArg1);
        return true;
    case CT__CATCH: 
        sprintf(buff, "(catch %.2lf)", m_dArg1);
        return true;
    case CT__KICK:
        sprintf(buff, "(kick %.2lf %.2lf)", m_dArg1, m_dArg2);
        return true;
    case CT__MOVE:
        sprintf(buff, "(move %.2lf %.2lf)", m_dArg1, m_dArg2);
        return true;
    }
    return false;
}

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CGameCommandSeq* CGameCommandSeq::AddGameCommand(CGameCommand *pGameCommand) 
{
	m_cGameCommands.push(pGameCommand);
	return this;
}

bool CGameCommandSeq::GetGameCommand(CGameCommand **pGameCommand)
{
	if(m_cGameCommands.size() > 0)
	{
		*pGameCommand = m_cGameCommands.front();
		m_cGameCommands.pop();
		return true;
	}
	else return false;
}

int CGameCommandSeq::GetGameCommandsCount() {
	return m_cGameCommands.size();
}

void CGameCommandSeq::Clear()
{
    while (!m_cGameCommands.empty()) {
        delete m_cGameCommands.front();
        m_cGameCommands.pop();
    }
}

