#ifndef WORLDOBJECTS_H
#define WORLDOBJECTS_H

#include "WorldGeometry.h"
#include "Perception.h"
#include "ToDoClasses.h"
#include "types.h"
#include "Skills.h"
#include <vector>

using namespace std;


typedef vector<double> doublevector;

typedef vector<CDiffuse2DVector> DiffusePointVector;


class CMovingObject
{
protected:
	double m_direction;
	CDiffuse2DVector m_position,m_speed,m_acceleration;
	CDiffuse2DVector m_prev_position,m_prev_speed,m_prev_acceleration;
	double m_probability;

	CAngular2DVector m_see_position,m_see_speed;

	int m_last_seen;

	DWORD m_see_status;

    bool i_am_local;

public:

						CMovingObject()
                        {
                            m_probability=0;
                            m_see_status=0;
                            i_am_local=false;
                        }
	const CDiffuse2DVector &GetPosition() const
                        {
                            return m_position;
                        }
	const CDiffuse2DVector &GetSpeed   () const 
                        {
                            return m_speed;
                        }
	const CDiffuse2DVector &GetAcceleration   () const
                        {
                            return m_acceleration;
                        }
	double              GetProbability()  const 
                        {
                            return m_probability;
                        }
	double              GetDirection() const 
                        {
                            return m_direction;
                        }
	void				SetPosition(const CDiffuse2DVector &p)
                        {
                            m_prev_position=m_position;
                            if((m_see_status & SEE_DISTANCE ||  m_see_status & EXPECTED_DISTANCE) ||
                               (m_see_status & SEE_ANGLE || m_see_status & EXPECTED_ANGLE))
                            {
                                m_see_status|=PREV_POSITION;
                            }
                            else
                            {
                                m_see_status&=!PREV_POSITION;
                            }


                            m_position=p;
                        }
	void				SetSpeed   (const CDiffuse2DVector &s)
                        {
                            if((m_see_status & SEE_DISTANCE_CHANGE ||  m_see_status & EXPECTED_DISTANCE_CHANGE) ||
                               (m_see_status & SEE_ANGLE_CHANGE || m_see_status & EXPECTED_ANGLE_CHANGE))
                            {
                                m_see_status|=PREV_SPEED;
                            }
                            else
                            {
                                m_see_status&=!PREV_SPEED;
                            }
                            m_speed=s;
                        }
	void				SetAcceleration(const CDiffuse2DVector &a)
                        {
                            if(m_see_status & EXPECTED_ACCELERATION)
                            {
                                m_see_status|=PREV_ACCELERATION;
                            }
                            else
                            {
                                m_see_status&=!PREV_ACCELERATION;
                            }

                            m_acceleration=a;
                        }
	void				SetProbability(double p)
                        {
                            m_probability=p;
                        }
	void				SetDirection(double d)
                        {
                            m_direction=d;
                        }
//	void	virtual		Precompute(int stepcount,CGameCommand *command){}

	const CAngular2DVector &GetSeePosition() const
                        {
                            return m_see_position;
                        }
	const CAngular2DVector &GetSeeSpeed() const
                        {
                            return m_see_speed;
                        }
	int					 GetLastSeen() const
                        {
                            return m_last_seen;
                        }
	DWORD				 GetSeeStatus() const
                        {
                            return m_see_status;
                        }

	void SetSeePosition(const CAngular2DVector &pos)
                        {
                            m_see_position=pos;
                        }
	void SetSeeSpeed(const CAngular2DVector &speed)
                        {
                            m_see_speed=speed;
                        }
	void SetLastSeen(int ls)
                        {
                            m_last_seen=ls;
                        }
	void SetSeeStatus(DWORD stats,DWORD mask)
                        {
                            m_see_status=stats ^ (mask & (stats ^ m_see_status));
                        }


	void virtual Precompute();
};


class CWorldModel;



const int APP_GR_DEFAULT=32;

class CAgent:public CMovingObject
{
protected:
	double	m_neck_direction;
	double	m_stamina;
	double	m_effort;
	int		m_visual_settings;
	int		m_local_number;

	doublevector m_approach_distances;

	int m_number;
	int m_side;
	double m_goalie;

	CWorldModel *m_my_world;

	
public:

    CAgent():CMovingObject()
			{
				m_visual_settings=0;
				SetApproachDistanceGranularity(APP_GR_DEFAULT);
                m_number=UNKNOWN;
                m_side=UNKNOWN;
                m_goalie=0;
			}
	double	GetNeckDirection() const
			{
				return m_neck_direction;
			}
	double	GetStamina() const
			{
				return m_stamina;
			}
	int		GetVisualSettings() const
			{
				return m_visual_settings;
			}
	int		GetLocalNumber() const
			{
				return m_visual_settings;
			}
    double  GetViewAngle() const
            {
                switch(m_visual_settings)
                {
                    case    VISUAL_RANGE_NARROW : return PI/2;
                    case    VISUAL_RANGE_NORMAL : return PI;
                    case    VISUAL_RANGE_WIDE   : return PI*2;
                }
                return 0;
            }
	int		GetApproachDistanceGranularity() const
			{
				return m_approach_distances.size();
			}
	double	GetApproachDistance(); const

	void	SetApproachDistanceGranularity(int gr)
			{
				m_approach_distances.resize(gr);
				for(int i=0;i<m_approach_distances.size();i++) m_approach_distances[i]=0;
			}
	void	SetNeckDirection(double nd)
			{
				m_neck_direction=nd;
			}
	void	SetStamina(double st)
			{
				m_stamina=st;
			}
	void	SetVisualSettings(int vs)
			{
				m_visual_settings=vs;
			}
	void	SetLocalNumber(int ln)
			{	
				m_local_number=ln;
			}

	bool command_used;


	int GetPlayerNumber() const
            {
                return m_number;
            }
	int GetPlayerSide() const
            {
                return m_side;
            }
	double GetGoalie() const
            {
                return m_goalie;
            }
	
	void SetPlayerNumber(int nr)
            {
                m_number=nr;
            }
	void SetPlayerSide(int ps)
            {
                m_side=ps;  
            }
	void SetGoalie(double gl)
            {
                m_goalie=gl;
            }

	double	virtual TestOwnership(const CSeenPlayer &player,const CAgent &local);//ughly&nasty
	void	virtual Update(CSeenPlayer &player,const CAgent &local);//ughly
	virtual CGameCommand *GetCommand();//nasty
	void	virtual	Precompute();//nasty

	void	UpdateApproachDistances(const CMovingObject &obj,const CAgent &local);//ughly
};


class CBall:public CMovingObject
{
public:
	void UpdateBallPosition(CSeenObject _oBall,const CAgent &seeing);//ughly
	void virtual Precompute();//nasty
};


#define GOT_SEE 1
#define GOT_SENSE_BODY 2
#define GOT_HEAR 4
#define GOT_ALL 7

class CLocalAgent:public CAgent
{
public:
    CGameCommandSeq *actionseq;
    CBasicSkills *bskl;

protected:
    int m_time;

public:

    int GetTime() const
    {
        return m_time;
    }

    void SetTime(int t)
    {
        m_time=t;
    }

    CLocalAgent();
    virtual ~CLocalAgent();

    void Deliberate(CPerceptionSeq *pPerceptionSeq, CGameCommandSeq *pGameCommandSeq);
    bool UpdatePlayerPosition(CSeenFlagsVect &_fFlags, CSeenGoalsVect &_gGoals, CSeenLinesVect &_lLines);//nasty&ughly
    bool UpdatePlayerProperties(CSenseBody *sense_body);
    bool UpdatePlayerSeenObjects(CPerception *Perception);
};


typedef vector<CAgent*> Agents;


class CWorldModel
{
	CBall *m_ball;

	Agents m_identified_agents;
	Agents m_unidentified_agents;
//	Agents m_seen_agents;
public:    


	CWorldModel()
	{
		m_ball=new CBall;
	}
	void Recompute(CPerception *Perception,const CAgent &local);
	void Precompute();//nasty
	~CWorldModel()
	{
		delete m_ball;
		int i;
		for(i=0;i<m_identified_agents.size();i++)
		{
			delete m_identified_agents[i];
		}
		for(i=0;i<m_unidentified_agents.size();i++)
		{
			delete m_unidentified_agents[i];
		}

//		for(i=0;i<m_seen_agents.size();i++)
//		{
//			delete m_seen_agents[i];
//		}
	}
    CBall *GetBall() { return m_ball; };
};

#endif