// WorldObjects.cpp: implementation of various world object types....
//
//////////////////////////////////////////////////////////////////////

#include "stdAfx.h"
#include "WorldObjects.h"
#include "staticfield.h"
#include "Player.h"
#include "Coordinator.h"

#include "ChildView.h"  // FIXME
#include "ToDoEvent.h"
#include "TextMessageBuffer.h"


CStaticField field;

inline double WeightFn(double d)
{
	return 1.0 / (0.01 + d);
}

CLocalAgent::CLocalAgent():CAgent()
{
	m_time = 0;
	m_my_world = new CWorldModel;

    bskl = new CBasicSkills;
}

CLocalAgent::~CLocalAgent()
{
    if (m_my_world) { delete m_my_world;  m_my_world = NULL; }

    if (bskl) { delete bskl;  bskl = NULL; }
}


void CLocalAgent::Deliberate(CPerceptionSeq *pPerceptionSeq, CGameCommandSeq *pGameCommandSeq)
{
    // poznacime si GameCommandSeq do kontextu kvoli skillsom
    actionseq = pGameCommandSeq;

    CPerception *pPerception;

	static CPerception world_perception;
    static CPerception rPerception0;  // FIXMEEE: pouzivane len na vizualizaciu 

	int received_info;
    int received_info0 = 0;

    // FIXMEEE: neviem ako inak zistit, ci je lopta vo vnutornom svete 
    //   viditelna (aktualna) v tomto kroku -> tak ju vymazem a dole otestujem
    m_my_world->GetBall()->SetSeeStatus(0, 0);

    while (pPerceptionSeq->GetPerception(&pPerception))
	{
		while(pPerception->GetPlayTime()>m_time)
		{
			if(received_info & GOT_SEE)
			{
				UpdatePlayerSeenObjects(&world_perception);
			}
			received_info=0;
			Precompute();
            break;  // FIXMEEEE
        }

		switch(pPerception->GetMsgType())
		{
			case MT_See:
			{
				world_perception = *pPerception;  // brrrrr
				received_info |= GOT_SEE;

				UpdatePlayerPosition(pPerception->GetSeenFlags(), pPerception->GetSeenGoals(),pPerception->GetSeenLines());

				if (m_pReadyView)
				{
					rPerception0 = *pPerception;  // brrrrr
					m_pReadyView->SetNewPerception(&rPerception0);

					CChildView *vv = m_pReadyView;

					vv->m_pAgent->SetPosition(GetPosition());
					vv->m_pAgent->SetDirection(GetDirection());
					vv->m_pAgent->SetNeckDirection(GetNeckDirection());
					m_pReadyView = NULL;  // FIXMEEEE
					vv->Invalidate();
                }
			}
			break;
			case MT_Hear:
			{
				received_info |= GOT_HEAR;
				fprintf(m_ff, "<hear>\n");
			}
			break;
			case MT_SenseBody:
			{
				received_info |= GOT_SENSE_BODY;
                CSenseBody my_body;

                pPerception->GetSenseBody(&my_body);
				UpdatePlayerProperties(&my_body);

				if (m_pReadyView)
				{
					rPerception0 = *pPerception;
					m_pReadyView->SetNewPerception(&rPerception0);

					CChildView *vv = m_pReadyView;
					vv->m_pAgent->SetDirection(GetDirection());
				}

			}
			break;
		}

        received_info0 |= received_info;
    }

	if(received_info & GOT_SEE)
	{
		UpdatePlayerSeenObjects(&world_perception);
	}

    //////////////////////////////////////////////////////////////////
    // no podme uz konecne nieco robit...

    // FIXMEE: aby neposielal moc casto, tak zatial len ak pride
    //   sense body spolu so see
    if((received_info0 & (GOT_SENSE_BODY|GOT_SEE)) == (GOT_SENSE_BODY|GOT_SEE)) {

        // shortcut na loptu
        CBall *pBall = m_my_world->GetBall();

        // FIXME: pridat podmienku, ci viem kde som na ihrisku
        //   + nejako rozumnejsie testovat, ci vidim loptu
        if (pBall->GetSeeStatus() & (SEE_ANGLE|SEE_DISTANCE)) {
            // na zaklade vnutorneho sveta urcime relativny vektor k lopte
            C2DVector toball = Rot(pBall->GetPosition() - m_position, DegToRad(-m_direction)); 

            fprintf(m_ff, "{> m_direction %lf}\n", (double)m_direction);

            double angtoball = RadToDeg(toball.GetAngle());

            // bez!, kop! alebo sa krut! 
            if ((angtoball > -5) && (angtoball < 5)) {
                if (toball.GetDistance() > 1.0) {
                    bskl->Dash(this, 100.0);
                } else {
                    C2DVector togoal = Rot(field.GetGoal(GT_L) - m_position, DegToRad(-m_direction));
                    bskl->Kick(this, 50.0, RadToDeg(togoal.GetAngle()));
                }
            } else {
                bskl->Turn(this, angtoball);
            }
        } else {
            bskl->Turn(this, 20.0);
        }
    }
}


bool CLocalAgent::UpdatePlayerProperties(CSenseBody *sense_body)
{
    m_see_status|=SEE_BODY_DIRECTION|SEE_STAMINA|SEE_EFFORT|SEE_DISTANCE_CHANGE;

    if( !(m_see_status & EXPECTED_ANGLE_CHANGE || m_see_status & SEE_ANGLE_CHANGE))
    {
        m_speed.SetXYDiffusion(1,0,1e9);
    }

    m_speed.SetDistance(sense_body->GetSpeed());
    m_stamina=sense_body->GetStamina();
    m_effort=sense_body->GetEffort();
    m_direction=m_neck_direction - sense_body->GetHeadDir();
    return true;
}

bool CLocalAgent::UpdatePlayerSeenObjects(CPerception *Perception)
{
	if(m_my_world)
	{
		m_my_world->Recompute(Perception,*this);
		return true;
	}
	else
	{
		return false;
	}
}



bool CLocalAgent::UpdatePlayerPosition(CSeenFlagsVect &_fFlags, CSeenGoalsVect &_gGoals, CSeenLinesVect &_lLines)//nasty&ughly
{
	//flagy a goaly

	int fsz = _fFlags.size();
	int gsz = _gGoals.size();
	DiffusePointVector flag_points , goal_points;
	DiffusePointVector flag_speeds , goal_speeds;
	flag_points.resize(fsz);
	goal_points.resize(gsz);

	int i;

	// spocitat relativne suradnice bodov

	for(i = 0 ; i < fsz ; i++)
	{
		CAngular2DVector flag_ang(_fFlags[i].GetDirection() * PI / 180 , _fFlags[i].GetDistance());
		flag_points[i] = CDiffuse2DVector(flag_ang , 0.1 , 0.01 , 0.1);
	}

	for(i = 0 ; i < gsz ; i++)
	{
		CAngular2DVector goal_ang(_gGoals[i].GetDirection() * PI / 180 , _gGoals[i].GetDistance());
		goal_points[i] = CDiffuse2DVector(goal_ang , 0.1 , 0.01 , 0.1);
	}

	double S = 0 , r;

	//vahovany aritmenicky priemer...

	C2DVector T , P , t , p;

	
	for(i = 0 ; i < fsz ; i++)
	{
//		if( (_fFlags[i].GetFlags() & SEE_PERCEPTION_DISTANCE ) &&
//			(_fFlags[i].GetFlags() & SEE_PERCEPTION_DIRECTION) &&
//			(_fFlags[i].GetFlags() & SEE_PERCEPTION_TYPE     ))
		{
			r = WeightFn(flag_points[i].GetDiffusion());

			T += r * field.GetFlag(_fFlags[i].GetFlagID());
			P += r * flag_points[i];
			S += r;
		}
	}

	for(i = 0 ; i < gsz ; i++)
	{
//		if( (_fGoals[i].GetFlags() & SEE_PERCEPTION_DISTANCE ) &&
//			(_fGoals[i].GetFlags() & SEE_PERCEPTION_DIRECTION) &&
//			(_fGoals[i].GetFlags() & SEE_PERCEPTION_TYPE     ))
		{
			r = WeightFn(goal_points[i].GetDiffusion());

			T += r * field.GetGoal(_gGoals[i].GetGoalID());
			P += r * goal_points[i];
			S += r;
		}
	}

	if(S > 0)
	{
		T/=S;
		P/=S;

		double A = 0,B = 0,C = 0;

		for(i = 0 ; i < fsz ; i++)
		{
//			if( (_fFlags[i].GetFlags() & SEE_PERCEPTION_DISTANCE ) &&
//				(_fFlags[i].GetFlags() & SEE_PERCEPTION_DIRECTION) &&
//				(_fFlags[i].GetFlags() & SEE_PERCEPTION_TYPE     ))
			{
				r = WeightFn(flag_points[i].GetDiffusion());
				t = T - field.GetFlag(_fFlags[i].GetFlagID());
				p = flag_points[i];

				A += r * (p & P);
				B += r * (p & t);
				C += r * (p * t);
			}
		}

		for(i = 0 ; i < gsz ; i++)
		{
//			if( (_fGoals[i].GetFlags() & SEE_PERCEPTION_DISTANCE ) &&
//				(_fGoals[i].GetFlags() & SEE_PERCEPTION_DIRECTION) &&
//				(_fGoals[i].GetFlags() & SEE_PERCEPTION_TYPE     ))
			{
				r = WeightFn(goal_points[i].GetDiffusion());
				t = T - field.GetGoal(_gGoals[i].GetGoalID());
				p = goal_points[i];

				A += r * (p & P);
				B += r * (p & t);
				C += r * (p * t);
			}
		}
		float telen=sqrt(B * B + C * C);
		if(telen==0) return false;
		float angle = (acosf(A / sqrt(B * B + C * C)) + atan2( C , B));

		C2DVector Poz = T - Rot(P , -angle);

        // na zaver este zratame svoju vlastnu neurcitost...

		double E=0;

		for(i = 0 ; i < fsz ; i++)
		{
//			if( (_fFlags[i].GetFlags() & SEE_PERCEPTION_DISTANCE ) &&
//				(_fFlags[i].GetFlags() & SEE_PERCEPTION_DIRECTION) &&
//				(_fFlags[i].GetFlags() & SEE_PERCEPTION_TYPE     ))
			{
				p = flag_points[i] - Rot(field.GetFlag(_fFlags[i].GetFlagID()) - Poz , angle);

				E += WeightFn(flag_points[i].GetDiffusion()) * (p * p);
			}
		}

		for(i = 0 ; i < gsz ; i++)
		{
//			if( (_fGoals[i].GetFlags() & SEE_PERCEPTION_DISTANCE ) &&
//				(_fGoals[i].GetFlags() & SEE_PERCEPTION_DIRECTION) &&
//				(_fGoals[i].GetFlags() & SEE_PERCEPTION_TYPE     ))
			{
				p = goal_points[i] - Rot(field.GetGoal(_gGoals[i].GetGoalID()) - Poz , angle);

				E += WeightFn(goal_points[i].GetDiffusion()) * (p * p);
			}
		}


        CDiffuse2DVector old=m_position;

		angle=AngNormalise( angle );
        m_position.SetVDiffusion(Poz , sqrt(E / S));
		m_neck_direction =RadToDeg(angle);

		

		S=0;
		C2DVector VSpeed;

		for(i = 0 ; i < fsz ; i++)
		{
			r = WeightFn(flag_points[i].GetDiffusion());
			VSpeed-=r*Rot(C2DVector(_fFlags[i].GetDistanceChng(),_fFlags[i].GetDistance()*_fFlags[i].GetDirectionChng() * PI / 180),angle);
			S+=r;
		}

		for(i = 0 ; i < gsz ; i++)
		{
			r = WeightFn(goal_points[i].GetDiffusion());
			VSpeed-=r*Rot(C2DVector(_gGoals[i].GetDistanceChng(),_gGoals[i].GetDistance()*_gGoals[i].GetDirectionChng() * PI / 180),angle);
			S+=r;
		}
        CDiffuse2DVector dif=old-m_position;

        if(dif.GetDiffusion()>dif.GetDistance())
        {
			m_see_status &= (!PREV_MASK) & (!EXPECTED_DISTANCE_CHANGE) &(!EXPECTED_ANGLE_CHANGE);
		}


		bool seeing_speed=false;

		CDiffuse2DVector SeenSpeed;
		if(S>0)
		{
			VSpeed/=S;

			E=0;

			for(i = 0 ; i < fsz ; i++)
			{
				p=VSpeed+r*Rot(C2DVector(_fFlags[i].GetDistanceChng(),_fFlags[i].GetDistance()*_fFlags[i].GetDirectionChng() * PI / 180),angle);
				E+=WeightFn(flag_points[i].GetDiffusion())*(p*p);
			}

			for(i = 0 ; i < gsz ; i++)
			{
				p=VSpeed+r*Rot(C2DVector(_gGoals[i].GetDistanceChng(),_gGoals[i].GetDistance()*_gGoals[i].GetDirectionChng() * PI / 180),angle);
				E+=WeightFn(flag_points[i].GetDiffusion())*(p*p);
			}

			E=sqrt(E/S);

		   SeenSpeed.SetVDiffusion(VSpeed,E);
		   seeing_speed=true;
		}

		bool computing_speed=false;
		
		CDiffuse2DVector ComputedSpeed;

        if(m_see_status& PREV_POSITION)
        {
			ComputedSpeed=m_position-m_prev_position;
			computing_speed=true;

		}


		CDiffuse2DVector Speed;

		if(seeing_speed)
		{
			if(computing_speed )
			{
				double a=WeightFn(SeenSpeed.GetDiffusion());
				double b=WeightFn(ComputedSpeed.GetDiffusion());
				Speed=(a*SeenSpeed+b*ComputedSpeed)/(a+b);
			}
			else
			{
				Speed=SeenSpeed;
			}
		}
		else
		{
			Speed=ComputedSpeed;
		}

		if(seeing_speed || computing_speed)
		{
            m_see_status|=SEE_ANGLE_CHANGE;

			if(m_see_status&SEE_DISTANCE_CHANGE)
			{
				m_speed.SetAngle(Speed.GetAngle());
				m_speed.SetDiffusion(Speed.GetDiffusion());
			}
			else
			{
				m_speed=Speed;
			}


            if(m_see_status&PREV_SPEED)
            {
                m_acceleration=m_speed-m_prev_speed;
                m_see_status|=EXPECTED_ACCELERATION;
            }
        }

        m_see_status|=SEE_ANGLE|SEE_DISTANCE|SEE_NECK_DIRECTION;

		return true;


	}
	return false;
}



void CAgent::UpdateApproachDistances(const CMovingObject &obj,const CAgent &local)//ughly
{
	CAngular2DVector pt(obj.GetPosition());
	m_approach_distances[m_approach_distances.size()*pt.GetAngle()/2/PI] =
        __max(0,pt.GetDistance()-obj.GetPosition().GetDiffusion());
}

void CBall::Precompute()
{
}

void CBall::UpdateBallPosition(CSeenObject _oBall,const CAgent &local)//ughly
{
	int flags=_oBall.GetSetValuesVar();
	
	if(flags &(SEE_ANGLE|SEE_DISTANCE))
	{
        fprintf(m_ff, "{ball %lf}\n", (double)_oBall.GetDirection());

		CDiffuse2DVector position(CAngular2DVector(DegToRad(_oBall.GetDirection()+local.GetNeckDirection()),_oBall.GetDistance()),0.1,0.1,0.1);

		m_position=position+CDiffuse2DVector((C2DVector)local.GetPosition(),0);

        m_see_status|=SEE_ANGLE|SEE_DISTANCE;

		CDiffuse2DVector speed;

		if(flags &(SEE_ANGLE_CHANGE|SEE_DISTANCE_CHANGE))
		{
			CDiffuse2DVector speed(_oBall.GetDistance()*DegToRad(_oBall.GetDirectionChng()),_oBall.GetDistanceChng(),0.1);
			speed=Rot(speed,DegToRad(local.GetNeckDirection()));
			m_speed=speed+local.GetSpeed();
	        m_see_status|=SEE_ANGLE_CHANGE|SEE_DISTANCE_CHANGE;
		}
		else
		{
			if( m_see_status &PREV_POSITION)
			{
				m_speed=m_position-m_prev_position;
		        m_see_status|=SEE_ANGLE_CHANGE|SEE_DISTANCE_CHANGE;
			}
			else
			{
				return;
			}
		}
		if( m_see_status &PREV_SPEED)
		{
			m_acceleration=m_speed-m_prev_speed;
		    m_see_status|=EXPECTED_ACCELERATION;
		}
	}
}


void  CAgent::Precompute()//nasty
{
}


CGameCommand * CAgent::GetCommand()
{
	return 0;
}

void CMovingObject::Precompute()
{
}




void CWorldModel::Recompute(CPerception *Perception,const CAgent &local)
{
	CSeenObject tmp_ball;

	Perception->GetBall(&tmp_ball);

	m_ball->UpdateBallPosition(tmp_ball,local);


return;   // FIXME -> hodilo to Access Violation na riadku:  id_vals[i][j]=m_identified_agents[i]->TestOwnership(*(act_seen[j]),local);

	CSeenPlayer tmp_player;

	int seen_count=Perception->GetPlayersCount();
	int unid_count=m_unidentified_agents.size();
	int id_count=m_identified_agents.size();

	int i,j;

	double **id_vals;
	double **unid_vals;

	bool *matched_unid;
	bool *matched_seen;

	CSeenPlayer **act_seen;

	act_seen= new CSeenPlayer *[seen_count];

	id_vals=new double*[id_count];
	unid_vals=new double*[unid_count];
	matched_unid=new bool[unid_count];
	matched_seen=new bool[seen_count];

	memset(matched_unid,0,unid_count*sizeof(bool));
	memset(matched_seen,0,seen_count*sizeof(bool));

	for(i=0;i<seen_count;i++)
	{
		act_seen[i]=&(Perception->GetSeenPlayers()[i]);
	}

	for(i=0;i=id_count;i++)
	{
		id_vals[i]=new double[seen_count];

		for(j=0;j<seen_count;j++)
		{
			id_vals[i][j]=m_identified_agents[i]->TestOwnership(*(act_seen[j]),local);
		}
	}

	for(i=0;i=unid_count;i++)
	{
		unid_vals[i]=new double[seen_count];

		for(j=0;j<seen_count;j++)
		{
			unid_vals[i][j]=m_identified_agents[i]->TestOwnership(*(act_seen[j]),local);
		}
	}



	int i_id=-1,j_id=-1;

	double max_id=-1;

	int seen_rem=seen_count;

	bool not_hotovo=true;

	while(not_hotovo)
	{
		int i_unid=-1,j_unid=-1;

		double max_unid=-1;

		int i_id=-1,j_id=-1;

		double max_id=-1;

		for(i=0;i=unid_count;i++)
		{
			for(j=0;j<seen_count;j++)
			{
				if(max_unid<unid_vals[i][j])
				{
					i_unid=i;
					j_unid=j;
					max_unid=unid_vals[i][j];
				}
			}
		}

		for(i=0;i=id_count;i++)
		{
			for(j=0;j<seen_count;j++)
			{
				if(max_id<id_vals[i][j])
				{
					i_id=i;
					j_id=j;
					max_id=id_vals[i][j];
				}
			}
		}

		if(max_id>=max_unid)
		{
			if(max_id>0)
			{
				m_identified_agents[i_id]->Update(*(act_seen[j_id]),local);
				matched_seen[j_unid]=true;

				for(j=0;j<seen_count;j++)
				{
					id_vals[i_id][j]=-1;
				}

				for(i=0;i<id_count;i++)
				{
					id_vals[i][j_id]=-1;
				}
			}
			else
			{
				not_hotovo=false;
			}
		}
		else
		{
			if(max_unid>0)
			{
				m_unidentified_agents[i_unid]->Update(*(act_seen[j_unid]),local);
				matched_unid[i_unid]=true;
				matched_seen[j_unid]=true;

				for(j=0;j<seen_count;j++)
				{
					unid_vals[i_unid][j]=-1;
				}

				for(i=0;i<unid_count;i++)
				{
					unid_vals[i][j_unid]=-1;
				}
			}
			else
			{
				not_hotovo=false;
			}
		}
	}


	for(i=0;i<unid_count;i++)
	{
		if(matched_unid[i])
		{
			if(m_unidentified_agents[i]->GetSeeStatus() &(SEE_SIDE|SEE_NUMBER))
			{
				m_identified_agents.insert(m_identified_agents.end(),m_unidentified_agents[i]);
				m_unidentified_agents[i]=0;
			}
		}
		else
		{
			delete m_unidentified_agents[i];
			m_unidentified_agents[i]=0;
		}
	}

	for(i=0;i<m_unidentified_agents.size();)
	{
		if(!m_unidentified_agents[i])
		{
			m_unidentified_agents.erase(&(m_unidentified_agents[i]));
		}
		else
		{
			i++;
		}
	}

	for(i=0;i<seen_count;i++)
	{
		if(!matched_seen[i])
		{
			CAgent *new_agent=new CAgent;
			new_agent->Update(*(act_seen[i]),local);

			if(new_agent->GetSeeStatus() &(SEE_SIDE|SEE_NUMBER))
			{
				m_identified_agents.insert(m_identified_agents.end(),new_agent);
			}
			else
			{
				m_unidentified_agents.insert(m_unidentified_agents.end(),new_agent);
			}

		}
//		delete act_seen[i];
	}

	delete []matched_seen;
	delete []matched_unid;
	delete []act_seen;

	for(i=0;i<id_count;i++)
	{
		delete []id_vals[i];
	}
	delete []id_vals;

	for(i=0;i<unid_count;i++)
	{
		delete []unid_vals[i];
	}
	delete []unid_vals;
}


void CWorldModel::Precompute()
{
	m_ball->Precompute();
}





double CAgent::TestOwnership(const CSeenPlayer &player,const CAgent &local)//ughly
{
	int flags=player.GetSetValuesVar();

	if((flags&SEE_SIDE) && ((m_see_status&SEE_SIDE) || (m_see_status&EXPECTED_SIDE) ) && (m_side!=player.GetSide()))
	{
		return 0;
	}

	if((flags&SEE_NUMBER) && ((m_see_status&SEE_NUMBER) || (m_see_status&EXPECTED_NUMBER) ) && (m_side!=player.GetUniformNum()))
	{
		return 0;
	}

	if((flags&SEE_SIDE) && ((m_see_status&SEE_SIDE) || (m_see_status&EXPECTED_SIDE)) && (flags&SEE_NUMBER) && ((m_see_status&SEE_NUMBER) || (m_see_status&EXPECTED_NUMBER) ))
	{
		return 1;
	}
////////////!!!!!!!!!

	if(flags &(SEE_ANGLE|SEE_DISTANCE))
	{
		CDiffuse2DVector position(CAngular2DVector(player.GetDirection()+DegToRad(local.GetNeckDirection()),player.GetDirection()),0.1,0.1,0.1);

		CDiffuse2DVector delta=m_position-position-local.GetPosition();

		return exp(-delta.GetDistance()/delta.GetDiffusion());
	}
	return 0;// CAUTION AGENT IS BLIND !!!
}



void CAgent::Update(CSeenPlayer &player,const CAgent &local)//ughly
{
	int flags=player.GetSetValuesVar();

	if(flags&SEE_SIDE)
	{
		m_side=player.GetSide();
		m_see_status|=SEE_SIDE;
	}

	if(flags&SEE_NUMBER)
	{
		m_number=player.GetUniformNum();
		m_see_status|=SEE_NUMBER;
	}

	if(flags&SEE_BODY_DIRECTION)
	{
		m_direction=RadToDeg(AngNormalise((DegToRad((double)player.GetBodyDir())+DegToRad(local.GetNeckDirection()))));
		m_see_status|=SEE_BODY_DIRECTION;
	}

	if(flags&SEE_NECK_DIRECTION)
	{
		m_neck_direction=RadToDeg(AngNormalise((DegToRad((double)player.GetHeadDir())+DegToRad(local.GetNeckDirection()))));
		m_see_status|=SEE_NECK_DIRECTION;
	}

	if(flags &(SEE_ANGLE|SEE_DISTANCE))
	{
		CDiffuse2DVector position(CAngular2DVector(player.GetDirection()+DegToRad(local.GetNeckDirection()),player.GetDirection()),0.1,0.1,0.1);

		m_position=position+CDiffuse2DVector((C2DVector)local.GetPosition(),0);

        m_see_status|=SEE_ANGLE|SEE_DISTANCE;

		CDiffuse2DVector speed;

		if(flags &(SEE_ANGLE_CHANGE|SEE_DISTANCE_CHANGE))
		{
			CDiffuse2DVector speed(player.GetDistance()*DegToRad(player.GetDirectionChng()),player.GetDistanceChng(),0.1);
			speed=Rot(speed,DegToRad(local.GetNeckDirection()));
			m_speed=speed+local.GetSpeed();
	        m_see_status|=SEE_ANGLE_CHANGE|SEE_DISTANCE_CHANGE;
		}
		else
		{
			if( m_see_status &PREV_POSITION)
			{
				m_speed=m_position-m_prev_position;
		        m_see_status|=SEE_ANGLE_CHANGE|SEE_DISTANCE_CHANGE;
			}
			else
			{
				return;
			}
		}
		if( m_see_status &PREV_SPEED)
		{
			m_acceleration=m_speed-m_prev_speed;
		    m_see_status|=EXPECTED_ACCELERATION;
		}
	}
}
