// VisStaticField.cpp: implementation of the CVisStaticField class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Player.h"
#include "VisStaticField.h"
#include "StaticField.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CVisStaticField::CVisStaticField()
{
	m_pStaticField = new CStaticField();
}

CVisStaticField::~CVisStaticField()
{
	delete m_pStaticField;
}

//////////////////////////////////////////////////////////////////////////////
// void CVisStaticField::GetFlag( EFlagType flag_name, CVisObject* visFlag )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		EFlagType flag_name
//		CVisObject* visFlag
//
//////////////////////////////////////////////////////////////////////////////
void CVisStaticField::GetFlag( EFlagType flag_name, CVisObject* visFlag )
{
	C2DVector staticFieldFlag = m_pStaticField->GetFlag( flag_name );

	visFlag->CreateFlag( staticFieldFlag );
}

//////////////////////////////////////////////////////////////////////////////
// float CVisStaticField::GetFieldWidth( void ) 
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//
//////////////////////////////////////////////////////////////////////////////
float CVisStaticField::GetFieldWidth( void ) 
{ 
	return float( m_pStaticField->GetFieldWidth() ); 
}

//////////////////////////////////////////////////////////////////////////////
// float CVisStaticField::GetFieldLength( void ) 
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//
//////////////////////////////////////////////////////////////////////////////
float CVisStaticField::GetFieldLength( void ) 
{ 
	return float( m_pStaticField->GetFieldLength() ); 
}

//////////////////////////////////////////////////////////////////////////////
// float CVisStaticField::GetPenaltyAreaWidth( void ) 
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//
//////////////////////////////////////////////////////////////////////////////
float CVisStaticField::GetPenaltyAreaWidth( void ) 
{ 
	return float( m_pStaticField->GetPenaltyAreaWidth() ); 
}

//////////////////////////////////////////////////////////////////////////////
// float CVisStaticField::GetPenaltyAreaLength( void ) 
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//
//////////////////////////////////////////////////////////////////////////////
float CVisStaticField::GetPenaltyAreaLength( void ) 
{ 
	return float( m_pStaticField->GetPenaltyAreaLength() ); 
}

//////////////////////////////////////////////////////////////////////////////
// float CVisStaticField::GetGoalSize( void ) 
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//
//////////////////////////////////////////////////////////////////////////////
float CVisStaticField::GetGoalSize( void ) 
{ 
	return float( m_pStaticField->GetGoalSize() ); 
}