// VisObject.h: interface for the CVisObject class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_VISOBJECT_H__63238AC9_3FAD_4F3A_A8D1_29AAF7449AB8__INCLUDED_)
#define AFX_VISOBJECT_H__63238AC9_3FAD_4F3A_A8D1_29AAF7449AB8__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ToDoClasses.h"
#include "WorldGeometry.h"

class CSeenFlag;
class CSeenObject;
class CSeenPlayer;

class CAgent;
class CBall;

enum EVisObjectType {

	VOT_None,
	VOT_Flag,
	VOT_Line,
	VOT_Ball,
	VOT_OwnPlayer,
	VOT_UnknownPlayer,
	VOT_TeamPlayer,
	VOT_EnemyPlayer,

	VOT_PerFlag,
	VOT_PerBall,
	VOT_PerLine,
	VOT_PerUnknownPlayer,
	VOT_PerTeamPlayer,
	VOT_PerEnemyPlayer,

	VOT_Count
};

class CAgent;

class CVisObject  
{
	EVisObjectType		m_eObjectType;			// typ objektu
	
	float				m_fRotation;			// rotacia objektu
	float				m_fHeadRotation;		// rotacia hlavy hracov, u ostatnych objektoch nepouzite

	float				m_fViewAngle;			// sirka pohladu hraca
	float				m_fViewDistance;		// dohlad hraca

	CDiffuse2DVector	m_cSpeed;				// rychlost hraca
	CDiffuse2DVector	m_cPosition;			// pozicia hraca
	CDiffuse2DVector	m_cAcceleration;		// zrychlenie hraca

	int					m_nNumber;				// cislo hraca

	DWORD				m_DFlags;				// platnost jednotlivych udajovych poli


public:

	CVisObject();
	virtual ~CVisObject();

	void Initialize( void ) { m_eObjectType = VOT_None; };

	void CreateFlag( C2DVector staticFieldFlag );
	void CreateOwnPlayer( CAgent* agent );

	/// Vytvaranie objektov na zobrazenie ///

	// reprezentacia vnutorneho sveta
	void CreatePlayer( CAgent* agent );
	void CreateBall( CBall* ball );

	// na zaklade vnemov zo servera
	void CreateFlag( CSeenFlag* seenFlag, CAgent* agent );
	void CreatePlayer( CSeenPlayer* seenFlag, CAgent* agent );
	void CreateBall( CSeenObject* seenFlag, CAgent* agent );

	float GetPosX( void ) { return m_cPosition.GetX(); };
	float GetPosY( void ) { return m_cPosition.GetY(); };
	float GetPosDiff( void ) { return m_cPosition.GetDiffusion(); };

	float GetSpeedX( void ) { return m_cSpeed.GetX(); };
	float GetSpeedY( void ) { return m_cSpeed.GetY(); };
	float GetSpeedDiff( void ) { return m_cSpeed.GetDiffusion(); };

	float GetAccelX( void ) { return m_cAcceleration.GetX(); };
	float GetAccelY( void ) { return m_cAcceleration.GetY(); };
	float GetAccelDiff( void ) { return m_cAcceleration.GetDiffusion(); };

	float GetRotation( void ) { return m_fRotation; };
	float GetHeadRotation( void ) { return m_fHeadRotation; };

	float GetViewAngle( void ) { return m_fViewAngle; };
	float GetViewDistance( void ) { return m_fViewDistance; };

	DWORD GetFlags( void ) { return m_DFlags; };

	int GetPlayerNumber( void ) { return m_nNumber; };

	EVisObjectType GetObjectType( void ) { return m_eObjectType; };
	
	void Localize( float distance, float angle, float& worldX, float& worldY );
	void Localize( float distance, float angle, CDiffuse2DVector* world_pos );
};

#endif // !defined(AFX_VISOBJECT_H__63238AC9_3FAD_4F3A_A8D1_29AAF7449AB8__INCLUDED_)
