// Timer.cpp: implementation of the CTimer class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Player.h"
#include "Timer.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CTimer::CTimer()
{
	QueryPerformanceFrequency(&m_nFrequency);
	Start();
}

CTimer::~CTimer()
{
}

__int64 CTimer::GetFrequency()
{
	return m_nFrequency.QuadPart;
}

__int64 CTimer::GetStartTime()
{
	return m_nStartTime.QuadPart;
}

__int64 CTimer::Start()
{
	QueryPerformanceCounter(&m_nStartTime);
	return m_nStartTime.QuadPart;
}

__int64 CTimer::GetElapsedTime()
{
	LARGE_INTEGER nActualTime;
	QueryPerformanceCounter(&nActualTime);
	return nActualTime.QuadPart - m_nStartTime.QuadPart;
}
