#ifndef SERVERMSGTRANSLATOR_H
#define SERVERMSGTRANSLATOR_H

#include "ServerMsg.h"
#include "Perception.h"
#include "GameCommand.h"
#include <string>

#define MAX_MSG_LEN 512

/*
Name: CCharString
Purpose: Wraper class for "string"
Notes: 
Created: 5.12.2000, frz
Last Modified: 6.12.2000, frz
*/
class CCharString
{
protected:
	string m_sString;
public:
	CCharString();
	CCharString(char* str);
	~CCharString();
	int GetStrLength(){return m_sString.size();}
	string GetString(){return m_sString;}
};


/*
Name: CParseString
Purpose: Class for with methods for parsing stored string
Notes: 
Created: 5.12.2000, frz 
Last Modified: 7.12.2000, frz
*/
class CParseString : public CCharString
{
private:

public:
	CParseString();
	CParseString(char* str);
	~CParseString();
	int GetInteger(){return atoi(m_sString.data());}
	double GetDouble(){return atof(m_sString.data());}
	int GetFirstWord(CParseString* subString);
	int GetFirstBar(CParseString* subString);
	int GetNextWord(int pos, CParseString* subString);
	int GetNextBar(int pos, CParseString* subString);
	int GetWordCount();
	int GetBarCount();
	bool operator==(CParseString str);
	bool operator==(CCharString str);
	bool operator==(string sString);
	bool operator==(char* szString);
	void operator=(CParseString str);
	void operator=(CCharString str);
	void operator=(string sString);
	void operator=(char* szString);
};


/*
Name: CParser
Purpose: Class for parsing information from soccer server
Notes: 
Created: 5.12.2000, frz 
Last Modified: 7.12.2000, frz
*/

class CServerMsgTranslator //: public CEventRecipient
{
protected:
	EFlagType DecodeFlag(CParseString f1, CParseString f2, CParseString f3);
    EPlayMode DecodePlayMode(CParseString pm);

    void ParseObj(CPerception* newPerception, CParseString* str);
	void Parse(char* msg, CPerception* newPerception);

public:
    CServerMsgTranslator() {};
    // CServerMsgTranslator(CWinThread* pDefThread, CCoordinator* pCoordinator);
    virtual ~CServerMsgTranslator() {};

    // virtual void OnEvent(CBasicEvent *pEvent);

    int ParseServerMsg(CServerMsg *pServerMsg, CPerception *pPerception);
    int GenerateServerMsg(CGameCommand *pCommand, CServerMsg *pServerMsg);
};


#endif  // SERVERMSGTRANSLATOR_H
