// ChildView.cpp : implementation of the CChildView class
//


#include "stdafx.h"

#include <math.h>

#include "Player.h"
#include "ChildView.h"
#include "VisStaticField.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

const int DEFAULT_METER_PIXEL_RATIO = 5;
const int DEFAULT_FIELD_LINE_WIDTH = 1;
const int DEFAULT_FIELD_GOAL_LINE_WIDTH = 1;

const int DEFAULT_ORIENTED_LINE_SIZE = 4;

const int DEFAULT_ALL_FIELD_POSX_PIXEL = 30;
const int DEFAULT_ALL_FIELD_POSY_PIXEL = 50;
const int DEFAULT_FIELD_BORDER_SIZE = 10;

const int DEFAULT_MAX_FLAG_PIXEL_SIZE = 4;
const int DEFAULT_MAX_PLAYER_PIXEL_SIZE = 12;
const int DEFAULT_MAX_BALL_PIXEL_SIZE = 4;
const int DEFAULT_MAX_AGENT_PIXEL_SIZE = 8;

const float PERCEPTION_COLOR_MODIFIER = 0.85f;

/////////////////////////////////////////////////////////////////////////////
// CChildView

CChildView *m_pReadyView = NULL;     // FIXME

CChildView::CChildView()
{
	m_pMyDevice = new CDC();
	m_pMyBitmap = new CBitmap();
	m_pStaticField = new CVisStaticField();
	m_pPerception = new CVisPerception();
    m_pAgent = m_pPerception->m_pAgent;    // FIXME

	m_nMeterPixelRatio = DEFAULT_METER_PIXEL_RATIO;	
	m_nFieldLineWidth = DEFAULT_FIELD_LINE_WIDTH;
	m_nFieldGoalLineWidth = DEFAULT_FIELD_GOAL_LINE_WIDTH;
	m_nOrientedLineSizePixel = DEFAULT_ORIENTED_LINE_SIZE;

	m_nFieldLengthPixel = m_pStaticField->GetFieldLength() * m_nMeterPixelRatio;
	m_nFieldWidthPixel = m_pStaticField->GetFieldWidth() * m_nMeterPixelRatio;
	m_nFieldBorderPixel = DEFAULT_FIELD_BORDER_SIZE * m_nMeterPixelRatio;

	//m_nAllFieldPosXPixel = DEFAULT_ALL_FIELD_POSX_PIXEL;
	//m_nAllFieldPosYPixel = DEFAULT_ALL_FIELD_POSY_PIXEL;

	m_nAllFieldPosXPixel = 0;
	m_nAllFieldPosYPixel = 0;


	m_nFieldCenterXPixel = m_nAllFieldPosXPixel + m_nFieldBorderPixel + m_nFieldLengthPixel / 2;
	m_nFieldCenterYPixel = m_nAllFieldPosYPixel + m_nFieldBorderPixel + m_nFieldWidthPixel / 2;

	// pociatocne nastavenie volitelnych moznosti
	m_bVisualSetupFlagIcon = true;

	CreatePensAndBrushes();

    m_pReadyView = this;
}

CChildView::~CChildView()
{
    m_pReadyView = NULL;

//    delete m_pStaticField;      ???
//    delete m_pPerception;

	delete m_pMyDevice;
	delete m_pMyBitmap;

	delete m_pStaticField;

	delete m_pFlagPen;
	delete m_pFlagBrush;
	delete m_pBallPen;
	delete m_pBallBrush;
	delete m_pUnknownPlayerPen;
	delete m_pUnknownPlayerBrush;
	delete m_pTeamPlayerPen;
	delete m_pTeamPlayerBrush;
	delete m_pEnemyPlayerPen;
	delete m_pEnemyPlayerBrush;
	delete m_pOwnAgentPen;
	delete m_pOwnAgentBrush;
	delete m_pOwnAgentRotationPen;
}


BEGIN_MESSAGE_MAP(CChildView,CWnd )
	//{{AFX_MSG_MAP(CChildView)
	ON_WM_PAINT()
	ON_WM_ERASEBKGND()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CChildView message handlers

//////////////////////////////////////////////////////////////////////////////
// BOOL CChildView::PreCreateWindow(CREATESTRUCT& cs) 
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		CREATESTRUCT& cs
//
//////////////////////////////////////////////////////////////////////////////
BOOL CChildView::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	cs.dwExStyle |= WS_EX_CLIENTEDGE;
	cs.style &= ~WS_BORDER;
	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		::LoadCursor(NULL, IDC_ARROW), HBRUSH(COLOR_WINDOW+1), NULL);

	return TRUE;
}


//////////////////////////////////////////////////////////////////////////////
// void CChildView::ConvertWorldToPixel( float coord_x, float coord_y, int& pixel_x, int& pixel_y )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		float coord_x
//		float coord_y
//		int& pixel_x
//		int& pixel_y
//
//////////////////////////////////////////////////////////////////////////////
void CChildView::ConvertWorldToPixel( float coord_x, float coord_y, int& pixel_x, int& pixel_y )
{
	pixel_x = int( coord_x * float( m_nMeterPixelRatio ) ) + m_nFieldCenterXPixel;
	pixel_y = int( coord_y * float( m_nMeterPixelRatio ) ) + m_nFieldCenterYPixel;

	pixel_y = m_nFieldWidthPixel + 2 * m_nFieldBorderPixel - pixel_y;
}

void CChildView::CreatePensAndBrushes( void )
{
	m_pFlagPen = new CPen( PS_SOLID, 1, RGB( 0, 0 , 0 ) );
	m_pFlagBrush = new CBrush( RGB( 0, 0, 0 ) );
	m_pBallPen = new CPen( PS_SOLID, 1, RGB( 240, 140, 0 ) );
	m_pBallBrush = new CBrush( RGB( 240, 140, 0 ) );
	m_pUnknownPlayerPen = new CPen( PS_SOLID, 1, RGB( 0, 240, 0 ) );
	m_pUnknownPlayerBrush = new CBrush( RGB( 0, 240, 0 ) );
	m_pTeamPlayerPen = new CPen( PS_SOLID, 1, RGB( 240, 240, 0 ) );
	m_pTeamPlayerBrush = new CBrush( RGB( 240, 240, 0 ) );
	m_pEnemyPlayerPen = new CPen( PS_SOLID, 1, RGB( 140, 0, 0 ) );
	m_pEnemyPlayerBrush = new CBrush( RGB( 140, 0, 0 ) );
	m_pOwnAgentPen = new CPen( PS_SOLID, 1, RGB( 0, 100, 255 ) );
	m_pOwnAgentBrush = new CBrush( RGB( 0, 100, 255 ) );
	m_pOwnHeadAgentPen  = new CPen( PS_SOLID, 1, RGB( 0, 160, 255 ) );
	m_pOwnHeadAgentBrush = new CBrush( RGB( 0, 160, 255 ) );
	m_pOwnAgentRotationPen = new CPen( PS_SOLID, 1, RGB( 255, 255, 255 ) );
}

void CChildView::PerceptionColorUpdate( CPen* new_pen, CBrush* new_brush, CPen* origin_pen, CBrush* origin_brush )
{
	LOGPEN logpen;

	if ( !origin_pen->GetLogPen( &logpen ) )
		return;

	COLORREF color = logpen.lopnColor;
	
	BYTE red = color & 0xff;
	BYTE green = ( color >> 8 ) & 0xff;
	BYTE blue = ( color >> 16 ) & 0xff;

	red = BYTE( red * PERCEPTION_COLOR_MODIFIER );
	green = BYTE( green * PERCEPTION_COLOR_MODIFIER );
	blue = BYTE( blue * PERCEPTION_COLOR_MODIFIER );

	logpen.lopnColor = RGB( red, green, blue );

	new_pen->CreatePenIndirect( &logpen );

	LOGBRUSH logbrush;
	origin_brush->GetLogBrush( &logbrush );

	color = logbrush.lbColor;

	red = BYTE( red * PERCEPTION_COLOR_MODIFIER );
	green = BYTE( green * PERCEPTION_COLOR_MODIFIER );
	blue = BYTE( blue * PERCEPTION_COLOR_MODIFIER );

	logbrush.lbColor = RGB( red, green, blue );

	new_brush->CreateBrushIndirect( &logbrush );

}

//////////////////////////////////////////////////////////////////////////////
// void CChildView::DrawCircle( CDC* pDC, int centerX, int centerY, int radius, CPen* drawPen )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		CDC* pDC
//		int centerX
//		int centerY
//		int radius
//		CPen* drawPen
//
//////////////////////////////////////////////////////////////////////////////
void CChildView::DrawCircle( CDC* pDC, int centerX, int centerY, int radius, CPen* drawPen, CBrush* drawBrush )
{
	CPen* oldPen = pDC->SelectObject( drawPen );
	CBrush* oldBrush = pDC->SelectObject( drawBrush );
	
	pDC->Ellipse( centerX - radius, centerY - radius, centerX + radius, centerY + radius );

	pDC->SelectObject( oldBrush );
	pDC->SelectObject( oldPen );
}

//////////////////////////////////////////////////////////////////////////////
// void CChildView::DrawCircleLine( CDC* pDC, int centerX, int centerY, int radius, CPen* drawPen )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		CDC* pDC
//		int centerX
//		int centerY
//		int radius
//		CPen* drawPen
//
//////////////////////////////////////////////////////////////////////////////
void CChildView::DrawCircleLine( CDC* pDC, int centerX, int centerY, int radius, CPen* drawPen )
{
	CPen* oldPen = pDC->SelectObject( drawPen );

	// create & select transparent brush
	LOGBRUSH logBrush;
	logBrush.lbStyle = BS_HOLLOW;

	CBrush mBrush;
	mBrush.CreateBrushIndirect( &logBrush );
	CBrush* oldBrush = pDC->SelectObject( &mBrush );

	pDC->Ellipse( centerX - radius, centerY - radius, centerX + radius, centerY + radius );
	
	pDC->SelectObject( oldBrush );
	pDC->SelectObject( oldPen );
}

//////////////////////////////////////////////////////////////////////////////
// void CChildView::DrawLine( CDC* pDC, int posX0, int posY0, int posX1, int posY1, CPen* drawPen )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		CDC* pDC
//		int posX0
//		int posY0
//		int posX1
//		int posY1
//		CPen* drawPen
//
//////////////////////////////////////////////////////////////////////////////
void CChildView::DrawLine( CDC* pDC, int posX0, int posY0, int posX1, int posY1, CPen* drawPen )
{
	CPen* oldPen = pDC->SelectObject( drawPen );

	pDC->MoveTo( posX0, posY0 );
	pDC->LineTo( posX1, posY1 );

	pDC->SelectObject( oldPen );
}

//////////////////////////////////////////////////////////////////////////////
// void CChildView::DrawOrientedLine( CDC* pDC, int startX, int startY, int targetX, int targetY, CPen* drawPen )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		CDC* pDC
//		int startX
//		int startY
//		int targetX
//		int targetY
//		CPen* drawPen
//
//////////////////////////////////////////////////////////////////////////////
void CChildView::DrawOrientedLine( CDC* pDC, int startX, int startY, int targetX, int targetY, CPen* drawPen )
{
	DrawLine( pDC, startX, startY, targetX, targetY, drawPen );

	CPen* oldPen = pDC->SelectObject( drawPen );

	int dx = targetX - startX;
	int dy = targetY - startY;
	double len = sqrt( double( dx * dx + dy * dy ) );

	dx = int( m_nOrientedLineSizePixel * dx / len );
	dy = int( m_nOrientedLineSizePixel * dy / len );

	int dOppx = -int( 2 * dx );
	int dOppy = -int( 2 * dy );

	int d2x = int ( -dy );
	int d2y = int ( dx );

	int trX = targetX + d2x + dOppx;
	int trY = targetY + d2y + dOppy;

	DrawLine( pDC, targetX, targetY, trX, trY, drawPen );

	trX = targetX - d2x + dOppx;
	trY = targetY - d2y + dOppy;

	DrawLine( pDC, targetX, targetY, trX, trY, drawPen );

	pDC->SelectObject( oldPen );
}

//////////////////////////////////////////////////////////////////////////////
// void CChildView::DrawCross( CDC* pDC, int centerX, int centerY, int size, CPen* drawPen )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		CDC* pDC
//		int centerX
//		int centerY
//		int size
//		CPen* drawPen
//
//////////////////////////////////////////////////////////////////////////////
void CChildView::DrawCross( CDC* pDC, int centerX, int centerY, int size, CPen* drawPen )
{
	CPen* oldPen = pDC->SelectObject( drawPen );

	int halfSize = size / 2;
	
	DrawLine( pDC, centerX - halfSize, centerY - halfSize, centerX + halfSize, centerY + halfSize + 1, drawPen );
	DrawLine( pDC, centerX - halfSize, centerY + halfSize, centerX + halfSize, centerY - halfSize - 1, drawPen );

	pDC->SelectObject( oldPen );
}

//////////////////////////////////////////////////////////////////////////////
// void CChildView::DrawArc( CDC* pDC, int posX0, int posY0, int posX1, int posY1, int arcX0, int arcY0, int arcX1, int arcY1, CPen* drawPen )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		CDC* pDC
//		int posX0
//		int posY0
//		int posX1
//		int posY1
//		int arcX0
//		int arcY0
//		int arcX1
//		int arcY1
//		CPen* drawPen
//
//////////////////////////////////////////////////////////////////////////////
void CChildView::DrawArc( CDC* pDC, int posX0, int posY0, int posX1, int posY1, int arcX0, int arcY0, int arcX1, int arcY1, CPen* drawPen )
{
	CPen* oldPen = pDC->SelectObject( drawPen );
	
	pDC->Arc( posX0, posY0, posX1, posY1, arcX0, arcY0, arcX1, arcY1 );

	pDC->SelectObject( oldPen );
}

//////////////////////////////////////////////////////////////////////////////
// void CChildView::DrawField( CDC* pDC, int pos_x, int pos_y, bool drawStaticFlags )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		CDC* pDC
//
//////////////////////////////////////////////////////////////////////////////
void CChildView::DrawField( CDC* pDC, int posX, int posY, bool drawStaticFlags )
{
	CBrush	allFieldBrush( RGB( 0, 140, 0 ) );
	CBrush	playFieldBrush( RGB( 0, 175, 0 ) ); 
	RECT	fieldRect;

	pDC->SetBkMode( TRANSPARENT );

	fieldRect.left = posX;
	fieldRect.right = posX + m_nFieldLengthPixel + 2 * m_nFieldBorderPixel;
	fieldRect.bottom = posY;
	fieldRect.top = posY + m_nFieldWidthPixel + 2 * m_nFieldBorderPixel;

	// plocha ihriska + okraje
	pDC->FillRect( &fieldRect, &allFieldBrush );
	
	fieldRect.left += m_nFieldBorderPixel;
	fieldRect.top -= m_nFieldBorderPixel;
	fieldRect.bottom += m_nFieldBorderPixel;
	fieldRect.right -= m_nFieldBorderPixel;

	// plochu ihriska zobraz odlisnopu farbou
	pDC->FillRect( &fieldRect, &playFieldBrush );

	// tak tu si do stredu zobrazime logo
	// DrawLogo();

	// kreslenie ciar
	CPen linePen( PS_SOLID, m_nFieldLineWidth, RGB( 255, 255, 255 ) );

	// zobrazenie obvodovych ciar ihriska
	DrawLine( pDC, fieldRect.left, fieldRect.top, fieldRect.right + 1, fieldRect.top, &linePen );
	DrawLine( pDC, fieldRect.left, fieldRect.bottom, fieldRect.right + 1, fieldRect.bottom, &linePen );
	DrawLine( pDC, fieldRect.left, fieldRect.top, fieldRect.left, fieldRect.bottom, &linePen );
	DrawLine( pDC, fieldRect.right, fieldRect.top, fieldRect.right, fieldRect.bottom, &linePen );

	// zobrazenie stredovej ciary
	DrawLine( pDC, m_nFieldCenterXPixel, fieldRect.top, m_nFieldCenterXPixel, fieldRect.bottom, &linePen );

	DrawCircleLine( pDC, m_nFieldCenterXPixel, m_nFieldCenterYPixel, m_pStaticField->GetGoalSize() * m_nMeterPixelRatio / 2, &linePen );

	// zobrazenie pokutoveho uzemia
	float m0x, m0y, m1x, m1y;
	int p0x, p0y, p1x, p1y;

	// najskor lave pokutove uzemie
	m0x = m1x = float( -m_pStaticField->GetFieldLength() / 2.0f + m_pStaticField->GetPenaltyAreaLength() );
	m0y = float( -m_pStaticField->GetPenaltyAreaWidth() / 2.0f );
	m1y = -m0y;

	ConvertWorldToPixel( m0x, m0y, p0x, p0y );
	ConvertWorldToPixel( m1x, m1y, p1x, p1y );

	DrawLine( pDC, p0x, p0y, p1x, p1y, &linePen );
	DrawLine( pDC, fieldRect.left, p1y, p1x, p1y, &linePen );
	DrawLine( pDC, fieldRect.left, p0y, p0x, p0y, &linePen );

	// prave pokutove uzemie, y-ove suradnice sa nemenia!
	m0x = m1x = float( m_pStaticField->GetFieldLength() / 2 - m_pStaticField->GetPenaltyAreaLength() );

	ConvertWorldToPixel( m0x, m0y, p0x, p0y );
	ConvertWorldToPixel( m1x, m1y, p1x, p1y );

	DrawLine( pDC, p0x, p0y, p1x, p1y, &linePen );
	DrawLine( pDC, fieldRect.right, p1y, p1x, p1y, &linePen );
	DrawLine( pDC, fieldRect.right, p0y, p0x, p0y, &linePen );

	// zozbrazenie branok
	CPen goalPen( PS_SOLID, m_nFieldGoalLineWidth, RGB( 0, 0, 0 ) );

	// y-ove suradnice pre obe branky su rovnake
	int halfGoalPixelSize = int( float( m_pStaticField->GetGoalSize() * m_nMeterPixelRatio ) / 2.0f );
	int goalTopY = m_nFieldCenterYPixel + halfGoalPixelSize;
	int goalBottomY = m_nFieldCenterYPixel - halfGoalPixelSize;

	// lava branka
	DrawLine( pDC, fieldRect.left - m_nFieldGoalLineWidth / 2, goalBottomY, 
			fieldRect.left - m_nFieldGoalLineWidth / 2, goalTopY, &goalPen );

	// prava branka
	DrawLine( pDC, fieldRect.right + m_nFieldGoalLineWidth / 2, goalBottomY,
			fieldRect.right + m_nFieldGoalLineWidth / 2, goalTopY, &goalPen );

	if ( !drawStaticFlags )
		return;

	// zobrazenie vsetkych vlajok na ihrisku ( nulty flag je neplatny )
	CVisObject visFlag;

	for( DWORD i = FT_C; i < DWORD( FT_COUNT ); i++ )
	{
		m_pStaticField->GetFlag( EFlagType( i ), &visFlag );
		DrawFlag( pDC, &visFlag );
	}
}

//////////////////////////////////////////////////////////////////////////////
// void CChildView::DrawFlag( CDC* pDC, CVisObject* visFlag )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		CDC* pDC
//		int pos_x
//		int pos_y
//
//////////////////////////////////////////////////////////////////////////////
void CChildView::DrawFlag( CDC* pDC, CVisObject* pVisFlag )
{
	if ( pVisFlag->GetObjectType() != VOT_Flag )
	{
		ASSERT( 0 );
		return;
	}

	int px, py;

	ConvertWorldToPixel( pVisFlag->GetPosX(), pVisFlag->GetPosY(), px, py );
	
	//if ( m_bVisualSetupFlagIcon )
	if ( 0 )
	{
		// draw flag like icon
		//CBitmap* flagBitmap = GetFlagBitmap();
		//CPalette* flagPallette = GetFlagPallette();
	}
	else
	{
		// 
		int flagSize = int( 1.2f * m_nMeterPixelRatio );
		if ( flagSize > DEFAULT_MAX_FLAG_PIXEL_SIZE )
			flagSize = DEFAULT_MAX_FLAG_PIXEL_SIZE;

		CPen* flagPen = GetFlagPen();

		DrawCross( pDC, px, py, flagSize, flagPen );
	}
}

//////////////////////////////////////////////////////////////////////////////
// void CChildView::DrawBall( CDC* pDC, CVisObject* pVisBall )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		CDC* pDC
//		CVisObject* pVisBall
//
//////////////////////////////////////////////////////////////////////////////
void CChildView::DrawBall( CDC* pDC, CVisObject* pVisBall )
{
	if ( pVisBall->GetObjectType() != VOT_Ball )
	{
		ASSERT( 0 );
		return;
	}

	int ballSize = int( 0.7f * m_nMeterPixelRatio );
	if ( ballSize > DEFAULT_MAX_BALL_PIXEL_SIZE )
		ballSize = DEFAULT_MAX_BALL_PIXEL_SIZE;

	int px, py;
	CPen* ballPen = GetBallPen();
	CBrush* ballBrush = GetBallBrush();

	ConvertWorldToPixel( pVisBall->GetPosX(), pVisBall->GetPosY(), px, py );

	DrawCircle( pDC, px, py, ballSize, ballPen, ballBrush );
}

//////////////////////////////////////////////////////////////////////////////
// void CChildView::DrawOwnAgent( CDC* pDC, CVisObject* pVisAgent )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		CDC* pDC
//		CVisObject* pVisAgent
//
//////////////////////////////////////////////////////////////////////////////
void CChildView::DrawOwnAgent( CDC* pDC, CVisObject* pVisAgent )
{
	if ( pVisAgent->GetObjectType() != VOT_OwnPlayer )
	{
		ASSERT( 0 );
		return;
	}

	int agentSize = int( 1.2f * m_nMeterPixelRatio );
	if ( agentSize > DEFAULT_MAX_AGENT_PIXEL_SIZE )
		agentSize = DEFAULT_MAX_AGENT_PIXEL_SIZE;

	int px, py;
	float kx, ky;

	CPen* agentPen = GetOwnAgentPen();
	CBrush* agentBrush = GetOwnAgentBrush();
	CPen* agentRotationLine = GetOwnAgentRotationLine();

	ConvertWorldToPixel( pVisAgent->GetPosX(), pVisAgent->GetPosY(), px, py );

	// telo
	DrawCircle( pDC, px, py, agentSize, agentPen, agentBrush );

	// rotacia tela
	kx = float( px );
	ky = float( py );
	pVisAgent->Localize( agentSize, pVisAgent->GetRotation(), kx, ky );
	DrawLine( pDC, px, py, int( kx ), int( ky ), agentRotationLine );

	agentPen = GetOwnHeadAgentPen();
	agentBrush = GetOwnHeadAgentBrush();

	// hlava
	DrawCircle( pDC, px, py, agentSize / 2, agentPen, agentBrush );

	// rotacia hlavy
	float headRotation = pVisAgent->GetHeadRotation();
	kx = float( px );
	ky = float( py );
	pVisAgent->Localize( agentSize / 2, headRotation, kx, ky );
	DrawLine( pDC, px, py, int( kx ), int( ky ), agentRotationLine );

	// vykreslenie dohladu hraca
	float viewAngle = pVisAgent->GetViewAngle() / 2;
	int viewDistance = int ( pVisAgent->GetViewDistance() * m_nMeterPixelRatio );
	float kx0 = float( px );
	float ky0 = float( py );
	pVisAgent->Localize( viewDistance, headRotation + viewAngle, kx0, ky0 );
	DrawLine( pDC, px, py, int( kx0 ), int( ky0 ), agentRotationLine );

	float kx1 = float( px );
	float ky1 = float( py );
	pVisAgent->Localize( viewDistance, headRotation - viewAngle, kx1, ky1 );
	DrawLine( pDC, px, py, int( kx1 ), int( ky1 ), agentRotationLine );
	DrawArc( pDC, px - viewDistance, py - viewDistance, px + viewDistance, py + viewDistance, int( kx0 ), int( ky0 ), int( kx1 ), int( ky1 ), agentRotationLine );
	
}

//////////////////////////////////////////////////////////////////////////////
// void CChildView::DrawPlayer( CDC* pDC, CVisObject* pVisPlayer )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		CDC* pDC
//		CVisObject* pVisPlayer
//
//////////////////////////////////////////////////////////////////////////////
void CChildView::DrawPlayer( CDC* pDC, CVisObject* pVisPlayer )
{
	int playerSize = int( 1.1f * m_nMeterPixelRatio );
	if ( playerSize > DEFAULT_MAX_PLAYER_PIXEL_SIZE )
		playerSize = DEFAULT_MAX_PLAYER_PIXEL_SIZE;
	int px, py;

	CPen* playerPen;
	CBrush* playerBrush;

	switch( pVisPlayer->GetObjectType() )
	{
		case VOT_UnknownPlayer :
				playerPen = GetUnknownPlayerPen();
				playerBrush = GetUnknownPlayerBrush();
				break;

		case VOT_EnemyPlayer :
				playerPen = GetEnemyPlayerPen();
				playerBrush = GetEnemyPlayerBrush();
				break;

		case VOT_TeamPlayer :
				playerPen = GetTeamPlayerPen();
				playerBrush = GetTeamPlayerBrush();
				break;

		default :
				ASSERT( 0 );
				return;
	}

	ConvertWorldToPixel( pVisPlayer->GetPosX(), pVisPlayer->GetPosY(), px, py );
	DrawCircle( pDC, px, py, playerSize, playerPen, playerBrush );
}

//////////////////////////////////////////////////////////////////////////////
// void CChildView::DrawPerceptionFlag( CDC* pDC, CVisObject* pVisFlag )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		CDC* pDC
//		CVisObject* pVisFlag
//
//////////////////////////////////////////////////////////////////////////////
void CChildView::DrawPerceptionFlag( CDC* pDC, CVisObject* pVisFlag )
{
	if ( pVisFlag->GetObjectType() != VOT_PerFlag )
	{
		ASSERT( 0 );
		return;
	}

	int flagSize = int( 0.3f * m_nMeterPixelRatio );
	if ( flagSize > DEFAULT_MAX_FLAG_PIXEL_SIZE )
		flagSize = DEFAULT_MAX_FLAG_PIXEL_SIZE;

	int px, py;
	CPen* flagPen;
	CBrush* flagBrush;

	flagPen = GetFlagPen();
	flagBrush = GetFlagBrush();

	ConvertWorldToPixel( pVisFlag->GetPosX(), pVisFlag->GetPosY(), px, py );
	DrawCircle( pDC, px, py, flagSize, flagPen, flagBrush );
}

//////////////////////////////////////////////////////////////////////////////
// void CChildView::DrawPerceptionBall( CDC* pDC, CVisObject* pVisBall )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		CDC* pDC
//		CVisObject* pVisBall
//
//////////////////////////////////////////////////////////////////////////////
void CChildView::DrawPerceptionBall( CDC* pDC, CVisObject* pVisBall )
{
	if ( pVisBall->GetObjectType() != VOT_PerBall )
	{
		ASSERT( 0 );
		return;
	}

	int ballSize = int( 0.4f * m_nMeterPixelRatio );
	if ( ballSize > DEFAULT_MAX_BALL_PIXEL_SIZE )
		ballSize = DEFAULT_MAX_BALL_PIXEL_SIZE;

	int px, py;
	CPen ballPen;
	CBrush ballBrush;

	PerceptionColorUpdate( &ballPen, &ballBrush, GetBallPen(), GetBallBrush() );

	ConvertWorldToPixel( pVisBall->GetPosX(), pVisBall->GetPosY(), px, py );
	DrawCircle( pDC, px, py, ballSize, &ballPen, &ballBrush );
}

//////////////////////////////////////////////////////////////////////////////
// void CChildView::DrawPerceptionPlayer( CDC* pDC, CVisObject* pVisPlayer )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		CDC* pDC
//		CVisObject* pVisPlayer
//
//////////////////////////////////////////////////////////////////////////////
void CChildView::DrawPerceptionPlayer( CDC* pDC, CVisObject* pVisPlayer )
{
	int playerSize = int( 0.5f * m_nMeterPixelRatio );
	if ( playerSize > DEFAULT_MAX_PLAYER_PIXEL_SIZE )
		playerSize = DEFAULT_MAX_PLAYER_PIXEL_SIZE;
	
	int px, py;
	CPen playerPen;
	CBrush playerBrush;


	switch( pVisPlayer->GetObjectType() )
	{
		case VOT_PerUnknownPlayer :
			{
				PerceptionColorUpdate( &playerPen, &playerBrush, GetUnknownPlayerPen(), GetUnknownPlayerBrush() );
			}
			break;

		case VOT_PerTeamPlayer :
			{
				PerceptionColorUpdate( &playerPen, &playerBrush, GetTeamPlayerPen(), GetTeamPlayerBrush() );
			}
			break;

		case VOT_PerEnemyPlayer :
			{
				PerceptionColorUpdate( &playerPen, &playerBrush, GetEnemyPlayerPen(), GetEnemyPlayerBrush() );
			}
			break;

		default :
			ASSERT( 0 );
			return;
	}

	ConvertWorldToPixel( pVisPlayer->GetPosX(), pVisPlayer->GetPosY(), px, py );
	DrawCircle( pDC, px, py, playerSize, &playerPen, &playerBrush );
}

//////////////////////////////////////////////////////////////////////////////
// void CChildView::OnDraw( CDC* pDC )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		CDC* pDC
//
//////////////////////////////////////////////////////////////////////////////
void CChildView::OnDraw( CDC* pDC )
{
	/*CBitmap m_Bitmap;
	CPalette m_Pallette;

	bool imageLoaded = LoadBMPImage( ".\\BMP\\field.bmp", m_Bitmap, &m_Pallette);

	if ( imageLoaded )
		DrawBitmap( pDC, m_Bitmap, &m_Pallette, 50, 70 );

	CBitmap m_Bitmap2;
	CPalette m_Pallette2;

	imageLoaded = LoadBMPImage( ".\\BMP\\logo.bmp", m_Bitmap2, &m_Pallette2 );

	if ( imageLoaded )
		DrawBitmap( pDC, m_Bitmap2, &m_Pallette2, 260, 80 );

	*/

	DrawField( pDC, m_nAllFieldPosXPixel, m_nAllFieldPosYPixel );

	CVisObject fooObject;

	// najskor si zobrazime objekty podla vnutoneho sveta hraca
	fooObject.CreateOwnPlayer( m_pAgent );
	DrawOwnAgent( pDC, &fooObject );

	/*
	// pokusny hrac, neznama strana
	fooObject.CreatePlayer();
	DrawPlayer( pDC, &fooObject );

	// pokusny hrac z nasho timu
	fooObject.CreateTeamPlayer();
	DrawPlayer( pDC, &fooObject );

	// pokusny hrac zo superovho timu
	fooObject.CreateEnemyPlayer();
	DrawPlayer( pDC, &fooObject );

	// loptu nakoniec aby ju bolo vzdy vidiet
	fooObject.CreateBall();
	DrawBall( pDC, &fooObject );
	*/

    if (m_pReadyView != NULL) return;

	// na a tu si prebehneme vsetky vnemy co mame v perception
	// vnemy idu posledne aby boli vzdy na vrchu
	int i, countFlag = m_pPerception->GetFlagsCount();
	//TRACE("\n +++ \n pocet_flagov = %d", countFlag );

	for( i = 0; i < countFlag; i++ )
	{
		if ( m_pPerception->GetSeenFlag( i, &fooObject ) != -1 )
			DrawPerceptionFlag( pDC, &fooObject );
	}

	int countPlayer = m_pPerception->GetPlayersCount();
	//TRACE("\n +++ \n pocet_hracov = %d", countPlayer );

	for( i = 0; i < countPlayer; i++ )
	{
		if ( m_pPerception->GetSeenPlayer( i, &fooObject ) != -1 )
			DrawPerceptionPlayer( pDC, &fooObject );
	}

	if ( m_pPerception->GetSeenBall( &fooObject ) != -1 )
		DrawPerceptionBall( pDC, &fooObject );
}

//////////////////////////////////////////////////////////////////////////////
// bool CChildView::LoadBMPImage( LPCTSTR sBMPFile, CBitmap& bitmap, CPalette *pPal )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		LPCTSTR sBMPFile
//		CBitmap& bitmap
//		CPalette *pPal
//
//////////////////////////////////////////////////////////////////////////////
bool CChildView::LoadBMPImage( LPCTSTR sBMPFile, CBitmap& bitmap, CPalette *pPal )
{
	CFile file;
	if( !file.Open( sBMPFile, CFile::modeRead) )
		return FALSE;

	BITMAPFILEHEADER bmfHeader;

	// Read file header
	if (file.Read((LPSTR)&bmfHeader, sizeof(bmfHeader)) != sizeof(bmfHeader))
		return FALSE;

	// File type should be 'BM'
	if (bmfHeader.bfType != ((WORD) ('M' << 8) | 'B'))
		return FALSE;

	// Get length of the remainder of the file and allocate memory
	DWORD nPackedDIBLen = file.GetLength() - sizeof(BITMAPFILEHEADER);
	HGLOBAL hDIB = ::GlobalAlloc(GMEM_FIXED, nPackedDIBLen);
	if (hDIB == 0)
		return FALSE;

	// Read the remainder of the bitmap file.
	if (file.ReadHuge((LPSTR)hDIB, nPackedDIBLen) != nPackedDIBLen )
	{
		::GlobalFree(hDIB);
		return FALSE;
	}


	BITMAPINFOHEADER &bmiHeader = *(LPBITMAPINFOHEADER)hDIB ;
	BITMAPINFO &bmInfo = *(LPBITMAPINFO)hDIB ;

	// If bmiHeader.biClrUsed is zero we have to infer the number
	// of colors from the number of bits used to specify it.
	int nColors = bmiHeader.biClrUsed ? bmiHeader.biClrUsed : 
						1 << bmiHeader.biBitCount;

	LPVOID lpDIBBits;
	if( bmInfo.bmiHeader.biBitCount > 8 )
		lpDIBBits = (LPVOID)((LPDWORD)(bmInfo.bmiColors + bmInfo.bmiHeader.biClrUsed) + 
			((bmInfo.bmiHeader.biCompression == BI_BITFIELDS) ? 3 : 0));
	else
		lpDIBBits = (LPVOID)(bmInfo.bmiColors + nColors);

	// Create the logical palette
	if( pPal != NULL )
	{
		// Create the palette
		if( nColors <= 256 )
		{
			UINT nSize = sizeof(LOGPALETTE) + (sizeof(PALETTEENTRY) * nColors);
			LOGPALETTE *pLP = (LOGPALETTE *) new BYTE[nSize];

			pLP->palVersion = 0x300;
			pLP->palNumEntries = nColors;

			for( int i=0; i < nColors; i++)
			{
				pLP->palPalEntry[i].peRed = bmInfo.bmiColors[i].rgbRed;
				pLP->palPalEntry[i].peGreen = bmInfo.bmiColors[i].rgbGreen;
				pLP->palPalEntry[i].peBlue = bmInfo.bmiColors[i].rgbBlue;
				pLP->palPalEntry[i].peFlags = 0;
			}

			pPal->CreatePalette( pLP );

			delete[] pLP;
		}
	}

	CClientDC dc(NULL);
	CPalette* pOldPalette = NULL;
	if( pPal )
	{
		pOldPalette = dc.SelectPalette( pPal, FALSE );
		dc.RealizePalette();
	}

	HBITMAP hBmp = CreateDIBitmap( dc.m_hDC,		// handle to device context 
				&bmiHeader,							// pointer to bitmap size and format data 
				CBM_INIT,							// initialization flag 
				lpDIBBits,							// pointer to initialization data 
				&bmInfo,							// pointer to bitmap color-format data 
				DIB_RGB_COLORS);					// color-data usage 
	bitmap.Attach( hBmp );

	if( pOldPalette )
		dc.SelectPalette( pOldPalette, FALSE );

	::GlobalFree(hDIB);
	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////
// void CChildView::DrawBitmap(CDC* pDC, CBitmap& bitmap, CPalette *pPal, int pos_x, int pos_y )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		CDC* pDC
//		CBitmap& bitmap
//		CPalette *pPal
//
//////////////////////////////////////////////////////////////////////////////
void CChildView::DrawBitmap(CDC* pDC, CBitmap& bitmap, CPalette *pPal, int pos_x, int pos_y )
{
	// Create a compatible memory DC
	CDC memDC;
	memDC.CreateCompatibleDC( pDC );
	memDC.SelectObject( &bitmap );

	// Select and realize the palette
	if( pPal != NULL && pDC->GetDeviceCaps( RASTERCAPS ) & RC_PALETTE )
	{
		pDC->SelectPalette( pPal, FALSE );
		pDC->RealizePalette();
	}

	BITMAP bm;
	bitmap.GetBitmap( &bm );

	pDC->BitBlt( pos_x, pos_y, bm.bmWidth, bm.bmHeight, &memDC, 0, 0,SRCCOPY );
}

//////////////////////////////////////////////////////////////////////////////
// void CChildView::OnPaint() 
// ---------------------------------------------------------------------------
// Description:
//		
//
//////////////////////////////////////////////////////////////////////////////
void CChildView::OnPaint() 
{
	CPaintDC	dc( this ); // device context for painting
	CRect		rectUpdate;

	dc.GetClipBox( &rectUpdate );

	CBitmap* oldBitmap = m_pMyDevice->SelectObject( m_pMyBitmap );
	
	m_pMyDevice->SelectClipRgn( 0 );
	m_pMyDevice->IntersectClipRect( &rectUpdate );

	CBrush bkgndBrush( ( COLORREF ) ::GetSysColor( COLOR_WINDOW ) );
	CBrush* oldBrush = m_pMyDevice->SelectObject( &bkgndBrush );

	m_pMyDevice->PatBlt( rectUpdate.left, rectUpdate.top, rectUpdate.Width(), rectUpdate.Height(), PATCOPY );

	OnDraw( m_pMyDevice );

	dc.BitBlt( rectUpdate.left, rectUpdate.top, rectUpdate.Width(), rectUpdate.Height(), 
			m_pMyDevice, rectUpdate.left, rectUpdate.top, SRCCOPY );

	m_pMyDevice->SelectObject( oldBitmap );
	m_pMyDevice->SelectObject( oldBrush );

    m_pReadyView = this;
}

//////////////////////////////////////////////////////////////////////////////
// BOOL CChildView::OnEraseBkgnd(CDC* pDC) 
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		CDC* pDC
//
//////////////////////////////////////////////////////////////////////////////
BOOL CChildView::OnEraseBkgnd(CDC* pDC) 
{
	//return CWnd ::OnEraseBkgnd(pDC);
	return FALSE;
}

//////////////////////////////////////////////////////////////////////////////
// BOOL CChildView::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext) 
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		LPCTSTR lpszClassName
//		LPCTSTR lpszWindowName
//		DWORD dwStyle
//		const RECT& rect
//		CWnd* pParentWnd
//		UINT nID
//		CCreateContext* pContext
//
//////////////////////////////////////////////////////////////////////////////
BOOL CChildView::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext) 
{
	// TODO: Add your specialized code here and/or call the base class
	
	BOOL retVal = CWnd::Create(lpszClassName, lpszWindowName, dwStyle, rect, pParentWnd, nID, pContext);

	CClientDC dc( this );
	m_pMyDevice->CreateCompatibleDC( &dc );
	m_pMyBitmap->CreateCompatibleBitmap( &dc, ::GetSystemMetrics( SM_CXSCREEN ), ::GetSystemMetrics( SM_CYSCREEN ) ); 
	m_pMyDevice->SetMapMode( MM_TEXT );

	return retVal;
}

void CChildView::OnSize(UINT nType, int cx, int cy) 
{
	m_nMeterPixelRatio = min( cx / ( 1.05f * 115 ), cy / ( 1.05f * 78 ) );

	m_nFieldLengthPixel = m_pStaticField->GetFieldLength() * m_nMeterPixelRatio;
	m_nFieldWidthPixel = m_pStaticField->GetFieldWidth() * m_nMeterPixelRatio;
	m_nFieldBorderPixel = DEFAULT_FIELD_BORDER_SIZE * m_nMeterPixelRatio;

	m_nAllFieldPosXPixel = 0;
	m_nAllFieldPosYPixel = 0;

	m_nFieldCenterXPixel = m_nAllFieldPosXPixel + m_nFieldBorderPixel + m_nFieldLengthPixel / 2;
	m_nFieldCenterYPixel = m_nAllFieldPosYPixel + m_nFieldBorderPixel + m_nFieldWidthPixel / 2;


	CWnd ::OnSize(nType, cx, cy);
}
