// LogManager.cpp: implementation of the CLogManager class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Player.h"
#include "LogManager.h"
#include "ToDoClasses.h"
#include "TextMessageBuffer.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

const int MAX_FULL_MESSAGE_LENGHT = 256;
const DWORD LOG_FILE_MASK = 0x00000000;
#define LOG_FILE "pokus.log"

#pragma warning (disable : 4786)

CLogManager cLogManager;

void log_msg( DWORD priority, const char* str, ...) 
{
	va_list args;
	va_start( args, str );

	FILE* file = cLogManager.GetFileHandle( LOG_FILE );

	if ( !file ) 
	{
		// subor nie je otvoreny
		return;
	}

	cLogManager.AddMessageText( file, priority, str, args );
}

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CLogManager::CLogManager()
{
	AddNewFile( LOG_FILE, LOG_FILE_MASK );
}

CLogManager::~CLogManager()
{

}

//////////////////////////////////////////////////////////////////////////////
// FILE* CLogManager::GetFileHandle( char* sFileName )
// ---------------------------------------------------------------------------
// Description:
//		vrati smernik na subor, ktory ma nazov sfileName
//
// ---------------------------------------------------------------------------
// Parameters:
//		char* sFileName
//
//////////////////////////////////////////////////////////////////////////////
FILE* CLogManager::GetFileHandle( char* sFileName )
{
	string s( sFileName );

	if ( m_vFiles.find( s ) == m_vFiles.end() )
	{
		// takyto subor nie je zadefinovany
		return 0;
	}

	SFilePriorityMask str = m_vFiles[s];

	return str.file_hande;
}

//////////////////////////////////////////////////////////////////////////////
// void CLogManager::AddNewFile( const char* sName, DWORD mask )
// ---------------------------------------------------------------------------
// Description:
//		otvorenie noveho suboru
//
// ---------------------------------------------------------------------------
// Parameters:
//		char* sName
//		DWORD mask			- maska urcuje ktore spravy budu smerovat do
//							  tohto suboru
//
//////////////////////////////////////////////////////////////////////////////
void CLogManager::AddNewFile( char* sName, DWORD mask )
{
	FILE* new_file = fopen( sName, "w" );

	if ( !new_file )
	{
		// nepodarilo sa otvorit novy subor
		return;
	}

	SFilePriorityMask new_structure;
	string s( sName );

	new_structure.active_priority = 0;
	new_structure.upper_mask = mask;
	new_structure.file_hande = new_file;

	m_vFiles[s] = new_structure;
}

//////////////////////////////////////////////////////////////////////////////
// void CLogManager::AddActivePriority( char* sFileName, DWORD dNewPriority )
// ---------------------------------------------------------------------------
// Description:
//		pridanie noveju aktivnej priority, aktivna priorita je taka, ktora sa loguje
//
// ---------------------------------------------------------------------------
// Parameters:
//		char* sFileName
//		DWORD dNewPriority
//
//////////////////////////////////////////////////////////////////////////////
void CLogManager::AddActivePriority( char* sFileName, DWORD dNewPriority )
{
	string s( sFileName );

	if ( m_vFiles.find( s ) == m_vFiles.end() )
	{
		// takyto subor nie je zadefinovany
		return;
	}

	SFilePriorityMask new_structure = m_vFiles[s];
	// tu by somn este mohol hodit nejake testy
	new_structure.active_priority |= dNewPriority;
	m_vFiles[s] = new_structure;
}

//////////////////////////////////////////////////////////////////////////////
// void CLogManager::RemoveActivePriority( char* sFileName, DWORD dRemPriority )
// ---------------------------------------------------------------------------
// Description:
//		odstranenie aktivnej priority
//
// ---------------------------------------------------------------------------
// Parameters:
//		DWORD dRemPriority
//
//////////////////////////////////////////////////////////////////////////////
void CLogManager::RemoveActivePriority( char* sFileName, DWORD dRemPriority )
{
	string s( sFileName );

	if ( m_vFiles.find( s ) == m_vFiles.end() )
	{
		// takyto subor nie je zadefinovany
		return;
	}

	SFilePriorityMask new_structure = m_vFiles[s];
	// tu by somn este mohol hodit nejake testy

	new_structure.active_priority &= ~dRemPriority;
	m_vFiles[s] = new_structure;
}

//////////////////////////////////////////////////////////////////////////////
// void CLogManager::AddMessageText( FILE* pFile, DWORD dPriority, const char* fmt, va_list args )
// ---------------------------------------------------------------------------
// Description:
//		vypis textovej spravy do suboru s logovacieho okna na obrazovku, resp.
//		ladiaceho okna MS Visual Studia
//
// ---------------------------------------------------------------------------
// Parameters:
//		FILE* pFile
//		DWORD dPriority
//		const char* fmt
//		va_list args
//
//////////////////////////////////////////////////////////////////////////////
void CLogManager::AddMessageText( FILE* pFile, DWORD dPriority, const char* fmt, va_list args )
{
	vfprintf( pFile, fmt, args );
	fprintf( pFile, "\n" );

	char st_args[MAX_FULL_MESSAGE_LENGHT];
	vsprintf( st_args, fmt, args );
	text_buffer.AddMessage( st_args, dPriority );
}
