// WorldObjects.cpp: implementation of various world object types....
//
//////////////////////////////////////////////////////////////////////

#include "stdAfx.h"
#include "WorldObjects.h"
#include "staticfield.h"
#include "Player.h"
#include "Coordinator.h"

#include "ChildView.h"  // FIXME
#include "ToDoEvent.h"
#include "TextMessageBuffer.h"


CStaticField field;

inline double WeightFn(double d)
{
	return 1.0 / (0.01 + d);
}


CGameCommand *CLocalAgent::Deliberate(CPerceptionSeq *pPerceptionSeq)
{
    CPerception *pPerception;
    static CPerception rPerception;
    static CPerception rPerception0;

	rPerception.ClearAll();
    while (pPerceptionSeq->GetPerception(&pPerception))
	{
		rPerception = *pPerception;
		delete pPerception;

		while(rPerception.GetPlayTime()>m_time)
		{
			Precompute();
		}

		switch(rPerception.GetMsgType())
		{
			case MT_See:
			{
				UpdatePlayerPosition(rPerception.GetSeenFlags(), rPerception.GetSeenGoals(),rPerception.GetSeenLines());

				if (m_pReadyView)
				{
					rPerception0 = rPerception;
					m_pReadyView->SetNewPerception(&rPerception0);

					CChildView *vv = m_pReadyView;

					vv->m_pAgent->SetPosition(GetPosition());
					vv->m_pAgent->SetDirection(GetDirection());
					vv->m_pAgent->SetNeckDirection(GetNeckDirection());
					m_pReadyView = NULL;  // FIXMEEEE
					vv->Invalidate();
                }
			}
			break;
			case MT_Hear:
			{
				fprintf(m_ff, "<hear>\n");
			}
			break;
			case MT_SenseBody:
			{
                CSenseBody my_body;

                rPerception.GetSenseBody(&my_body);
				UpdatePlayerProperties(&my_body);

				if (m_pReadyView)
				{
					rPerception0 = rPerception;
					m_pReadyView->SetNewPerception(&rPerception0);

					// skusime bobrikov algoritmus lokalizacie 
					//   zatial len kvoli vizualizacii
					CChildView *vv = m_pReadyView;
					// nasledujucu sekciu zaremovat, aby sa nerobila LOKALIZACIA
					  vv->m_pAgent->SetDirection(GetDirection());
				}

			}
			break;
		}
    }

    pPerceptionSeq->Clear();
	return GetCommand();
}




/*

void Deliberate(CPerceptionSeq *pPerceptionSeq)
{
    static CGameCommandSeq cSendCommands;
    CGameCommand cGameCommand;



        if (rPerception.GetMsgType() == MT_See) {
//			fprintf(m_ff, "<see>\n");
//				nLastPlayTime = rPerception.GetPlayTime();
			if (rPerception.IsBallSeen()) {
				CSeenObject ball;
				rPerception.GetBall(&ball);
				if (ball.GetDistance() > 1.2) {
					if ((ball.GetDirection() < 5) && (ball.GetDirection() > -5)) {
						cGameCommand.m_tCmdType = CT__DASH;
						cGameCommand.m_val_A = 10.00;
					} else {
						cGameCommand.m_tCmdType = CT__TURN;
						cGameCommand.m_val_A = ball.GetDirection();
						todo2 = 11;
					}
				} else {
					cGameCommand.m_tCmdType = CT__KICK;
					cGameCommand.m_val_A = 50.00;
					cGameCommand.m_val_B =  0.00;
					log_msg("kick %lf %lf", cGameCommand.m_val_A, cGameCommand.m_val_B);
				}

				//todo = -1;
				//if (todo != -1) 
			} else {  // "(turn 15.00)";
        		cGameCommand.m_tCmdType = CT__TURN;
        		cGameCommand.m_val_A = 15.00;
            } //else todo = 0;
			todo = 0;

            cSendCommands.Add(&cGameCommand);

            static CSendDataEvent event;
            event.m_eType = ET__SEND_COMMANDS;
            event.m_pGameCommandSeq = &cSendCommands;
			fprintf(m_ff, "<send>\n");
            EventDispatcher.SendEvent(&event);
*/

bool CLocalAgent::UpdatePlayerProperties(CSenseBody *sense_body)
{
    m_see_status|=SEE_BODY_DIRECTION|SEE_STAMINA|SEE_EFFORT|SEE_DISTANCE_CHANGE;

    if( !(m_see_status & EXPECTED_ANGLE_CHANGE || m_see_status & SEE_ANGLE_CHANGE))
    {
        m_speed.SetXYDiffusion(1,0,1e9);
    }

    m_speed.SetDistance(sense_body->GetSpeed());
    m_stamina=sense_body->GetStamina();
    m_effort=sense_body->GetEffort();
    m_direction=m_neck_direction - sense_body->GetHeadDir();
    return true;
}





bool CLocalAgent::UpdatePlayerPosition(CSeenFlagsVect &_fFlags, CSeenGoalsVect &_gGoals, CSeenLinesVect &_lLines)//nasty&ughly
{
	//flagy a goaly

	int fsz = _fFlags.size();
	int gsz = _gGoals.size();
	DiffusePointVector flag_points , goal_points;
	flag_points.resize(fsz);
	goal_points.resize(gsz);

	int i;

	// spocitat relativne suradnice bodov

	for(i = 0 ; i < fsz ; i++)
	{
		CAngular2DVector flag_ang(_fFlags[i].GetDirection() * PI / 180 , _fFlags[i].GetDistance());
		flag_points[i] = CDiffuse2DVector(flag_ang , 0.1 , 0.01 , 0.1);
	}

	for(i = 0 ; i < gsz ; i++)
	{
		CAngular2DVector goal_ang(_gGoals[i].GetDirection() * PI / 180 , _gGoals[i].GetDistance());
		goal_points[i] = CDiffuse2DVector(goal_ang , 0.1 , 0.01 , 0.1);
	}

	double S = 0 , r;

	//vahovany aritmenicky priemer...

	C2DVector T , P , t , p;

	
	for(i = 0 ; i < fsz ; i++)
	{
//		if( (_fFlags[i].GetFlags() & SEE_PERCEPTION_DISTANCE ) &&
//			(_fFlags[i].GetFlags() & SEE_PERCEPTION_DIRECTION) &&
//			(_fFlags[i].GetFlags() & SEE_PERCEPTION_TYPE     ))
		{
			r = WeightFn(flag_points[i].GetDiffusion());

			T += r * field.GetFlag(_fFlags[i].GetFlagID());
			P += r * flag_points[i];
			S += r;
		}
	}

	for(i = 0 ; i < gsz ; i++)
	{
//		if( (_fGoals[i].GetFlags() & SEE_PERCEPTION_DISTANCE ) &&
//			(_fGoals[i].GetFlags() & SEE_PERCEPTION_DIRECTION) &&
//			(_fGoals[i].GetFlags() & SEE_PERCEPTION_TYPE     ))
		{
			r = WeightFn(goal_points[i].GetDiffusion());

			T += r * field.GetGoal(_gGoals[i].GetGoalID());
			P += r * goal_points[i];
			S += r;
		}
	}

	if(S > 0)
	{
		T/=S;
		P/=S;

		double A = 0,B = 0,C = 0;

		for(i = 0 ; i < fsz ; i++)
		{
//			if( (_fFlags[i].GetFlags() & SEE_PERCEPTION_DISTANCE ) &&
//				(_fFlags[i].GetFlags() & SEE_PERCEPTION_DIRECTION) &&
//				(_fFlags[i].GetFlags() & SEE_PERCEPTION_TYPE     ))
			{
				r = WeightFn(flag_points[i].GetDiffusion());
				t = T - field.GetFlag(_fFlags[i].GetFlagID());
				p = flag_points[i];

				A += r * (p & P);
				B += r * (p & t);
				C += r * (p * t);
			}
		}

		for(i = 0 ; i < gsz ; i++)
		{
//			if( (_fGoals[i].GetFlags() & SEE_PERCEPTION_DISTANCE ) &&
//				(_fGoals[i].GetFlags() & SEE_PERCEPTION_DIRECTION) &&
//				(_fGoals[i].GetFlags() & SEE_PERCEPTION_TYPE     ))
			{
				r = WeightFn(goal_points[i].GetDiffusion());
				t = T - field.GetGoal(_gGoals[i].GetGoalID());
				p = goal_points[i];

				A += r * (p & P);
				B += r * (p & t);
				C += r * (p * t);
			}
		}
		float angle = (acosf(A / sqrt(B * B + C * C)) + atan2( C , B));

		C2DVector Poz = T - Rot(P , -angle);

        // na zaver este zratame svoju vlastnu neurcitost...

		double E=0;

		for(i = 0 ; i < fsz ; i++)
		{
//			if( (_fFlags[i].GetFlags() & SEE_PERCEPTION_DISTANCE ) &&
//				(_fFlags[i].GetFlags() & SEE_PERCEPTION_DIRECTION) &&
//				(_fFlags[i].GetFlags() & SEE_PERCEPTION_TYPE     ))
			{
				p = flag_points[i] - Rot(field.GetFlag(_fFlags[i].GetFlagID()) - Poz , angle);

				E += WeightFn(flag_points[i].GetDiffusion()) * (p * p);
			}
		}

		for(i = 0 ; i < gsz ; i++)
		{
//			if( (_fGoals[i].GetFlags() & SEE_PERCEPTION_DISTANCE ) &&
//				(_fGoals[i].GetFlags() & SEE_PERCEPTION_DIRECTION) &&
//				(_fGoals[i].GetFlags() & SEE_PERCEPTION_TYPE     ))
			{
				p = goal_points[i] - Rot(field.GetGoal(_gGoals[i].GetGoalID()) - Poz , angle);

				E += WeightFn(goal_points[i].GetDiffusion()) * (p * p);
			}
		}


        CDiffuse2DVector old=m_position;

        m_position.SetVDiffusion(Poz , sqrt(E / S));
		m_neck_direction =RadToDeg(AngNormalise( angle ));

        if(m_see_status& PREV_POSITION)
        {
            if( (m_see_status & EXPECTED_ANGLE) &&
                ( m_see_status & EXPECTED_DISTANCE) &&
                ( m_see_status & EXPECTED_NECK_DIRECTION)
              )
            {
                CDiffuse2DVector dif=old-m_position;

                if(dif.GetDiffusion()>dif.GetDistance())
                {
                    if( m_see_status & EXPECTED_ANGLE_CHANGE &&
                        m_see_status & EXPECTED_DISTANCE_CHANGE)
                    {
                        CDiffuse2DVector Speed=m_position-m_prev_position;
                        if(m_see_status&SEE_DISTANCE_CHANGE)
                        {
                            m_speed.SetAngle(Speed.GetAngle());
                            m_speed.SetDiffusion(Speed.GetDiffusion());

                            m_see_status|=SEE_ANGLE_CHANGE;
                        }
                        else
                        {
                            m_speed=Speed;
                        }
                        m_see_status|=SEE_ANGLE_CHANGE;

                        if(m_see_status&PREV_SPEED)
                        {
                            m_acceleration=m_speed-m_prev_speed;
                            m_see_status|=EXPECTED_ACCELERATION;
                        }
                    }
                }
                else
                {
                    m_see_status &= (!PREV_MASK) & (!EXPECTED_DISTANCE_CHANGE) &(!EXPECTED_ANGLE_CHANGE);
                }
            }
        }

        m_see_status|=SEE_ANGLE|SEE_DISTANCE|SEE_NECK_DIRECTION;

		return true;


	}
	return false;
}



void CAgent::UpdateApproachDistances(const CMovingObject &obj,const CAgent &local)//ughly
{
	CAngular2DVector pt(obj.GetPosition());
	m_approach_distances[m_approach_distances.size()*pt.GetAngle()/2/PI] =
        __max(0,pt.GetDistance()-obj.GetPosition().GetDiffusion());
}

void CBall::UpdateBallPosition(CSeenObject _oBall,const CAgent &local)//ughly
{

/*	int flags=_oBall.GetSetValuesVar();

	if(! (flags &SEE_ANGLE))
	{
		m_position.SetAngleDistance(_oBall.GetDirection()+local.GetNeckDirection(),
/*
    last_seen=0;

    see_status &= !SEE_MASK;

    int flags=_oBall.GetSetValuesVar();


    if(! (flags & (SEE_ANGLE | SEE_DISTANCE | SEE_ANGLE_CHANGE | SEE_DISTANCE_CHANGE)))
    {
        see_status |= SEE_ANGLE | SEE_DISTANCE;
        see_status &= _ANGLE  SEE_DISTANCE;

        
	int useable=SEE_NOTHING;




    if(flags & SEE_ANGLE && flags & SEE_DISTANCE)
    {
        useable=SEE_ANGLE|SEE_DISTANCE;
        see_position.SetAngle(_oBall.GetDirection());
        see_position.SetDistance(_oBall.GetDistance());
        C2DVector=new_position = local.GetPosition() + Rot(CDiffuse2DVector(see_position , 0.1 , 0.1 , 0.1) , local.GetNeckDirection());
		if(
    }
*/
}


double CAgent::TestOwnership(const CSeenPlayer &player,const CAgent &local)//ughly&nasty
{
    return 0.0;
}

void  CAgent::Update(const CSeenPlayer &player,const CAgent &local)//ughly
{
}

void  CAgent::Precompute()//nasty
{
}


CGameCommand * CAgent::GetCommand()
{
	return 0;
}

void CMovingObject::Precompute()
{
}