#ifndef _WORLD_GEOMETRY_76547643
#define _WORLD_GEOMETRY_76547643

#include "types.h"

class CAngular2DVector;
class CDiffuse2DVector;
class C2DLine;

class C2DVector
{
//friend C2DVector operator - (C2DVector p1 , const C2DVector &p2);

protected:
public:

friend C2DVector operator * (double f     , C2DVector p);
friend C2DVector operator * (const C2DVector &p  , double f);
friend C2DVector operator / (const C2DVector &p  , double f);
friend C2DVector operator + (const C2DVector &p1 , const C2DVector &p2);
friend double    operator * (const C2DVector &p1 , const C2DVector &p2);
friend double    operator & (const C2DVector &p1 , const C2DVector &p2);

friend C2DVector Rot(const C2DVector &q,double a);

friend CAngular2DVector;
friend CDiffuse2DVector;
friend C2DLine;

	double m_x , m_y;

public:

	C2DVector(const C2DVector &p)
	{
		m_x = p.m_x;
		m_y = p.m_y;
	}

	C2DVector(const CAngular2DVector &p);

	C2DVector(double x , double y)
	{
		m_x = x;
		m_y = y;
	}

	C2DVector()
	{
		m_x = 0;
		m_y = 0;
	}
	
	void SetXY(double x , double y)
	{
		m_x = x;
		m_y = y;
	}

	void SetX(double x)
	{
		m_x = x;
	}

	void SetY(double y)
	{
		m_y = y;
	}

	void SetAngleDistance(double a , double d)
	{
		m_x = d * cos(a);
		m_y = d * sin(a);
	}

	void SetAngle(double a);

	void SetDistance(double d);

	double GetX() const
	{
		return m_x;
	}

	double GetY() const
	{
		return m_y;
	}

    double GetAngle() const
	{
		return atan2(m_x , m_y);
	}

	double GetDistance() const
	{
		return sqrt(m_x * m_x + m_y * m_y);
	}

	const C2DVector	&operator = (const C2DVector &q)
	{
		m_x = q.m_x;
		m_y = q.m_y;
		return q;
	}

	const C2DVector	&operator += (const C2DVector &q)
	{
		m_x += q.m_x;
		m_y += q.m_y;
		return *this;
	}

	const C2DVector	&operator -= (const C2DVector &q)
	{
		m_x -= q.m_x;
		m_y -= q.m_y;
		return *this;
	}

	const C2DVector	&operator *= (double q)
	{
		m_x *= q;
		m_y *= q;
		return *this;
	}

	const C2DVector	&operator /= (double q)
	{
		m_x /= q;
		m_y /= q;
		return *this;
	}

	const	C2DVector	&operator = (const CAngular2DVector &q);
};

class CAngular2DVector
{

protected:

friend C2DVector;
friend CDiffuse2DVector;
friend C2DLine;

	double m_a,m_d;

public:

	CAngular2DVector(const CAngular2DVector &p)
	{ 
		m_a = p.m_a;
		m_d = p.m_d;
	}

	CAngular2DVector(double a , double d)
	{
		m_a = a;
		m_d = d;
	}

	CAngular2DVector(const C2DVector &q)
	{
		m_a = atan2(q.m_x , q.m_y);
		m_d = sqrt(q.m_x * q.m_x + q.m_y * q.m_y);
	}
	CAngular2DVector()
	{
		m_a = 0;
		m_d = 0;
	}

	void SetAngleDistance(double a , double d)
	{
		m_a = a;
		m_d = d;
	}

	void SetAngle(double a)
	{
		m_a = a;
	}

	void SetDistance(double d)
	{
		m_d = d;
	}

	double GetAngle() const
	{
		return m_a;
	}

	double GetDistance() const
	{
		return m_d;
	}

	double GetX() const
	{
		return m_d * cos(m_a);
	}

	double GetY() const
	{
		return m_d * sin(m_a);
	}

	const CAngular2DVector &operator = (const CAngular2DVector &q)
	{
		m_a = q.m_a;
		m_d = q.m_d;
		return q;
	}

	const CAngular2DVector &operator = (const C2DVector &q)
	{
		m_a = atan2(q.m_x , q.m_y);
		m_d = sqrt(q.m_x * q.m_x + q.m_y * q.m_y);
		return *this;
	}
};

	
class CDiffuse2DVector:public C2DVector
{

protected:

//friend CDiffuse2DVector operator -(CDiffuse2DVector p1,const CDiffuse2DVector &p2);
friend CDiffuse2DVector operator +(CDiffuse2DVector p1,const CDiffuse2DVector &p2);
friend CDiffuse2DVector operator *(CDiffuse2DVector p,double f);
friend CDiffuse2DVector operator /(CDiffuse2DVector p,double f);
friend CDiffuse2DVector operator *(double f,CDiffuse2DVector p);

friend CDiffuse2DVector Rot(const CDiffuse2DVector &q,double a);

friend C2DVector;
friend CAngular2DVector;
friend C2DLine;

	double m_d;

public:

	CDiffuse2DVector(const C2DVector &p , double d) : C2DVector(p)
	{
		m_d = d;
	}

	CDiffuse2DVector(const CAngular2DVector &p , double d) : C2DVector(p)
	{
		m_d = d;
	}

	CDiffuse2DVector(const CAngular2DVector &p , double disc_a , double disc_e , double disc_b);

	CDiffuse2DVector(const CDiffuse2DVector &p) : C2DVector(p)
	{
		m_d = p.m_d;
	}

	CDiffuse2DVector(double x , double y , double d) : C2DVector(x , y)
	{
		m_d = d;
	}

	CDiffuse2DVector()
	{
		m_d = 0;
	}
	
	void SetXYDiffusion(double x,double y,double d)
	{
		m_x = x;
		m_y = y;
		m_d = d;
	}

	void SetVDiffusion(const C2DVector &v,double d)
	{
		m_x = v.m_x;
		m_y = v.m_y;
		m_d = d;
	}

	void SetDiffusion(double d)
	{
		m_d = d;
	}

	double GetDiffusion() const
	{
		return m_d;
	}

	const CDiffuse2DVector &operator = (const CDiffuse2DVector &q)
	{
		m_x = q.m_x;
		m_y = q.m_y;
		m_d = q.m_d;
		return *this;
	}

	const CDiffuse2DVector &operator += (const CDiffuse2DVector &q)
	{
		m_x += q.m_x;
		m_y += q.m_y;
		m_d += q.m_d;
		return *this;
	}

	const CDiffuse2DVector &operator -= (const CDiffuse2DVector &q)
	{
		m_x -= q.m_x;
		m_y -= q.m_y;
		m_d += q.m_d;
		return *this;
	}

	const CDiffuse2DVector &operator *= (double q)
	{
		m_x *= q;
		m_y *= q;
		m_d *= q;
		return *this;
	}

	const CDiffuse2DVector &operator /= (double q)
	{
		m_x /= q;
		m_y /= q;
		m_d /= q;
		return *this;
	}

};



class C2DLine
{
protected:

	double m_a,m_d;

public:

	C2DLine()
	{
		m_a = 0;
		m_d = 0;
	}

	C2DLine(const C2DLine &l)
	{
		m_a = l.m_a; 
	 	m_d = l.m_d;
	}

	C2DLine(double a,double d)
	{
		m_a = a;
		m_d = d;
	}

	C2DLine(const C2DVector &p1,const C2DVector &p2)
	{
		double dx = p2.m_x - p1.m_x;
		double dy = p2.m_y - p1.m_y;

		m_a = atan2(dy , dx);
		m_d = p1.m_x * dy - p1.m_y * dx;
	}

	void Set(const C2DVector &p1,const C2DVector &p2)
	{
		double dx = p2.m_x - p1.m_x;
		double dy = p2.m_y - p1.m_y;

		m_a = atan2(dy , dx);
		m_d = p1.m_x * dy - p1.m_y * dx;
	}
};


inline C2DVector Rot(const C2DVector &q,double a)
{
	return C2DVector(q.m_x * cos(a) - q.m_y * sin(a), q.m_x * sin(a) + q.m_y * cos(a));
}

inline CDiffuse2DVector Rot(const CDiffuse2DVector &q,double a)
{
	return CDiffuse2DVector(q.m_x * cos(a) - q.m_y * sin(a), q.m_x * sin(a) + q.m_y * cos(a),q.m_d);
}


const inline C2DVector &C2DVector::operator = (const CAngular2DVector &q)
{
	m_x = q.m_d * cos(q.m_a);
	m_y = q.m_d * sin(q.m_a);
	return *this;
}

inline C2DVector operator * (double f , C2DVector p)
{
	p.m_x *= f; 
	p.m_y *= f;
	return p;
} // ako by sa toto dalo napisat efektivnejsie ???

inline CDiffuse2DVector operator * (double f , CDiffuse2DVector p)
{
	p.m_x *= f;
	p.m_y *= f;
	p.m_d *= f;
	return p;
} // ako by sa toto dalo napisat efektivnejsie ???

inline C2DVector operator * (C2DVector p , double f)
{
	p.m_x *= f; 
	p.m_y *= f;
	return p;
} // ako by sa toto dalo napisat efektivnejsie ???

inline CDiffuse2DVector operator * (CDiffuse2DVector p , double f)
{
	p.m_x *= f;
	p.m_y *= f;
	p.m_d *= f;
	return p;
} // ako by sa toto dalo napisat efektivnejsie ???
/*
a takto by to vyzeralo, keby to bolo podla R.K.

inline CDiffuse2DVector operator *(CDiffuse2DVector p , double f)
{
	p.SetX(p.GetX() * f);
	p.SetY(p.GetY() * f);
	p.SetDiffuse(p.GetDiffuse() * f);
	return p;
}

BRRRR....
*/

inline C2DVector operator / (C2DVector p , double f)
{
	p.m_x /= f;
	p.m_y /= f;
	return p;
} // ako by sa toto dalo napisat efektivnejsie ???

inline CDiffuse2DVector operator / (CDiffuse2DVector p , double f)
{ 
	p.m_x /= f;
	p.m_y /= f;
	p.m_d /= f;
	return p;
} // ako by sa toto dalo napisat efektivnejsie ???

inline C2DVector::C2DVector(const CAngular2DVector &p)
{
	m_x = p.m_d * cos(p.m_a);
	m_y = p.m_d * sin(p.m_a);
}

inline void C2DVector::SetDistance(double d)
{
	SetAngleDistance(GetAngle() , d);
}

inline void C2DVector::SetAngle(double a)
{
	SetAngleDistance(a , GetDistance());
}

inline CDiffuse2DVector::CDiffuse2DVector(const CAngular2DVector &p , double disc_b , double disc_e , double disc_a)
{
	disc_a /= 2;
	disc_b /= 2;
	double demaxmax = exp(log(p.m_d + disc_b) + disc_e);
	double deminmin = exp(log(p.m_d - disc_b) - disc_e);

	disc_a = (demaxmax - deminmin) / 2;
	//demaxmax-=disc_a;

	m_x = p.m_d * cos(p.m_a);
	m_y = p.m_d * sin(p.m_a);

	m_d = (disc_a + disc_b) / 2;
}


inline C2DVector operator - (C2DVector &p1 ,C2DVector &p2)
{
	return C2DVector(p1.GetX() - p2.GetX() , p1.GetY() - p2.GetY());
}

inline C2DVector operator + (const C2DVector &p1 , const C2DVector &p2)
{
	return C2DVector(p1.m_x + p2.m_x , p1.m_y + p2.m_y);
}

inline double operator * (const C2DVector &p1 , const C2DVector &p2)
{
	return p1.m_x*p2.m_x+p1.m_y*p2.m_y;
}

inline double operator & (const C2DVector &p1 ,const C2DVector &p2)
{
	return p1.m_x * p2.m_y - p1.m_y * p2.m_x;
}




inline CDiffuse2DVector operator - (CDiffuse2DVector &p1 ,CDiffuse2DVector &p2)
{
    return CDiffuse2DVector(p1.GetX() - p2.GetX() , p1.GetY() - p2.GetY() , p1.GetDiffusion() + p2.GetDiffusion());
}


//what else ???

inline double AngNormalise(double a)
{
    return fmod(a,2*PI);
}

inline double AngDistance(double a1,double a2)
{
    double da=AngNormalise(a1)-AngNormalise(a2);
    if(da> PI) return da-2*PI;
    if(da<-PI) return da+2*PI;
    return da;
}

#define RadToDeg(a) ((a) * 180.0 / PI)
#define DegToRad(a) ((a) * PI / 180.0)

#endif


