// VisObject.h: interface for the CVisObject class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_VISOBJECT_H__63238AC9_3FAD_4F3A_A8D1_29AAF7449AB8__INCLUDED_)
#define AFX_VISOBJECT_H__63238AC9_3FAD_4F3A_A8D1_29AAF7449AB8__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ToDoClasses.h"
#include "WorldGeometry.h"
class CSeenFlag;
class CSeenObject;
class CSeenPlayer;

enum EVisObjectType {

	VOT_None,
	VOT_Flag,
	VOT_Line,
	VOT_Ball,
	VOT_OwnPlayer,
	VOT_UnknownPlayer,
	VOT_TeamPlayer,
	VOT_EnemyPlayer,

	VOT_PerFlag,
	VOT_PerBall,
	VOT_PerLine,
	VOT_PerPlayer,

	VOT_Count
};

class CAgent;

class CVisObject  
{
	EVisObjectType	m_eObjectType;		// typ objektu
	float			m_fPosX;			// x-ova pozicia objektu vo svet. suradniciach
	float			m_fPosY;			// y-ova pozicia objektu vo svet. suradniciach
	float			m_fRotation;		// rotacia objektu

	float			m_fHeadRotation;	// rotacia hlavy hracov, u ostatnych objektoch nepouzite
	float			m_fViewAngle;		// sirka pohladu hraca
	float			m_fViewDistance;	// dohlad hraca


public:

	CVisObject();
	virtual ~CVisObject();

	void Initialize( void ) { m_eObjectType = VOT_None; };

	void CreateFlag( C2DVector staticFieldFlag );
	void CreateOwnPlayer( CAgent* agent );

	/// Vytvaranie objektov na zobrazenie ///

	// reprezentacia vnutorneho sveta
	void CreatePlayer( void );
	void CreateEnemyPlayer( void );
	void CreateTeamPlayer( void );
	void CreateBall( void );

	// na zaklade vnemov zo servera
	void CreateFlag( CSeenFlag* seenFlag, CAgent* agent );
	void CreatePlayer( CSeenPlayer* seenFlag, CAgent* agent );
	void CreateBall( CSeenObject* seenFlag, CAgent* agent );

	float GetPosX( void ) { return m_fPosX; };
	float GetPosY( void ) { return m_fPosY; };
	float GetRotation( void ) { return m_fRotation; };
	float GetHeadRotation( void ) { return m_fHeadRotation; };

	float GetViewAngle( void ) { return m_fViewAngle; };
	float GetViewDistance( void ) { return m_fViewDistance; };

	EVisObjectType GetObjectType( void ) { return m_eObjectType; };
	
	void Localize( float distance, float angle, float& worldX, float& worldY );
};

#endif // !defined(AFX_VISOBJECT_H__63238AC9_3FAD_4F3A_A8D1_29AAF7449AB8__INCLUDED_)
