// VisObject.cpp: implementation of the CVisObject class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Player.h"

#include "VisObject.h"
#include "staticfield.h"
#include "Perception.h"
#include "WorldObjects.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CVisObject::CVisObject()
{
	Initialize();
}

CVisObject::~CVisObject()
{

}

void CVisObject::CreateFlag( C2DVector staticFieldFlag )
{
	Initialize();

	// nastav typ objektu, meno a poziciu, pri vlajke viac netreba
	m_eObjectType = VOT_Flag;
	
	m_fPosX = staticFieldFlag.GetX();
	m_fPosY = staticFieldFlag.GetY();

}


// nasledjuce funkcie su pre objekty z vnutorneho sveta

void CVisObject::CreateOwnPlayer( CAgent* agent )
{
	m_eObjectType = VOT_OwnPlayer;
	m_fPosX = agent->GetPosition().GetX();
	m_fPosY = agent->GetPosition().GetY();
	m_fRotation = agent->GetDirection();
	m_fHeadRotation = agent->GetNeckDirection();
	m_fViewDistance = 100;//FIXME !!! FIX ME !!! FIX_ME !!!
	m_fViewAngle = RadToDeg(agent->GetViewAngle());
}

void CVisObject::CreatePlayer( void )
{
	m_eObjectType = VOT_UnknownPlayer;
	m_fPosX = -10.0f;
	m_fPosY = -10.0f;
	m_fRotation = 0.0f;
	m_fHeadRotation = 0.0f;
}

void CVisObject::CreateEnemyPlayer( void )
{
	m_eObjectType = VOT_EnemyPlayer;
	m_fPosX = 10.0f;
	m_fPosY = -10.0f;
	m_fRotation = 0.0f;
	m_fHeadRotation = 0.0f;
}

void CVisObject::CreateTeamPlayer( void )
{
	m_eObjectType = VOT_TeamPlayer;
	m_fPosX = 0.0f;
	m_fPosY = 0.0f;
	m_fRotation = 0.0f;
	m_fHeadRotation = 0.0f;
}

void CVisObject::CreateBall( void )
{
	m_eObjectType = VOT_Ball;
	m_fPosX = 10.0f;
	m_fPosY = 0.0f;
	m_fRotation = 0.0f;
	m_fHeadRotation = 0.0f;
}

//////////////////////////////////////////////////////////////////////////////
// void CVisObject::CreateFlag( CSeenFlag* seenFlag, CAgent* agent )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		CSeenFlag* seenFlag
//		CAgent* agent
//
//////////////////////////////////////////////////////////////////////////////
void CVisObject::CreateFlag( CSeenFlag* seenFlag, CAgent* agent )
{
	m_eObjectType = VOT_PerFlag;
	m_fPosX = agent->GetPosition().GetX();
	m_fPosY = agent->GetPosition().GetY();
	float angle = float( seenFlag->GetDirection() ) - agent->GetNeckDirection();
		
	Localize( seenFlag->GetDistance(), angle, m_fPosX, m_fPosY );
}

//////////////////////////////////////////////////////////////////////////////
// void CVisObject::CreatePlayer( CSeenPlayer* seenFlag, CAgent* agent )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		CSeenPlayer* seenFlag
//		CAgent* agent
//
//////////////////////////////////////////////////////////////////////////////
void CVisObject::CreatePlayer( CSeenPlayer* seenPlayer, CAgent* agent )
{
	m_eObjectType = VOT_PerPlayer;
	m_fPosX = agent->GetPosition().GetX();
	m_fPosY = agent->GetPosition().GetY();
	float angle = float( seenPlayer->GetDirection() ) - agent->GetNeckDirection();
		
	Localize( seenPlayer->GetDistance(), angle, m_fPosX, m_fPosY );
}

//////////////////////////////////////////////////////////////////////////////
// void CVisObject::CreateBall( CSeenObject* seenFlag, CAgent* agent )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		CSeenObject* seenFlag
//		CAgent* agent
//
//////////////////////////////////////////////////////////////////////////////
void CVisObject::CreateBall( CSeenObject* seenObject, CAgent* agent )
{
	m_eObjectType = VOT_PerBall;
	m_fPosX = agent->GetPosition().GetX();
	m_fPosY = agent->GetPosition().GetY();
	float angle = float( seenObject->GetDirection() ) - agent->GetNeckDirection();
		
	Localize( seenObject->GetDistance(), angle, m_fPosX, m_fPosY );
}

//////////////////////////////////////////////////////////////////////////////
// void CVisObject::Localize( float distance, float angle, float& worldX, float& worldY )
// ---------------------------------------------------------------------------
// Description:
//		
//
// ---------------------------------------------------------------------------
// Parameters:
//		float distance
//		float angle
//		float& worldX
//		float& worldY
//
//////////////////////////////////////////////////////////////////////////////
void CVisObject::Localize( float distance, float angle, float& worldX, float& worldY )
{
	worldX += distance * cos( angle * PI / 180 );
	worldY += distance * sin( angle * PI / 180 );
}
