// TextMessageBuffer.cpp: implementation of the CTextMessageBuffer class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Player.h"
#include "TextMessageBuffer.h"
#include "ToDoClasses.h"
#include "ChildTextView.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

const int MAX_TEXT_BUFFER_SIZE = 50;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CTextMessageBuffer::CTextMessageBuffer()
{

}

CTextMessageBuffer::~CTextMessageBuffer()
{
	CMessageList::iterator i;

	for( i = m_cMessages.begin(); i != m_cMessages.end(); i++ )
	{
		delete *i;
	}
}

void CTextMessageBuffer::AddMessage( char* new_message, DWORD mask )
{
	// FIXME do buffra sa budu pridavat len tie spravy, ktore 
	// vyhovuju aktivnej maske
	//
	// if ( !(ACTIVE_MESSAGE_MASK | mask ) )
	//		return;

	SMessageStruct* foo = new SMessageStruct();

	int m_len = strlen( new_message );
	char* f_text = new char[m_len + 1];
	strcpy( f_text, new_message );
	f_text[m_len] = 0;

	foo->m_czText = f_text;
	foo->m_dMask = mask;

	m_cMessages.insert( m_cMessages.end(), foo );

	if ( m_cMessages.size() > MAX_TEXT_BUFFER_SIZE )
	{
		delete *m_cMessages.begin();
		m_cMessages.erase( m_cMessages.begin() );
	}

	if ( m_pTextReadyView )
	{
		m_pTextReadyView->Invalidate();
	}
}

CMessageList* CTextMessageBuffer::GetMessageList( void )
{
	return &m_cMessages;
}