#include "stdafx.h"
#include "ServerCommunicator.h"
#include "ToDoClasses.h"
#include "ToDoEvent.h"

#include "LogManager.h"

CServerCommunicator::CServerCommunicator()
{
    m_bSynchronized = FALSE;
    m_nSynchPlayTime = -1;
    m_nSynchSystemTime = -1;
    m_nLastSystemTime = -1;

    // FIXME??
    m_pSendCommandSeq = new CGameCommandSeq();
    m_pSentCommandSeq = new CGameCommandSeq();
}

CServerCommunicator::~CServerCommunicator()
{
    if (m_pSendCommandSeq) {
        delete m_pSendCommandSeq;  m_pSendCommandSeq = NULL;
    }
    if (m_pSentCommandSeq) {
        delete m_pSentCommandSeq;  m_pSentCommandSeq = NULL;
    }
}

void CServerCommunicator::Initialize(CGameState *pGameState,
                                     CPerceptionSeq *pPerceptionSeq,
                                     CSystemClock *pSysClock, 
                                     CServerConnection *pSrvConnection, 
                                     CServerMsgTranslator *pSrvTranslator)
{
    m_pGameState = pGameState;
    m_pPerceptionSeq = pPerceptionSeq;
    m_pSystemClock = pSysClock;
    m_pServerConnection = pSrvConnection;
    m_pServerMsgTranslator = pSrvTranslator;
}

/* pre zadany systemovy cas upravi hraci cas GameState.GameTime 
   na zaklade hodnot m_nSynchPlayTime a m_nSynchSystemTime */
/* upravuje cas iba smerom nahor => cas musi narastat, preto nie je mozne
   spracovat po volani tejto funkcie starsie vnemy, ktore prisli pred nou
   (automaticky sa im priradi hodnota naposledy zvacseneho casu) */
/* funkcia vrati kolko milisekund uz trva aktualny sim. krok */
int CServerCommunicator::UpdateGameTime(int nSystemTime)
{
    int nSynchTime;
    int nPlayTime, nStopCycles;

    if ((!m_bSynchronized) || (m_nLastSystemTime > nSystemTime)) return -1;

    // zistime ako dlho sme zosynchronizovany = nSynchTime
    nSynchTime = nSystemTime - m_nSynchSystemTime;
    if (nSynchTime < 0) { m_bSynchronized = FALSE; return -1; }

    m_nLastSystemTime = nSystemTime;

    // vypocitame nove hodnoty herneho cas
    if (!isStopMode(m_pGameState->GetPlayMode()))
    {
        // FIXME - pre Windowsacky soccer server nebudeme umelo zvysovat cas
        //  => cas sa zvysuje len podla prijatych sprav
        // nPlayTime = m_nSynchPlayTime + (nSynchTime / SP_SEND_STEP);
        nPlayTime = m_nSynchPlayTime;
        nStopCycles = 0;
    } else {
        nPlayTime = m_nSynchPlayTime;
        nStopCycles = nSynchTime / SP_SEND_STEP;
    }

    // nastavime novu hodnotu a urcime celkovy pocet cyklov
    CGameTime tGameTime = m_pGameState->GetGameTime();
    if (tGameTime.m_nPlayTime == nPlayTime) {
        tGameTime.m_nAllCycles += nStopCycles - tGameTime.m_nStopCycles;
    } else {
        tGameTime.m_nAllCycles += nPlayTime - tGameTime.m_nPlayTime;
    }
    tGameTime.m_nPlayTime = nPlayTime;
    tGameTime.m_nStopCycles = nStopCycles;

    m_pGameState->SetGameTime(tGameTime);

    //fprintf(m_ff, "Cas: %d, %d, %d (%d)\n", tGameTime.m_nPlayTime, tGameTime.m_nStopCycles, tGameTime.m_nAllCycles, nSynchTime);

    return nSynchTime % SP_SEND_STEP;
}

/* upravi cas synchronizacie na zaklade casu prichodu prvej udalosti 
   so zmenenym hracim casom */
void CServerCommunicator::UpdateSynchTime(int nPlayTime, int nSystemTime)
{
    // FIXME: predpokladame, ze sense_body pride vzdy na zaciatku cyklu
    //   nemusi platit v pripade, ze sami vysleme ziadost o sense_body
    if ((!m_bSynchronized) || (m_nSynchPlayTime != nPlayTime)) {
        // ak si myslim, ze som v stopmode, ale zmenil sa cas (=nie hned po inicializacii), tak asi nemam 
        //   aktualne informacie nastavim, ze playmod je nejaky nestopmodovy
        if ((m_nSynchPlayTime > 0) && (isStopMode(m_pGameState->GetPlayMode()))) {
            m_pGameState->SetPlayMode(PM_UNKNOWN_NOSTOP);
        }

        // nastavime, ze v case nSystemTime nastal novy sim. krok nPlayTime
        m_nSynchPlayTime = nPlayTime;
        m_nSynchSystemTime = nSystemTime;
        m_bSynchronized = TRUE;
    }

/*  Bool bStopPlay = isStopMode(m_pGameState->GetPlayMode());

    if (!bStopPlay)
    {
        if (m_nSynchTime != nPlayTime) {
            m_nSynchTime = nPlayTime;
            m_nSynchInts = ??;
        }
    } else {
        if (m_nSynchTime != nPlayTime) {
            m_nSynchTime = nPlayTime;
            m_nSynchInts = ??;
        }
    } */

    UpdateGameTime(nSystemTime);
}

void CServerCommunicator::UpdateGameState(CPerception *pPerception)
{
    EPlayMode nPlayMode;
    CGameTime tOldTime, tGameTime;

    // nastavime playmod podla perceptionu 
    nPlayMode = pPerception->GetPlayMode();
    if (isValidPlayMode(nPlayMode)) {
        m_pGameState->SetPlayMode(nPlayMode);
    }

    // uprav cas synchronizacie
    UpdateSynchTime(pPerception->GetPlayTime(), pPerception->GetReceiveSystemTime());

//  if ((m_pGameState->CurrentTime - oldTime) > 1) && (...)) {
//      error("missed simulation step");
//  }
}

void CServerCommunicator::ProcessReceivedSrvMsgs()
{
    int res;
    CServerMsg *pSrvMsg;
    CPerception rPerception;    

    while ((pSrvMsg = m_pServerConnection->ReceiveMsg()) != NULL) {
        res = m_pServerMsgTranslator->ParseServerMsg(pSrvMsg, &rPerception);
        if (res) continue;

        UpdateGameState(&rPerception);

        // ak pride sensebody tak skontroluj, ci vykonal posledny command
        // inak ho zmaz zo SentCommandsSeq

        // FIXME: predpokladam, ze perception sa spracuje este v tom cykle,
        // kedy pride -> je potrebne spracuvat v realnom case (
        rPerception.SetGameTime(m_pGameState->GetGameTime());

        m_pPerceptionSeq->AddPerception(new CPerception(rPerception));
    }
}

void CServerCommunicator::OnReceiveServerMsg()
{
    ProcessReceivedSrvMsgs();
    OnSynchTimer(0);
}

/* FIXME: pridat parameter force = posli teraz, lebo uz nebudes mat moznost */
/* premenovat DoAct? */
void CServerCommunicator::OnSynchTimer(int nTimeToNextCall)
{   
    int nStepTime;                  // ako dlho uz trva aktualny sim. cyklus
    int nGameCycles = m_pGameState->GetGameTime().m_nAllCycles;

    // spracujeme vsetky prijate spravy,
    ProcessReceivedSrvMsgs();

    nStepTime = UpdateGameTime(m_pSystemClock->GetTime());
    if (nStepTime < 0) return;

    // FIXME - napevno: raz za simulacny krok rozmyslaj a posli akciu
    if (nLastDeliberateTime != nGameCycles) {
//  if (nStepTime >= SP_SEND_STEP - TIME_TO_DELIBERATE - TIME_TO_SEND) {
        TRACE("rozmyslaj\n");
        nLastDeliberateTime = nGameCycles;
        
        static CStartDeliberationEvent event;
//      FIXME - okopiruj_Perception_a_GameState??
        event.m_eType = ET__START_DELIBERATION;
        event.m_pPerceptionSeq = m_pPerceptionSeq;
        event.m_pGameCommandSeq = m_pSentCommandSeq;
        EventDispatcher.SendEvent(&event);
    }

    if (nLastSendTime != nGameCycles) {
//  if (nStepTime >= SP_SEND_STEP - TIME_TO_SEND) {
        //TRACE("konaj\n");
		LOGMSG( 1, "konaj" );

        CServerMsg mSrvMsg;
        CGameCommand *pGameCommand;

//      + test ci su pre aktualny sim. krok
//      if (Action.Valid) SendAction();
//      if (TurnNeck.Valid) SendTurnNeck();
//      if (ChangeView.Valid) SendChangeView();
//      if (NeedSenseBody) SendSenseBody();
//      + zarad do SentCommandSeq

        // FIXME
        // ak je zadany nejaky command na poslanie, tak ho posli (max. 1 v kazdom kroku)
        while (m_pSendCommandSeq->GetGameCommand(&pGameCommand))
		{
            if (pGameCommand->GetCmdType() != CT__NONE)
			{
                //fprintf(m_ff, "%d %d\n", nLastSendTime, nGameCycles);
                nLastSendTime = nGameCycles;
                
                m_pServerMsgTranslator->GenerateServerMsg(pGameCommand, &mSrvMsg);
                m_pServerConnection->SendMsg(mSrvMsg);
//                m_pSentCommandSeq->AddGameCommand(pGameCommand);
//                pGameCommand->NoCommand();
            }
			delete pGameCommand;
        }

//      m_pServerMsgTranslator->GenerateServerMsg(NULL, &mSrvMsg);
//      m_pServerConnection->SendMsg(mSrvMsg);
    }
}

void CServerCommunicator::SendCommands(CGameCommandSeq *pSendCommands)
{
    CGameCommand *pGameCommand;

    while (pSendCommands->GetGameCommand(&pGameCommand)){
		m_pSendCommandSeq->AddGameCommand(pGameCommand);
	}
    OnSynchTimer(0);
}