// Parser.cpp: implementation of the CParser, CCharString and CParseString class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Player.h"
#include "Parser.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

/* implementation of the CParser class */

/* Construction/Destruction */
CParser::CParser()
{

}

CParser::~CParser()
{

}

void CParser::Parse(char* msg, CPerception* newPerception)
{
	int pos;
	CParseString parseStr(msg);
	CParseString word;
	CParseString barredStr;
	pos = parseStr.GetFirstWord(&word);
	if(word == "see") 
	{
		newPerception->SetMsgType(MT_See);
		pos = parseStr.GetNextWord(pos, &word);
		newPerception->SetPlayTime(word.GetInteger());
		pos = parseStr.GetNextBar(pos, &barredStr);
		if(pos != -1)
			ParseObj(newPerception, &barredStr);
		while((pos = parseStr.GetNextBar(pos, &barredStr)) != -1) {
			ParseObj(newPerception, &barredStr);
		}
	}
	else if(word == "hear") 
	{
		double dir;
		string msg;
		EHearMsgType type;
        EPlayMode tPlayMode;
		newPerception->SetMsgType(MT_Hear);
		pos = parseStr.GetNextWord(pos, &word);
		newPerception->SetPlayTime(word.GetInteger());
		pos = parseStr.GetNextWord(pos, &word);
        tPlayMode = PM_NONE;
		if(word == "referee")
		{
			dir = 0.0;
			type = MT_Referee;
            /* parse playmode from referee */
            pos = parseStr.GetNextWord(pos, &word);
            tPlayMode = DecodePlayMode(word);
            msg = parseStr.GetString().substr(pos + 1, parseStr.GetStrLength() - pos);
		}
		else if(word == "self")
		{
			dir = 0.0;
			type = MT_Self;
            msg = parseStr.GetString().substr(pos + 1, parseStr.GetStrLength() - pos);
		}
		else
		{
			dir = word.GetDouble();
			type = MT_Other;
            msg = parseStr.GetString().substr(pos + 1, parseStr.GetStrLength() - pos);
		}
		newPerception->SetHeardMsg(dir, type, tPlayMode, (char*) msg.data());
	}
	else if(word == "sense_body") 
	{
		int barPos, ret;
		EViewQuality tViewQuality; // VQ_None, VQ_Low, VQ_High
		EViewWidth tViewWidth; // VW_None, VW_Narrow, VW_Normal, VW_Wide
		double dStamina, dEffort, dSpeed, dHeadDir;
		int nKickCount, nDashCount, nTurnCount, nSayCount, nHeadTurnCount;
		newPerception->SetMsgType(MT_SenseBody);
		pos = parseStr.GetNextWord(pos, &word);
		newPerception->SetPlayTime(word.GetInteger());
		while((pos = parseStr.GetNextBar(pos, &barredStr)) != -1) {
			barPos = barredStr.GetFirstWord(&word);
			if(word == "view_mode")
			{
				ret = barredStr.GetNextWord(barPos, &word);
				if(ret != -1)
				{
					barPos = ret;
					if(word == "low")
						tViewQuality = VQ_Low;
					else if(word == "high")
						tViewQuality = VQ_High;
					else
						tViewQuality = VQ_None;
				}
				ret = barredStr.GetNextWord(barPos, &word);
				if(ret != -1)
				{
					barPos = ret;
					if(word == "narrow")
						tViewWidth = VW_Narrow;
					else if(word == "normal")
						tViewWidth = VW_Normal;
					else if(word == "wide")
						tViewWidth = VW_Wide;
					else
						tViewWidth = VW_None;
				}
			}
			if(word == "stamina")
			{
				ret = barredStr.GetNextWord(barPos, &word);
				if(ret != -1)
				{
					barPos = ret;
					dStamina = word.GetDouble();
				}
				ret = barredStr.GetNextWord(barPos, &word);
				if(ret != -1)
				{
					barPos = ret;
					dEffort = word.GetDouble();
				}
			}
			if(word == "speed")
			{
				ret = barredStr.GetNextWord(barPos, &word);
				if(ret != -1)
				{
					barPos = ret;
					dSpeed = word.GetDouble();
				}
			}
			if(word == "head_angle")
			{
				ret = barredStr.GetNextWord(barPos, &word);
				if(ret != -1)
				{
					barPos = ret;
					dHeadDir = word.GetDouble();
				}				
			}
			if(word == "kick")
			{
				ret = barredStr.GetNextWord(barPos, &word);
				if(ret != -1)
				{
					barPos = ret;
					nKickCount = word.GetInteger();
				}
			}
			if(word == "dash")
			{
				ret = barredStr.GetNextWord(barPos, &word);
				if(ret != -1)
				{
					barPos = ret;
					nDashCount = word.GetInteger();
				}
			}
			if(word == "turn")
			{
				ret = barredStr.GetNextWord(barPos, &word);
				if(ret != -1)
				{
					barPos = ret;
					nTurnCount = word.GetInteger();
				}
			}
			if(word == "say")
			{
				ret = barredStr.GetNextWord(barPos, &word);
				if(ret != -1)
				{
					barPos = ret;
					nSayCount = word.GetInteger();
				}
			}
			if(word == "turn_neck")
			{
				ret = barredStr.GetNextWord(barPos, &word);
				if(ret != -1)
				{
					barPos = ret;
					nHeadTurnCount = word.GetInteger();
				}
			}
		}
		newPerception->SetSenseBody(tViewQuality, tViewWidth, dStamina, dEffort, dSpeed, dHeadDir, nKickCount, nDashCount, nTurnCount, nSayCount, nHeadTurnCount);
	}
	else if(word == "init")
	{
		int nUniformNum;
		ESide tSide;
		EPlayMode tPlayMode;
		newPerception->SetMsgType(MT_Init);
		pos = parseStr.GetNextWord(pos, &word);
		if(word == "l")
		{
			tSide = S_Left;
		}
		else if(word == "r")
		{
			tSide = S_Right;
		}
		else
		{
			tSide = S_None;
		}
		pos = parseStr.GetNextWord(pos, &word);
		nUniformNum = word.GetInteger();
		pos = parseStr.GetNextWord(pos, &word);
        tPlayMode = DecodePlayMode(word);
        newPerception->SetInitMsg(nUniformNum, tSide, tPlayMode);
	}
	else
	{
		newPerception->SetMsgType(MT_NoMsg);
	}
}

void CParser::ParseObj(CPerception* newPerception, CParseString* str)
{
	int pos, barPos, ret;
	double dir = NOT_EXISTING, dist = NOT_EXISTING, dirChng = NOT_EXISTING, distChng = NOT_EXISTING, bodyDir = NOT_EXISTING, headDir = NOT_EXISTING;
	int uNum;
	char teamName[16];
	CParseString f1, f2, f3;
	ELineType lineType;
	EFlagType flagType;
	EGoalType goalType;
//	ESetValues setValues = SV_None;
    int setValues = SEE_NOTHING;
 	CParseString barredStr;
	CParseString word;
	teamName[0] = '\0';
	uNum = -1;
	pos = str->GetFirstBar(&barredStr);
	ret = str->GetNextWord(pos, &word);
	if(ret != -1)
	{
		pos = ret;
		dist = word.GetDouble();
//		setValues = static_cast<ESetValues>(setValues + SV_Dist);
        setValues |= SEE_DISTANCE;
	}
	ret = str->GetNextWord(pos, &word);
	if(ret != -1)
	{
		pos = ret;
		dir = -word.GetDouble();
//		setValues = static_cast<ESetValues>(setValues + SV_Dir);
        setValues |= SEE_ANGLE;
	}
	ret = str->GetNextWord(pos, &word);
	if(ret != -1)
	{
		pos = ret;
		distChng = word.GetDouble();
//		setValues = static_cast<ESetValues>(setValues + SV_DistChng);
        setValues |= SEE_DISTANCE_CHANGE;
	}
	ret = str->GetNextWord(pos, &word);
	if(ret != -1)
	{
		pos = ret;
		dirChng = word.GetDouble();
//		setValues = static_cast<ESetValues>(setValues + SV_DirChng);
        setValues |= SEE_DISTANCE_CHANGE;
	}
	ret = str->GetNextWord(pos, &word);
	if(ret != -1)
	{
		pos = ret;
		bodyDir = word.GetDouble();
        setValues |= SEE_BODY_DIRECTION;
	}
	ret = str->GetNextWord(pos, &word);
	if(ret != -1)
	{
		pos = ret;
		headDir = word.GetDouble();
        setValues |= SEE_NECK_DIRECTION;
	}
	barPos = barredStr.GetFirstWord(&word);
	switch((word.GetString())[0]) {
	case 'p':
		ret = barredStr.GetNextWord(barPos, &word);
		if(ret != -1)
		{
			barPos = ret;
			strcpy(teamName, word.GetString().data());
               setValues |= SEE_SIDE;

		}
		ret = barredStr.GetNextWord(barPos, &word);
		if(ret != -1)
		{
			barPos = ret;
			uNum = word.GetInteger();
            setValues |= SEE_NUMBER;
		}
		newPerception->AddSeenPlayer(uNum, teamName, dist, dir, distChng, dirChng, setValues, bodyDir, headDir);
		break;
	case 'g':
		ret = barredStr.GetNextWord(barPos, &word);
		if(ret != -1)
		{
			if(word == "l")
				goalType = GT_L;
			else if(word == "r")
				goalType = GT_R;
			else
				goalType = GT_NoGoal;
		}
		newPerception->AddSeenGoal(goalType, dist, dir, distChng, dirChng, setValues);
		break;
	case 'f':
		ret = barredStr.GetNextWord(barPos, &f1);
		if(ret != -1)
		{
			barPos = ret;
		}
		ret = barredStr.GetNextWord(barPos, &f2);
		if(ret != -1)
		{
			barPos = ret;
		}
		ret = barredStr.GetNextWord(barPos, &f3);
		if(ret != -1)
		{
			barPos = ret;
		}
		flagType = DecodeFlag(f1, f2, f3);
		newPerception->AddSeenFlag(flagType, dist, dir, distChng, dirChng, setValues);
		break;
	case 'l':
		ret = barredStr.GetNextWord(barPos, &word);
		if(ret != -1)
		{
			if(word == "l")
				lineType = LT_L;
			else if(word == "r")
				lineType = LT_R;
			else if(word == "t")
				lineType = LT_T;
			else if(word == "b")
				lineType = LT_B;
			else
				lineType = LT_NoLine;
		}
		newPerception->AddSeenLine(lineType, dist, dir, distChng, dirChng, setValues);
		break;
	case 'b':
		newPerception->AddSeenBall(dist, dir, distChng, dirChng, setValues);
		break;
	}	
}


EFlagType CParser::DecodeFlag(CParseString f1, CParseString f2, CParseString f3)
{
	EFlagType flagType;
	if(f1 == "c")
	{
		if(f2.GetString() == "")
			flagType = FT_C;
		if(f2 == "t")
			flagType = FT_CT;
		if(f2 == "b")
			flagType = FT_CB;
	}
	else if(f1 == "l")
	{
		if(f2 == "t")
		{
			if(f3.GetString() == "")
				flagType = FT_LT;
			if(f3 == "10")
				flagType = FT_LT10;
			if(f3 == "20")
				flagType = FT_LT20;
			if(f3 == "30")
				flagType = FT_LT30;
		}

		if(f2 == "b")
		{
			if(f3.GetString() == "")
				flagType = FT_LB;
			if(f3 == "10")
				flagType = FT_LB10;
			if(f3 == "20")
				flagType = FT_LB20;
			if(f3 == "30")
				flagType = FT_LB30;
		}
		if(f2 == "0")
			flagType = FT_L0;
	}
	else if(f1 == "r")
	{
		if(f2 == "t")
		{
			if(f3.GetString() == "")
				flagType = FT_RT;
			if(f3 == "10")
				flagType = FT_RT10;
			if(f3 == "20")
				flagType = FT_RT20;
			if(f3 == "30")
				flagType = FT_RT30;
		}

		if(f2 == "b")
		{
			if(f3.GetString() == "")
				flagType = FT_RB;
			if(f3 == "10")
				flagType = FT_RB10;
			if(f3 == "20")
				flagType = FT_RB20;
			if(f3 == "30")
				flagType = FT_RB30;
		}
		if(f2 == "0")
			flagType = FT_R0;
	}
	else if(f1 == "t")
	{
		if(f2 == "l")
		{
			if(f3 == "10")
				flagType = FT_TL10;
			if(f3 == "20")
				flagType = FT_TL20;
			if(f3 == "30")
				flagType = FT_TL30;
			if(f3 == "40")
				flagType = FT_TL40;
			if(f3 == "50")
				flagType = FT_TL50;
		}

		if(f2 == "r")
		{
			if(f3 == "10")
				flagType = FT_TR10;
			if(f3 == "20")
				flagType = FT_TR20;
			if(f3 == "30")
				flagType = FT_TR30;
			if(f3 == "40")
				flagType = FT_TR40;
			if(f3 == "50")
				flagType = FT_TR50;
		}
		if(f2 == "0")
			flagType = FT_T0;
	}
	else if(f1 == "b")
	{
		if(f2 == "l")
		{
			if(f3 == "10")
				flagType = FT_BL10;
			if(f3 == "20")
				flagType = FT_BL20;
			if(f3 == "30")
				flagType = FT_BL30;
			if(f3 == "40")
				flagType = FT_BL40;
			if(f3 == "50")
				flagType = FT_BL50;
		}

		if(f2 == "r")
		{
			if(f3 == "10")
				flagType = FT_BR10;
			if(f3 == "20")
				flagType = FT_BR20;
			if(f3 == "30")
				flagType = FT_BR30;
			if(f3 == "40")
				flagType = FT_BR40;
			if(f3 == "50")
				flagType = FT_BR50;
		}
		if(f2 == "0")
			flagType = FT_B0;
	}
	else if(f1 == "p")
	{
		if(f2 == "l")
		{
			if(f3 == "t")
				flagType = FT_PLT;
			if(f3 == "c")
				flagType = FT_PLC;
			if(f3 == "b")
				flagType = FT_PLB;
		}
		if(f2 == "r")
		{
			if(f3 == "t")
				flagType = FT_PRT;
			if(f3 == "c")
				flagType = FT_PRC;
			if(f3 == "b")
				flagType = FT_PRB;
		}
	}
	else if(f1 == "g")
	{
		if(f2 == "l")
		{
			if(f3 == "t")
				flagType = FT_GLT;
			if(f3 == "b")
				flagType = FT_GLB;
		}
		if(f2 == "r")
		{
			if(f3 == "t")
				flagType = FT_GRT;
			if(f3 == "b")
				flagType = FT_GRB;
		}
	}
	else
	{
		flagType = FT_NoFlag;
	}
	return flagType;
}

EPlayMode CParser::DecodePlayMode(CParseString pm)
{
    EPlayMode tPlayMode;

	if(pm == "before_kick_off")
		tPlayMode = PM_BeforeKickOff;
	else if(pm == "time_over")
		tPlayMode = PM_TimeOver;
	else if(pm == "play_on")
		tPlayMode = PM_PlayOn;
	else if(pm == "kick_off_l")
		tPlayMode = PM_KickOff_Left;
	else if(pm == "kick_off_r")
		tPlayMode = PM_KickOff_Right;
	else if(pm == "kick_in_l")
		tPlayMode = PM_KickIn_Left;
	else if(pm == "kick_in_r")
		tPlayMode = PM_KickIn_Right;
	else if(pm == "free_kick_l")
		tPlayMode = PM_FreeKick_Left;
	else if(pm == "free_kick_r")
		tPlayMode = PM_FreeKick_Right;
	else if(pm == "corner_kick_l")
		tPlayMode = PM_CornerKick_Left;
	else if(pm == "corner_kick_r")
		tPlayMode = PM_CornerKick_Right;
	else if(pm == "goal_kick_l")
		tPlayMode = PM_GoalKick_Left;
	else if(pm == "goal_kick_r")
		tPlayMode = PM_GoalKick_Right;
	else
		tPlayMode = PM_NONE;

    return tPlayMode;
}

//////////////////////////////////////////////////////////////////////
// implementation of the CCharString class
//////////////////////////////////////////////////////////////////////

// Construction/Destruction

CCharString::CCharString()
{
	m_sString = "";
}

CCharString::CCharString(char* str)
{
	m_sString = str;
}

CCharString::~CCharString()
{
}


//////////////////////////////////////////////////////////////////////
// implementation of the CParseString class
//////////////////////////////////////////////////////////////////////

// Construction/Destruction

CParseString::CParseString()
{
	m_sString = "";
}

CParseString::CParseString(char* str)
{
	m_sString = str;
}

CParseString::~CParseString()
{
}

int CParseString::GetFirstWord(CParseString* subString)
{
	string str;
	int i, j;
	i = 0;
	j = 0;
	while(!isalnum(m_sString[i]) && (m_sString[i] != '-') && (m_sString[i] != '_') && (i != m_sString.size()))
	{
		i++;
	}
	j = i;
	while(((isalnum(m_sString[i])) || (m_sString[i] == '.') || (m_sString[i] == '-') || (m_sString[i] == '_')) && (i != m_sString.size()))
	{
		i++;
	}
	str = m_sString.substr(j, i - j); 
	*subString = str;
	return i;
}

int CParseString::GetFirstBar(CParseString* subString)
{
	string str;
	int i, j, level;
	i = 0;
	j = 0;
	level = 0;
	while((m_sString[i] != '(') && (i != m_sString.size()))
	{
		i++;
	}
	if(i != m_sString.size())
		i++;
	j = i;
	while(((m_sString[i] != ')') || (level != 0)) && (i != m_sString.size())) 
	{
		if(m_sString[i] == '(')
			level++;
		if(m_sString[i] == ')')
			level--;
		i++;
	}
	if(i != m_sString.size())
	{
		str = m_sString.substr(j, i - j);
		*subString = str;
		return i;
	}
	else
	{
		str = ""; 
		*subString = str;
		return -1;
	}
}

int CParseString::GetNextWord(int pos, CParseString* subString)
{
	if(pos >= m_sString.size())
		return -1;
	string str;
	int i, j;
	i = pos;
	j = 0;
	while((!isalnum(m_sString[i])) && (m_sString[i] != '-') && (m_sString[i] != '_') && (i != m_sString.size()))
	{
		i++;
	}
	j = i;
	while(((isalnum(m_sString[i])) || (m_sString[i] == '.') || (m_sString[i] == '-') || (m_sString[i] == '_')) && (i != m_sString.size()))
	{
		i++;
	}
	str = m_sString.substr(j, i - j);
	*subString = str;
	return i;
}

int CParseString::GetNextBar(int pos, CParseString* subString)
{
	if(pos >= m_sString.size())
		return -1;
	string str;
	int i, j, level;
	i = pos;
	j = 0;
	level = 0;
	while((m_sString[i] != '(') && (i != m_sString.size()))
	{
		i++;
	}
	if(i != m_sString.size())
		i++;
	j = i;
	while(((m_sString[i] != ')') || (level != 0)) && (i != m_sString.size())) 
	{
		if(m_sString[i] == '(')
			level++;
		if(m_sString[i] == ')')
			level--;
		i++;
	}
	if(i != m_sString.size())
	{
		str = m_sString.substr(j, i - j);
		*subString = str;
		return i;
	}
	else
	{
		str = "";
		*subString = str;
		return -1;
	}
}

int CParseString::GetWordCount()
{
	int count,i;
	i = 0;
	count = 0;
	while(i != m_sString.size()) {
		while((!isalnum(m_sString[i])) && (m_sString[i] != '.') && (m_sString[i] != '-') && (m_sString[i] != '-') && (i != m_sString.size()))
		{
			i++;
		}
		while(((isalnum(m_sString[i])) || (m_sString[i] == '.') || (m_sString[i] == '-') || (m_sString[i] == '_')) && (i != m_sString.size()))
		{
			i++;
		}
		if(i != m_sString.size())
			count++;
	}
	return count;
}

int CParseString::GetBarCount()
{
	int count, i, level;
	i = 0;
	count = 0;
	level = 0;
	while(i != m_sString.size()) {
		while((m_sString[i] != '(') && (i != m_sString.size()))
		{
			i++;
		}
		while(((m_sString[i] != ')') || (level != 0)) && (i != m_sString.size())) 
		{
			if(m_sString[i] == '(')
				level++;
			if(m_sString[i] == ')')
				level--;
			i++;
		}
		if(i != m_sString.size())
			count++;
	}
	return count;
}

bool CParseString::operator==(CParseString str)
{
	return m_sString == str.GetString();
}

bool CParseString::operator==(CCharString str)
{
	return m_sString == str.GetString();
}

bool CParseString::operator==(string sString)
{
	return m_sString == sString;
}

bool CParseString::operator==(char* szString)
{
	return m_sString == szString;
}

void CParseString::operator=(CParseString str)
{	
	m_sString = str.GetString();
}

void CParseString::operator=(CCharString str)
{
	m_sString = str.GetString();
}

void CParseString::operator=(string sString)
{
	m_sString = sString;
}	

void CParseString::operator=(char* szString)
{
	m_sString = szString;
}
