// Geometry.h: interface for the Geometry class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_Geometry_H__1D105CCB_B5B7_4AAD_BFDC_65989CEC3B44__INCLUDED_)
#define AFX_Geometry_H__1D105CCB_B5B7_4AAD_BFDC_65989CEC3B44__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

//#include <iostream.h>         FIXME: neslo to kompilovat, tak je to zakomentovane
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <signal.h>

typedef double AngleRad;
typedef double AngleDeg;

#define double_EPS .001

/**
  * Trieda na pracu s vektormi
  * by: jeeff
  */

class Vector
{
public:
    double x;
    double y;

    Vector(double vx = 0, double vy = 0)
    {
       x = vx; y = vy;
    }
    Vector operator -() { return Vector(-x, -y); }
    Vector operator +(const Vector &a) { return Vector(x + a.x, y + a.y); }
    Vector operator -(const Vector &a) { return Vector(x - a.x, y - a.y); }
    Vector operator *(const double &a) { return Vector(x * a, y * a); }
    Vector operator *(const Vector &a) { return Vector(x * a.x, y * a.y); }
    Vector operator /(const double &a) { return Vector(x / a, y / a); }
    Vector operator /(const Vector &a) { return Vector(x / a.x, y / a.y); }
    void operator =(const double &a) { x = a; y = a; }
    void operator +=(const Vector &a) { x += a.x;  y += a.y; }
    void operator +=(const double &a) { x += a;  y += a; }
    void operator -=(const Vector &a) { x -= a.x;  y -= a.y; }
    void operator -=(const double &a) { x -= a;  y -= a; }
    void operator *=(const double &a) { x *= a;  y *= a; }
    void operator /=(const double &a) { x /= a;  y /= a; }
    operator !=(const Vector &a) { return (x != a.x) || (y != a.y); }
    operator !=(const double &a) { return (x != a) || (y != a); }
    operator ==(const Vector &a) { return (x == a.x) && (y == a.y); }

//    friend ostream& operator <<(ostream & os, Vector v) { return os << "("<<v.x<<", "<<v.y<<")"; }
//    void Print() { cout << *this << endl; }
    void ins(double vx = 0, double vy = 0) { x = vx; y = vy; }
    double mod() { return sqrt(x*x + y*y); }
    double mod2() { return x*x + y*y; }
    double dist(const Vector &a) { return (*this-a).mod(); }
    double dist2(const Vector &a) { return (*this-a).mod2(); }
    Vector Normalize() { return SetLength(1.0); }
    Vector SetLength(double len) { return (*this) * (len / mod()); }
    AngleDeg dir() { return atan2(y,x); }
    Vector rotate(AngleDeg angle)
    { return Vector(this->mod()*cos(this->dir()+angle), this->mod()*sin(this->dir()+angle)); }
    Vector Global2Relative(Vector orig, double ang);
    Vector Relative2Global(Vector orig, double ang);

    //void ins(double vx = 0, double vy = 0) { x = vx; y = vy; }
};

inline Vector Polar2Vector(double mod, AngleDeg ang) {
  return Vector(mod * cos(ang), mod * sin(ang));
}

inline Vector Vector::Global2Relative(Vector orig, double ang)
{
  return (*this - orig).rotate(-ang);
}

inline Vector Vector::Relative2Global(Vector orig, double ang)
{
  return (rotate(ang) + orig);
}

inline Vector operator *(const double &a, const Vector &v)
{ return Vector(v.x * a, v.y * a); }

/*
 * Ray - udrziava poziciu a smer
 * by: jeeff
 */
class Line;
class RRectangle;
class Ray
{
  //  friend Line;
  //friend RRectangle;
public:
  Ray()
    { origin = Vector(0,0); direction = Vector(1,0); }
  Ray(Vector orig, Vector dir);
  Ray(Vector orig, double ang)
  {
      origin = orig;
      direction = Polar2Vector(1.0, ang);
  }

  bool OnRay(Vector pt);
  bool InRightDir(Vector pt); // more lenient than above about distance off ray

  bool intersection(Ray r, Vector *pPt);
  bool intersection(Line l, Vector *pPt);

  int CircleIntersect(double rad, Vector center,
            Vector* psol1, Vector* psol2);

  Vector GetClosestPoint(Vector pt);

  //Vector RRectangleIntersection(RRectangle R);

protected:
  friend Line;
  friend RRectangle;
  Vector origin;
  Vector direction;
};

/**
  * Trieda na pracu s ciarami
  * by: jeeff
  */

class Line
{
 public:
  Line(double x_coef=0.0, double y_coef=0.0, double constant=0.0);
  Line(Ray r)
    { LineFromRay(r); }

  void LineFromTwoPoints(Vector pt1, Vector pt2);
  void LineFromRay(Ray r);
  void LineFromRay(Vector orig, Vector dir)
    { LineFromRay(Ray(orig, dir)); }
  void LineFromRay(Vector orig, AngleDeg dir)
    { LineFromRay(orig, Polar2Vector(1.0, dir)); }

  bool PointOnLine(double x, double y);
  inline bool PointOnLine(Vector pt) { return PointOnLine(pt.x, pt.y); }

  double dist(Vector pt);
  double dist2(Vector pt);
  double angle(); /* returns the angle of the line in [-90, 90] */

  bool InBetween(Vector pt, Vector end1, Vector end2);
  Vector GetClosestPtInBetween(Vector pt, Vector end1, Vector end2);

  /* the buffer should really be linked to an option or something,
     but 1.0 is okay */
  inline bool OnLine(Vector pt, double buffer = 1.0)
    { return (dist2(pt) < sqrt(buffer)) ? TRUE : FALSE; }

  Vector ProjectPointUsingCircle(Vector pt);
  inline Vector ProjectPoint(Vector pt) { return intersection(perpendicular(pt)); }

  double get_y(double x);
  double get_x(double y);
  Vector intersection(Line l);
  inline Line perpendicular(Vector pt) { return Line(B,-A,A*pt.y - B*pt.x); }

  bool RayIntersection(Ray r, Vector *ppt);

  Line shift_y(double val)
    { return Line(A, B, C - val * B); }
  Line shift_x(double val)
    { return Line(A, B, C - val * A); }

  /* returns whether the projection of pt1 is closer to targ_pt than the
     projection of pt2 */
  bool IsPtCloserToPtOnLine(Vector pt1, Vector pt2, Vector targ_pt);

  bool HalfPlaneTest(Vector pt); //return TRUE on top/left part of plane
  bool SameSlope(Line l);

//  friend ostream& operator <<(ostream & os, Line l)
//    { return os << "#L("<<l.A<<", "<<l.B<<", "<<l.C<<")"; }
//  void Print(void) { cout << *this << endl; }

  // private:
  double A,B,C; /* the three coeffs in the line equation */
  /* Ax + By + C = 0 */
} ;

inline Line LineFromTwoPoints(Vector pt1, Vector pt2)
{ Line l; l.LineFromTwoPoints(pt1,pt2); return l; }
inline Line LineFromRay      (Ray r)
{ Line l; l.LineFromRay     (r); return l; }
inline Line LineFromRay      (Vector orig, Vector dir)
{ Line l; l.LineFromRay     (orig,dir); return l; }
inline Line LineFromRay      (Vector orig, AngleDeg dir)
{ Line l; l.LineFromRay     (orig,dir); return l; }



/**
  * Trieda na pracu s stvorhranmi
  * by: jeeff
  */

class RRectangle
{
public:

  RRectangle() ;
  RRectangle(const double left, const double right,
       const double top, const double bottom) ;
  RRectangle(const Vector center, const Vector size) ;

  operator ==(const RRectangle &a)
  { return (left_x == a.left_x) && (right_x == a.right_x) &&
      (top_y == a.top_y) && (bottom_y == a.bottom_y); }

  inline double TopY()     { return top_y; }
  inline double BottomY()  { return bottom_y; }
  inline double RightX()   { return right_x; }
  inline double LeftX()    { return left_x; }

  inline Vector TopLeftCorner() { return Vector(left_x, top_y); }
  inline Vector TopRightCorner() { return Vector(right_x, top_y); }
  inline Vector BottomLeftCorner() { return Vector(left_x, bottom_y); }
  inline Vector BottomRightCorner() { return Vector(right_x, bottom_y); }

  inline Line LeftEdge() {return LineFromTwoPoints(TopLeftCorner(), BottomLeftCorner());}
  inline Line RightEdge() {return LineFromTwoPoints(TopRightCorner(), BottomRightCorner());}
  inline Line TopEdge() {return LineFromTwoPoints(TopLeftCorner(), TopRightCorner());}
  inline Line BottomEdge() {return LineFromTwoPoints(BottomLeftCorner(), BottomRightCorner());}

  Line GetEdge(int n);  //order: top, right, bot, left; starting at 0
  Vector GetPoint(int n); //order: TL, TR, BR, BL; starting at 0

  inline double Width()    { return right_x - left_x; }
  inline double Height()   { return bottom_y - top_y; }

  inline Vector Center()  { return Vector( LeftX() + Width()/2, TopY() + Height()/2 ); }

  bool   IsWithin(const Vector& p) ;
  Vector nearestHEdge(const Vector& p) ;
  Vector nearestVEdge(const Vector& p) ;
  Vector nearestEdge(const Vector& p) ;

  double  DistanceToEdge(const Vector& p);
  Vector AdjustToWithin(const Vector& p);

  Line nearestHEdgeLine(const Vector& p) ;
  Line nearestVEdgeLine(const Vector& p) ;
  Line nearestEdgeLine(const Vector& p) ;

  RRectangle shrink(double val)
    { return expand(-val); }
  RRectangle expand(double val);

  RRectangle expandLeft(double val)
    {return RRectangle(left_x - val, right_x, top_y, bottom_y);}
  RRectangle expandRight(double val)
    {return RRectangle(left_x, right_x + val, top_y, bottom_y);}
  RRectangle expandTop(double val)
    {return RRectangle(left_x, right_x, top_y - val, bottom_y);}
  RRectangle expandBottom(double val)
    {return RRectangle(left_x, right_x, top_y, bottom_y + val);}
  RRectangle shrinkLeft(double val)
    { return expandLeft(-val); }
  RRectangle shrinkRight(double val)
    { return expandRight(-val); }
  RRectangle shrinkTop(double val)
    { return expandTop(-val); }
  RRectangle shrinkBottom(double val)
    { return expandBottom(-val); }

//  friend ostream& operator <<(ostream & os, RRectangle r)
//    { return os << "RRectangle:  x = " << r.LeftX() << " to " << r.RightX()
//      << "   y = " << r.TopY() << " to " << r.BottomY(); }
  void Print();

  Vector RayIntersection(Ray r);

private:
  double left_x ;
  double right_x ;
  double top_y ;
  double bottom_y ;

} ;


/**
  * Trieda geometrickych operacii
  * by: jeeff
  */

class Geometry
{
public:
   Geometry();
   virtual ~Geometry();

};




#endif // !defined(AFX_Geometry_H__1D105CCB_B5B7_4AAD_BFDC_65989CEC3B44__INCLUDED_)
