#ifndef GAMECOMMAND_H
#define GAMECOMMAND_H

#include "gametime.h"
#include "perceptiontypes.h"
#include <string>
#include <queue>

using namespace std;

//! Types of commands
enum EGameCommandType {
    CT__NONE = 0,
    CT__DASH,
    CT__TURN,
    CT__KICK,
    CT__NECK,
    CT__MOVE,
    CT__CATCH,
	CT__INIT,
	CT__BYE,
	CT__RECONNECT,
	CT__CHANGEVIEW,
	CT__SAY,
	CT__SENSEBODY,
	CT__COUNT
};

/*! \brief
*/
class CGameCommand
{
private:
	EGameCommandType m_tCmdType;	//!< Typ prikazu 
    CGameTime m_tGameTime;			//!< Cas vytvorenia
	string m_sArg1, m_sArg2; 
	double m_dArg1, m_dArg2;
	int m_nArg1, m_nArg2;
public:
	/*! \brief Konstruktor triedy
	*/
	CGameCommand(){m_tCmdType = CT__NONE;}
	/*! \brief Konstruktor triedy s inicializaciou casu vytvorenia.
	*/
	CGameCommand(CGameTime tGameTime){m_tGameTime = tGameTime; m_tCmdType = CT__NONE;}	
	virtual ~CGameCommand();

	/*! \brief Funkcia vracia typ nastaveneho prikazu.
	\return Vracia aktualny typ prikazu.
	*/
	EGameCommandType GetCmdType(){return m_tCmdType;}

	/*! \brief Funkcia vracia cas vytvorenia prikazu.
	\return Vracia cas reprezentovany objektom CGameTime.
	*/
	CGameTime GetGameTime(){return m_tGameTime;}
	

	/*! \brief Funkcia nastavi typ prikazu na hodnotu CT__NONE.
	*/
	void NoCommand(){m_tCmdType = CT__NONE;}
	/*! \brief Funkcia nastavi typ prikazu na init.
	\param teamName Meno timu, ku ktoremu patri hrac posielajuci tento prikaz.
	\param version Verzia servera, ku ktorej sa pripaja. 
	\param goalie Ak tento parameter obsahuje retazzec goalie, bude hrac prihlaseny ako brankar 
	*/
	void Init(string teamName, double version = -1, string goalie = ""){m_tCmdType = CT__INIT; m_sArg1 = teamName; m_dArg1 = version; m_sArg2 = goalie;}
	/*! \brief Funkcia nastavi typ prikazu na bye.
	*/
	void Bye(){m_tCmdType = CT__BYE;}
	/*! \brief Funkcia nastavi typ prikazu na reconnect.
	*/
	void Reconnect(string teamName, int uNum){m_tCmdType = CT__RECONNECT; m_sArg1 = teamName; m_nArg1 = uNum;}
	/*! \brief Funkcia nastavi typ prikazu na catch
	*/
	void Catch(double direction){m_tCmdType = CT__CATCH; m_dArg1 = direction;}
	/*! \brief Funkcia nastavi typ prikazu na change view.
	*/
	void ChangeView(EViewWidth width, EViewQuality quality){m_tCmdType = CT__CHANGEVIEW; m_nArg1 = width; m_nArg2 = quality;}
	/*! \brief Funkcia nastavi typ prikazu na dash.
	*/
	void Dash(double power){m_tCmdType = CT__DASH; m_dArg1 = power;}
	/*! \brief Funkcia nastavi typ prikazu na kick.
	*/
	void Kick(double power, double dir){m_tCmdType = CT__KICK; m_dArg1 = power; m_dArg2 = dir;}
	/*! \brief Funkcia nastavi typ prikazu na move.
	*/
	void Move(double x, double y){m_tCmdType = CT__MOVE; m_dArg1 = x; m_dArg2 = y;}
	/*! \brief Funkcia nastavi typ prikazu na say.
	*/
	void Say(string message){m_tCmdType = CT__SAY; m_sArg1 = message;}
	/*! \brief Funkcia nastavi typ prikazu na sense body.
	*/
	void SenseBody(){m_tCmdType = CT__SENSEBODY;}
	/*! \brief Funkcia nastavi typ prikazu na turn.
	*/
	void Turn(double moment){m_tCmdType = CT__TURN; m_dArg1 = moment;}
	/*! \brief Funkcia nastavi typ prikazu na turn neck.
	*/
	void TurnNeck(double angle){m_tCmdType = CT__NECK; m_dArg1 = angle;}

	/*! \brief Funkcia generuje textovu spravu pre server na zaklade nastaveneho typu a parametrov
	*/
	bool GenerateMessage(char* buff);
/*
public:
    CGameTime m_tGameTime;

    EGameCommandType m_tCmdType;
    double m_val_A, m_val_B;

public:
    CGameCommand(EGameCommandType tCmdType = CT__NONE) { m_tCmdType = tCmdType; };
*/
};


typedef queue<CGameCommand*> CGameCommandQueue;

class CGameCommandSeq
{
private:
	CGameCommandQueue m_cGameCommands;		//!< Rad, v ktorom sa ukladaju ukazovatele na objekty typu CGameCommand
public:
	/*! \brief Konstruktor triedy
	*/
	CGameCommandSeq(){}
	~CGameCommandSeq()
	{
		Clear();	
	}
	/*! \brief Pridanie noveho ukazovatela do radu.
	\param pGameCommand Ukazovatel na pridavany objekt do radu.
	*/
	CGameCommandSeq* AddGameCommand(CGameCommand *pGameCommand);
	/*! \brief Ziskanie prveho ukazovatela z radu.
	\param pGameCommand Ukazovatel do ktoreho sa ulori adresu, kde sa ulozi prvy ukazovatel v rade.
	*/
	bool GetGameCommand(CGameCommand **ppGameCommand);
	/*! \brief Vrati pocet prvkov v rade.
	\return Vrati true ak rad nebol prazdny.
	*/
	int GetGameCommandsCount();
	/*! \brief Vyprazdni obsah radu.
	*/
    void Clear()
	{
		while (!m_cGameCommands.empty())
		{
			delete m_cGameCommands.front();
			m_cGameCommands.pop();
		}
	}

/*    CGameCommand m_cGameCommand;

public:
    void Add(CGameCommand *pGameCommand) { m_cGameCommand = *pGameCommand; };
    // FIXME: get iterator + next...
    CGameCommand *GetFirst() { return &m_cGameCommand; };
    CGameCommand *GetNext() { return NULL; }
*/
};

#endif // GAMECOMMAND
