#ifndef SERVERMSGTRANSLATOR_H
#define SERVERMSGTRANSLATOR_H

#include "ServerMsg.h"
#include "ToDoClasses.h"
#include "Perception.h"
#include "Parser.h"

class CServerMsgTranslator
{
private:
    EPlayMode m_mPlayMode;
    CParser m_Parser;

public:
    CServerMsgTranslator();

    int get_int(char **str_ptr);  // FIXME

    int ParseServerMsg(CServerMsg *pServerMsg, CPerception *pPerception) 
    {
/*      pPerception->SetPlayMode(PM_NONE);

        // FIXME po prvej hear sprave nastavime playon
        if (pServerMsg->m_sMessage[3] == 'a') pPerception->SetPlayMode(m_mPlayMode = PM_PlayOn);

        int time;
        // ak nejde o init, tak parsneme cas
        if (pServerMsg->m_sMessage[3] == 'i') time = 0;
        else {
            //pPerception->SetPlayMode(m_mPlayMode);

	        char *pc = (char *)pServerMsg->m_sMessage.c_str();
            time = get_int(&pc);
        }

        pPerception->SetPlayTime(time); */

        // parsneme celu spravu
        pPerception->ClearAll();
        m_Parser.Parse((char *)pServerMsg->m_sMessage.c_str(), pPerception);

        // a nakonci este nakopirujeme cas prichodu
        pPerception->SetReceiveSystemTime(pServerMsg->m_nReceiveSystemTime);

        return 0;
    };
    int GenerateServerMsg(CGameCommand *pCommand, CServerMsg *pServerMsg) {
        char buff[64];
        switch (pCommand->m_tCmdType) {
        case CT__DASH: 
            sprintf(buff, "(dash %.2lf)", pCommand->m_val_A);
            pServerMsg->m_sMessage = buff;
            break;
        case CT__TURN: 
            sprintf(buff, "(turn %.2lf)", -pCommand->m_val_A);
            pServerMsg->m_sMessage = buff;
            break;
        case CT__NECK: 
            sprintf(buff, "(neck %.2lf)", -pCommand->m_val_A);
            pServerMsg->m_sMessage = buff;
            break;
        case CT__CATCH: 
            sprintf(buff, "(catch %.2lf)", pCommand->m_val_A);
            pServerMsg->m_sMessage = buff;
            break;
    	case CT__KICK:
            sprintf(buff, "(kick %.2lf %.2lf)", pCommand->m_val_A, -pCommand->m_val_B);
            pServerMsg->m_sMessage = buff;
            break;
    	case CT__MOVE:
            sprintf(buff, "(move %.2lf %.2lf)", pCommand->m_val_A, pCommand->m_val_B);
            pServerMsg->m_sMessage = buff;
            break;
        }
        return 0;
    };
};


#endif  // SERVERMSGTRANSLATOR_H